/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.lock.impl;

import io.atomix.core.lock.AsyncDistributedLock;
import io.atomix.core.lock.DistributedLock;
import io.atomix.primitive.AsyncPrimitive;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.Synchronous;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;

public class BlockingDistributedLock
extends Synchronous<AsyncDistributedLock>
implements DistributedLock {
    private final AsyncDistributedLock asyncLock;
    private final long operationTimeoutMillis;

    public BlockingDistributedLock(AsyncDistributedLock asyncLock, long operationTimeoutMillis) {
        super((AsyncPrimitive)asyncLock);
        this.asyncLock = asyncLock;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    @Override
    public void lock() {
        this.asyncLock.lock().join();
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.asyncLock.lock().join();
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean tryLock() {
        return this.asyncLock.tryLock().join();
    }

    @Override
    public boolean tryLock(Duration timeout) {
        return this.asyncLock.tryLock(timeout).join();
    }

    @Override
    public void unlock() {
        this.complete(this.asyncLock.unlock());
    }

    @Override
    public AsyncDistributedLock async() {
        return this.asyncLock;
    }

    private <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(this.operationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PrimitiveException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new PrimitiveException.Timeout();
        }
        catch (ExecutionException e) {
            throw new PrimitiveException(e.getCause());
        }
    }
}

