/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.idgenerator.impl;

import io.atomix.core.idgenerator.AsyncAtomicIdGenerator;
import io.atomix.core.idgenerator.AtomicIdGenerator;
import io.atomix.primitive.AsyncPrimitive;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.Synchronous;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class BlockingAtomicIdGenerator
extends Synchronous<AsyncAtomicIdGenerator>
implements AtomicIdGenerator {
    private final AsyncAtomicIdGenerator asyncIdGenerator;
    private final long operationTimeoutMillis;

    public BlockingAtomicIdGenerator(AsyncAtomicIdGenerator asyncIdGenerator, long operationTimeoutMillis) {
        super((AsyncPrimitive)asyncIdGenerator);
        this.asyncIdGenerator = asyncIdGenerator;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    @Override
    public long nextId() {
        return this.complete(this.asyncIdGenerator.nextId());
    }

    @Override
    public AsyncAtomicIdGenerator async() {
        return this.asyncIdGenerator;
    }

    private <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(this.operationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PrimitiveException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new PrimitiveException.Timeout();
        }
        catch (ExecutionException e) {
            throw new PrimitiveException(e.getCause());
        }
    }
}

