/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.string;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.executor.string.StringExecutor;

public class SetBitExecutor
extends StringExecutor {
    private final String ERROR_NOT_INT = "The number provided must be numeric";
    private final String ERROR_VALUE = "The value is out of range, must be 0 or 1";
    private final String ERROR_ILLEGAL_OFFSET = "The offset is out of range, must be greater than or equal to 0  and at most 4294967295 (512MB)";

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        byte[] bytes;
        int value;
        long offset;
        List<byte[]> commandElems = command.getProcessedCommand();
        Region<ByteArrayWrapper, ByteArrayWrapper> r = context.getRegionProvider().getStringsRegion();
        if (commandElems.size() < 4) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the SETBIT command is \"SETBIT key offset value\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        this.checkAndSetDataType(key, context);
        ByteArrayWrapper wrapper = r.get(key);
        int returnBit = 0;
        try {
            byte[] offAr = commandElems.get(2);
            byte[] valAr = commandElems.get(3);
            offset = Coder.bytesToLong(offAr);
            value = Coder.bytesToInt(valAr);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The number provided must be numeric"));
            return;
        }
        if (value != 0 && value != 1) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The value is out of range, must be 0 or 1"));
            return;
        }
        if (offset < 0L || offset > 0xFFFFFFFFL) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The offset is out of range, must be greater than or equal to 0  and at most 4294967295 (512MB)"));
            return;
        }
        int byteIndex = (int)(offset / 8L);
        offset %= 8L;
        if (wrapper == null) {
            bytes = new byte[byteIndex + 1];
            if (value == 1) {
                bytes[byteIndex] = (byte)(128 >> (int)offset);
            }
            r.put(key, new ByteArrayWrapper(bytes));
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
        } else {
            bytes = wrapper.toBytes();
            returnBit = byteIndex < bytes.length ? (bytes[byteIndex] & 128 >> (int)offset) >> (int)(7L - offset) : 0;
            if (byteIndex < bytes.length) {
                bytes[byteIndex] = value == 1 ? (byte)(bytes[byteIndex] | 128 >> (int)offset) : (byte)(bytes[byteIndex] & ~(128 >> (int)offset));
                r.put(key, new ByteArrayWrapper(bytes));
            } else {
                byte[] newBytes = new byte[byteIndex + 1];
                System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
                newBytes[byteIndex] = value == 1 ? (byte)(newBytes[byteIndex] | 128 >> (int)offset) : (byte)(newBytes[byteIndex] & ~(128 >> (int)offset));
                r.put(key, new ByteArrayWrapper(newBytes));
            }
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), returnBit));
        }
    }
}

