/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.list;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.AbstractExecutor;

public abstract class ListExecutor
extends AbstractExecutor {
    protected static final int LIST_EMPTY_SIZE = 2;

    protected static final QueryService getQueryService() {
        return GemFireCacheImpl.getInstance().getQueryService();
    }

    protected Region<Integer, ByteArrayWrapper> getOrCreateRegion(ExecutionHandlerContext context, ByteArrayWrapper key, RedisDataType type) {
        return context.getRegionProvider().getOrCreateRegion(key, type, context);
    }

    protected Region<Integer, ByteArrayWrapper> getRegion(ExecutionHandlerContext context, ByteArrayWrapper key) {
        return context.getRegionProvider().getRegion(key);
    }

    protected void pushElements(ByteArrayWrapper key, List<byte[]> commandElems, int startIndex, int endIndex, Region keyRegion, ListDirection pushType, ExecutionHandlerContext context) {
        Integer opp;
        String indexKey = pushType == ListDirection.LEFT ? "head" : "tail";
        String oppositeKey = pushType == ListDirection.RIGHT ? "head" : "tail";
        Integer index = (Integer)keyRegion.get(indexKey);
        if (index != (opp = (Integer)keyRegion.get(oppositeKey))) {
            index = index + (pushType == ListDirection.LEFT ? -1 : 1);
        }
        for (int i = startIndex; i < endIndex; ++i) {
            Integer existingIndex;
            ByteArrayWrapper oldValue;
            byte[] value = commandElems.get(i);
            ByteArrayWrapper wrapper = new ByteArrayWrapper(value);
            do {
                if ((oldValue = keyRegion.putIfAbsent(index, wrapper)) == null) continue;
                index = index + (pushType == ListDirection.LEFT ? -1 : 1);
            } while (oldValue != null);
            boolean indexSet = false;
            do {
                existingIndex = (Integer)keyRegion.get(indexKey);
            } while ((pushType == ListDirection.RIGHT && existingIndex < index || pushType == ListDirection.LEFT && existingIndex > index) && !(indexSet = keyRegion.replace(indexKey, existingIndex, index)));
        }
    }

    protected static enum ListDirection {
        LEFT,
        RIGHT;

    }
}

