/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.hll;

import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.RedisDataTypeMismatchException;
import org.apache.geode.redis.internal.executor.AbstractExecutor;

public abstract class HllExecutor
extends AbstractExecutor {
    public static final Double DEFAULT_HLL_STD_DEV = 0.081;
    public static final Integer DEFAULT_HLL_DENSE = 18;
    public static final Integer DEFAULT_HLL_SPARSE = 32;

    protected final void checkAndSetDataType(ByteArrayWrapper key, ExecutionHandlerContext context) {
        RedisDataType oldVal = context.getRegionProvider().metaPutIfAbsent(key, RedisDataType.REDIS_HLL);
        if (oldVal == RedisDataType.REDIS_PROTECTED) {
            throw new RedisDataTypeMismatchException("The key name \"" + key + "\" is protected");
        }
        if (oldVal != null && oldVal != RedisDataType.REDIS_HLL) {
            throw new RedisDataTypeMismatchException("The key name \"" + key + "\" is already used by a " + ((Object)((Object)oldVal)).toString());
        }
    }
}

