/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.executor.AbstractExecutor;
import org.apache.geode.redis.internal.org.apache.hadoop.fs.GlobPattern;

public class KeysExecutor
extends AbstractExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        Pattern pattern;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the KEYS command is \"KEYS pattern\""));
            return;
        }
        String glob = Coder.bytesToString(commandElems.get(1));
        Set<String> allKeys = context.getRegionProvider().metaKeySet();
        ArrayList<String> matchingKeys = new ArrayList<String>();
        try {
            pattern = GlobPattern.compile(glob);
        }
        catch (PatternSyntaxException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Incorrect syntax for given glob regex"));
            return;
        }
        for (String key : allKeys) {
            if (key.equals("__ReDiS_MeTa_DaTa") || key.equals("ReDiS_StRiNgS") || key.equals("ReDiS_HlL") || !pattern.matcher(key).matches()) continue;
            matchingKeys.add(key);
        }
        if (matchingKeys.isEmpty()) {
            command.setResponse(Coder.getEmptyArrayResponse(context.getByteBufAllocator()));
        } else {
            command.setResponse(Coder.getBulkStringArrayResponse(context.getByteBufAllocator(), matchingKeys));
        }
    }
}

