/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.RedisCommandParserException;

public class ByteToCommandDecoder
extends ByteToMessageDecoder {
    private static final byte rID = 13;
    private static final byte nID = 10;
    private static final byte bulkStringID = 36;
    private static final byte arrayID = 42;
    private static final int MAX_BULK_STRING_LENGTH = 0x20000000;

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        Command c = null;
        do {
            in.markReaderIndex();
            c = this.parse(in);
            if (c == null) {
                in.resetReaderIndex();
                return;
            }
            out.add(c);
        } while (in.isReadable());
    }

    private Command parse(ByteBuf buffer) throws RedisCommandParserException {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (!buffer.isReadable()) {
            return null;
        }
        byte firstB = buffer.readByte();
        if (firstB != 42) {
            throw new RedisCommandParserException("Expected: * Actual: " + (char)firstB);
        }
        ArrayList<byte[]> commandElems = new ArrayList<byte[]>();
        if (!this.parseArray(commandElems, buffer)) {
            return null;
        }
        return new Command(commandElems);
    }

    private boolean parseArray(ArrayList<byte[]> commandElems, ByteBuf buffer) throws RedisCommandParserException {
        int arrayLength = this.parseCurrentNumber(buffer);
        if (arrayLength == Integer.MIN_VALUE || !this.parseRN(buffer)) {
            return false;
        }
        if (arrayLength < 0 || arrayLength > 1000000000) {
            throw new RedisCommandParserException("invalid multibulk length");
        }
        for (int i = 0; i < arrayLength; ++i) {
            byte[] newBulkString;
            if (!buffer.isReadable()) {
                return false;
            }
            byte currentChar = buffer.readByte();
            if (currentChar == 36) {
                newBulkString = this.parseBulkString(buffer);
                if (newBulkString == null) {
                    return false;
                }
            } else {
                throw new RedisCommandParserException("expected: '$', got '" + (char)currentChar + "'");
            }
            commandElems.add(newBulkString);
        }
        return true;
    }

    private byte[] parseBulkString(ByteBuf buffer) throws RedisCommandParserException {
        int bulkStringLength = this.parseCurrentNumber(buffer);
        if (bulkStringLength == Integer.MIN_VALUE) {
            return null;
        }
        if (bulkStringLength > 0x20000000) {
            throw new RedisCommandParserException("invalid bulk length, cannot exceed max length of 536870912");
        }
        if (!this.parseRN(buffer)) {
            return null;
        }
        if (!buffer.isReadable(bulkStringLength)) {
            return null;
        }
        byte[] bulkString = new byte[bulkStringLength];
        buffer.readBytes(bulkString);
        if (!this.parseRN(buffer)) {
            return null;
        }
        return bulkString;
    }

    private int parseCurrentNumber(ByteBuf buffer) {
        int number = 0;
        int readerIndex = buffer.readerIndex();
        byte b = 0;
        while (true) {
            if (!buffer.isReadable()) {
                return Integer.MIN_VALUE;
            }
            b = buffer.readByte();
            if (!Character.isDigit(b)) break;
            number = number * 10 + (b - 48);
            ++readerIndex;
        }
        buffer.readerIndex(readerIndex);
        return number;
    }

    private boolean parseRN(ByteBuf buffer) throws RedisCommandParserException {
        if (!buffer.isReadable(2)) {
            return false;
        }
        byte b = buffer.readByte();
        if (b != 13) {
            throw new RedisCommandParserException("expected '\r', got '" + (char)b + "'");
        }
        b = buffer.readByte();
        if (b != 10) {
            throw new RedisCommandParserException("expected: '\n', got '" + (char)b + "'");
        }
        return true;
    }
}

