/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.pdx.internal;

import java.nio.ByteBuffer;
import java.util.Date;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.pdx.PdxFieldDoesNotExistException;
import org.apache.geode.pdx.PdxFieldTypeMismatchException;
import org.apache.geode.pdx.WritablePdxInstance;
import org.apache.geode.pdx.internal.PdxField;
import org.apache.geode.pdx.internal.PdxInstanceImpl;
import org.apache.geode.pdx.internal.PdxOutputStream;
import org.apache.geode.pdx.internal.PdxReaderImpl;
import org.apache.geode.pdx.internal.PdxType;
import org.apache.geode.pdx.internal.PdxWriterImpl;
import org.apache.geode.pdx.internal.TypeRegistry;

public class WritablePdxInstanceImpl
extends PdxInstanceImpl
implements WritablePdxInstance {
    private static final long serialVersionUID = 7398999150097596214L;
    private static final Object NULL_TOKEN = new Object();
    private Object[] dirtyFields = null;

    public WritablePdxInstanceImpl(PdxReaderImpl original) {
        super(original);
    }

    private synchronized void dirtyField(PdxField f, Object value) {
        if (this.dirtyFields == null) {
            this.dirtyFields = new Object[this.getPdxType().getFieldCount()];
        }
        if (value == null) {
            value = NULL_TOKEN;
        }
        this.dirtyFields[f.getFieldIndex()] = value;
        this.clearCachedState();
    }

    @Override
    protected synchronized PdxReaderImpl getUnmodifiableReader(String fieldName) {
        PdxField f;
        if (this.dirtyFields != null && (f = this.getPdxType().getPdxField(fieldName)) != null && this.dirtyFields[f.getFieldIndex()] != null) {
            return this.getUnmodifiableReader();
        }
        return new PdxReaderImpl(this);
    }

    @Override
    public synchronized Object getCachedObject() {
        return super.getCachedObject();
    }

    @Override
    public synchronized int hashCode() {
        return super.hashCode();
    }

    @Override
    protected synchronized PdxReaderImpl getUnmodifiableReader() {
        if (this.dirtyFields != null) {
            PdxWriterImpl writer;
            PdxOutputStream os = new PdxOutputStream(this.basicSize() + 9);
            if (this.getPdxType().getHasDeletedField()) {
                PdxType pt = new PdxType(this.getPdxType().getClassName(), !this.getPdxType().getNoDomainClass());
                GemFireCacheImpl gfc = GemFireCacheImpl.getForPdx("PDX registry is unavailable because the Cache has been closed.");
                TypeRegistry tr = gfc.getPdxRegistry();
                writer = new PdxWriterImpl(pt, tr, os);
            } else {
                writer = new PdxWriterImpl(this.getPdxType(), os);
            }
            for (PdxField f : this.getPdxType().getFields()) {
                if (f.isDeleted()) continue;
                Object dv = this.dirtyFields[f.getFieldIndex()];
                if (dv != null) {
                    if (dv == NULL_TOKEN) {
                        dv = null;
                    }
                    writer.writeField(f, dv);
                    continue;
                }
                writer.writeRawField(f, this.getRaw(f));
            }
            writer.completeByteStreamGeneration();
            ByteBuffer bb = os.toByteBuffer();
            bb.position(9);
            this.basicSetBuffer(bb.slice());
            this.dirtyFields = null;
        }
        return new PdxReaderImpl(this);
    }

    @Override
    public void setField(String fieldName, Object value) {
        PdxField f;
        block58: {
            block57: {
                f = this.getPdxType().getPdxField(fieldName);
                if (f == null) {
                    throw new PdxFieldDoesNotExistException("A field named " + fieldName + " does not exist on " + this.getPdxType());
                }
                if (value == null) break block57;
                switch (f.getFieldType()) {
                    case CHAR: {
                        if (!(value instanceof Character)) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a Character but was a " + value.getClass());
                        }
                        break block58;
                    }
                    case BOOLEAN: {
                        if (!(value instanceof Boolean)) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a Boolean but was a " + value.getClass());
                        }
                        break block58;
                    }
                    case BYTE: {
                        if (!(value instanceof Byte)) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a Byte but was a " + value.getClass());
                        }
                        break block58;
                    }
                    case SHORT: {
                        if (!(value instanceof Short)) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a Short but was a " + value.getClass());
                        }
                        break block58;
                    }
                    case INT: {
                        if (!(value instanceof Integer)) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a Integer but was a " + value.getClass());
                        }
                        break block58;
                    }
                    case LONG: {
                        if (!(value instanceof Long)) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a Long but was a " + value.getClass());
                        }
                        break block58;
                    }
                    case FLOAT: {
                        if (!(value instanceof Float)) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a Float but was a " + value.getClass());
                        }
                        break block58;
                    }
                    case DOUBLE: {
                        if (!(value instanceof Double)) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a Double but was a " + value.getClass());
                        }
                        break block58;
                    }
                    case STRING: {
                        if (!(value instanceof String)) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a String but was a " + value.getClass());
                        }
                        break block58;
                    }
                    case BOOLEAN_ARRAY: {
                        if (!(value instanceof boolean[])) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a boolean[] but was a " + value.getClass());
                        }
                        break block58;
                    }
                    case CHAR_ARRAY: {
                        if (!(value instanceof char[])) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a char[] but was a " + value.getClass());
                        }
                        break block58;
                    }
                    case BYTE_ARRAY: {
                        if (!(value instanceof byte[])) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a byte[] but was a " + value.getClass());
                        }
                        break block58;
                    }
                    case SHORT_ARRAY: {
                        if (!(value instanceof short[])) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a short[] but was a " + value.getClass());
                        }
                        break block58;
                    }
                    case INT_ARRAY: {
                        if (!(value instanceof int[])) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a int[] but was a " + value.getClass());
                        }
                        break block58;
                    }
                    case LONG_ARRAY: {
                        if (!(value instanceof long[])) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a long[] but was a " + value.getClass());
                        }
                        break block58;
                    }
                    case FLOAT_ARRAY: {
                        if (!(value instanceof float[])) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a float[] but was a " + value.getClass());
                        }
                        break block58;
                    }
                    case DOUBLE_ARRAY: {
                        if (!(value instanceof double[])) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a double[] but was a " + value.getClass());
                        }
                        break block58;
                    }
                    case STRING_ARRAY: {
                        if (!(value instanceof String[])) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a String[] but was a " + value.getClass());
                        }
                        break block58;
                    }
                    case ARRAY_OF_BYTE_ARRAYS: {
                        if (!(value instanceof byte[][])) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a byte[][] but was a " + value.getClass());
                        }
                        break block58;
                    }
                    case OBJECT_ARRAY: {
                        if (!(value instanceof Object[])) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a Object[] but was a " + value.getClass());
                        }
                        break block58;
                    }
                    case OBJECT: {
                        break block58;
                    }
                    case DATE: {
                        if (!Date.class.equals(value.getClass())) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a Date but was a " + value.getClass());
                        }
                        break block58;
                    }
                    default: {
                        throw new InternalGemFireException("Unhandled field type " + (Object)((Object)f.getFieldType()));
                    }
                }
            }
            switch (f.getFieldType()) {
                case CHAR: {
                    value = Character.valueOf('\u0000');
                    break;
                }
                case BOOLEAN: {
                    value = false;
                    break;
                }
                case BYTE: {
                    value = (byte)0;
                    break;
                }
                case SHORT: {
                    value = (short)0;
                    break;
                }
                case INT: {
                    value = 0;
                    break;
                }
                case FLOAT: {
                    value = Float.valueOf(0.0f);
                    break;
                }
                case DOUBLE: {
                    value = 0.0;
                    break;
                }
                case LONG: {
                    value = 0L;
                    break;
                }
                case STRING: 
                case BOOLEAN_ARRAY: 
                case CHAR_ARRAY: 
                case BYTE_ARRAY: 
                case SHORT_ARRAY: 
                case INT_ARRAY: 
                case LONG_ARRAY: 
                case FLOAT_ARRAY: 
                case DOUBLE_ARRAY: 
                case STRING_ARRAY: 
                case ARRAY_OF_BYTE_ARRAYS: 
                case OBJECT_ARRAY: 
                case OBJECT: 
                case DATE: {
                    break;
                }
                default: {
                    throw new InternalGemFireException("Unhandled field type " + (Object)((Object)f.getFieldType()));
                }
            }
        }
        this.dirtyField(f, value);
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

