/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.callbacks;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.util.CacheListenerAdapter;
import org.apache.geode.distributed.internal.ClusterConfigurationService;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.configuration.domain.Configuration;
import org.apache.logging.log4j.Logger;

public class ConfigurationChangeListener
extends CacheListenerAdapter<String, Configuration> {
    private static final Logger logger = LogService.getLogger();
    private final ClusterConfigurationService sharedConfig;

    public ConfigurationChangeListener(ClusterConfigurationService sharedConfig) {
        this.sharedConfig = sharedConfig;
    }

    @Override
    public void afterUpdate(EntryEvent<String, Configuration> event) {
        super.afterUpdate(event);
        this.addOrRemoveJarFromFilesystem(event);
    }

    @Override
    public void afterCreate(EntryEvent<String, Configuration> event) {
        super.afterCreate(event);
        this.addOrRemoveJarFromFilesystem(event);
    }

    private void addOrRemoveJarFromFilesystem(EntryEvent<String, Configuration> event) {
        String group = event.getKey();
        Configuration newConfig = event.getNewValue();
        Configuration oldConfig = event.getOldValue();
        Set<String> newJars = newConfig.getJarNames();
        Set<Object> oldJars = oldConfig == null ? new HashSet() : oldConfig.getJarNames();
        HashSet<String> jarsAdded = new HashSet<String>(newJars);
        HashSet jarsRemoved = new HashSet(oldJars);
        jarsAdded.removeAll(oldJars);
        jarsRemoved.removeAll(newJars);
        if (!jarsAdded.isEmpty() && !jarsRemoved.isEmpty()) {
            throw new IllegalStateException("We don't expect to have jars both added and removed in one event");
        }
        for (String jarAdded : jarsAdded) {
            if (this.jarExistsInFilesystem(group, jarAdded)) continue;
            try {
                this.sharedConfig.downloadJarFromOtherLocators(group, jarAdded);
            }
            catch (Exception e) {
                logger.error("Unable to add jar: " + jarAdded, (Throwable)e);
            }
        }
        for (String jarRemoved : jarsRemoved) {
            File jar = this.sharedConfig.getPathToJarOnThisLocator(group, jarRemoved).toFile();
            if (!jar.exists()) continue;
            try {
                FileUtils.forceDelete(jar);
            }
            catch (IOException e) {
                logger.error("Exception occurred while attempting to delete a jar from the filesystem: {}", (Object)jarRemoved, (Object)e);
            }
        }
    }

    private boolean jarExistsInFilesystem(String groupName, String jarName) {
        return this.sharedConfig.getPathToJarOnThisLocator(groupName, jarName).toFile().exists();
    }
}

