/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.result;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Time;
import java.text.MessageFormat;
import java.util.zip.DataFormatException;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.json.GfJsonArray;
import org.apache.geode.management.internal.cli.json.GfJsonException;
import org.apache.geode.management.internal.cli.json.GfJsonObject;
import org.apache.geode.management.internal.cli.result.ResultData;
import org.apache.geode.management.internal.cli.result.ResultDataException;
import org.apache.geode.management.internal.cli.shell.Gfsh;

public abstract class AbstractResultData
implements ResultData {
    public static final String SECTION_DATA_ACCESSOR = "__sections__";
    public static final String TABLE_DATA_ACCESSOR = "__tables__";
    public static final String BYTE_DATA_ACCESSOR = "__bytes__";
    public static final int FILE_TYPE_BINARY = 0;
    public static final int FILE_TYPE_TEXT = 1;
    private static final String FILE_NAME_FIELD = "fileName";
    private static final String FILE_TYPE_FIELD = "fileType";
    private static final String FILE_DATA_FIELD = "fileData";
    private static final String DATA_FIELD = "data";
    private static final String DATA_LENGTH_FIELD = "dataLength";
    private static final String FILE_MESSAGE = "fileMessage";
    protected GfJsonObject gfJsonObject;
    protected GfJsonObject contentObject;
    private Result.Status status = Result.Status.OK;

    protected AbstractResultData() {
        this.gfJsonObject = new GfJsonObject();
        this.contentObject = new GfJsonObject();
        try {
            this.gfJsonObject.putOpt("content", this.contentObject);
        }
        catch (GfJsonException gfJsonException) {
            // empty catch block
        }
    }

    protected AbstractResultData(GfJsonObject jsonObject) {
        this.gfJsonObject = jsonObject;
        this.contentObject = this.gfJsonObject.getJSONObject("content");
    }

    @Override
    public GfJsonObject getGfJsonObject() {
        return this.gfJsonObject;
    }

    @Override
    public abstract String getType();

    @Override
    public String getHeader() {
        return this.gfJsonObject.getString("header");
    }

    @Override
    public String getFooter() {
        return this.gfJsonObject.getString("footer");
    }

    public AbstractResultData setHeader(String headerText) {
        try {
            this.gfJsonObject.put("header", headerText);
        }
        catch (GfJsonException e) {
            throw new ResultDataException(e.getMessage());
        }
        return this;
    }

    public AbstractResultData setFooter(String footerText) {
        try {
            this.gfJsonObject.put("footer", footerText);
        }
        catch (GfJsonException e) {
            throw new ResultDataException(e.getMessage());
        }
        return this;
    }

    private static String addTimeStampBeforeLastDot(String src) {
        String toAdd = String.valueOf(new Time(System.currentTimeMillis()));
        toAdd = "-" + toAdd.replaceAll(":", "_");
        int lastIndexOf = src.lastIndexOf(".");
        if (lastIndexOf != -1) {
            String substr1 = src.substring(0, lastIndexOf);
            String substr2 = src.substring(lastIndexOf);
            src = substr1 + toAdd + substr2;
        } else {
            src = src + toAdd;
        }
        return src;
    }

    public ResultData addAsFile(String fileName, String fileContents, String message, boolean addTimeStampToName) {
        return this.addAsFile(fileName, fileContents.getBytes(), 1, message, addTimeStampToName);
    }

    public ResultData addAsFile(String fileName, byte[] data, int fileType, String message, boolean addTimeStampToName) {
        byte[] bytes = data;
        if (addTimeStampToName) {
            fileName = AbstractResultData.addTimeStampBeforeLastDot(fileName);
        }
        return this.addAsFile(fileName.getBytes(), bytes, fileType, message);
    }

    public ResultData addByteDataFromFileFile(String filePath, int fileType, String message, boolean addTimeStampToName) throws FileNotFoundException, IOException {
        byte[][] filesToBytes = CliUtil.filesToBytes(new String[]{filePath});
        byte[] bytes = filesToBytes[0];
        if (addTimeStampToName) {
            String fileName = new String(filesToBytes[0]);
            fileName = AbstractResultData.addTimeStampBeforeLastDot(fileName);
            bytes = fileName.getBytes();
        }
        return this.addAsFile(bytes, filesToBytes[1], fileType, message);
    }

    private ResultData addAsFile(byte[] fileName, byte[] data, int fileType, String message) {
        if (fileType != 0 && fileType != 1) {
            throw new IllegalArgumentException("Unsupported file type is specified.");
        }
        GfJsonObject sectionData = new GfJsonObject();
        try {
            GfJsonArray fileDataArray = this.contentObject.getJSONArray(BYTE_DATA_ACCESSOR);
            if (fileDataArray == null) {
                fileDataArray = new GfJsonArray();
                this.contentObject.put(BYTE_DATA_ACCESSOR, fileDataArray);
            }
            fileDataArray.put(sectionData);
            sectionData.put(FILE_NAME_FIELD, fileName);
            sectionData.put(FILE_TYPE_FIELD, fileType);
            sectionData.put(FILE_MESSAGE, message.getBytes());
            sectionData.putAsJSONObject(FILE_DATA_FIELD, CliUtil.compressBytes(data));
        }
        catch (GfJsonException e) {
            throw new ResultDataException(e.getMessage());
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void readFileDataAndDump(GfJsonArray byteDataArray, String directory) throws GfJsonException, DataFormatException, IOException {
        boolean overwriteAllExisting = false;
        int length = byteDataArray.size();
        String options = length > 1 ? "(y/N/a)" : "(y/N)";
        for (int i = 0; i < length; ++i) {
            GfJsonObject object = byteDataArray.getJSONObject(i);
            int fileType = object.getInt(FILE_TYPE_FIELD);
            if (fileType != 0 && fileType != 1) {
                throw new IllegalArgumentException("Unsupported file type found.");
            }
            byte[] fileNameBytes = null;
            GfJsonArray fileNameJsonBytes = object.getJSONArray(FILE_NAME_FIELD);
            fileNameBytes = fileNameJsonBytes != null ? GfJsonArray.toByteArray(fileNameJsonBytes) : (byte[])object.get(FILE_NAME_FIELD);
            String fileName = new String(fileNameBytes);
            byte[] fileMessageBytes = null;
            GfJsonArray fileMessageJsonBytes = object.getJSONArray(FILE_MESSAGE);
            fileMessageBytes = fileMessageJsonBytes != null ? GfJsonArray.toByteArray(fileMessageJsonBytes) : (byte[])object.get(FILE_MESSAGE);
            String fileMessage = new String(fileMessageBytes);
            GfJsonObject fileDataBytes = object.getJSONObject(FILE_DATA_FIELD);
            byte[] byteArray = GfJsonArray.toByteArray(fileDataBytes.getJSONArray(DATA_FIELD));
            int dataLength = fileDataBytes.getInt(DATA_LENGTH_FIELD);
            CliUtil.DeflaterInflaterData uncompressBytes = CliUtil.uncompressBytes(byteArray, dataLength);
            byte[] uncompressed = uncompressBytes.getData();
            if (directory == null || directory.isEmpty()) {
                directory = System.getProperty("user.dir", ".");
            }
            boolean isGfshVM = CliUtil.isGfshVM();
            File fileToDumpData = new File(fileName);
            if (!fileToDumpData.isAbsolute()) {
                fileToDumpData = new File(directory, fileName);
            }
            File parentDirectory = fileToDumpData.getParentFile();
            if (fileToDumpData.exists()) {
                String fileExistsMessage = CliStrings.format("File with name \"{0}\" already exists in \"{1}\".", fileName, fileToDumpData.getParent(), options);
                if (!isGfshVM) throw new IOException(fileExistsMessage);
                Gfsh gfsh = Gfsh.getCurrentInstance();
                if (gfsh != null && !gfsh.isQuietMode() && !overwriteAllExisting) {
                    String interaction = gfsh.interact(fileExistsMessage = fileExistsMessage + " Overwrite? " + options + " : ");
                    if ("a".equalsIgnoreCase(interaction.trim())) {
                        overwriteAllExisting = true;
                    } else if (!"y".equalsIgnoreCase(interaction.trim())) {
                        continue;
                    }
                }
            } else {
                if (!parentDirectory.exists()) {
                    AbstractResultData.handleCondition(CliStrings.format("Parent directory of \"{0}\" does not exist.", (Object)fileToDumpData.getAbsolutePath()), isGfshVM);
                    return;
                }
                if (!parentDirectory.canWrite()) {
                    AbstractResultData.handleCondition(CliStrings.format("Parent directory of \"{0}\" is not writable.", (Object)fileToDumpData.getAbsolutePath()), isGfshVM);
                    return;
                }
                if (!parentDirectory.isDirectory()) {
                    AbstractResultData.handleCondition(CliStrings.format("Parent of \"{0}\" is not a directory.", (Object)fileToDumpData.getAbsolutePath()), isGfshVM);
                    return;
                }
            }
            if (fileType == 1) {
                FileWriter fw = new FileWriter(fileToDumpData);
                BufferedWriter bw = new BufferedWriter(fw);
                bw.write(new String(uncompressed));
                bw.flush();
                fw.flush();
                fw.close();
            } else if (fileType == 0) {
                FileOutputStream fos = new FileOutputStream(fileToDumpData);
                fos.write(uncompressed);
                fos.flush();
                fos.close();
            }
            if (fileMessage == null || fileMessage.isEmpty() || !isGfshVM) continue;
            Gfsh.println(MessageFormat.format(fileMessage, fileToDumpData.getAbsolutePath()));
        }
    }

    static void handleCondition(String message, boolean isGfshVM) throws IOException {
        if (isGfshVM) {
            Gfsh gfsh = Gfsh.getCurrentInstance();
            if (gfsh != null && !gfsh.isQuietMode()) {
                gfsh.logWarning(message, null);
            }
        } else {
            throw new IOException(message);
        }
    }

    @Override
    public void setStatus(Result.Status status) {
        this.status = status;
    }

    @Override
    public Result.Status getStatus() {
        return this.status;
    }
}

