/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.help;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.geode.management.internal.cli.parser.CommandTarget;

public class CliTopic
implements Comparable<CliTopic> {
    private static final Map<String, String> nameDescriptionMap = new HashMap<String, String>();
    private final String name;
    private final String oneLinerDescription;
    private Set<CommandTarget> commandTargets;

    public CliTopic(String name) {
        this.name = name;
        this.oneLinerDescription = nameDescriptionMap.get(this.name);
        this.commandTargets = new HashSet<CommandTarget>();
    }

    public String getName() {
        return this.name;
    }

    public String getOneLinerDescription() {
        return this.oneLinerDescription;
    }

    public void addCommandTarget(CommandTarget commandTarget) {
        this.commandTargets.add(commandTarget);
    }

    public Map<String, String> getCommandsNameHelp() {
        TreeMap<String, String> commandsNameHelp = new TreeMap<String, String>();
        for (CommandTarget commandTarget : this.commandTargets) {
            commandsNameHelp.put(commandTarget.getCommandName(), commandTarget.getCommandHelp());
        }
        return commandsNameHelp;
    }

    @Override
    public int compareTo(CliTopic o) {
        if (o != null) {
            return this.name.compareTo(o.name);
        }
        return -1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        CliTopic other = (CliTopic)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return CliTopic.class.getSimpleName() + "[" + this.name + "]";
    }

    static {
        nameDescriptionMap.put("Geode", "Apache Geode is a distributed data management platform providing dynamic scalability, high performance and database-like persistence.");
        nameDescriptionMap.put("Region", "A region is the core building block of the Apache Geode distributed system. Cached data is organized into regions and all data puts, gets, and querying activities are done against them.");
        nameDescriptionMap.put("WAN", "For multiple data centers in remote locations, Geode provides a WAN gateway to facilitate data sharing. The WAN gateway connects two or more remote sites and then sends asynchronous, batched updates as data is changed.");
        nameDescriptionMap.put("JMX", "JMX technology provides the tools for building distributed, Web-based, modular and dynamic solutions for managing and monitoring devices, applications, and service-driven networks.");
        nameDescriptionMap.put("Disk Store", "Disk stores are used to persist data to disk as a backup to your in-memory copy or as overflow storage when memory use is too high.");
        nameDescriptionMap.put("Locator", "JVMs running Geode discover each other through a TCP service named the locator.");
        nameDescriptionMap.put("Server", "A server is Geode cluster member which holds a Geode cache. Depending on the topology used it can refer to either a system that responds to client requests or a system that is only a peer to other members.");
        nameDescriptionMap.put("Manager", "The Manager is a member which has the additional role of a managing & monitoring the Geode distributed system.");
        nameDescriptionMap.put("Statistics", "iEvery application and server in a Apache Geode distributed system can be configured to perform statistical data collection for analysis.");
        nameDescriptionMap.put("Lifecycle", "Launching, execution and termination of Geode cluster members such as servers and locators.");
        nameDescriptionMap.put("Management-Monitoring", "The management of and monitoring of Geode systems using Geode tools, such as Apache Geode Pulse or Data Browser, and JConsole, which is provided with the JDK(TM)");
        nameDescriptionMap.put("Data", "User data as stored in regions of the Geode distributed system.");
        nameDescriptionMap.put("Configuration", "Configuration of Apache Geode Cache & Servers/Locators hosting the Cache.");
        nameDescriptionMap.put("Function Execution", "The function execution service provides solutions for these application use cases: \n\tAn application that executes a server-side transaction or carries out data updates using the Geode distributed locking service. \n\tAn application that needs to initialize some of its components once on each server, which might be used later by executed functions. Initialization and startup of a third-party service, such as a messaging service. \n\tAny arbitrary aggregation operation that requires iteration over local data sets that can be done more efficiently through a single call to the cache server. \n\tAny kind of external resource provisioning that can be done by executing a function on a server.");
        nameDescriptionMap.put("Help", "Provides usage information for gfsh & its commands.");
        nameDescriptionMap.put("Debug-Utility", "Debugging aids & utilities to use with Apache Geode.");
        nameDescriptionMap.put("GFSH", "The Geode Shell");
    }
}

