/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.cache.wan.GatewaySenderException;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.GatewaySenderDestroyFunctionArgs;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.logging.log4j.Logger;

public class GatewaySenderDestroyFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogService.getLogger();
    private static final String ID = GatewaySenderDestroyFunction.class.getName();
    public static GatewaySenderDestroyFunction INSTANCE = new GatewaySenderDestroyFunction();

    @Override
    public void execute(FunctionContext context) {
        ResultSender<CliFunctionResult> resultSender = context.getResultSender();
        Cache cache = CacheFactory.getAnyInstance();
        String memberNameOrId = CliUtil.getMemberNameOrId(cache.getDistributedSystem().getDistributedMember());
        GatewaySenderDestroyFunctionArgs gatewaySenderDestroyFunctionArgs = (GatewaySenderDestroyFunctionArgs)context.getArguments();
        try {
            GatewaySender gatewaySender = cache.getGatewaySender(gatewaySenderDestroyFunctionArgs.getId());
            if (gatewaySender == null) {
                throw new GatewaySenderException("GateWaySender with Id  " + gatewaySenderDestroyFunctionArgs.getId() + " not found");
            }
            gatewaySender.stop();
            gatewaySender.destroy();
            resultSender.lastResult(new CliFunctionResult(memberNameOrId, true, CliStrings.format("GatewaySender \"{0}\" destroyed on \"{1}\"", gatewaySenderDestroyFunctionArgs.getId(), memberNameOrId)));
        }
        catch (GatewaySenderException gse) {
            resultSender.lastResult(this.handleException(memberNameOrId, gse.getMessage(), gse));
        }
        catch (Exception e) {
            String exceptionMsg = e.getMessage();
            if (exceptionMsg == null) {
                exceptionMsg = CliUtil.stackTraceAsString(e);
            }
            resultSender.lastResult(this.handleException(memberNameOrId, exceptionMsg, e));
        }
    }

    private CliFunctionResult handleException(String memberNameOrId, String exceptionMsg, Exception e) {
        if (e != null && logger.isDebugEnabled()) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        if (exceptionMsg != null) {
            return new CliFunctionResult(memberNameOrId, false, exceptionMsg);
        }
        return new CliFunctionResult(memberNameOrId);
    }

    @Override
    public String getId() {
        return ID;
    }
}

