/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.List;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.query.Index;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.management.internal.cli.domain.IndexInfo;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;

public class DestroyIndexFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        IndexInfo indexInfo = (IndexInfo)context.getArguments();
        String memberId = null;
        try {
            Cache cache = CacheFactory.getAnyInstance();
            memberId = cache.getDistributedSystem().getDistributedMember().getId();
            QueryService queryService = cache.getQueryService();
            String indexName = indexInfo.getIndexName();
            String regionPath = indexInfo.getRegionPath();
            XmlEntity xmlEntity = new XmlEntity("region", "name", regionPath, "index", "name", indexName);
            if (regionPath != null && !regionPath.isEmpty()) {
                Region region = cache.getRegion(regionPath);
                if (region != null) {
                    if (indexName == null || indexName.isEmpty()) {
                        queryService.removeIndexes(region);
                        context.getResultSender().lastResult(new CliFunctionResult(memberId, xmlEntity));
                    } else {
                        Index index = queryService.getIndex(region, indexName);
                        if (index != null) {
                            queryService.removeIndex(index);
                            context.getResultSender().lastResult(new CliFunctionResult(memberId, xmlEntity));
                        } else {
                            context.getResultSender().lastResult(new CliFunctionResult(memberId, false, CliStrings.format("Index named \"{0}\" not found", (Object)indexName)));
                        }
                    }
                } else {
                    context.getResultSender().lastResult(new CliFunctionResult(memberId, false, CliStrings.format("Region \"{0}\" not found", (Object)regionPath)));
                }
            } else if (indexName == null || indexName.isEmpty()) {
                queryService.removeIndexes();
                context.getResultSender().lastResult(new CliFunctionResult(memberId, xmlEntity));
            } else if (this.removeIndexByName(indexName, queryService)) {
                context.getResultSender().lastResult(new CliFunctionResult(memberId, xmlEntity));
            } else {
                context.getResultSender().lastResult(new CliFunctionResult(memberId, false, CliStrings.format("Index named \"{0}\" not found", (Object)indexName)));
            }
        }
        catch (CacheClosedException e) {
            context.getResultSender().lastResult(new CliFunctionResult(memberId, e, e.getMessage()));
        }
        catch (Exception e) {
            context.getResultSender().lastResult(new CliFunctionResult(memberId, e, e.getMessage()));
        }
    }

    private boolean removeIndexByName(String name, QueryService queryService) {
        List indexes = (List)queryService.getIndexes();
        boolean removed = false;
        if (indexes != null) {
            for (Index index : indexes) {
                if (!index.getName().equals(name)) continue;
                queryService.removeIndex(index);
                removed = true;
            }
        }
        return removed;
    }

    @Override
    public String getId() {
        return DestroyIndexFunction.class.getName();
    }
}

