/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands.dto;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.geode.management.internal.cli.commands.dto.RegionAttributesInfo;
import org.apache.geode.management.internal.cli.commands.dto.RegionMemberDetails;
import org.apache.geode.management.internal.cli.json.GfJsonObject;
import org.apache.geode.management.internal.cli.result.CliJsonSerializable;
import org.apache.geode.management.internal.cli.util.JsonUtil;

public class RegionDetails
implements CliJsonSerializable {
    private static Map<String, String> nameToDisplayName = new HashMap<String, String>();
    private String name;
    private String path;
    private boolean isPartitioned;
    private boolean isPersistent;
    private String[] groups;
    private RegionAttributesInfo regionAttributesInfo;
    private List<RegionMemberDetails> regionMemberDetailsList;
    private String[] fieldsToSkipOnUI;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isPartitioned() {
        return this.isPartitioned;
    }

    public void setPartitioned(boolean isPartitioned) {
        this.isPartitioned = isPartitioned;
    }

    public boolean isPersistent() {
        return this.isPersistent;
    }

    public void setPersistent(boolean isPersistent) {
        this.isPersistent = isPersistent;
    }

    public RegionAttributesInfo getRegionAttributesInfo() {
        return this.regionAttributesInfo;
    }

    public void setRegionAttributesInfo(RegionAttributesInfo regionAttributesInfo) {
        this.regionAttributesInfo = regionAttributesInfo;
    }

    public List<RegionMemberDetails> getRegionMemberDetailsList() {
        return this.regionMemberDetailsList;
    }

    public void setRegionMemberDetailsList(List<RegionMemberDetails> regionMemberDetailsList) {
        this.regionMemberDetailsList = regionMemberDetailsList;
    }

    public String[] getGroups() {
        return this.groups;
    }

    public void setGroups(String ... groups) {
        this.groups = groups;
    }

    @Override
    public int getJSId() {
        return 11;
    }

    @Override
    public Map<String, String> getFieldNameToDisplayName() {
        return nameToDisplayName;
    }

    @Override
    public String[] getFieldsToSkipOnUI() {
        return this.fieldsToSkipOnUI;
    }

    @Override
    public void setFieldsToSkipOnUI(String ... fieldsToSkipOnUI) {
        this.fieldsToSkipOnUI = fieldsToSkipOnUI;
    }

    @Override
    public void fromJson(GfJsonObject objectStateAsjson) {
        this.name = JsonUtil.getString(objectStateAsjson, "name");
        this.path = JsonUtil.getString(objectStateAsjson, "path");
        this.isPartitioned = JsonUtil.getBoolean(objectStateAsjson, "partitioned");
        this.isPersistent = JsonUtil.getBoolean(objectStateAsjson, "persistent");
        this.groups = JsonUtil.getStringArray(objectStateAsjson, "groups");
        if (objectStateAsjson.has("regionAttributesInfo")) {
            this.regionAttributesInfo = new RegionAttributesInfo();
            this.regionAttributesInfo.fromJson(JsonUtil.getJSONObject(objectStateAsjson, "regionAttributesInfo"));
        }
        List<CliJsonSerializable> retrievedList = JsonUtil.getList(objectStateAsjson, "regionMemberDetailsList");
        this.regionMemberDetailsList = new ArrayList<RegionMemberDetails>();
        for (int i = 0; i < retrievedList.size(); ++i) {
            this.regionMemberDetailsList.add((RegionMemberDetails)retrievedList.get(i));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.fieldsToSkipOnUI);
        result = 31 * result + Arrays.hashCode(this.groups);
        result = 31 * result + (this.isPartitioned ? 1231 : 1237);
        result = 31 * result + (this.isPersistent ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.regionAttributesInfo == null ? 0 : this.regionAttributesInfo.hashCode());
        result = 31 * result + (this.regionMemberDetailsList == null ? 0 : this.regionMemberDetailsList.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegionDetails other = (RegionDetails)obj;
        if (!Arrays.equals(this.fieldsToSkipOnUI, other.fieldsToSkipOnUI)) {
            return false;
        }
        if (!Arrays.equals(this.groups, other.groups)) {
            return false;
        }
        if (this.isPartitioned != other.isPartitioned) {
            return false;
        }
        if (this.isPersistent != other.isPersistent) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.regionAttributesInfo == null ? other.regionAttributesInfo != null : !this.regionAttributesInfo.equals(other.regionAttributesInfo)) {
            return false;
        }
        return !(this.regionMemberDetailsList == null ? other.regionMemberDetailsList != null : !this.areMemberDetailsSame(this.regionMemberDetailsList, other.regionMemberDetailsList));
    }

    private boolean areMemberDetailsSame(List<RegionMemberDetails> mine, List<RegionMemberDetails> other) {
        if (other != null && other.size() == mine.size()) {
            for (int i = 0; i < mine.size(); ++i) {
                if (mine.get(i).equals(other.get(i))) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RegionDetails [name=");
        builder.append(this.name);
        builder.append(", path=");
        builder.append(this.path);
        builder.append(", isPartitioned=");
        builder.append(this.isPartitioned);
        builder.append(", isPersistent=");
        builder.append(this.isPersistent);
        builder.append(", groups=");
        builder.append(Arrays.toString(this.groups));
        builder.append(", regionAttributesInfo=");
        builder.append(this.regionAttributesInfo);
        builder.append(", regionMemberDetailsList=");
        builder.append(this.regionMemberDetailsList);
        builder.append("]");
        return builder.toString();
    }

    static {
        nameToDisplayName.put("name", "Name");
        nameToDisplayName.put("path", "Path");
        nameToDisplayName.put("partitioned", "Is Partitioned");
        nameToDisplayName.put("persistent", "Is Persistent");
        nameToDisplayName.put("groups", "Group(s)");
        nameToDisplayName.put("regionAttributesInfo", "Region Attributes");
        nameToDisplayName.put("regionMemberDetailsList", "On Members");
    }
}

