/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionInvocationTargetException;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.domain.CacheServerInfo;
import org.apache.geode.management.internal.cli.domain.MemberInformation;
import org.apache.geode.management.internal.cli.functions.GetMemberInformationFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CompositeResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class MemberCommands
implements CommandMarker {
    private static final GetMemberInformationFunction getMemberInformation = new GetMemberInformationFunction();

    private Gfsh getGfsh() {
        return Gfsh.getCurrentInstance();
    }

    @CliCommand(value={"list members"}, help="Display all or a subset of members.")
    @CliMetaData(shellOnly=false, relatedTopic={"Server"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result listMember(@CliOption(key={"group"}, unspecifiedDefaultValue="", optionContext="converter.hint.member.groups", help="Group name for which members will be displayed.") String group) {
        Result result = null;
        try {
            TreeSet<DistributedMember> memberSet = new TreeSet<DistributedMember>();
            Cache cache = CacheFactory.getAnyInstance();
            if (group.isEmpty()) {
                memberSet.addAll(CliUtil.getAllMembers(cache));
            } else {
                memberSet.addAll(cache.getDistributedSystem().getGroupMembers(group));
            }
            if (memberSet.isEmpty()) {
                result = ResultBuilder.createInfoResult("No Members Found");
            } else {
                TabularResultData resultData = ResultBuilder.createTabularResultData();
                for (DistributedMember member : memberSet) {
                    resultData.accumulate("Name", member.getName());
                    resultData.accumulate("Id", member.getId());
                }
                result = ResultBuilder.buildResult(resultData);
            }
        }
        catch (Exception e) {
            result = ResultBuilder.createGemFireErrorResult("Could not fetch the list of members. " + e.getMessage());
            LogWrapper.getInstance().warning(e.getMessage(), e);
        }
        return result;
    }

    @CliCommand(value={"describe member"}, help="Display information about a member, including name, id, groups, regions, etc.")
    @CliMetaData(shellOnly=false, relatedTopic={"Server"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result describeMember(@CliOption(key={"name"}, optionContext="converter.hint.all.member.idOrName", help="Display information about a member, including name, id, groups, regions, etc.", mandatory=true) String memberNameOrId) {
        Result result = null;
        try {
            DistributedMember memberToBeDescribed = CliUtil.getDistributedMemberByNameOrId(memberNameOrId);
            if (memberToBeDescribed != null) {
                ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)getMemberInformation, null, memberToBeDescribed);
                ArrayList output = (ArrayList)rc.getResult();
                Object obj = output.get(0);
                if (obj != null && obj instanceof MemberInformation) {
                    CompositeResultData crd = ResultBuilder.createCompositeResultData();
                    MemberInformation memberInformation = (MemberInformation)obj;
                    memberInformation.setName(memberToBeDescribed.getName());
                    memberInformation.setId(memberToBeDescribed.getId());
                    memberInformation.setHost(memberToBeDescribed.getHost());
                    memberInformation.setProcessId("" + memberToBeDescribed.getProcessId());
                    CompositeResultData.SectionResultData section = crd.addSection();
                    section.addData("Name", memberInformation.getName());
                    section.addData("Id", memberInformation.getId());
                    section.addData("Host", memberInformation.getHost());
                    section.addData("Regions", CliUtil.convertStringSetToString(memberInformation.getHostedRegions(), '\n'));
                    section.addData("PID", memberInformation.getProcessId());
                    section.addData("Groups", memberInformation.getGroups());
                    section.addData("Used Heap", memberInformation.getHeapUsage() + "M");
                    section.addData("Max Heap", memberInformation.getMaxHeapSize() + "M");
                    String offHeapMemorySize = memberInformation.getOffHeapMemorySize();
                    if (offHeapMemorySize != null && !offHeapMemorySize.isEmpty()) {
                        section.addData("Off Heap Size", offHeapMemorySize);
                    }
                    section.addData("Working Dir", memberInformation.getWorkingDirPath());
                    section.addData("Log file", memberInformation.getLogFilePath());
                    section.addData("Locators", memberInformation.getLocators());
                    if (memberInformation.isServer()) {
                        CompositeResultData.SectionResultData clientServiceSection = crd.addSection();
                        List<CacheServerInfo> csList = memberInformation.getCacheServeInfo();
                        if (csList != null) {
                            Iterator<CacheServerInfo> iters = csList.iterator();
                            clientServiceSection.setHeader("Cache Server Information");
                            while (iters.hasNext()) {
                                CacheServerInfo cacheServerInfo = iters.next();
                                clientServiceSection.addData("Server Bind", cacheServerInfo.getBindAddress());
                                clientServiceSection.addData("Server Port", cacheServerInfo.getPort());
                                clientServiceSection.addData("Running", cacheServerInfo.isRunning());
                            }
                            clientServiceSection.addData("Client Connections", memberInformation.getClientCount());
                        }
                    }
                    result = ResultBuilder.buildResult(crd);
                } else {
                    result = ResultBuilder.createInfoResult(CliStrings.format("Information for the member \"{0}\" could not be retrieved.", new Object[]{memberNameOrId}));
                }
            } else {
                result = ResultBuilder.createInfoResult(CliStrings.format("Member \"{0}\" not found", new Object[]{memberNameOrId}));
            }
        }
        catch (CacheClosedException memberToBeDescribed) {
        }
        catch (FunctionInvocationTargetException e) {
            result = ResultBuilder.createGemFireErrorResult(e.getMessage());
        }
        catch (Exception e) {
            result = ResultBuilder.createGemFireErrorResult(e.getMessage());
        }
        return result;
    }

    @CliAvailabilityIndicator(value={"list members", "describe member"})
    public boolean isListMemberAvailable() {
        boolean isAvailable = true;
        if (CliUtil.isGfshVM()) {
            isAvailable = this.getGfsh() != null && this.getGfsh().isConnectedAndReady();
        }
        return isAvailable;
    }
}

