/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.annotation.CliArgument;
import org.apache.geode.management.internal.cli.help.CliTopic;
import org.apache.geode.management.internal.cli.parser.Argument;
import org.apache.geode.management.internal.cli.parser.AvailabilityTarget;
import org.apache.geode.management.internal.cli.parser.CommandTarget;
import org.apache.geode.management.internal.cli.parser.GfshMethodTarget;
import org.apache.geode.management.internal.cli.parser.GfshOptionParser;
import org.apache.geode.management.internal.cli.parser.Option;
import org.apache.geode.management.internal.cli.parser.jopt.JoptOptionParser;
import org.apache.geode.management.internal.cli.util.ClasspathScanLoadHelper;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class CommandManager {
    private static final Object INSTANCE_LOCK = new Object();
    private static CommandManager INSTANCE = null;
    public static final String USER_CMD_PACKAGES_PROPERTY = "gemfire.user-command-packages";
    public static final String USER_CMD_PACKAGES_ENV_VARIABLE = "GEMFIRE_USER_COMMAND_PACKAGES";
    private Properties cacheProperties;
    private LogWrapper logWrapper;
    private static List<String> SHL_CONVERTERS_TOSKIP = new ArrayList<String>();
    private final List<Converter<?>> converters = new ArrayList();
    private final Map<String, CommandTarget> commands = new TreeMap<String, CommandTarget>();
    private final Map<String, AvailabilityTarget> availabilityIndicators = new HashMap<String, AvailabilityTarget>();
    private final Map<String, CliTopic> topics = new TreeMap<String, CliTopic>();

    private CommandManager(boolean loadDefaultCommands, Properties cacheProperties) throws ClassNotFoundException, IOException {
        if (cacheProperties != null) {
            this.cacheProperties = cacheProperties;
        }
        this.logWrapper = LogWrapper.getInstance();
        if (loadDefaultCommands) {
            this.loadCommands();
            if (this.logWrapper.fineEnabled()) {
                this.logWrapper.fine("Commands Loaded: " + this.commands.keySet());
                this.logWrapper.fine("Command Availability Indicators Loaded: " + this.availabilityIndicators.keySet());
                this.logWrapper.fine("Converters Loaded: " + this.converters);
            }
        }
    }

    private void loadUserCommands() throws ClassNotFoundException, IOException {
        String cacheUserCmdPackages;
        StringTokenizer tokenizer;
        HashSet<String> userCommandPackages = new HashSet<String>();
        if (System.getProperty(USER_CMD_PACKAGES_PROPERTY) != null) {
            tokenizer = new StringTokenizer(System.getProperty(USER_CMD_PACKAGES_PROPERTY), ",");
            while (tokenizer.hasMoreTokens()) {
                userCommandPackages.add(tokenizer.nextToken());
            }
        }
        if (System.getenv().containsKey(USER_CMD_PACKAGES_ENV_VARIABLE)) {
            tokenizer = new StringTokenizer(System.getenv().get(USER_CMD_PACKAGES_ENV_VARIABLE), ",");
            while (tokenizer.hasMoreTokens()) {
                userCommandPackages.add(tokenizer.nextToken());
            }
        }
        if (this.cacheProperties != null && (cacheUserCmdPackages = this.cacheProperties.getProperty("user-command-packages")) != null && !cacheUserCmdPackages.isEmpty()) {
            StringTokenizer tokenizer2 = new StringTokenizer(cacheUserCmdPackages, ",");
            while (tokenizer2.hasMoreTokens()) {
                userCommandPackages.add(tokenizer2.nextToken());
            }
        }
        for (String userCommandPackage : userCommandPackages) {
            try {
                Set<Class<?>> foundClasses = ClasspathScanLoadHelper.loadAndGet(userCommandPackage, CommandMarker.class, true);
                for (Class<?> klass : foundClasses) {
                    try {
                        this.add((CommandMarker)klass.newInstance());
                    }
                    catch (Exception e) {
                        this.logWrapper.warning("Could not load User Commands from: " + klass + " due to " + e.getLocalizedMessage());
                    }
                }
                CommandManager.raiseExceptionIfEmpty(foundClasses, "User Command");
            }
            catch (ClassNotFoundException e) {
                this.logWrapper.warning("Could not load User Commands due to " + e.getLocalizedMessage());
                throw e;
            }
            catch (IOException e) {
                this.logWrapper.warning("Could not load User Commands due to " + e.getLocalizedMessage());
                throw e;
            }
            catch (IllegalStateException e) {
                this.logWrapper.warning(e.getMessage(), e);
                throw e;
            }
        }
    }

    private void loadPluginCommands() {
        Iterator<CommandMarker> iterator = ServiceLoader.load(CommandMarker.class, ClassPathLoader.getLatest().asClassLoader()).iterator();
        while (iterator.hasNext()) {
            try {
                CommandMarker commandMarker = iterator.next();
                try {
                    this.add(commandMarker);
                }
                catch (Exception e) {
                    this.logWrapper.warning("Could not load Command from: " + commandMarker.getClass() + " due to " + e.getLocalizedMessage(), e);
                }
            }
            catch (ServiceConfigurationError e) {
                this.logWrapper.severe("Could not load Command: " + e.getLocalizedMessage(), e);
            }
        }
    }

    private void loadCommands() throws ClassNotFoundException, IOException {
        this.loadUserCommands();
        this.loadPluginCommands();
        Set<Class<?>> foundClasses = null;
        try {
            foundClasses = ClasspathScanLoadHelper.loadAndGet("org.apache.geode.management.internal.cli.commands", CommandMarker.class, true);
            for (Class<?> klass : foundClasses) {
                try {
                    this.add((CommandMarker)klass.newInstance());
                }
                catch (Exception e) {
                    this.logWrapper.warning("Could not load Command from: " + klass + " due to " + e.getLocalizedMessage());
                }
            }
            CommandManager.raiseExceptionIfEmpty(foundClasses, "Commands");
        }
        catch (ClassNotFoundException e) {
            this.logWrapper.warning("Could not load Commands due to " + e.getLocalizedMessage());
            throw e;
        }
        catch (IOException e) {
            this.logWrapper.warning("Could not load Commands due to " + e.getLocalizedMessage());
            throw e;
        }
        catch (IllegalStateException e) {
            this.logWrapper.warning(e.getMessage(), e);
            throw e;
        }
        try {
            foundClasses = ClasspathScanLoadHelper.loadAndGet("org.apache.geode.management.internal.cli.converters", Converter.class, true);
            for (Class<?> klass : foundClasses) {
                try {
                    this.add((Converter)klass.newInstance());
                }
                catch (Exception e) {
                    this.logWrapper.warning("Could not load Converter from: " + klass + " due to " + e.getLocalizedMessage());
                }
            }
            CommandManager.raiseExceptionIfEmpty(foundClasses, "Converters");
        }
        catch (ClassNotFoundException e) {
            this.logWrapper.warning("Could not load Converters due to " + e.getLocalizedMessage());
            throw e;
        }
        catch (IOException e) {
            this.logWrapper.warning("Could not load Converters due to " + e.getLocalizedMessage());
            throw e;
        }
        catch (IllegalStateException e) {
            this.logWrapper.warning(e.getMessage(), e);
            throw e;
        }
        try {
            foundClasses = ClasspathScanLoadHelper.loadAndGet("org.springframework.shell.converters", Converter.class, true);
            for (Class<?> klass : foundClasses) {
                try {
                    if (SHL_CONVERTERS_TOSKIP.contains(klass.getName())) continue;
                    this.add((Converter)klass.newInstance());
                }
                catch (Exception e) {
                    this.logWrapper.warning("Could not load Converter from: " + klass + " due to " + e.getLocalizedMessage());
                }
            }
            CommandManager.raiseExceptionIfEmpty(foundClasses, "Basic Converters");
        }
        catch (ClassNotFoundException e) {
            this.logWrapper.warning("Could not load Default Converters due to " + e.getLocalizedMessage());
            throw e;
        }
        catch (IOException e) {
            this.logWrapper.warning("Could not load Default Converters due to " + e.getLocalizedMessage());
            throw e;
        }
        catch (IllegalStateException e) {
            this.logWrapper.warning(e.getMessage(), e);
            throw e;
        }
    }

    private static void raiseExceptionIfEmpty(Set<Class<?>> foundClasses, String errorFor) throws IllegalStateException {
        if (foundClasses == null || foundClasses.isEmpty()) {
            throw new IllegalStateException("Required " + errorFor + " classes were not loaded. Check logs for errors.");
        }
    }

    public static CommandManager getInstance() throws ClassNotFoundException, IOException {
        return CommandManager.getInstance(true);
    }

    public static CommandManager getInstance(Properties cacheProperties) throws ClassNotFoundException, IOException {
        return CommandManager.getInstance(true, cacheProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearInstance() {
        Object object = INSTANCE_LOCK;
        synchronized (object) {
            INSTANCE = null;
        }
    }

    static CommandManager getInstance(boolean loadDefaultCommands) throws ClassNotFoundException, IOException {
        return CommandManager.getInstance(loadDefaultCommands, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CommandManager getInstance(boolean loadDefaultCommands, Properties cacheProperties) throws ClassNotFoundException, IOException {
        Object object = INSTANCE_LOCK;
        synchronized (object) {
            if (INSTANCE == null) {
                INSTANCE = new CommandManager(loadDefaultCommands, cacheProperties);
            }
            return INSTANCE;
        }
    }

    public static CommandManager getExisting() {
        return INSTANCE;
    }

    public void add(Converter<?> converter) {
        this.converters.add(converter);
    }

    public void add(CommandMarker commandMarker) {
        Method[] methods;
        for (Method method : methods = commandMarker.getClass().getMethods()) {
            String[] value;
            if (method.getAnnotation(CliCommand.class) != null) {
                String[] relatedTopics;
                CliMetaData commandMetaData;
                LinkedList<Argument> arguments = new LinkedList<Argument>();
                LinkedList<Option> options = new LinkedList<Option>();
                GfshOptionParser optionParser = this.getOptionParser();
                Annotation[][] parameterAnnotations = method.getParameterAnnotations();
                Class<?>[] parameterTypes = method.getParameterTypes();
                int parameterNo = 0;
                for (int i = 0; i < parameterAnnotations.length; ++i) {
                    Annotation[] annotations = parameterAnnotations[i];
                    Class<?> parameterType = parameterTypes[i];
                    boolean paramFound = false;
                    String valueSeparator = "__NULL__";
                    for (Annotation annotation : annotations) {
                        if (annotation instanceof CliArgument) {
                            Argument argumentToAdd = this.createArgument((CliArgument)annotation, parameterType, parameterNo);
                            arguments.add(argumentToAdd);
                            ++parameterNo;
                            continue;
                        }
                        if (annotation instanceof CliOption) {
                            Option createdOption = this.createOption((CliOption)annotation, parameterType, parameterNo);
                            if (!"__NULL__".equals(valueSeparator)) {
                                createdOption.setValueSeparator(valueSeparator);
                                valueSeparator = "__NULL__";
                            } else {
                                paramFound = true;
                            }
                            options.add(createdOption);
                            ++parameterNo;
                            continue;
                        }
                        if (!(annotation instanceof CliMetaData)) continue;
                        valueSeparator = ((CliMetaData)annotation).valueSeparator();
                        if (!"__NULL__".equals(valueSeparator)) {
                            if (!paramFound) continue;
                            Option lastAddedOption = options.getLast();
                            lastAddedOption.setValueSeparator(valueSeparator);
                            valueSeparator = "__NULL__";
                            continue;
                        }
                        valueSeparator = "__NULL__";
                    }
                }
                optionParser.setArguments(arguments);
                optionParser.setOptions(options);
                GfshMethodTarget gfshMethodTarget = new GfshMethodTarget(method, commandMarker);
                CliCommand cliCommand = method.getAnnotation(CliCommand.class);
                String[] values = cliCommand.value();
                String commandName = null;
                String[] synonyms = null;
                if (values.length > 1) {
                    synonyms = new String[values.length - 1];
                }
                commandName = values[0];
                for (int j = 1; j < values.length; ++j) {
                    synonyms[j - 1] = values[j];
                }
                CommandTarget commandTarget = new CommandTarget(commandName, synonyms, gfshMethodTarget, optionParser, null, cliCommand.help());
                for (String string : values) {
                    if (this.commands.get(string) == null) {
                        this.commands.put(string, commandTarget);
                        continue;
                    }
                    this.logWrapper.info("Multiple commands configured with the same name: " + string);
                }
                if (!CliUtil.isGfshVM() || (commandMetaData = method.getAnnotation(CliMetaData.class)) == null) continue;
                for (String topicName : relatedTopics = commandMetaData.relatedTopic()) {
                    CliTopic topic = this.topics.get(topicName);
                    if (topic == null) {
                        topic = new CliTopic(topicName);
                        this.topics.put(topicName, topic);
                    }
                    topic.addCommandTarget(commandTarget);
                }
                continue;
            }
            if (method.getAnnotation(CliAvailabilityIndicator.class) == null) continue;
            CliAvailabilityIndicator cliAvailabilityIndicator = method.getAnnotation(CliAvailabilityIndicator.class);
            AvailabilityTarget availabilityIndicator = new AvailabilityTarget(commandMarker, method);
            for (String string : value = cliAvailabilityIndicator.value()) {
                this.availabilityIndicators.put(string, availabilityIndicator);
            }
        }
        this.updateAvailabilityIndicators();
    }

    public void updateAvailabilityIndicators() {
        for (String string : this.availabilityIndicators.keySet()) {
            CommandTarget commandTarget = this.commands.get(string);
            if (commandTarget == null) continue;
            commandTarget.setAvailabilityIndicator(this.availabilityIndicators.get(string));
        }
    }

    public Option createOption(CliOption cliOption, Class<?> parameterType, int parameterNo) {
        Option option = new Option();
        ArrayList<String> synonyms = new ArrayList<String>();
        for (String string : cliOption.key()) {
            if (option.setLongOption(string)) continue;
            synonyms.add(string);
        }
        option.setSynonyms(synonyms);
        if (option.getAggregate().size() <= 0) {
            this.logWrapper.warning("Option should have a name");
        }
        option.setHelp(cliOption.help());
        option.setRequired(cliOption.mandatory());
        option.setSystemProvided(cliOption.systemProvided());
        option.setSpecifiedDefaultValue(cliOption.specifiedDefaultValue());
        option.setUnspecifiedDefaultValue(cliOption.unspecifiedDefaultValue());
        option.setContext(cliOption.optionContext());
        option.setConverter(this.getConverter(parameterType, option.getContext()));
        option.setDataType(parameterType);
        option.setParameterNo(parameterNo);
        return option;
    }

    public Argument createArgument(CliArgument cliArgument, Class<?> parameterType, int parameterNo) {
        Argument argument = new Argument();
        argument.setArgumentName(cliArgument.name());
        argument.setContext(cliArgument.argumentContext());
        argument.setConverter(this.getConverter(parameterType, argument.getContext()));
        argument.setHelp(cliArgument.help());
        argument.setRequired(cliArgument.mandatory());
        argument.setDataType(parameterType);
        argument.setParameterNo(parameterNo);
        argument.setUnspecifiedDefaultValue(cliArgument.unspecifiedDefaultValue());
        argument.setSystemProvided(cliArgument.systemProvided());
        return argument;
    }

    public Converter<?> getConverter(Class<?> parameterType, String context) {
        for (Converter<?> converter : this.converters) {
            if (!converter.supports(parameterType, context)) continue;
            return converter;
        }
        return null;
    }

    private GfshOptionParser getOptionParser() {
        return new JoptOptionParser();
    }

    public Map<String, CommandTarget> getCommands() {
        return Collections.unmodifiableMap(this.commands);
    }

    AvailabilityTarget getAvailabilityIndicator(Object key) {
        return this.availabilityIndicators.get(key);
    }

    public Set<String> getTopicNames() {
        Set<String> topicsNames = this.topics.keySet();
        return Collections.unmodifiableSet(topicsNames);
    }

    public List<CliTopic> getTopics() {
        ArrayList<CliTopic> topicsList = new ArrayList<CliTopic>(this.topics.values());
        return Collections.unmodifiableList(topicsList);
    }

    public CliTopic getTopic(String topicName) {
        CliTopic foundTopic = this.topics.get(topicName);
        if (foundTopic == null) {
            Set<Map.Entry<String, CliTopic>> entries = this.topics.entrySet();
            for (Map.Entry<String, CliTopic> entry : entries) {
                if (!entry.getKey().equalsIgnoreCase(topicName)) continue;
                foundTopic = entry.getValue();
                break;
            }
        }
        return foundTopic;
    }

    static {
        SHL_CONVERTERS_TOSKIP.add("org.springframework.shell.converters.BooleanConverter");
        SHL_CONVERTERS_TOSKIP.add("org.springframework.shell.converters.EnumConverter");
    }
}

