/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.internal.util.IOUtils;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.GfshParser;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.functions.MembersForRegionFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResultException;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.shell.Gfsh;

public class CliUtil {
    public static final String GFSHVM_IDENTIFIER = "gfsh";
    public static boolean isGfshVM = Boolean.getBoolean("gfsh");
    public static final FileFilter JAR_FILE_FILTER = new CustomFileFilter(".jar");

    public static boolean isGfshVM() {
        return isGfshVM;
    }

    public static String cliDependenciesExist(boolean includeGfshDependencies) {
        String jarProductName = null;
        jarProductName = CliUtil.checkLibraryByLoadingClass("org.springframework.shell.core.Parser", "Spring Shell");
        jarProductName = CliUtil.checkLibraryByLoadingClass("org.springframework.shell.core.annotation.CliCommand", "Spring Shell");
        if (jarProductName != null) {
            return jarProductName;
        }
        jarProductName = CliUtil.checkLibraryByLoadingClass("org.springframework.core.SpringVersion", "Spring Core");
        if (jarProductName != null) {
            return jarProductName;
        }
        if (includeGfshDependencies && (jarProductName = CliUtil.checkLibraryByLoadingClass("jline.console.ConsoleReader", "JLine")) != null) {
            return jarProductName;
        }
        return jarProductName;
    }

    private static String checkLibraryByLoadingClass(String className, String jarProductName) {
        try {
            ClassPathLoader.getLatest().forName(className);
        }
        catch (ClassNotFoundException e) {
            return jarProductName;
        }
        return null;
    }

    public static Cache getCacheIfExists() {
        Cache cache;
        try {
            cache = CacheFactory.getAnyInstance();
        }
        catch (CacheClosedException e) {
            cache = null;
        }
        return cache;
    }

    public static byte[][] filesToBytes(String[] fileNames) throws FileNotFoundException, IOException {
        ArrayList<byte[]> filesDataList = new ArrayList<byte[]>();
        for (int i = 0; i < fileNames.length; ++i) {
            File file = new File(fileNames[i]);
            if (!file.exists()) {
                throw new FileNotFoundException("Could not find " + file.getCanonicalPath());
            }
            if (file.isDirectory()) {
                File[] childrenFiles = file.listFiles(JAR_FILE_FILTER);
                for (int j = 0; j < childrenFiles.length; ++j) {
                    filesDataList.add(childrenFiles[j].getName().getBytes());
                    filesDataList.add(CliUtil.toByteArray(new FileInputStream(childrenFiles[j])));
                }
                continue;
            }
            filesDataList.add(file.getName().getBytes());
            filesDataList.add(CliUtil.toByteArray(new FileInputStream(file)));
        }
        Object filesData = new byte[filesDataList.size()][];
        filesData = (byte[][])filesDataList.toArray((T[])filesData);
        return filesData;
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        int n = 0;
        byte[] buffer = new byte[4096];
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }

    public static String[] bytesToNames(byte[][] fileData) {
        String[] names = new String[fileData.length / 2];
        for (int i = 0; i < fileData.length; i += 2) {
            names[i / 2] = new String(fileData[i]);
        }
        return names;
    }

    public static byte[][] bytesToData(byte[][] fileData) {
        byte[][] data = new byte[fileData.length / 2][];
        for (int i = 1; i < fileData.length; i += 2) {
            data[i / 2] = fileData[i];
        }
        return data;
    }

    public static void bytesToFiles(byte[][] fileData, String parentDirPath, boolean mkRequireddirs) throws FileNotFoundException, IOException, UnsupportedOperationException {
        FileOutputStream fos = null;
        File parentDir = new File(parentDirPath);
        if (mkRequireddirs && !parentDir.exists() && !parentDir.mkdirs()) {
            throw new UnsupportedOperationException("Couldn't create required directory structure for " + parentDirPath);
        }
        for (int i = 0; i < fileData.length; ++i) {
            if (i % 2 == 0) {
                String fileName = new String(fileData[i]);
                fos = new FileOutputStream(new File(parentDir, fileName));
                continue;
            }
            fos.write(fileData[i]);
            fos.close();
        }
    }

    public static boolean isValidFileName(String filePath, String extension) {
        boolean isValid = true;
        return isValid;
    }

    public static Set<String> getAllRegionNames() {
        Cache cache = CacheFactory.getAnyInstance();
        HashSet<String> regionNames = new HashSet<String>();
        Set<Region<?, ?>> rootRegions = cache.rootRegions();
        for (Region<?, ?> rootRegion : rootRegions) {
            regionNames.add(rootRegion.getFullPath().substring(1));
            Set<Region<?, ?>> subRegions = rootRegion.subregions(true);
            for (Region<?, ?> subRegion : subRegions) {
                regionNames.add(subRegion.getFullPath().substring(1));
            }
        }
        return regionNames;
    }

    public static String convertStringSetToString(Set<String> stringSet, char delimiter) {
        StringBuilder sb = new StringBuilder();
        if (stringSet != null) {
            for (String stringValue : stringSet) {
                sb.append(stringValue);
                sb.append(delimiter);
            }
        }
        return sb.toString();
    }

    public static String convertStringListToString(List<String> stringList, char delimiter) {
        StringBuilder sb = new StringBuilder();
        if (stringList != null) {
            for (String stringValue : stringList) {
                sb.append(stringValue);
                sb.append(delimiter);
            }
        }
        return sb.toString();
    }

    public static Set<DistributedMember> findMembersOrThrow(String groups, String members) throws CommandResultException {
        String[] groupsArray = groups == null ? new String[]{} : groups.split(",");
        String[] membersArray = members == null ? new String[]{} : members.split(",");
        return CliUtil.findMembersOrThrow(groupsArray, membersArray);
    }

    public static Set<DistributedMember> findMembersOrThrow(String[] groups, String[] members) throws CommandResultException {
        Set<DistributedMember> matchingMembers = CliUtil.findMembers(groups, members);
        if (matchingMembers.isEmpty()) {
            throw new CommandResultException(ResultBuilder.createUserErrorResult("No Members Found"));
        }
        return matchingMembers;
    }

    public static Set<DistributedMember> findMembers(String[] groups, String[] members) {
        if (groups == null) {
            groups = new String[]{};
        }
        if (members == null) {
            members = new String[]{};
        }
        Cache cache = CacheFactory.getAnyInstance();
        if (members.length > 0 && groups.length > 0) {
            throw new IllegalArgumentException("Please provide either \"member\" or \"group\" option.");
        }
        Set<DistributedMember> allNormalMembers = CliUtil.getAllNormalMembers(cache);
        if (members.length == 0 && groups.length == 0) {
            return allNormalMembers;
        }
        HashSet<DistributedMember> matchingMembers = new HashSet<DistributedMember>();
        for (String memberNameOrId : members) {
            for (DistributedMember member : allNormalMembers) {
                if (!memberNameOrId.equalsIgnoreCase(member.getId()) && !memberNameOrId.equals(member.getName())) continue;
                matchingMembers.add(member);
            }
        }
        for (String group : groups) {
            for (DistributedMember member : allNormalMembers) {
                if (!member.getGroups().contains(group)) continue;
                matchingMembers.add(member);
            }
        }
        return matchingMembers;
    }

    public static DistributedMember getDistributedMemberByNameOrId(String memberNameOrId) {
        DistributedMember memberFound = null;
        if (memberNameOrId != null) {
            Cache cache = CacheFactory.getAnyInstance();
            Set<DistributedMember> memberSet = CliUtil.getAllMembers(cache);
            for (DistributedMember member : memberSet) {
                if (!memberNameOrId.equalsIgnoreCase(member.getId()) && !memberNameOrId.equals(member.getName())) continue;
                memberFound = member;
                break;
            }
        }
        return memberFound;
    }

    public static String stackTraceAsString(Throwable e) {
        String stackAsString = "";
        if (e != null) {
            StringWriter writer = new StringWriter();
            PrintWriter pw = new PrintWriter(writer);
            e.printStackTrace(pw);
            stackAsString = writer.toString();
        }
        return stackAsString;
    }

    public static <K> Class<K> forName(String classToLoadName, String neededFor) {
        Class<?> loadedClass = null;
        try {
            ClassPathLoader classPathLoader = ClassPathLoader.getLatest();
            if (classToLoadName != null && !classToLoadName.isEmpty()) {
                loadedClass = classPathLoader.forName(classToLoadName);
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new RuntimeException(CliStrings.format("Could not find class \"{0}\" specified for \"{1}\".", classToLoadName, neededFor), e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException(CliStrings.format("Class \"{0}\" specified for \"{1}\" is not of an expected type.", classToLoadName, neededFor), e);
        }
        return loadedClass;
    }

    public static <K> K newInstance(Class<K> klass, String neededFor) {
        K instance = null;
        try {
            instance = klass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(CliStrings.format("Could not instantiate class \"{0}\" specified for \"{1}\".", klass, neededFor), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(CliStrings.format("Could not access class \"{0}\" specified for \"{1}\".", klass, neededFor), e);
        }
        return instance;
    }

    public static DeflaterInflaterData compressBytes(byte[] input) {
        Deflater compresser = new Deflater();
        compresser.setInput(input);
        compresser.finish();
        byte[] buffer = new byte[100];
        byte[] result = new byte[]{};
        int compressedDataLength = 0;
        int totalCompressedDataLength = 0;
        do {
            byte[] newResult = new byte[result.length + buffer.length];
            System.arraycopy(result, 0, newResult, 0, result.length);
            compressedDataLength = compresser.deflate(buffer);
            totalCompressedDataLength += compressedDataLength;
            System.arraycopy(buffer, 0, newResult, result.length, buffer.length);
            result = newResult;
        } while (compressedDataLength != 0);
        return new DeflaterInflaterData(totalCompressedDataLength, result);
    }

    public static DeflaterInflaterData uncompressBytes(byte[] output, int compressedDataLength) throws DataFormatException {
        Inflater decompresser = new Inflater();
        decompresser.setInput(output, 0, compressedDataLength);
        byte[] buffer = new byte[512];
        byte[] result = new byte[]{};
        while (!decompresser.needsInput()) {
            int bytesRead = decompresser.inflate(buffer);
            byte[] newResult = new byte[result.length + bytesRead];
            System.arraycopy(result, 0, newResult, 0, result.length);
            System.arraycopy(buffer, 0, newResult, result.length, bytesRead);
            result = newResult;
        }
        decompresser.end();
        return new DeflaterInflaterData(result.length, result);
    }

    public static void main(String[] args) {
        try {
            byte[][] filesToBytes = CliUtil.filesToBytes(new String[]{"/export/abhishek1/work/aspenmm/GFTryouts/test.json"});
            System.out.println(filesToBytes[1].length);
            DeflaterInflaterData compressBytes = CliUtil.compressBytes(filesToBytes[1]);
            System.out.println(compressBytes);
            DeflaterInflaterData uncompressBytes = CliUtil.uncompressBytes(compressBytes.data, compressBytes.dataLength);
            System.out.println(uncompressBytes);
            System.out.println(new String(uncompressBytes.getData()));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DataFormatException e) {
            e.printStackTrace();
        }
    }

    public static void main1(String[] args) {
        try {
            byte[][] fileToBytes = CliUtil.filesToBytes(new String[]{"../dumped/source/lib"});
            CliUtil.bytesToFiles(fileToBytes, "../dumped/dest/lib/", true);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean contains(Object[] array, Object object) {
        boolean contains = false;
        if (array != null && object != null) {
            contains = Arrays.asList(array).contains(object);
        }
        return contains;
    }

    public static Set<DistributedMember> getAllNormalMembers(Cache cache) {
        return new HashSet<DistributedMember>(((InternalDistributedSystem)cache.getDistributedSystem()).getDistributionManager().getNormalDistributionManagerIds());
    }

    public static Set<DistributedMember> getAllMembers(Cache cache) {
        return new HashSet<DistributedMember>(((InternalDistributedSystem)cache.getDistributedSystem()).getDistributionManager().getDistributionManagerIds());
    }

    public static Set<DistributedMember> getAllMembers(InternalDistributedSystem internalDS) {
        return new HashSet<DistributedMember>(internalDS.getDistributionManager().getDistributionManagerIds());
    }

    public static Set<DistributedMember> getDistributedMembersByGroup(Cache cache, String[] groups) {
        HashSet<DistributedMember> groupMembers = new HashSet<DistributedMember>();
        for (String group : groups) {
            groupMembers.addAll(((InternalDistributedSystem)cache.getDistributedSystem()).getDistributionManager().getGroupMembers(group));
        }
        return groupMembers;
    }

    public static ResultCollector<?, ?> executeFunction(Function function, Object args, Set<DistributedMember> targetMembers) {
        Execution execution = null;
        execution = args != null ? FunctionService.onMembers(targetMembers).withArgs(args) : FunctionService.onMembers(targetMembers);
        ((AbstractExecution)execution).setIgnoreDepartedMembers(true);
        return execution.execute(function);
    }

    public static ResultCollector<?, ?> executeFunction(Function function, Object args, DistributedMember targetMember) {
        Execution execution = null;
        execution = args != null ? FunctionService.onMember(targetMember).withArgs(args) : FunctionService.onMember(targetMember);
        ((AbstractExecution)execution).setIgnoreDepartedMembers(true);
        return execution.execute(function);
    }

    public static Set<DistributedMember> getRegionAssociatedMembers(String region, Cache cache, boolean returnAll) {
        if (region == null || region.isEmpty()) {
            return null;
        }
        ManagementService managementService = ManagementService.getExistingManagementService(cache);
        DistributedSystemMXBean distributedSystemMXBean = managementService.getDistributedSystemMXBean();
        HashSet<DistributedMember> matchedMembers = new HashSet<DistributedMember>();
        HashSet<DistributedMember> allClusterMembers = new HashSet<DistributedMember>();
        allClusterMembers.addAll(cache.getMembers());
        allClusterMembers.add(cache.getDistributedSystem().getDistributedMember());
        for (DistributedMember member : allClusterMembers) {
            try {
                if (distributedSystemMXBean.fetchRegionObjectName(CliUtil.getMemberNameOrId(member), region) == null) continue;
                matchedMembers.add(member);
            }
            catch (Exception exception) {}
        }
        return matchedMembers;
    }

    public static String getMemberNameOrId(DistributedMember distributedMember) {
        String nameOrId = null;
        if (distributedMember != null) {
            nameOrId = distributedMember.getName();
            nameOrId = nameOrId != null && !nameOrId.isEmpty() ? nameOrId : distributedMember.getId();
        }
        return nameOrId;
    }

    public static String collectionToString(Collection<?> col, int newlineAfter) {
        if (col != null) {
            StringBuilder builder = new StringBuilder();
            int lastNewlineAt = 0;
            Iterator<?> it = col.iterator();
            while (it.hasNext()) {
                Object object = it.next();
                builder.append(String.valueOf(object));
                if (it.hasNext()) {
                    builder.append(", ");
                }
                if (newlineAfter <= 0 || (builder.length() - lastNewlineAt) / newlineAfter < 1) continue;
                builder.append(GfshParser.LINE_SEPARATOR);
            }
            return builder.toString();
        }
        return "" + null;
    }

    public static <T> String arrayToString(T[] array) {
        if (array != null) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < array.length; ++i) {
                T object = array[i];
                builder.append(String.valueOf(object));
                if (i >= array.length - 1) continue;
                builder.append(", ");
            }
            return builder.toString();
        }
        return "" + null;
    }

    public static String decodeWithDefaultCharSet(String urlToDecode) {
        try {
            return URLDecoder.decode(urlToDecode, Charset.defaultCharset().name());
        }
        catch (UnsupportedEncodingException e) {
            return urlToDecode;
        }
    }

    public static String resolvePathname(String pathname) {
        return StringUtils.isBlank(pathname) ? pathname : IOUtils.tryGetCanonicalPathElseGetAbsolutePath(new File(pathname));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runLessCommandAsExternalViewer(Result commandResult, boolean isError) {
        StringBuilder sb = new StringBuilder();
        String NEW_LINE = System.getProperty("line.separator");
        while (commandResult.hasNextLine()) {
            sb.append(commandResult.nextLine()).append(NEW_LINE);
        }
        File file = null;
        FileWriter fw = null;
        try {
            file = File.createTempFile("gfsh_output", "less");
            fw = new FileWriter(file);
            fw.append(sb.toString());
            fw.close();
            File workingDir = file.getParentFile();
            Process p = Runtime.getRuntime().exec(new String[]{"sh", "-c", "LESSOPEN=\"|color %s\" less -SR " + file.getName() + " < /dev/tty > /dev/tty "}, null, workingDir);
            p.waitFor();
        }
        catch (IOException e) {
            Gfsh.printlnErr(e.getMessage());
        }
        catch (InterruptedException e) {
            Gfsh.printlnErr(e.getMessage());
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    public static String getClientIdFromCacheClientProxy(CacheClientProxy p) {
        if (p == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("[").append(p.getProxyID()).append(":port=").append(p.getRemotePort()).append(":primary=").append(p.isPrimary()).append("]");
        return buffer.toString();
    }

    public static Set<DistributedMember> getMembersForeRegionViaFunction(Cache cache, String regionPath, boolean returnAll) {
        try {
            HashSet<DistributedMember> regionMembers = new HashSet<DistributedMember>();
            MembersForRegionFunction membersForRegionFunction = new MembersForRegionFunction();
            FunctionService.registerFunction(membersForRegionFunction);
            Set<DistributedMember> targetMembers = CliUtil.getAllMembers(cache);
            List resultList = (List)CliUtil.executeFunction((Function)membersForRegionFunction, (Object)regionPath, targetMembers).getResult();
            for (Object object : resultList) {
                try {
                    if (object instanceof Exception) {
                        LogWrapper.getInstance().warning("Exception in getMembersForeRegionViaFunction " + ((Throwable)object).getMessage(), (Throwable)object);
                        continue;
                    }
                    if (object instanceof Throwable) {
                        LogWrapper.getInstance().warning("Exception in getMembersForeRegionViaFunction " + ((Throwable)object).getMessage(), (Throwable)object);
                        continue;
                    }
                    if (object == null) continue;
                    Map memberDetails = (Map)object;
                    for (Map.Entry entry : memberDetails.entrySet()) {
                        Set<DistributedMember> dsMems = CliUtil.getAllMembers(cache);
                        for (DistributedMember mem : dsMems) {
                            if (!mem.getId().equals(entry.getKey())) continue;
                            regionMembers.add(mem);
                            if (returnAll) continue;
                            return regionMembers;
                        }
                    }
                }
                catch (Exception ex) {
                    LogWrapper.getInstance().warning("getMembersForeRegionViaFunction exception " + ex);
                }
            }
            return regionMembers;
        }
        catch (Exception e) {
            LogWrapper.getInstance().warning("getMembersForeRegionViaFunction exception " + e);
            return null;
        }
    }

    public static class DeflaterInflaterData
    implements Serializable {
        private static final long serialVersionUID = 1104813333595216795L;
        private final int dataLength;
        private final byte[] data;

        public DeflaterInflaterData(int dataLength, byte[] data) {
            this.dataLength = dataLength;
            this.data = data;
        }

        public int getDataLength() {
            return this.dataLength;
        }

        public byte[] getData() {
            return this.data;
        }

        public String toString() {
            return String.valueOf(this.dataLength);
        }
    }

    static class CustomFileFilter
    implements FileFilter {
        private String extensionWithDot;

        public CustomFileFilter(String extensionWithDot) {
            this.extensionWithDot = extensionWithDot;
        }

        @Override
        public boolean accept(File pathname) {
            String name = pathname.getName();
            return name.endsWith(this.extensionWithDot);
        }
    }
}

