/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.tcp;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.DMStats;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.ByteBufferWriter;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.ObjToByteArraySerializer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.tcp.BaseMsgStreamer;
import org.apache.geode.internal.tcp.Buffers;
import org.apache.geode.internal.tcp.ConnectExceptions;
import org.apache.geode.internal.tcp.Connection;
import org.apache.geode.internal.tcp.ConnectionException;
import org.apache.geode.internal.tcp.MsgIdGenerator;
import org.apache.geode.internal.tcp.MsgStreamerList;
import org.apache.geode.internal.tcp.VersionedMsgStreamer;
import org.apache.logging.log4j.Logger;

public class MsgStreamer
extends OutputStream
implements ObjToByteArraySerializer,
BaseMsgStreamer,
ByteBufferWriter {
    private static final Logger logger = LogService.getLogger();
    private final List<?> cons;
    private ConnectExceptions ce;
    private final ByteBuffer buffer;
    private int flushedBytes = 0;
    private final DistributionMessage msg;
    private boolean normalMsg = false;
    private boolean startedSerializingMsg = false;
    private boolean doneWritingMsg = false;
    private final DMStats stats;
    private short msgId;
    private long serStartTime;
    private final boolean directReply;
    private int overflowMode = 0;
    private HeapDataOutputStream overflowBuf = null;
    private static final boolean ASCII_STRINGS = Boolean.getBoolean("gemfire.ASCII_STRINGS");

    protected final void release() {
        MsgIdGenerator.release(this.msgId);
        this.buffer.clear();
        this.overflowBuf = null;
        Buffers.releaseSenderBuffer(this.buffer, this.stats);
    }

    @Override
    public final ConnectExceptions getConnectExceptions() {
        return this.ce;
    }

    @Override
    public final List<?> getSentConnections() {
        return this.cons;
    }

    MsgStreamer(List<?> cons, DistributionMessage msg, boolean directReply, DMStats stats, int sendBufferSize) {
        this.stats = stats;
        this.msg = msg;
        this.cons = cons;
        this.buffer = Buffers.acquireSenderBuffer(sendBufferSize, stats);
        this.buffer.clear();
        this.buffer.position(7);
        this.msgId = (short)-1;
        this.directReply = directReply;
        this.startSerialization();
    }

    public static BaseMsgStreamer create(List<?> cons, DistributionMessage msg, boolean directReply, DMStats stats) {
        Connection firstCon = (Connection)cons.get(0);
        int numCons = cons.size();
        if (numCons > 1) {
            Version version;
            Connection con;
            Object2ObjectOpenHashMap<Version, ArrayList<Connection>> versionToConnMap = null;
            int numVersioned = 0;
            for (Object c : cons) {
                ArrayList<Connection> vcons;
                con = (Connection)c;
                version = con.getRemoteVersion();
                if (version == null) continue;
                if (versionToConnMap == null) {
                    versionToConnMap = new Object2ObjectOpenHashMap<Version, ArrayList<Connection>>();
                }
                if ((vcons = (ArrayList<Connection>)versionToConnMap.get(version)) == null) {
                    vcons = new ArrayList<Connection>(numCons);
                    versionToConnMap.put(version, vcons);
                }
                vcons.add(con);
                ++numVersioned;
            }
            if (versionToConnMap == null) {
                return new MsgStreamer(cons, msg, directReply, stats, firstCon.getSendBufferSize());
            }
            ArrayList<MsgStreamer> streamers = new ArrayList<MsgStreamer>(versionToConnMap.size() + 1);
            int sendBufferSize = firstCon.getSendBufferSize();
            if (numCons > numVersioned) {
                ArrayList<Connection> unversionedCons = new ArrayList<Connection>(numCons);
                for (Object c : cons) {
                    con = (Connection)c;
                    version = con.getRemoteVersion();
                    if (version != null) continue;
                    unversionedCons.add(con);
                }
                streamers.add(new MsgStreamer(unversionedCons, msg, directReply, stats, sendBufferSize));
            }
            ObjectIterator itr = versionToConnMap.object2ObjectEntrySet().fastIterator();
            while (itr.hasNext()) {
                Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)itr.next();
                Object ver = entry.getKey();
                Object l = entry.getValue();
                streamers.add(new VersionedMsgStreamer((List)l, msg, directReply, stats, sendBufferSize, (Version)ver));
            }
            return new MsgStreamerList(streamers);
        }
        Version version = firstCon.getRemoteVersion();
        if (version == null) {
            return new MsgStreamer(cons, msg, directReply, stats, firstCon.getSendBufferSize());
        }
        return new VersionedMsgStreamer(cons, msg, directReply, stats, firstCon.getSendBufferSize(), version);
    }

    @Override
    public void reserveConnections(long startTime, long ackTimeout, long ackSDTimeout) {
        for (Connection con : this.cons) {
            con.setInUse(true, startTime, ackTimeout, ackSDTimeout, this.cons);
            if (ackTimeout <= 0L) continue;
            con.scheduleAckTimeouts();
        }
    }

    private void startSerialization() {
        this.serStartTime = this.stats.startMsgSerialization();
    }

    @Override
    public final int writeMessage() throws IOException {
        try {
            this.startedSerializingMsg = true;
            InternalDataSerializer.writeDSFID(this.msg, this);
            this.doneWritingMsg = true;
            if (this.flushedBytes == 0) {
                this.normalMsg = true;
            }
            this.realFlush(true);
            int n = this.flushedBytes;
            return n;
        }
        finally {
            this.release();
        }
    }

    @Override
    public final void write(int b) {
        this.ensureCapacity(1);
        if (this.overflowBuf != null) {
            this.overflowBuf.write(b);
            return;
        }
        this.buffer.put((byte)b);
    }

    private final void ensureCapacity(int amount) {
        if (this.overflowBuf != null) {
            return;
        }
        int remainingSpace = this.buffer.capacity() - this.buffer.position();
        if (amount > remainingSpace) {
            this.realFlush(false);
        }
    }

    @Override
    public void flush() {
    }

    private boolean isOverflowMode() {
        return this.overflowMode > 0;
    }

    private void enableOverflowMode() {
        ++this.overflowMode;
    }

    private void disableOverflowMode() {
        --this.overflowMode;
        if (!this.isOverflowMode()) {
            this.overflowBuf = null;
        }
    }

    public final void realFlush(boolean lastFlushForMessage) {
        if (this.isOverflowMode()) {
            if (this.overflowBuf == null) {
                this.overflowBuf = new HeapDataOutputStream(this.buffer.capacity() - 7, Version.CURRENT);
            }
            return;
        }
        this.buffer.flip();
        this.setMessageHeader();
        int serializedBytes = this.buffer.limit();
        this.flushedBytes += serializedBytes;
        DistributionMessage conflationMsg = null;
        if (this.normalMsg) {
            conflationMsg = this.msg;
        }
        this.stats.endMsgSerialization(this.serStartTime);
        Iterator<?> it = this.cons.iterator();
        while (it.hasNext()) {
            Connection con = (Connection)it.next();
            try {
                con.sendPreserialized(this.buffer, lastFlushForMessage && this.msg.containsRegionContentChange(), conflationMsg);
            }
            catch (IOException ex) {
                it.remove();
                if (this.ce == null) {
                    this.ce = new ConnectExceptions();
                }
                this.ce.addFailure(con.getRemoteAddress(), ex);
                con.closeForReconnect(LocalizedStrings.MsgStreamer_CLOSING_DUE_TO_0.toLocalizedString("IOException"));
            }
            catch (ConnectionException ex) {
                it.remove();
                if (this.ce == null) {
                    this.ce = new ConnectExceptions();
                }
                this.ce.addFailure(con.getRemoteAddress(), ex);
                con.closeForReconnect(LocalizedStrings.MsgStreamer_CLOSING_DUE_TO_0.toLocalizedString("ConnectionException"));
            }
            this.buffer.rewind();
        }
        this.startSerialization();
        this.buffer.clear();
        this.buffer.position(7);
    }

    @Override
    public final void close() throws IOException {
        try {
            if (this.startedSerializingMsg && !this.doneWritingMsg && this.flushedBytes > 0) {
                for (Connection con : this.cons) {
                    con.closeForReconnect("Message serialization could not complete");
                }
            }
        }
        finally {
            super.close();
        }
    }

    @Override
    public final void write(byte[] source, int offset, int len) {
        if (this.overflowBuf != null) {
            this.overflowBuf.write(source, offset, len);
            return;
        }
        while (len > 0) {
            int remainingSpace = this.buffer.capacity() - this.buffer.position();
            if (remainingSpace == 0) {
                this.realFlush(false);
                if (this.overflowBuf == null) continue;
                this.overflowBuf.write(source, offset, len);
                return;
            }
            int chunkSize = remainingSpace;
            if (len < chunkSize) {
                chunkSize = len;
            }
            this.buffer.put(source, offset, chunkSize);
            offset += chunkSize;
            len -= chunkSize;
        }
    }

    @Override
    public final void write(ByteBuffer bb) {
        if (this.overflowBuf != null) {
            this.overflowBuf.write(bb);
            return;
        }
        int len = bb.remaining();
        while (len > 0) {
            int remainingSpace = this.buffer.capacity() - this.buffer.position();
            if (remainingSpace == 0) {
                this.realFlush(false);
                if (this.overflowBuf == null) continue;
                this.overflowBuf.write(bb);
                return;
            }
            int chunkSize = remainingSpace;
            if (len < chunkSize) {
                chunkSize = len;
            }
            int oldLimit = bb.limit();
            bb.limit(bb.position() + chunkSize);
            this.buffer.put(bb);
            bb.limit(oldLimit);
            len -= chunkSize;
        }
    }

    private final void setMessageHeader() {
        int msgType;
        Assert.assertTrue(this.overflowBuf == null);
        Assert.assertTrue(!this.isOverflowMode());
        if (this.doneWritingMsg) {
            msgType = this.normalMsg ? 76 : 78;
            if (this.directReply) {
                msgType |= 0x20;
            }
        } else {
            msgType = 77;
        }
        if (!this.normalMsg && this.msgId == -1) {
            this.msgId = MsgIdGenerator.obtain();
        }
        this.buffer.putInt(0, Connection.calcHdrSize(this.buffer.limit() - 7));
        this.buffer.put(4, (byte)(msgType & 0xFF));
        this.buffer.putShort(5, this.msgId);
        this.buffer.position(0);
    }

    @Override
    public final void writeBoolean(boolean v) {
        this.write(v ? 1 : 0);
    }

    @Override
    public final void writeByte(int v) {
        this.write(v);
    }

    @Override
    public final void writeShort(int v) {
        this.ensureCapacity(2);
        if (this.overflowBuf != null) {
            this.overflowBuf.writeShort(v);
            return;
        }
        this.buffer.putShort((short)v);
    }

    @Override
    public final void writeChar(int v) {
        this.ensureCapacity(2);
        if (this.overflowBuf != null) {
            this.overflowBuf.writeChar(v);
            return;
        }
        this.buffer.putChar((char)v);
    }

    @Override
    public final void writeInt(int v) {
        this.ensureCapacity(4);
        if (this.overflowBuf != null) {
            this.overflowBuf.writeInt(v);
            return;
        }
        this.buffer.putInt(v);
    }

    @Override
    public final void writeLong(long v) {
        this.ensureCapacity(8);
        if (this.overflowBuf != null) {
            this.overflowBuf.writeLong(v);
            return;
        }
        this.buffer.putLong(v);
    }

    @Override
    public final void writeFloat(float v) {
        this.ensureCapacity(4);
        if (this.overflowBuf != null) {
            this.overflowBuf.writeFloat(v);
            return;
        }
        this.buffer.putFloat(v);
    }

    @Override
    public final void writeDouble(double v) {
        this.ensureCapacity(8);
        if (this.overflowBuf != null) {
            this.overflowBuf.writeDouble(v);
            return;
        }
        this.buffer.putDouble(v);
    }

    @Override
    public final void writeBytes(String str) {
        if (this.overflowBuf != null) {
            this.overflowBuf.writeBytes(str);
            return;
        }
        int strlen = str.length();
        if (strlen > 0) {
            for (int i = 0; i < strlen; ++i) {
                this.writeByte((byte)str.charAt(i));
            }
        }
    }

    @Override
    public final void writeChars(String s) {
        if (this.overflowBuf != null) {
            this.overflowBuf.writeChars(s);
            return;
        }
        int len = s.length();
        int offset = 0;
        while (len > 0) {
            int remainingCharSpace = (this.buffer.capacity() - this.buffer.position()) / 2;
            if (remainingCharSpace == 0) {
                this.realFlush(false);
                if (this.overflowBuf == null) continue;
                this.overflowBuf.writeChars(s.substring(offset));
                return;
            }
            int chunkSize = remainingCharSpace;
            if (len < chunkSize) {
                chunkSize = len;
            }
            for (int i = 0; i < chunkSize; ++i) {
                this.buffer.putChar(s.charAt(offset + i));
            }
            offset += chunkSize;
            len -= chunkSize;
        }
    }

    @Override
    public final void writeUTF(String str) throws IOException {
        if (this.overflowBuf != null) {
            this.overflowBuf.writeUTF(str);
            return;
        }
        if (ASCII_STRINGS) {
            this.writeAsciiUTF(str);
        } else {
            this.writeFullUTF(str);
        }
    }

    private final void writeAsciiUTF(String str) throws IOException {
        int len = str.length();
        if (len > 65535) {
            throw new UTFDataFormatException();
        }
        this.writeShort(len);
        int offset = 0;
        while (len > 0) {
            int remainingSpace = this.buffer.capacity() - this.buffer.position();
            if (remainingSpace == 0) {
                this.realFlush(false);
                if (this.overflowBuf == null) continue;
                this.overflowBuf.write(str.substring(offset).getBytes());
                return;
            }
            int chunkSize = remainingSpace;
            if (len < chunkSize) {
                chunkSize = len;
            }
            for (int i = 0; i < chunkSize; ++i) {
                this.buffer.put((byte)str.charAt(offset + i));
            }
            offset += chunkSize;
            len -= chunkSize;
        }
    }

    private final void writeFullUTF(String str) throws IOException {
        char c;
        int i;
        int strlen = str.length();
        if (strlen > 65535) {
            throw new UTFDataFormatException();
        }
        int remainingSpace = this.buffer.capacity() - this.buffer.position();
        if (remainingSpace >= strlen * 3 + 2) {
            this.writeQuickFullUTF(str, strlen);
            return;
        }
        int utfSize = 0;
        for (i = 0; i < strlen; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utfSize;
                continue;
            }
            if (c > '\u07ff') {
                utfSize += 3;
                continue;
            }
            utfSize += 2;
        }
        if (utfSize > 65535) {
            throw new UTFDataFormatException();
        }
        this.writeShort(utfSize);
        for (i = 0; i < strlen; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.writeByte((byte)c);
                continue;
            }
            if (c > '\u07ff') {
                this.writeByte((byte)(0xE0 | c >> 12 & 0xF));
                this.writeByte((byte)(0x80 | c >> 6 & 0x3F));
                this.writeByte((byte)(0x80 | c >> 0 & 0x3F));
                continue;
            }
            this.writeByte((byte)(0xC0 | c >> 6 & 0x1F));
            this.writeByte((byte)(0x80 | c >> 0 & 0x3F));
        }
    }

    private final void writeQuickFullUTF(String str, int strlen) throws IOException {
        int utfSizeIdx = this.buffer.position();
        this.buffer.position(utfSizeIdx + 2);
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.buffer.put((byte)c);
                continue;
            }
            if (c > '\u07ff') {
                this.buffer.put((byte)(0xE0 | c >> 12 & 0xF));
                this.buffer.put((byte)(0x80 | c >> 6 & 0x3F));
                this.buffer.put((byte)(0x80 | c >> 0 & 0x3F));
                continue;
            }
            this.buffer.put((byte)(0xC0 | c >> 6 & 0x1F));
            this.buffer.put((byte)(0x80 | c >> 0 & 0x3F));
        }
        int utflen = this.buffer.position() - (utfSizeIdx + 2);
        if (utflen > 65535) {
            this.buffer.position(utfSizeIdx);
            throw new UTFDataFormatException();
        }
        this.buffer.putShort(utfSizeIdx, (short)utflen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void writeAsSerializedByteArray(Object v) throws IOException {
        if (v instanceof HeapDataOutputStream) {
            HeapDataOutputStream other = (HeapDataOutputStream)v;
            InternalDataSerializer.writeArrayLength(other.size(), this);
            other.sendTo(this);
            other.rewind();
            return;
        }
        if (this.overflowBuf != null) {
            this.overflowBuf.writeAsSerializedByteArray(v);
            return;
        }
        if (this.isOverflowMode()) {
            int remainingSpace = this.buffer.capacity() - this.buffer.position();
            if (remainingSpace < 5) {
                this.overflowBuf = new HeapDataOutputStream(this.buffer.capacity() - 7, Version.CURRENT);
                this.overflowBuf.writeAsSerializedByteArray(v);
                return;
            }
        } else {
            this.ensureCapacity(1029);
        }
        int lengthPos = this.buffer.position();
        this.buffer.position(lengthPos + 5);
        this.enableOverflowMode();
        boolean finished = false;
        try {
            try {
                DataSerializer.writeObject(v, this);
            }
            catch (IOException e) {
                IllegalArgumentException e2 = new IllegalArgumentException(LocalizedStrings.MsgStreamer_AN_EXCEPTION_WAS_THROWN_WHILE_SERIALIZING.toLocalizedString());
                e2.initCause(e);
                throw e2;
            }
            int baLength = this.buffer.position() - (lengthPos + 5);
            HeapDataOutputStream overBuf = this.overflowBuf;
            if (overBuf != null) {
                baLength += overBuf.size();
            }
            this.buffer.put(lengthPos, (byte)-3);
            this.buffer.putInt(lengthPos + 1, baLength);
            this.disableOverflowMode();
            finished = true;
            if (overBuf != null && !this.isOverflowMode()) {
                overBuf.sendTo(this);
            }
        }
        finally {
            if (!finished) {
                this.buffer.position(lengthPos);
                this.disableOverflowMode();
            }
        }
    }
}

