/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.sequencelog.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.sequencelog.GraphType;
import org.apache.geode.internal.sequencelog.io.Filter;
import org.apache.geode.internal.sequencelog.io.GemfireLogConverter;
import org.apache.geode.internal.sequencelog.io.InputStreamReader;
import org.apache.geode.internal.sequencelog.model.GraphSet;

public class GraphReader {
    private File[] files;

    public GraphReader(File file) {
        this(new File[]{file});
    }

    public GraphReader(File[] files) {
        this.files = files;
    }

    public GraphSet readGraphs() throws IOException {
        return this.readGraphs(false);
    }

    public GraphSet readGraphs(boolean areGemfireLogs) throws IOException {
        return this.readGraphs(new Filter(){

            @Override
            public boolean accept(GraphType graphType, String name, String edgeName, String source, String dest) {
                return true;
            }

            @Override
            public boolean acceptPattern(GraphType graphType, Pattern pattern, String edgeName, String source, String dest) {
                return true;
            }
        }, areGemfireLogs);
    }

    public GraphSet readGraphs(Filter filter) throws IOException {
        return this.readGraphs(filter, false);
    }

    public GraphSet readGraphs(Filter filter, boolean areGemfireLogs) throws IOException {
        GraphSet graphs = new GraphSet();
        if (areGemfireLogs) {
            HeapDataOutputStream out = new HeapDataOutputStream(Version.CURRENT);
            GemfireLogConverter.convertFiles(out, this.files);
            InputStreamReader reader = new InputStreamReader(out.getInputStream());
            reader.addToGraphs(graphs, filter);
        } else {
            for (File file : this.files) {
                FileInputStream fis = new FileInputStream(file);
                InputStreamReader reader = new InputStreamReader(fis);
                reader.addToGraphs(graphs, filter);
            }
        }
        graphs.readingDone();
        return graphs;
    }
}

