/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.process.ProcessStreamReader;
import org.apache.logging.log4j.Logger;

public final class BlockingProcessStreamReader
extends ProcessStreamReader {
    private static final Logger logger = LogService.getLogger();

    protected BlockingProcessStreamReader(ProcessStreamReader.Builder builder) {
        super(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("Running {}", (Object)this);
        }
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(this.inputStream));
            while ((line = reader.readLine()) != null) {
                this.inputListener.notifyInputLine(line);
            }
        }
        catch (IOException e) {
            if (isDebugEnabled) {
                logger.debug("Failure reading from buffered input stream: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        finally {
            block16: {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    if (!isDebugEnabled) break block16;
                    logger.debug("Failure closing buffered input stream reader: {}", (Object)e.getMessage(), (Object)e);
                }
            }
            if (isDebugEnabled) {
                logger.debug("Terminating {}", (Object)this);
            }
        }
    }
}

