/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.xmlcache;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.CustomExpiry;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.DiskWriteAttributes;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.InterestPolicy;
import org.apache.geode.cache.MembershipAttributes;
import org.apache.geode.cache.MirrorType;
import org.apache.geode.cache.PartitionAttributes;
import org.apache.geode.cache.PartitionAttributesFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.SubscriptionAttributes;
import org.apache.geode.compression.Compressor;
import org.apache.geode.internal.cache.EvictionAttributesImpl;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.cache.UserSpecifiedRegionAttributes;
import org.apache.geode.internal.cache.xmlcache.CacheCreation;
import org.apache.geode.internal.cache.xmlcache.ClientCacheCreation;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class RegionAttributesCreation
extends UserSpecifiedRegionAttributes
implements Serializable {
    private static final long serialVersionUID = 2241078661206355376L;
    private static final RegionAttributes defaultAttributes = new AttributesFactory().create();
    private ArrayList cacheListeners;
    private Set<String> gatewaySenderIds;
    private Set<String> asyncEventQueueIds;
    private CacheLoader cacheLoader;
    private CacheWriter cacheWriter;
    private ExpirationAttributes entryIdleTimeout;
    private CustomExpiry customEntryIdleTimeout;
    private ExpirationAttributes entryTimeToLive;
    private CustomExpiry customEntryTimeToLive;
    private int initialCapacity;
    private Class keyConstraint;
    private Class valueConstraint;
    private float loadFactor;
    private ExpirationAttributes regionIdleTimeout;
    private ExpirationAttributes regionTimeToLive;
    private Scope scope;
    private boolean statisticsEnabled;
    private boolean ignoreJTA;
    private boolean isLockGrantor;
    private int concurrencyLevel;
    private boolean concurrencyChecksEnabled = true;
    private boolean earlyAck;
    private boolean multicastEnabled;
    private DiskWriteAttributes diskWriteAttributes;
    private File[] diskDirs;
    private int[] diskSizes;
    private String diskStoreName;
    private boolean isDiskSynchronous = true;
    private boolean cloningEnabled = false;
    private DataPolicy dataPolicy;
    private boolean indexMaintenanceSynchronous;
    private String id;
    private String refid;
    private PartitionAttributes partitionAttributes;
    private MembershipAttributes membershipAttributes;
    private SubscriptionAttributes subscriptionAttributes;
    private EvictionAttributesImpl evictionAttributes;
    private boolean publisher;
    private boolean enableSubscriptionConflation;
    private boolean enableAsyncConflation;
    private String poolName;
    private Compressor compressor;
    private boolean offHeap;

    private static RegionAttributes getDefaultAttributes(CacheCreation cc) {
        if (cc != null) {
            return cc.getDefaultAttributes();
        }
        return defaultAttributes;
    }

    public RegionAttributesCreation(CacheCreation cc) {
        this(cc, RegionAttributesCreation.getDefaultAttributes(cc), true);
    }

    public RegionAttributesCreation() {
        this(defaultAttributes, true);
    }

    public RegionAttributesCreation(RegionAttributes attrs, boolean defaults) {
        this(null, attrs, defaults);
    }

    public RegionAttributesCreation(CacheCreation cc, RegionAttributes attrs, boolean defaults) {
        this.cacheListeners = new ArrayList(Arrays.asList(attrs.getCacheListeners()));
        this.gatewaySenderIds = new HashSet<String>(attrs.getGatewaySenderIds());
        this.asyncEventQueueIds = new HashSet<String>(attrs.getAsyncEventQueueIds());
        this.cacheLoader = attrs.getCacheLoader();
        this.cacheWriter = attrs.getCacheWriter();
        this.entryIdleTimeout = attrs.getEntryIdleTimeout();
        this.customEntryIdleTimeout = attrs.getCustomEntryIdleTimeout();
        this.entryTimeToLive = attrs.getEntryTimeToLive();
        this.customEntryTimeToLive = attrs.getCustomEntryTimeToLive();
        this.initialCapacity = attrs.getInitialCapacity();
        this.keyConstraint = attrs.getKeyConstraint();
        this.valueConstraint = attrs.getValueConstraint();
        this.loadFactor = attrs.getLoadFactor();
        this.regionIdleTimeout = attrs.getRegionIdleTimeout();
        this.regionTimeToLive = attrs.getRegionTimeToLive();
        this.scope = attrs.getScope();
        this.statisticsEnabled = attrs.getStatisticsEnabled();
        this.ignoreJTA = attrs.getIgnoreJTA();
        this.concurrencyLevel = attrs.getConcurrencyLevel();
        this.concurrencyChecksEnabled = attrs.getConcurrencyChecksEnabled();
        this.earlyAck = attrs.getEarlyAck();
        this.diskStoreName = attrs.getDiskStoreName();
        if (this.diskStoreName == null) {
            this.diskWriteAttributes = attrs.getDiskWriteAttributes();
            this.diskDirs = attrs.getDiskDirs();
            this.diskSizes = attrs.getDiskDirSizes();
        } else {
            this.diskWriteAttributes = null;
            this.diskDirs = null;
            this.diskSizes = null;
        }
        this.isDiskSynchronous = attrs.isDiskSynchronous();
        this.indexMaintenanceSynchronous = attrs.getIndexMaintenanceSynchronous();
        this.partitionAttributes = attrs.getPartitionAttributes();
        this.membershipAttributes = attrs.getMembershipAttributes();
        this.subscriptionAttributes = attrs.getSubscriptionAttributes();
        this.dataPolicy = attrs.getDataPolicy();
        this.evictionAttributes = (EvictionAttributesImpl)attrs.getEvictionAttributes();
        this.id = null;
        this.refid = null;
        this.enableSubscriptionConflation = attrs.getEnableSubscriptionConflation();
        this.publisher = attrs.getPublisher();
        this.enableAsyncConflation = attrs.getEnableAsyncConflation();
        this.poolName = attrs.getPoolName();
        this.multicastEnabled = attrs.getMulticastEnabled();
        this.cloningEnabled = attrs.getCloningEnabled();
        this.compressor = attrs.getCompressor();
        this.offHeap = attrs.getOffHeap();
        if (attrs instanceof UserSpecifiedRegionAttributes) {
            UserSpecifiedRegionAttributes nonDefault = (UserSpecifiedRegionAttributes)attrs;
            this.requiresPoolName = nonDefault.requiresPoolName;
            if (!defaults) {
                this.initHasFields(nonDefault);
            }
        } else if (!defaults) {
            this.setAllHasFields(true);
        }
    }

    static boolean equal(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    private boolean equal(long[] array1, long[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    private boolean equal(int[] array1, int[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    private boolean equal(File[] array1, File[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            boolean found = false;
            for (int j = 0; j < array2.length; ++j) {
                if (!RegionAttributesCreation.equal(array1[i].getAbsoluteFile(), array2[j].getAbsoluteFile())) continue;
                found = true;
                break;
            }
            if (found) continue;
            StringBuffer sb = new StringBuffer();
            sb.append("Didn't find ");
            sb.append(array1[i]);
            sb.append(" in ");
            for (int k = 0; k < array2.length; ++k) {
                sb.append(array2[k]);
                sb.append(" ");
            }
            System.out.println(sb);
            return false;
        }
        return true;
    }

    public boolean sameAs(RegionAttributes other) {
        if (!RegionAttributesCreation.equal(this.cacheListeners, Arrays.asList(other.getCacheListeners()))) {
            throw new RuntimeException(LocalizedStrings.RegionAttributesCreation_CACHELISTENERS_ARE_NOT_THE_SAME.toLocalizedString());
        }
        if (!RegionAttributesCreation.equal(this.entryIdleTimeout, other.getEntryIdleTimeout())) {
            throw new RuntimeException(LocalizedStrings.RegionAttributesCreation_ENTRYIDLETIMEOUT_IS_NOT_THE_SAME.toLocalizedString());
        }
        if (!RegionAttributesCreation.equal(this.customEntryIdleTimeout, other.getCustomEntryIdleTimeout())) {
            throw new RuntimeException(LocalizedStrings.RegionAttributesCreation_CUSTOMENTRYIDLETIMEOUT_IS_NOT_THE_SAME.toLocalizedString());
        }
        if (!RegionAttributesCreation.equal(this.entryTimeToLive, other.getEntryTimeToLive())) {
            throw new RuntimeException(LocalizedStrings.RegionAttributesCreation_ENTRYTIMETOLIVE_IS_NOT_THE_SAME.toLocalizedString());
        }
        if (!RegionAttributesCreation.equal(this.customEntryTimeToLive, other.getCustomEntryTimeToLive())) {
            throw new RuntimeException(LocalizedStrings.RegionAttributesCreation_CUSTOMENTRYTIMETOLIVE_IS_NOT_THE_SAME.toLocalizedString());
        }
        if (!RegionAttributesCreation.equal(this.partitionAttributes, other.getPartitionAttributes())) {
            throw new RuntimeException(LocalizedStrings.RegionAttributesCreation_PARTITIONATTRIBUTES_ARE_NOT_THE_SAME_0_1.toLocalizedString(this, other.getPartitionAttributes()));
        }
        if (!RegionAttributesCreation.equal(this.membershipAttributes, other.getMembershipAttributes())) {
            throw new RuntimeException(LocalizedStrings.RegionAttributesCreation_MEMBERSHIP_ATTRIBUTES_ARE_NOT_THE_SAME.toLocalizedString());
        }
        if (!RegionAttributesCreation.equal(this.subscriptionAttributes, other.getSubscriptionAttributes())) {
            throw new RuntimeException(LocalizedStrings.RegionAttributesCreation_SUBSCRIPTION_ATTRIBUTES_ARE_NOT_THE_SAME.toLocalizedString());
        }
        if (!RegionAttributesCreation.equal(this.evictionAttributes, other.getEvictionAttributes())) {
            throw new RuntimeException(LocalizedStrings.RegionAttributesCreation_EVICTION_ATTRIBUTES_ARE_NOT_THE_SAME_THIS_0_OTHER_1.toLocalizedString(this.evictionAttributes, other.getEvictionAttributes()));
        }
        if (this.diskStoreName == null) {
            if (!RegionAttributesCreation.equal(this.diskWriteAttributes, other.getDiskWriteAttributes())) {
                throw new RuntimeException(LocalizedStrings.RegionAttributesCreation_DISTWRITEATTRIBUTES_ARE_NOT_THE_SAME.toLocalizedString());
            }
            if (!this.equal(this.diskDirs, other.getDiskDirs())) {
                throw new RuntimeException(LocalizedStrings.RegionAttributesCreation_DISK_DIRS_ARE_NOT_THE_SAME.toLocalizedString());
            }
            if (!this.equal(this.diskSizes, other.getDiskDirSizes())) {
                throw new RuntimeException(LocalizedStrings.RegionAttributesCreation_DISK_DIR_SIZES_ARE_NOT_THE_SAME.toLocalizedString());
            }
        }
        if (!RegionAttributesCreation.equal(this.diskStoreName, other.getDiskStoreName())) {
            throw new RuntimeException(LocalizedStrings.RegionAttributesCreation_DISKSTORE_IS_NOT_THE_SAME_THIS_0_OTHER_1.toLocalizedString(this.diskStoreName, other.getDiskStoreName()));
        }
        if (this.isDiskSynchronous != other.isDiskSynchronous()) {
            throw new RuntimeException(LocalizedStrings.RegionAttributesCreation_DISKSYNCHRONOUS_IS_NOT_THE_SAME.toLocalizedString());
        }
        if (this.dataPolicy != other.getDataPolicy()) {
            throw new RuntimeException(LocalizedStrings.RegionAttributesCreation_DATA_POLICIES_ARE_NOT_THE_SAME_THIS_0_OTHER_1.toLocalizedString(this.getDataPolicy(), other.getDataPolicy()));
        }
        if (this.earlyAck != other.getEarlyAck()) {
            throw new RuntimeException(LocalizedStrings.RegionAttributesCreation_EARLY_ACK_IS_NOT_THE_SAME.toLocalizedString());
        }
        if (this.enableSubscriptionConflation != other.getEnableSubscriptionConflation()) {
            throw new RuntimeException(LocalizedStrings.RegionAttributesCreation_ENABLE_SUBSCRIPTION_CONFLATION_IS_NOT_THE_SAME.toLocalizedString());
        }
        if (this.enableAsyncConflation != other.getEnableAsyncConflation()) {
            throw new RuntimeException(LocalizedStrings.RegionAttributesCreation_ENABLE_ASYNC_CONFLATION_IS_NOT_THE_SAME.toLocalizedString());
        }
        if (this.initialCapacity != other.getInitialCapacity()) {
            throw new RuntimeException(LocalizedStrings.RegionAttributesCreation_INITIAL_CAPACITY_IS_NOT_THE_SAME.toLocalizedString());
        }
        if (!RegionAttributesCreation.equal(this.keyConstraint, other.getKeyConstraint())) {
            throw new RuntimeException(LocalizedStrings.RegionAttributesCreation_KEY_CONSTRAINTS_ARE_NOT_THE_SAME.toLocalizedString());
        }
        if (!RegionAttributesCreation.equal(this.valueConstraint, other.getValueConstraint())) {
            throw new RuntimeException(LocalizedStrings.RegionAttributesCreation_VALUE_CONSTRAINTS_ARE_NOT_THE_SAME.toLocalizedString());
        }
        if (this.loadFactor != other.getLoadFactor()) {
            throw new RuntimeException(LocalizedStrings.RegionAttributesCreation_LOAD_FACTORS_ARE_NOT_THE_SAME.toLocalizedString());
        }
        if (!RegionAttributesCreation.equal(this.regionIdleTimeout, other.getRegionIdleTimeout())) {
            throw new RuntimeException(LocalizedStrings.RegionAttributesCreation_REGION_IDLE_TIMEOUT_IS_NOT_THE_SAME.toLocalizedString());
        }
        if (!RegionAttributesCreation.equal(this.scope, this.getScope())) {
            throw new RuntimeException(LocalizedStrings.RegionAttributesCreation_SCOPE_IS_NOT_THE_SAME.toLocalizedString());
        }
        if (this.statisticsEnabled != other.getStatisticsEnabled()) {
            throw new RuntimeException(LocalizedStrings.RegionAttributesCreation_STATISTICS_ENABLED_IS_NOT_THE_SAME_THIS_0_OTHER_1.toLocalizedString(this.statisticsEnabled, other.getStatisticsEnabled()));
        }
        if (this.ignoreJTA != other.getIgnoreJTA()) {
            throw new RuntimeException(LocalizedStrings.RegionAttributesCreation_IGNORE_JTA_IS_NOT_THE_SAME.toLocalizedString());
        }
        if (this.concurrencyLevel != other.getConcurrencyLevel()) {
            throw new RuntimeException(LocalizedStrings.RegionAttributesCreation_CONCURRENCYLEVEL_IS_NOT_THE_SAME.toLocalizedString());
        }
        if (this.concurrencyChecksEnabled != other.getConcurrencyChecksEnabled()) {
            throw new RuntimeException(LocalizedStrings.RegionAttributesCreation_CONCURRENCYCHECKSENABLED_IS_NOT_THE_SAME.toLocalizedString());
        }
        if (this.indexMaintenanceSynchronous != other.getIndexMaintenanceSynchronous()) {
            throw new RuntimeException(LocalizedStrings.RegionAttributesCreation_INDEX_MAINTENANCE_SYNCHRONOUS_IS_NOT_THE_SAME.toLocalizedString());
        }
        if (!RegionAttributesCreation.equal(this.poolName, other.getPoolName())) {
            throw new RuntimeException("poolName is not the same: " + this.poolName + " != " + other.getPoolName());
        }
        if (!RegionAttributesCreation.equal(this.cacheLoader, other.getCacheLoader())) {
            throw new RuntimeException("CacheLoader are not the same");
        }
        if (!RegionAttributesCreation.equal(this.cacheWriter, other.getCacheWriter())) {
            throw new RuntimeException("CacheWriter is not the same");
        }
        if (this.multicastEnabled != other.getMulticastEnabled()) {
            String s = "MulticastEnabled is not the same: " + this.multicastEnabled + "!=" + other.getMulticastEnabled();
            throw new RuntimeException(s);
        }
        if (this.cloningEnabled != other.getCloningEnabled()) {
            throw new RuntimeException(LocalizedStrings.RegionAttributesCreation__CLONING_ENABLE_IS_NOT_THE_SAME_THIS_0_OTHER_1.toLocalizedString(this.cloningEnabled, other.getCloningEnabled()));
        }
        if (!RegionAttributesCreation.equal(this.compressor, other.getCompressor())) {
            throw new RuntimeException("Compressors are not the same.");
        }
        if (this.offHeap != other.getOffHeap()) {
            throw new RuntimeException(LocalizedStrings.RegionAttributesCreation_ENABLE_OFF_HEAP_MEMORY_IS_NOT_THE_SAME.toLocalizedString());
        }
        return true;
    }

    @Override
    public CacheLoader getCacheLoader() {
        return this.cacheLoader;
    }

    public CacheLoader setCacheLoader(CacheLoader cacheLoader) {
        CacheLoader old = this.cacheLoader;
        this.cacheLoader = cacheLoader;
        this.setHasCacheLoader(true);
        return old;
    }

    @Override
    public CacheWriter getCacheWriter() {
        return this.cacheWriter;
    }

    public CacheWriter setCacheWriter(CacheWriter cacheWriter) {
        CacheWriter old = this.cacheWriter;
        this.cacheWriter = cacheWriter;
        this.setHasCacheWriter(true);
        return old;
    }

    @Override
    public Class getKeyConstraint() {
        return this.keyConstraint;
    }

    public void setKeyConstraint(Class keyConstraint) {
        this.keyConstraint = keyConstraint;
        this.setHasKeyConstraint(true);
    }

    @Override
    public Class getValueConstraint() {
        return this.valueConstraint;
    }

    public void setValueConstraint(Class valueConstraint) {
        this.valueConstraint = valueConstraint;
        this.setHasValueConstraint(true);
    }

    @Override
    public ExpirationAttributes getRegionTimeToLive() {
        return this.regionTimeToLive;
    }

    public ExpirationAttributes setRegionTimeToLive(ExpirationAttributes timeToLive) {
        ExpirationAttributes old = this.regionTimeToLive;
        this.regionTimeToLive = timeToLive;
        this.setHasRegionTimeToLive(true);
        return old;
    }

    @Override
    public ExpirationAttributes getRegionIdleTimeout() {
        return this.regionIdleTimeout;
    }

    public ExpirationAttributes setRegionIdleTimeout(ExpirationAttributes idleTimeout) {
        ExpirationAttributes old = this.regionIdleTimeout;
        this.regionIdleTimeout = idleTimeout;
        this.setHasRegionIdleTimeout(true);
        return old;
    }

    @Override
    public ExpirationAttributes getEntryTimeToLive() {
        return this.entryTimeToLive;
    }

    @Override
    public CustomExpiry getCustomEntryTimeToLive() {
        return this.customEntryTimeToLive;
    }

    public ExpirationAttributes setEntryTimeToLive(ExpirationAttributes timeToLive) {
        ExpirationAttributes old = this.entryTimeToLive;
        this.entryTimeToLive = timeToLive;
        this.setHasEntryTimeToLive(true);
        return old;
    }

    public CustomExpiry setCustomEntryTimeToLive(CustomExpiry custom) {
        CustomExpiry old = this.customEntryTimeToLive;
        this.customEntryTimeToLive = custom;
        this.setHasCustomEntryTimeToLive(true);
        return old;
    }

    @Override
    public ExpirationAttributes getEntryIdleTimeout() {
        return this.entryIdleTimeout;
    }

    @Override
    public CustomExpiry getCustomEntryIdleTimeout() {
        return this.customEntryIdleTimeout;
    }

    public ExpirationAttributes setEntryIdleTimeout(ExpirationAttributes idleTimeout) {
        ExpirationAttributes old = this.entryIdleTimeout;
        this.entryIdleTimeout = idleTimeout;
        this.setHasEntryIdleTimeout(true);
        return old;
    }

    public CustomExpiry setCustomEntryIdleTimeout(CustomExpiry custom) {
        CustomExpiry old = this.customEntryIdleTimeout;
        this.customEntryIdleTimeout = custom;
        this.setHasCustomEntryIdleTimeout(true);
        return old;
    }

    @Override
    public MirrorType getMirrorType() {
        if (this.dataPolicy.isNormal() || this.dataPolicy.isPreloaded() || this.dataPolicy.isEmpty() || this.dataPolicy.withPartitioning()) {
            return MirrorType.NONE;
        }
        if (this.dataPolicy.withReplication()) {
            return MirrorType.KEYS_VALUES;
        }
        throw new IllegalStateException(LocalizedStrings.RegionAttributesCreation_NO_MIRROR_TYPE_CORRESPONDS_TO_DATA_POLICY_0.toLocalizedString(this.dataPolicy));
    }

    public void setMirrorType(MirrorType mirrorType) {
        DataPolicy dp = mirrorType.getDataPolicy();
        if (dp.withReplication()) {
            if (!this.getDataPolicy().withReplication()) {
                this.setDataPolicy(dp);
            }
        } else if (this.getDataPolicy().withReplication()) {
            this.setDataPolicy(dp);
        }
    }

    @Override
    public DataPolicy getDataPolicy() {
        return this.dataPolicy;
    }

    public void setDataPolicy(DataPolicy dataPolicy) {
        this.dataPolicy = dataPolicy;
        this.setHasDataPolicy(true);
        if (this.dataPolicy.withPartitioning() && !this.hasPartitionAttributes()) {
            this.setPartitionAttributes(new PartitionAttributesFactory().create());
            this.setHasPartitionAttributes(false);
        }
    }

    public void secretlySetDataPolicy(DataPolicy dataPolicy) {
        this.dataPolicy = dataPolicy;
    }

    @Override
    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
        this.setHasScope(true);
    }

    @Override
    public CacheListener[] getCacheListeners() {
        CacheListener[] result = new CacheListener[this.cacheListeners.size()];
        this.cacheListeners.toArray(result);
        return result;
    }

    @Override
    public CacheListener getCacheListener() {
        if (this.cacheListeners.isEmpty()) {
            return null;
        }
        if (this.cacheListeners.size() == 1) {
            return (CacheListener)this.cacheListeners.get(0);
        }
        throw new IllegalStateException(LocalizedStrings.RegionAttributesCreation_MORE_THAN_ONE_CACHE_LISTENER_EXISTS.toLocalizedString());
    }

    public void initCacheListeners(CacheListener[] listeners) {
        this.cacheListeners = new ArrayList<CacheListener>(Arrays.asList(listeners));
        this.setHasCacheListeners(true);
    }

    public void addCacheListener(CacheListener listener) {
        this.cacheListeners.add(listener);
        this.setHasCacheListeners(true);
    }

    public void setCacheListener(CacheListener listener) {
        this.cacheListeners = new ArrayList(1);
        this.cacheListeners.add(listener);
        this.setHasCacheListeners(true);
    }

    public void initGatewaySenders(Set<String> gatewaySenderIds) {
        this.gatewaySenderIds = new HashSet<String>(gatewaySenderIds);
        this.setHasGatewaySenderIds(true);
    }

    public void initAsyncEventQueues(Set<String> asyncEventQueues) {
        this.asyncEventQueueIds = new HashSet<String>(asyncEventQueues);
        this.setHasAsyncEventListeners(true);
    }

    public void addGatewaySenderId(String gatewaySenderId) {
        this.gatewaySenderIds.add(gatewaySenderId);
        this.setHasGatewaySenderIds(true);
    }

    public void addAsyncEventQueueId(String asyncEventQueueId) {
        this.asyncEventQueueIds.add(asyncEventQueueId);
        this.setHasAsyncEventListeners(true);
    }

    @Override
    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    public void setInitialCapacity(int initialCapacity) {
        this.initialCapacity = initialCapacity;
        this.setHasInitialCapacity(true);
    }

    @Override
    public float getLoadFactor() {
        return this.loadFactor;
    }

    public void setLoadFactor(float loadFactor) {
        this.loadFactor = loadFactor;
        this.setHasLoadFactor(true);
    }

    @Override
    public int getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    @Override
    public boolean getConcurrencyChecksEnabled() {
        return this.concurrencyChecksEnabled;
    }

    public void setConcurrencyLevel(int concurrencyLevel) {
        this.concurrencyLevel = concurrencyLevel;
        this.setHasConcurrencyLevel(true);
    }

    public void setConcurrencyChecksEnabled(boolean enabled) {
        this.concurrencyChecksEnabled = enabled;
        this.setHasConcurrencyChecksEnabled(true);
    }

    @Override
    public boolean getStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
        this.setHasStatisticsEnabled(true);
    }

    @Override
    public boolean getIgnoreJTA() {
        return this.ignoreJTA;
    }

    public void setIgnoreJTA(boolean flag) {
        this.ignoreJTA = flag;
        this.setHasIgnoreJTA(true);
    }

    @Override
    public boolean isLockGrantor() {
        return this.isLockGrantor;
    }

    public void setLockGrantor(boolean isLockGrantor) {
        this.isLockGrantor = isLockGrantor;
        this.setHasIsLockGrantor(true);
    }

    @Override
    public boolean getPersistBackup() {
        return this.getDataPolicy().withPersistence();
    }

    public void setPersistBackup(boolean persistBackup) {
        if (persistBackup) {
            if (!this.getDataPolicy().withPersistence()) {
                if (this.getDataPolicy().withPartitioning()) {
                    this.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                } else {
                    this.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                }
            }
        } else if (this.getDataPolicy().withReplication()) {
            this.setDataPolicy(DataPolicy.REPLICATE);
        } else if (this.getDataPolicy().withPartitioning()) {
            this.setDataPolicy(DataPolicy.PARTITION);
        }
    }

    @Override
    public boolean getEarlyAck() {
        return this.earlyAck;
    }

    public void setEarlyAck(boolean earlyAck) {
        this.earlyAck = earlyAck;
        this.setHasEarlyAck(true);
    }

    @Override
    public boolean getMulticastEnabled() {
        return this.multicastEnabled;
    }

    public void setMulticastEnabled(boolean multicastEnabled) {
        this.multicastEnabled = multicastEnabled;
        this.setHasMulticastEnabled(true);
    }

    @Override
    @Deprecated
    public boolean getPublisher() {
        return this.publisher;
    }

    @Deprecated
    public void setPublisher(boolean v) {
    }

    @Override
    public boolean getEnableConflation() {
        return this.getEnableSubscriptionConflation();
    }

    @Override
    public boolean getEnableBridgeConflation() {
        return this.getEnableSubscriptionConflation();
    }

    @Override
    public boolean getEnableSubscriptionConflation() {
        return this.enableSubscriptionConflation;
    }

    public void setEnableBridgeConflation(boolean v) {
        this.setEnableSubscriptionConflation(v);
    }

    public void setEnableSubscriptionConflation(boolean v) {
        this.enableSubscriptionConflation = v;
        this.setHasEnableSubscriptionConflation(true);
    }

    @Override
    public boolean getEnableAsyncConflation() {
        return this.enableAsyncConflation;
    }

    public void setEnableAsyncConflation(boolean enableAsyncConflation) {
        this.enableAsyncConflation = enableAsyncConflation;
        this.setHasEnableAsyncConflation(true);
    }

    public void setIndexMaintenanceSynchronous(boolean isSynchronous) {
        this.indexMaintenanceSynchronous = isSynchronous;
        this.setHasIndexMaintenanceSynchronous(true);
    }

    @Override
    public DiskWriteAttributes getDiskWriteAttributes() {
        return this.diskWriteAttributes;
    }

    public void setDiskWriteAttributes(DiskWriteAttributes attrs) {
        this.diskWriteAttributes = attrs;
        this.isDiskSynchronous = attrs.isSynchronous();
        this.setHasDiskWriteAttributes(true);
    }

    @Override
    public File[] getDiskDirs() {
        return this.diskDirs;
    }

    @Override
    public int[] getDiskDirSizes() {
        return this.diskSizes;
    }

    public void setDiskDirs(File[] diskDirs) {
        this.checkIfDirectoriesExist(diskDirs);
        this.diskDirs = diskDirs;
        this.diskSizes = new int[diskDirs.length];
        for (int i = 0; i < diskDirs.length; ++i) {
            this.diskSizes[i] = Integer.MAX_VALUE;
        }
        this.setHasDiskDirs(true);
    }

    @Override
    public String getDiskStoreName() {
        return this.diskStoreName;
    }

    public void setDiskStoreName(String diskStoreName) {
        this.diskStoreName = diskStoreName;
        this.setHasDiskStoreName(true);
    }

    @Override
    public boolean isDiskSynchronous() {
        return this.isDiskSynchronous;
    }

    public void setDiskSynchronous(boolean isDiskSynchronous) {
        this.isDiskSynchronous = isDiskSynchronous;
        this.setHasDiskSynchronous(true);
    }

    private void checkIfDirectoriesExist(File[] diskDirs) {
        for (int i = 0; i < diskDirs.length; ++i) {
            if (diskDirs[i].isDirectory()) continue;
            throw new IllegalArgumentException(LocalizedStrings.RegionAttributesCreation__0_WAS_NOT_AN_EXISTING_DIRECTORY.toLocalizedString(diskDirs[i]));
        }
    }

    public void setDiskDirsAndSize(File[] diskDirs, int[] sizes) {
        this.checkIfDirectoriesExist(diskDirs);
        this.diskDirs = diskDirs;
        if (sizes.length != this.diskDirs.length) {
            throw new IllegalArgumentException(LocalizedStrings.RegionAttributesCreation_NUMBER_OF_DISKSIZES_IS_0_WHICH_IS_NOT_EQUAL_TO_NUMBER_OF_DISK_DIRS_WHICH_IS_1.toLocalizedString(sizes.length, diskDirs.length));
        }
        this.verifyNonNegativeDirSize(sizes);
        this.diskSizes = sizes;
        this.setHasDiskDirs(true);
    }

    private void verifyNonNegativeDirSize(int[] sizes) {
        for (int i = 0; i < sizes.length; ++i) {
            if (sizes[i] >= 0) continue;
            throw new IllegalArgumentException(LocalizedStrings.RegionAttributesCreation_DIR_SIZE_CANNOT_BE_NEGATIVE_0.toLocalizedString(sizes[i]));
        }
    }

    @Override
    public boolean getIndexMaintenanceSynchronous() {
        return this.indexMaintenanceSynchronous;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setRefid(String refid) {
        this.refid = refid;
    }

    public String getRefid() {
        return this.refid;
    }

    void inheritAttributes(Cache cache) {
        this.inheritAttributes(cache, true);
    }

    void inheritAttributes(Cache cache, boolean setDefaultPool) {
        if (this.refid == null) {
            if (setDefaultPool && this.requiresPoolName && !this.hasPoolName()) {
                String defaultPoolName = null;
                if (cache instanceof GemFireCacheImpl) {
                    GemFireCacheImpl gfc = (GemFireCacheImpl)cache;
                    if (gfc.getDefaultPool() != null) {
                        defaultPoolName = gfc.getDefaultPool().getName();
                    }
                } else if (cache instanceof ClientCacheCreation) {
                    ClientCacheCreation ccc = (ClientCacheCreation)cache;
                    defaultPoolName = ccc.getDefaultPoolName();
                }
                if (defaultPoolName != null) {
                    this.setPoolName(defaultPoolName);
                }
            }
            return;
        }
        RegionAttributes parent = cache.getRegionAttributes(this.refid);
        if (parent == null) {
            throw new IllegalStateException(LocalizedStrings.RegionAttributesCreation_CANNOT_REFERENCE_NONEXISTING_REGION_ATTRIBUTES_NAMED_0.toLocalizedString(this.refid));
        }
        boolean parentIsUserSpecified = parent instanceof UserSpecifiedRegionAttributes;
        UserSpecifiedRegionAttributes parentWithHas = parentIsUserSpecified ? (UserSpecifiedRegionAttributes)parent : null;
        if (parentWithHas != null && setDefaultPool && parentWithHas.requiresPoolName) {
            this.requiresPoolName = true;
            if (!this.hasPoolName()) {
                String defaultPoolName = null;
                if (cache instanceof GemFireCacheImpl) {
                    GemFireCacheImpl gfc = (GemFireCacheImpl)cache;
                    if (gfc.getDefaultPool() != null) {
                        defaultPoolName = gfc.getDefaultPool().getName();
                    }
                } else if (cache instanceof ClientCacheCreation) {
                    ClientCacheCreation ccc = (ClientCacheCreation)cache;
                    defaultPoolName = ccc.getDefaultPoolName();
                }
                if (defaultPoolName != null) {
                    this.setPoolName(defaultPoolName);
                }
            }
        }
        if (!this.hasCacheListeners()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasCacheListeners()) {
                    this.initCacheListeners(parent.getCacheListeners());
                }
            } else {
                this.initCacheListeners(parent.getCacheListeners());
            }
        }
        if (!this.hasGatewaySenderId()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasGatewaySenderId()) {
                    this.initGatewaySenders(parent.getGatewaySenderIds());
                }
            } else {
                this.initGatewaySenders(parent.getGatewaySenderIds());
            }
        }
        if (!this.hasAsyncEventListeners()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasAsyncEventListeners()) {
                    this.initAsyncEventQueues(parent.getAsyncEventQueueIds());
                }
            } else {
                this.initAsyncEventQueues(parent.getAsyncEventQueueIds());
            }
        }
        if (!this.hasCacheLoader()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasCacheLoader()) {
                    this.setCacheLoader(parent.getCacheLoader());
                }
            } else {
                this.setCacheLoader(parent.getCacheLoader());
            }
        }
        if (!this.hasCacheWriter()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasCacheWriter()) {
                    this.setCacheWriter(parent.getCacheWriter());
                }
            } else {
                this.setCacheWriter(parent.getCacheWriter());
            }
        }
        if (!this.hasEntryIdleTimeout()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasEntryIdleTimeout()) {
                    this.setEntryIdleTimeout(parent.getEntryIdleTimeout());
                }
            } else {
                this.setEntryIdleTimeout(parent.getEntryIdleTimeout());
            }
        }
        if (!this.hasCustomEntryIdleTimeout()) {
            this.setCustomEntryIdleTimeout(parent.getCustomEntryIdleTimeout());
        }
        if (!this.hasEntryTimeToLive()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasEntryTimeToLive()) {
                    this.setEntryTimeToLive(parent.getEntryTimeToLive());
                }
            } else {
                this.setEntryTimeToLive(parent.getEntryTimeToLive());
            }
        }
        if (!this.hasCustomEntryTimeToLive()) {
            this.setCustomEntryTimeToLive(parent.getCustomEntryTimeToLive());
        }
        if (!this.hasInitialCapacity()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasInitialCapacity()) {
                    this.setInitialCapacity(parent.getInitialCapacity());
                }
            } else {
                this.setInitialCapacity(parent.getInitialCapacity());
            }
        }
        if (!this.hasKeyConstraint()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasKeyConstraint()) {
                    this.setKeyConstraint(parent.getKeyConstraint());
                }
            } else {
                this.setKeyConstraint(parent.getKeyConstraint());
            }
        }
        if (!this.hasValueConstraint()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasValueConstraint()) {
                    this.setValueConstraint(parent.getValueConstraint());
                }
            } else {
                this.setValueConstraint(parent.getValueConstraint());
            }
        }
        if (!this.hasLoadFactor()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasLoadFactor()) {
                    this.setLoadFactor(parent.getLoadFactor());
                }
            } else {
                this.setLoadFactor(parent.getLoadFactor());
            }
        }
        if (!this.hasRegionIdleTimeout()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasRegionIdleTimeout()) {
                    this.setRegionIdleTimeout(parent.getRegionIdleTimeout());
                }
            } else {
                this.setRegionIdleTimeout(parent.getRegionIdleTimeout());
            }
        }
        if (!this.hasRegionTimeToLive()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasRegionTimeToLive()) {
                    this.setRegionTimeToLive(parent.getRegionTimeToLive());
                }
            } else {
                this.setRegionTimeToLive(parent.getRegionTimeToLive());
            }
        }
        if (!this.hasScope()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasScope()) {
                    this.setScope(parent.getScope());
                }
            } else {
                this.setScope(parent.getScope());
            }
        }
        if (!this.hasStatisticsEnabled()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasStatisticsEnabled()) {
                    this.setStatisticsEnabled(parent.getStatisticsEnabled());
                }
            } else {
                this.setStatisticsEnabled(parent.getStatisticsEnabled());
            }
        }
        if (!this.hasIgnoreJTA()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasIgnoreJTA()) {
                    this.setIgnoreJTA(parent.getIgnoreJTA());
                }
            } else {
                this.setIgnoreJTA(parent.getIgnoreJTA());
            }
        }
        if (!this.hasIsLockGrantor()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasIsLockGrantor()) {
                    this.setLockGrantor(parent.isLockGrantor());
                }
            } else {
                this.setLockGrantor(parent.isLockGrantor());
            }
        }
        if (!this.hasConcurrencyLevel()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasConcurrencyLevel()) {
                    this.setConcurrencyLevel(parent.getConcurrencyLevel());
                }
            } else {
                this.setConcurrencyLevel(parent.getConcurrencyLevel());
            }
        }
        if (!this.hasConcurrencyChecksEnabled()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasConcurrencyChecksEnabled()) {
                    this.setConcurrencyChecksEnabled(parent.getConcurrencyChecksEnabled());
                }
            } else {
                this.setConcurrencyChecksEnabled(parent.getConcurrencyChecksEnabled());
            }
        }
        if (!this.hasEarlyAck()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasEarlyAck()) {
                    this.setEarlyAck(parent.getEarlyAck());
                }
            } else {
                this.setEarlyAck(parent.getEarlyAck());
            }
        }
        if (!this.hasEnableSubscriptionConflation()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasEnableSubscriptionConflation()) {
                    this.setEnableSubscriptionConflation(parent.getEnableSubscriptionConflation());
                }
            } else {
                this.setEnableSubscriptionConflation(parent.getEnableSubscriptionConflation());
            }
        }
        if (!this.hasPublisher()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasPublisher()) {
                    this.setPublisher(parent.getPublisher());
                }
            } else {
                this.setPublisher(parent.getPublisher());
            }
        }
        if (!this.hasEnableAsyncConflation()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasEnableAsyncConflation()) {
                    this.setEnableAsyncConflation(parent.getEnableAsyncConflation());
                }
            } else {
                this.setEnableAsyncConflation(parent.getEnableAsyncConflation());
            }
        }
        if (!this.hasMulticastEnabled()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasMulticastEnabled()) {
                    this.setMulticastEnabled(parent.getMulticastEnabled());
                }
            } else {
                this.setMulticastEnabled(parent.getMulticastEnabled());
            }
        }
        if (!this.hasDiskWriteAttributes()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasDiskWriteAttributes()) {
                    this.setDiskWriteAttributes(parent.getDiskWriteAttributes());
                }
            } else {
                this.setDiskWriteAttributes(parent.getDiskWriteAttributes());
            }
        }
        if (!this.hasDiskDirs()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasDiskDirs()) {
                    this.setDiskDirs(parent.getDiskDirs());
                }
            } else {
                this.setDiskDirs(parent.getDiskDirs());
            }
        }
        if (!this.hasIndexMaintenanceSynchronous()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasIndexMaintenanceSynchronous()) {
                    this.setIndexMaintenanceSynchronous(parent.getIndexMaintenanceSynchronous());
                }
            } else {
                this.setIndexMaintenanceSynchronous(parent.getIndexMaintenanceSynchronous());
            }
        }
        if (!this.hasPartitionAttributes()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasPartitionAttributes()) {
                    this.setPartitionAttributes(parent.getPartitionAttributes());
                }
            } else {
                this.setPartitionAttributes(parent.getPartitionAttributes());
            }
        }
        if (!this.hasSubscriptionAttributes()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasSubscriptionAttributes()) {
                    this.setSubscriptionAttributes(parent.getSubscriptionAttributes());
                }
            } else {
                this.setSubscriptionAttributes(parent.getSubscriptionAttributes());
            }
        }
        if (!this.hasDataPolicy()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasDataPolicy()) {
                    this.setDataPolicy(parent.getDataPolicy());
                }
            } else {
                this.setDataPolicy(parent.getDataPolicy());
            }
        }
        if (!this.hasEvictionAttributes()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasEvictionAttributes()) {
                    this.setEvictionAttributes(parent.getEvictionAttributes());
                }
            } else {
                this.setEvictionAttributes(parent.getEvictionAttributes());
            }
        }
        if (!this.hasPoolName()) {
            this.setPoolName(parent.getPoolName());
        }
        if (!this.hasDiskStoreName()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasDiskStoreName()) {
                    this.setDiskStoreName(parent.getDiskStoreName());
                }
            } else {
                this.setDiskStoreName(parent.getDiskStoreName());
            }
        }
        if (!this.hasDiskSynchronous()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasDiskSynchronous()) {
                    this.setDiskSynchronous(parent.isDiskSynchronous());
                }
            } else {
                this.setDiskSynchronous(parent.isDiskSynchronous());
            }
        }
        if (!this.hasCompressor()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasCompressor()) {
                    this.setCompressor(parent.getCompressor());
                }
            } else {
                this.setCompressor(parent.getCompressor());
            }
        }
        if (!this.hasConcurrencyChecksEnabled()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasConcurrencyChecksEnabled()) {
                    this.setConcurrencyChecksEnabled(parent.getConcurrencyChecksEnabled());
                }
            } else {
                this.setConcurrencyChecksEnabled(parent.getConcurrencyChecksEnabled());
            }
        }
        if (!this.hasMulticastEnabled()) {
            if (parentIsUserSpecified) {
                if (parentWithHas.hasMulticastEnabled()) {
                    this.setMulticastEnabled(parent.getMulticastEnabled());
                }
            } else {
                this.setMulticastEnabled(parent.getMulticastEnabled());
            }
        }
    }

    @Override
    public PartitionAttributes getPartitionAttributes() {
        return this.partitionAttributes;
    }

    public void setPartitionAttributes(PartitionAttributes pa) {
        if (pa != null) {
            if (!this.hasDataPolicy()) {
                this.setDataPolicy(PartitionedRegionHelper.DEFAULT_DATA_POLICY);
                this.setHasDataPolicy(false);
            }
            this.partitionAttributes = pa;
            this.setHasPartitionAttributes(true);
        }
    }

    @Override
    public MembershipAttributes getMembershipAttributes() {
        return this.membershipAttributes;
    }

    public void setMembershipAttributes(MembershipAttributes pa) {
        this.membershipAttributes = pa;
        this.setHasMembershipAttributes(true);
    }

    @Override
    public SubscriptionAttributes getSubscriptionAttributes() {
        return this.subscriptionAttributes;
    }

    public void setSubscriptionAttributes(SubscriptionAttributes pa) {
        this.subscriptionAttributes = pa;
        this.setHasSubscriptionAttributes(true);
    }

    public Region getRegion() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public void setEvictionAttributes(EvictionAttributes ea) {
        this.evictionAttributes = (EvictionAttributesImpl)ea;
        this.setHasEvictionAttributes(true);
    }

    @Override
    public EvictionAttributes getEvictionAttributes() {
        return this.evictionAttributes;
    }

    public void setPoolName(String poolName) {
        if ("".equals(poolName)) {
            poolName = null;
        }
        this.poolName = poolName;
        this.setHasPoolName(true);
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    public void setCloningEnable(boolean val) {
        this.cloningEnabled = val;
        this.setHasCloningEnabled(true);
    }

    @Override
    public boolean getCloningEnabled() {
        return this.cloningEnabled;
    }

    public void setCompressor(Compressor compressor) {
        this.compressor = compressor;
        this.setHasCompressor(true);
        if (compressor != null) {
            this.setCloningEnable(true);
        }
    }

    @Override
    public Compressor getCompressor() {
        return this.compressor;
    }

    public void setOffHeap(boolean offHeap) {
        this.offHeap = offHeap;
        this.setHasOffHeap(true);
    }

    @Override
    public boolean getOffHeap() {
        return this.offHeap;
    }

    public void prepareForValidation() {
        if (!(this.hasStatisticsEnabled() || this.getStatisticsEnabled() || this.getRegionTimeToLive().getTimeout() == 0 && this.getRegionIdleTimeout().getTimeout() == 0 && this.getEntryTimeToLive().getTimeout() == 0 && this.getEntryIdleTimeout().getTimeout() == 0 && this.getCustomEntryIdleTimeout() == null && this.getCustomEntryTimeToLive() == null)) {
            this.setStatisticsEnabled(true);
        }
        if (this.getDataPolicy().withReplication() && !this.getDataPolicy().withPersistence() && this.getScope().isDistributed() && (this.getEvictionAttributes().getAction().isLocalDestroy() || this.getEntryIdleTimeout().getAction().isLocal() || this.getEntryTimeToLive().getAction().isLocal() || this.getRegionIdleTimeout().getAction().isLocalInvalidate() || this.getRegionTimeToLive().getAction().isLocalInvalidate())) {
            this.setDataPolicy(DataPolicy.PRELOADED);
            this.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
        }
        if (!this.hasConcurrencyChecksEnabled() && !this.getConcurrencyChecksEnabled() && this.getDataPolicy().withPersistence()) {
            this.setConcurrencyChecksEnabled(true);
        }
    }

    @Override
    public Set<String> getAsyncEventQueueIds() {
        return this.asyncEventQueueIds;
    }

    @Override
    public Set<String> getGatewaySenderIds() {
        return this.gatewaySenderIds;
    }
}

