/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.operations.GetOperationContext;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.i18n.StringId;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.AuthorizeRequestPP;
import org.apache.geode.security.NotAuthorizedException;

public class Request
extends BaseCommand {
    private static final Request singleton = new Request();

    public static Command getCommand() {
        return singleton;
    }

    Request() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException {
        Part regionNamePart = null;
        Part keyPart = null;
        Part valuePart = null;
        String regionName = null;
        Object callbackArg = null;
        Object key = null;
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        CacheServerStats stats = servConn.getCacheServerStats();
        StringId errMessage = null;
        servConn.setAsTrue(2);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadGetRequestTime(start - oldStart);
        int parts = msg.getNumberOfParts();
        regionNamePart = msg.getPart(0);
        keyPart = msg.getPart(1);
        if (parts > 2) {
            valuePart = msg.getPart(2);
            try {
                callbackArg = valuePart.getObject();
            }
            catch (Exception e) {
                Request.writeException(msg, e, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
        }
        regionName = regionNamePart.getString();
        try {
            key = keyPart.getStringOrObject();
        }
        catch (Exception e) {
            Request.writeException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received get request ({} bytes) from {} for region {} key {} txId {}", (Object)servConn.getName(), (Object)msg.getPayloadLength(), (Object)servConn.getSocketString(), (Object)regionName, key, (Object)msg.getTransactionId());
        }
        if (key == null || regionName == null) {
            if (key == null && regionName == null) {
                errMessage = LocalizedStrings.Request_THE_INPUT_REGION_NAME_AND_KEY_FOR_THE_GET_REQUEST_ARE_NULL;
            } else if (key == null) {
                errMessage = LocalizedStrings.Request_THE_INPUT_KEY_FOR_THE_GET_REQUEST_IS_NULL;
            } else if (regionName == null) {
                errMessage = LocalizedStrings.Request_THE_INPUT_REGION_NAME_FOR_THE_GET_REQUEST_IS_NULL;
            }
            String s = errMessage.toLocalizedString();
            logger.warn("{}: {}", (Object)servConn.getName(), (Object)s);
            Request.writeErrorResponse(msg, 3, s, servConn);
            servConn.setAsTrue(1);
        } else {
            Region region = servConn.getCache().getRegion(regionName);
            if (region == null) {
                String reason = LocalizedStrings.Request__0_WAS_NOT_FOUND_DURING_GET_REQUEST.toLocalizedString(regionName);
                Request.writeRegionDestroyedEx(msg, regionName, reason, servConn);
                servConn.setAsTrue(1);
            } else {
                GetOperationContext getContext = null;
                try {
                    this.securityService.authorizeRegionRead(regionName, key.toString());
                    AuthorizeRequest authzRequest = servConn.getAuthzRequest();
                    if (authzRequest != null) {
                        getContext = authzRequest.getAuthorize(regionName, key, callbackArg);
                        callbackArg = getContext.getCallbackArg();
                    }
                }
                catch (NotAuthorizedException ex) {
                    Request.writeException(msg, ex, false, servConn);
                    servConn.setAsTrue(1);
                    return;
                }
                Object[] valueAndIsObject = new Object[3];
                try {
                    this.getValueAndIsObject(region, key, callbackArg, servConn, valueAndIsObject);
                }
                catch (Exception e) {
                    Request.writeException(msg, e, false, servConn);
                    servConn.setAsTrue(1);
                    return;
                }
                Object data = valueAndIsObject[0];
                boolean isObject = (Boolean)valueAndIsObject[1];
                try {
                    AuthorizeRequestPP postAuthzRequest = servConn.getPostAuthzRequest();
                    if (postAuthzRequest != null) {
                        byte[] serializedValue = (getContext = postAuthzRequest.getAuthorize(regionName, key, data, isObject, getContext)).getSerializedValue();
                        data = serializedValue == null ? getContext.getObject() : (Object)serializedValue;
                        isObject = getContext.isObject();
                    }
                }
                catch (NotAuthorizedException ex) {
                    Request.writeException(msg, ex, false, servConn);
                    servConn.setAsTrue(1);
                    return;
                }
                long oldStart2 = start;
                start = DistributionStats.getStatTime();
                stats.incProcessGetTime(start - oldStart2);
                if (region instanceof PartitionedRegion) {
                    PartitionedRegion pr = (PartitionedRegion)region;
                    if (pr.getNetworkHopType() != 0) {
                        Request.writeResponseWithRefreshMetadata(data, callbackArg, msg, isObject, servConn, pr, pr.getNetworkHopType());
                        pr.clearNetworkHopData();
                    } else {
                        Request.writeResponse(data, callbackArg, msg, isObject, servConn);
                    }
                } else {
                    Request.writeResponse(data, callbackArg, msg, isObject, servConn);
                }
                servConn.setAsTrue(1);
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Wrote get response back to {} for region {} key {} value: {}", (Object)servConn.getName(), (Object)servConn.getSocketString(), (Object)regionName, key, data);
                }
                stats.incWriteGetResponseTime(DistributionStats.getStatTime() - start);
            }
        }
    }

    public void getValueAndIsObject(Region region, Object key, Object callbackArg, ServerConnection servConn, Object[] result) {
        String regionName = region.getFullPath();
        if (servConn != null) {
            servConn.setModificationInfo(true, regionName, key);
        }
        boolean isObject = true;
        ClientProxyMembershipID id = servConn == null ? null : servConn.getProxyID();
        Object data = ((LocalRegion)region).get(key, callbackArg, true, true, true, id, null, false);
        if (data instanceof CachedDeserializable) {
            CachedDeserializable cd2 = (CachedDeserializable)data;
            if (!cd2.isSerialized()) {
                isObject = false;
                data = cd2.getDeserializedForReading();
            } else {
                data = cd2.getValue();
            }
        } else if (data == Token.REMOVED_PHASE1 || data == Token.REMOVED_PHASE2 || data == Token.TOMBSTONE || data == Token.DESTROYED) {
            data = null;
        } else if (data == Token.INVALID || data == Token.LOCAL_INVALID) {
            data = null;
        } else if (data instanceof byte[]) {
            isObject = false;
        }
        result[0] = data;
        result[1] = isObject;
        result[2] = data == null;
    }
}

