/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.InterestResultPolicy;
import org.apache.geode.cache.operations.RegisterInterestOperationContext;
import org.apache.geode.i18n.StringId;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.security.AuthorizeRequest;

public class RegisterInterestList61
extends BaseCommand {
    private static final RegisterInterestList61 singleton = new RegisterInterestList61();

    public static Command getCommand() {
        return singleton;
    }

    RegisterInterestList61() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, InterruptedException {
        byte[] regionDataPolicyPartBytes;
        InterestResultPolicy policy;
        Part regionNamePart = null;
        Part keyPart = null;
        Part numberOfKeysPart = null;
        String regionName = null;
        Object key = null;
        List<Object> keys = null;
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        int numberOfKeys = 0;
        int partNumber = 0;
        servConn.setAsTrue(2);
        servConn.setAsTrue(3);
        ChunkedMessage chunkedResponseMsg = servConn.getRegisterInterestResponseMessage();
        regionNamePart = msg.getPart(0);
        regionName = regionNamePart.getString();
        try {
            policy = (InterestResultPolicy)msg.getPart(1).getObject();
        }
        catch (Exception e) {
            RegisterInterestList61.writeChunkedException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        boolean isDurable = false;
        try {
            Part durablePart = msg.getPart(2);
            byte[] durablePartBytes = (byte[])durablePart.getObject();
            isDurable = durablePartBytes[0] == 1;
        }
        catch (Exception e) {
            RegisterInterestList61.writeChunkedException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        try {
            Part regionDataPolicyPart = msg.getPart(msg.getNumberOfParts() - 1);
            regionDataPolicyPartBytes = (byte[])regionDataPolicyPart.getObject();
        }
        catch (Exception e) {
            RegisterInterestList61.writeChunkedException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        numberOfKeysPart = msg.getPart(3);
        numberOfKeys = numberOfKeysPart.getInt();
        partNumber = 4;
        keys = new ArrayList<Object>();
        for (int i = 0; i < numberOfKeys; ++i) {
            keyPart = msg.getPart(partNumber + i);
            try {
                key = keyPart.getStringOrObject();
            }
            catch (Exception e) {
                RegisterInterestList61.writeChunkedException(msg, e, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
            keys.add(key);
        }
        boolean sendUpdatesAsInvalidates = false;
        if (msg.getNumberOfParts() > numberOfKeys + partNumber) {
            try {
                Part notifyPart = msg.getPart(numberOfKeys + partNumber);
                byte[] notifyPartBytes = (byte[])notifyPart.getObject();
                sendUpdatesAsInvalidates = notifyPartBytes[0] == 1;
            }
            catch (Exception e) {
                RegisterInterestList61.writeChunkedException(msg, e, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received register interest 61 request ({} bytes) from {} for the following {} keys in region {}: {}", (Object)servConn.getName(), (Object)msg.getPayloadLength(), (Object)servConn.getSocketString(), (Object)numberOfKeys, (Object)regionName, (Object)keys);
        }
        if (keys.isEmpty() || regionName == null) {
            StringId errMessage = null;
            if (keys.isEmpty() && regionName == null) {
                errMessage = LocalizedStrings.RegisterInterestList_THE_INPUT_LIST_OF_KEYS_IS_EMPTY_AND_THE_INPUT_REGION_NAME_IS_NULL_FOR_THE_REGISTER_INTEREST_REQUEST;
            } else if (keys.isEmpty()) {
                errMessage = LocalizedStrings.RegisterInterestList_THE_INPUT_LIST_OF_KEYS_FOR_THE_REGISTER_INTEREST_REQUEST_IS_EMPTY;
            } else if (regionName == null) {
                errMessage = LocalizedStrings.RegisterInterest_THE_INPUT_REGION_NAME_FOR_THE_REGISTER_INTEREST_REQUEST_IS_NULL;
            }
            String s = errMessage.toLocalizedString();
            logger.warn("{}: {}", (Object)servConn.getName(), (Object)s);
            RegisterInterestList61.writeChunkedErrorResponse(msg, 21, s, servConn);
            servConn.setAsTrue(1);
            return;
        }
        LocalRegion region = (LocalRegion)servConn.getCache().getRegion(regionName);
        if (region == null) {
            logger.info(LocalizedMessage.create(LocalizedStrings.RegisterInterestList_0_REGION_NAMED_1_WAS_NOT_FOUND_DURING_REGISTER_INTEREST_LIST_REQUEST, new Object[]{servConn.getName(), regionName}));
        }
        try {
            this.securityService.authorizeRegionRead(regionName);
            AuthorizeRequest authzRequest = servConn.getAuthzRequest();
            if (authzRequest != null && !DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                RegisterInterestOperationContext registerContext = authzRequest.registerInterestListAuthorize(regionName, keys, policy);
                keys = (List)registerContext.getKey();
            }
            servConn.getAcceptor().getCacheClientNotifier().registerClientInterest(regionName, keys, servConn.getProxyID(), isDurable, sendUpdatesAsInvalidates, true, regionDataPolicyPartBytes[0], true);
        }
        catch (Exception ex) {
            RegisterInterestList61.checkForInterrupt(servConn, ex);
            RegisterInterestList61.writeChunkedException(msg, ex, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        boolean isPrimary = servConn.getAcceptor().getCacheClientNotifier().getClientProxy(servConn.getProxyID()).isPrimary();
        if (!isPrimary) {
            chunkedResponseMsg.setMessageType(33);
            chunkedResponseMsg.setTransactionId(msg.getTransactionId());
            chunkedResponseMsg.sendHeader();
            chunkedResponseMsg.setLastChunk(true);
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending register interest response chunk from secondary for region: {} for key: {} chunk=<{}>", (Object)servConn.getName(), (Object)regionName, key, (Object)chunkedResponseMsg);
            }
            chunkedResponseMsg.sendChunk(servConn);
        } else {
            chunkedResponseMsg.setMessageType(32);
            chunkedResponseMsg.setTransactionId(msg.getTransactionId());
            chunkedResponseMsg.sendHeader();
            try {
                RegisterInterestList61.fillAndSendRegisterInterestResponseChunks(region, keys, 0, policy, servConn);
                servConn.setAsTrue(1);
            }
            catch (Exception e) {
                RegisterInterestList61.checkForInterrupt(servConn, e);
                RegisterInterestList61.writeChunkedException(msg, e, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sent register interest response for the following {} keys in region {}: {}", (Object)servConn.getName(), (Object)numberOfKeys, (Object)regionName, (Object)keys);
            }
        }
    }
}

