/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.operations.QueryOperationContext;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.QueryInvalidException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.types.CollectionTypeImpl;
import org.apache.geode.cache.query.types.CollectionType;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommandQuery;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.AuthorizeRequest;

public class Query651
extends BaseCommandQuery {
    private static final Query651 singleton = new Query651();

    public static Command getCommand() {
        return singleton;
    }

    protected Query651() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, InterruptedException {
        servConn.setAsTrue(2);
        servConn.setAsTrue(3);
        String queryString = msg.getPart(0).getString();
        long compiledQueryId = 0L;
        Object[] queryParams = null;
        try {
            if (msg.getMessageType() == 80) {
                int params = msg.getPart(1).getInt();
                int paramStartIndex = 2;
                if (msg.getNumberOfParts() > 3 + params) {
                    int timeout = msg.getPart(3).getInt();
                    servConn.setRequestSpecificTimeout(timeout);
                    paramStartIndex = 4;
                }
                queryParams = new Object[params];
                for (int i = 0; i < queryParams.length; ++i) {
                    queryParams[i] = msg.getPart(i + paramStartIndex).getObject();
                }
            } else if (msg.getNumberOfParts() == 3) {
                int timeout = msg.getPart(2).getInt();
                servConn.setRequestSpecificTimeout(timeout);
            }
        }
        catch (ClassNotFoundException cne) {
            throw new QueryInvalidException(cne.getMessage() + queryString);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received query request from {} queryString: {}{}", (Object)servConn.getName(), (Object)servConn.getSocketString(), (Object)queryString, (Object)(queryParams != null ? " with num query parameters :" + queryParams.length : ""));
        }
        try {
            QueryService queryService = ((GemFireCacheImpl)servConn.getCachedRegionHelper().getCache()).getLocalQueryService();
            Query query = null;
            if (queryParams != null) {
                CacheClientNotifier ccn = servConn.getAcceptor().getCacheClientNotifier();
                query = ccn.getCompiledQuery(queryString);
                if (query == null) {
                    query = queryService.newQuery(queryString);
                    ccn.addCompiledQuery((DefaultQuery)query);
                }
                ccn.getStats().incCompiledQueryUsedCount(1L);
                ((DefaultQuery)query).setLastUsed(true);
            } else {
                query = queryService.newQuery(queryString);
            }
            Set regionNames = ((DefaultQuery)query).getRegionsInQuery(queryParams);
            QueryOperationContext queryContext = null;
            AuthorizeRequest authzRequest = servConn.getAuthzRequest();
            if (authzRequest != null) {
                queryContext = authzRequest.queryAuthorize(queryString, regionNames, queryParams);
                String newQueryString = queryContext.getQuery();
                if (queryString != null && !queryString.equals(newQueryString)) {
                    query = queryService.newQuery(newQueryString);
                    queryString = newQueryString;
                    regionNames = queryContext.getRegionNames();
                    if (regionNames == null) {
                        regionNames = ((DefaultQuery)query).getRegionsInQuery(null);
                    }
                }
            }
            this.processQueryUsingParams(msg, query, queryString, regionNames, start, null, queryContext, servConn, true, queryParams);
        }
        catch (QueryInvalidException e) {
            throw new QueryInvalidException(e.getMessage() + queryString);
        }
    }

    @Override
    protected CollectionType getCollectionType(SelectResults selectResults) {
        return new CollectionTypeImpl(List.class, selectResults.getCollectionType().getElementType());
    }
}

