/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.ResourceException;
import org.apache.geode.cache.operations.PutAllOperationContext;
import org.apache.geode.cache.operations.internal.UpdateOnlyMap;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.CachedDeserializableFactory;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PutAllPartialResultException;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.ha.ThreadIdentifier;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.security.AuthorizeRequest;

public class PutAll70
extends BaseCommand {
    private static final PutAll70 singleton = new PutAll70();

    public static Command getCommand() {
        return singleton;
    }

    private PutAll70() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long startp) throws IOException, InterruptedException {
        long start = startp;
        Part regionNamePart = null;
        Part numberOfKeysPart = null;
        Part keyPart = null;
        Part valuePart = null;
        String regionName = null;
        int numberOfKeys = 0;
        Object key = null;
        Part eventPart = null;
        boolean replyWithMetaData = false;
        VersionedObjectList response = null;
        StringBuffer errMessage = new StringBuffer();
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        CacheServerStats stats = servConn.getCacheServerStats();
        servConn.setAsTrue(2);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadPutAllRequestTime(start - oldStart);
        try {
            PartitionedRegion pr;
            regionNamePart = msg.getPart(0);
            regionName = regionNamePart.getString();
            if (regionName == null) {
                String putAllMsg = LocalizedStrings.PutAll_THE_INPUT_REGION_NAME_FOR_THE_PUTALL_REQUEST_IS_NULL.toLocalizedString();
                logger.warn("{}: {}", (Object)servConn.getName(), (Object)putAllMsg);
                errMessage.append(putAllMsg);
                PutAll70.writeErrorResponse(msg, 8, errMessage.toString(), servConn);
                servConn.setAsTrue(1);
                return;
            }
            LocalRegion region = (LocalRegion)crHelper.getRegion(regionName);
            if (region == null) {
                String reason = " was not found during put request";
                PutAll70.writeRegionDestroyedEx(msg, regionName, reason, servConn);
                servConn.setAsTrue(1);
                return;
            }
            eventPart = msg.getPart(1);
            ByteBuffer eventIdPartsBuffer = ByteBuffer.wrap(eventPart.getSerializedForm());
            long threadId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
            long sequenceId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
            EventID eventId = new EventID(servConn.getEventMemberIDByteArray(), threadId, sequenceId);
            Part callbacksPart = msg.getPart(2);
            boolean skipCallbacks = callbacksPart.getInt() == 1;
            numberOfKeysPart = msg.getPart(3);
            numberOfKeys = numberOfKeysPart.getInt();
            Map map = new LinkedHashMap();
            LinkedHashMap<Object, VersionTag> retryVersions = new LinkedHashMap<Object, VersionTag>();
            for (int i = 0; i < numberOfKeys; ++i) {
                String putAllMsg;
                keyPart = msg.getPart(4 + i * 2);
                key = keyPart.getStringOrObject();
                if (key == null) {
                    putAllMsg = LocalizedStrings.PutAll_ONE_OF_THE_INPUT_KEYS_FOR_THE_PUTALL_REQUEST_IS_NULL.toLocalizedString();
                    logger.warn("{}: {}", (Object)servConn.getName(), (Object)putAllMsg);
                    errMessage.append(putAllMsg);
                    PutAll70.writeErrorResponse(msg, 8, errMessage.toString(), servConn);
                    servConn.setAsTrue(1);
                    return;
                }
                valuePart = msg.getPart(4 + i * 2 + 1);
                if (valuePart.isNull()) {
                    putAllMsg = LocalizedStrings.PutAll_ONE_OF_THE_INPUT_VALUES_FOR_THE_PUTALL_REQUEST_IS_NULL.toLocalizedString();
                    logger.warn("{}: {}", (Object)servConn.getName(), (Object)putAllMsg);
                    errMessage.append(putAllMsg);
                    PutAll70.writeErrorResponse(msg, 8, errMessage.toString(), servConn);
                    servConn.setAsTrue(1);
                    return;
                }
                Object value = valuePart.isObject() ? (skipCallbacks && Token.INVALID.isSerializedValue(valuePart.getSerializedForm()) ? (Object)Token.INVALID : (Object)CachedDeserializableFactory.create(valuePart.getSerializedForm())) : valuePart.getSerializedForm();
                if (msg.isRetry()) {
                    VersionTag tag;
                    EventID entryEventId = new EventID(eventId, i);
                    if (region instanceof PartitionedRegion) {
                        PartitionedRegion pr2 = (PartitionedRegion)region;
                        int bucketId = pr2.getKeyInfo(key).getBucketId();
                        long entryThreadId = ThreadIdentifier.createFakeThreadIDForBulkOp(bucketId, entryEventId.getThreadID());
                        entryEventId = new EventID(entryEventId.getMembershipID(), entryThreadId, entryEventId.getSequenceID());
                    }
                    if ((tag = this.findVersionTagsForRetriedBulkOp(region, entryEventId)) != null) {
                        retryVersions.put(key, tag);
                    }
                }
                map.put(key, value);
            }
            if (msg.getNumberOfParts() == 4 + 2 * numberOfKeys + 1) {
                int timeout = msg.getPart(4 + 2 * numberOfKeys).getInt();
                servConn.setRequestSpecificTimeout(timeout);
            }
            this.securityService.authorizeRegionWrite(regionName);
            AuthorizeRequest authzRequest = servConn.getAuthzRequest();
            if (authzRequest != null) {
                if (DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                    authzRequest.createRegionAuthorize(regionName);
                } else {
                    PutAllOperationContext putAllContext = authzRequest.putAllAuthorize(regionName, map, null);
                    if ((map = putAllContext.getMap()) instanceof UpdateOnlyMap) {
                        map = ((UpdateOnlyMap)map).getInternalMap();
                    }
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Received putAll request ({} bytes) from {} for region {}", (Object)servConn.getName(), (Object)msg.getPayloadLength(), (Object)servConn.getSocketString(), (Object)regionName);
            }
            response = region.basicBridgePutAll(map, retryVersions, servConn.getProxyID(), eventId, skipCallbacks, null);
            if (!region.getConcurrencyChecksEnabled()) {
                response = null;
            }
            if (region instanceof PartitionedRegion && (pr = (PartitionedRegion)region).getNetworkHopType() != 0) {
                this.writeReplyWithRefreshMetadata(msg, response, servConn, pr, pr.getNetworkHopType());
                pr.clearNetworkHopData();
                replyWithMetaData = true;
            }
        }
        catch (RegionDestroyedException rde) {
            PutAll70.writeException(msg, rde, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        catch (ResourceException re) {
            PutAll70.writeException(msg, re, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        catch (PutAllPartialResultException pre) {
            PutAll70.writeException(msg, pre, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        catch (Exception ce) {
            PutAll70.checkForInterrupt(servConn, ce);
            PutAll70.writeException(msg, ce, false, servConn);
            servConn.setAsTrue(1);
            logger.warn(LocalizedMessage.create(LocalizedStrings.Generic_0_UNEXPECTED_EXCEPTION, servConn.getName()), (Throwable)ce);
            return;
        }
        finally {
            long oldStart2 = start;
            start = DistributionStats.getStatTime();
            stats.incProcessPutAllTime(start - oldStart2);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sending putAll70 response back to {} for region {}: {}", (Object)servConn.getName(), (Object)servConn.getSocketString(), (Object)regionName, (Object)response);
        }
        if (response != null && Version.GFE_70.compareTo(servConn.getClientVersion()) < 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("setting putAll keys to null");
            }
            response.setKeys(null);
        }
        if (!replyWithMetaData) {
            this.writeReply(msg, response, servConn);
        }
        servConn.setAsTrue(1);
        stats.incWritePutAllResponseTime(DistributionStats.getStatTime() - start);
    }

    @Override
    protected void writeReply(Message origMsg, ServerConnection servConn) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected void writeReply(Message origMsg, VersionedObjectList response, ServerConnection servConn) throws IOException {
        Message replyMsg = servConn.getReplyMessage();
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        replyMsg.setMessageType(6);
        replyMsg.setNumberOfParts(2);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addBytesPart(OK_BYTES);
        if (response != null) {
            response.clearObjects();
            replyMsg.addObjPart(response);
        }
        replyMsg.send(servConn);
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl tx: {}", (Object)servConn.getName(), (Object)origMsg.getTransactionId());
        }
    }

    @Override
    protected void writeReplyWithRefreshMetadata(Message origMsg, ServerConnection servConn, PartitionedRegion pr, byte nwHop) throws IOException {
        throw new UnsupportedOperationException();
    }

    private void writeReplyWithRefreshMetadata(Message origMsg, VersionedObjectList response, ServerConnection servConn, PartitionedRegion pr, byte nwHop) throws IOException {
        Message replyMsg = servConn.getReplyMessage();
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        replyMsg.setMessageType(6);
        replyMsg.setNumberOfParts(2);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addBytesPart(new byte[]{pr.getMetadataVersion(), nwHop});
        if (response != null) {
            response.clearObjects();
            replyMsg.addObjPart(response);
        }
        replyMsg.send(servConn);
        pr.getPrStats().incPRMetaDataSentCount();
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl with REFRESH_METADAT tx: {}", (Object)servConn.getName(), (Object)origMsg.getTransactionId());
        }
    }
}

