/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.ResourceException;
import org.apache.geode.cache.operations.PutAllOperationContext;
import org.apache.geode.cache.operations.internal.UpdateOnlyMap;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.CachedDeserializableFactory;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PutAllPartialResultException;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.security.AuthorizeRequest;

public class PutAll
extends BaseCommand {
    private static final PutAll singleton = new PutAll();

    public static Command getCommand() {
        return singleton;
    }

    private PutAll() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, InterruptedException {
        Part regionNamePart = null;
        Part numberOfKeysPart = null;
        Part keyPart = null;
        Part valuePart = null;
        String regionName = null;
        int numberOfKeys = 0;
        Object key = null;
        Part eventPart = null;
        StringBuffer errMessage = new StringBuffer();
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        CacheServerStats stats = servConn.getCacheServerStats();
        boolean replyWithMetaData = false;
        servConn.setAsTrue(2);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadPutAllRequestTime(start - oldStart);
        try {
            PartitionedRegion pr;
            regionNamePart = msg.getPart(0);
            regionName = regionNamePart.getString();
            if (regionName == null) {
                String putAllMsg = LocalizedStrings.PutAll_THE_INPUT_REGION_NAME_FOR_THE_PUTALL_REQUEST_IS_NULL.toLocalizedString();
                logger.warn("{}: {}", (Object)servConn.getName(), (Object)putAllMsg);
                errMessage.append(putAllMsg);
                PutAll.writeErrorResponse(msg, 8, errMessage.toString(), servConn);
                servConn.setAsTrue(1);
                return;
            }
            LocalRegion region = (LocalRegion)crHelper.getRegion(regionName);
            if (region == null) {
                String reason = " was not found during put request";
                PutAll.writeRegionDestroyedEx(msg, regionName, reason, servConn);
                servConn.setAsTrue(1);
                return;
            }
            eventPart = msg.getPart(1);
            ByteBuffer eventIdPartsBuffer = ByteBuffer.wrap(eventPart.getSerializedForm());
            long threadId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
            long sequenceId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
            EventID eventId = new EventID(servConn.getEventMemberIDByteArray(), threadId, sequenceId);
            numberOfKeysPart = msg.getPart(2);
            numberOfKeys = numberOfKeysPart.getInt();
            Map<Object, byte[]> map = new LinkedHashMap();
            for (int i = 0; i < numberOfKeys; ++i) {
                String putAllMsg;
                keyPart = msg.getPart(3 + i * 2);
                key = keyPart.getStringOrObject();
                if (key == null) {
                    putAllMsg = LocalizedStrings.PutAll_ONE_OF_THE_INPUT_KEYS_FOR_THE_PUTALL_REQUEST_IS_NULL.toLocalizedString();
                    logger.warn("{}: {}", (Object)servConn.getName(), (Object)putAllMsg);
                    errMessage.append(putAllMsg);
                    PutAll.writeErrorResponse(msg, 8, errMessage.toString(), servConn);
                    servConn.setAsTrue(1);
                    return;
                }
                valuePart = msg.getPart(3 + i * 2 + 1);
                if (valuePart.isNull()) {
                    putAllMsg = LocalizedStrings.PutAll_ONE_OF_THE_INPUT_VALUES_FOR_THE_PUTALL_REQUEST_IS_NULL.toLocalizedString();
                    logger.warn("{}: {}", (Object)servConn.getName(), (Object)putAllMsg);
                    errMessage.append(putAllMsg);
                    PutAll.writeErrorResponse(msg, 8, errMessage.toString(), servConn);
                    servConn.setAsTrue(1);
                    return;
                }
                Object value = valuePart.isObject() ? (Object)CachedDeserializableFactory.create(valuePart.getSerializedForm()) : valuePart.getSerializedForm();
                map.put(key, (byte[])value);
            }
            if (msg.getNumberOfParts() == 3 + 2 * numberOfKeys + 1) {
                int timeout = msg.getPart(3 + 2 * numberOfKeys).getInt();
                servConn.setRequestSpecificTimeout(timeout);
            }
            this.securityService.authorizeRegionWrite(regionName);
            AuthorizeRequest authzRequest = servConn.getAuthzRequest();
            if (authzRequest != null) {
                if (DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                    authzRequest.createRegionAuthorize(regionName);
                } else {
                    PutAllOperationContext putAllContext = authzRequest.putAllAuthorize(regionName, map, null);
                    if ((map = putAllContext.getMap()) instanceof UpdateOnlyMap) {
                        map = ((UpdateOnlyMap)map).getInternalMap();
                    }
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Received putAll request ({} bytes) from {} for region {}", (Object)servConn.getName(), (Object)msg.getPayloadLength(), (Object)servConn.getSocketString(), (Object)regionName);
            }
            region.basicBridgePutAll(map, Collections.emptyMap(), servConn.getProxyID(), eventId, false, null);
            if (region instanceof PartitionedRegion && (pr = (PartitionedRegion)region).getNetworkHopType() != 0) {
                this.writeReplyWithRefreshMetadata(msg, servConn, pr, pr.getNetworkHopType());
                pr.clearNetworkHopData();
                replyWithMetaData = true;
            }
        }
        catch (RegionDestroyedException rde) {
            PutAll.writeException(msg, rde, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        catch (ResourceException re) {
            PutAll.writeException(msg, re, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        catch (PutAllPartialResultException pre) {
            PutAll.writeException(msg, pre, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        catch (Exception ce) {
            PutAll.checkForInterrupt(servConn, ce);
            PutAll.writeException(msg, ce, false, servConn);
            servConn.setAsTrue(1);
            logger.warn(LocalizedMessage.create(LocalizedStrings.Generic_0_UNEXPECTED_EXCEPTION, servConn.getName()), (Throwable)ce);
            return;
        }
        finally {
            long oldStart2 = start;
            start = DistributionStats.getStatTime();
            stats.incProcessPutAllTime(start - oldStart2);
        }
        if (!replyWithMetaData) {
            this.writeReply(msg, servConn);
        }
        servConn.setAsTrue(1);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sent putAll response back to {} for region {}", (Object)servConn.getName(), (Object)servConn.getSocketString(), (Object)regionName);
        }
        stats.incWritePutAllResponseTime(DistributionStats.getStatTime() - start);
    }
}

