/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;

public class PeriodicAck
extends BaseCommand {
    private static final PeriodicAck singleton = new PeriodicAck();

    public static Command getCommand() {
        return singleton;
    }

    private PeriodicAck() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, ClassNotFoundException {
        servConn.setAsTrue(2);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received periodic ack request ({} bytes) from {}", (Object)servConn.getName(), (Object)msg.getPayloadLength(), (Object)servConn.getSocketString());
        }
        try {
            int numEvents = msg.getNumberOfParts();
            boolean success = false;
            CacheClientNotifier ccn = servConn.getAcceptor().getCacheClientNotifier();
            CacheClientProxy proxy = ccn.getClientProxy(servConn.getProxyID());
            if (proxy != null) {
                proxy.getHARegionQueue().createAckedEventsMap();
                for (int i = 0; i < numEvents; ++i) {
                    Part eventIdPart = msg.getPart(i);
                    eventIdPart.setVersion(servConn.getClientVersion());
                    EventID eid = (EventID)eventIdPart.getObject();
                    success = ccn.processDispatchedMessage(servConn.getProxyID(), eid);
                    if (!success) break;
                }
            }
            if (success) {
                proxy.getHARegionQueue().setAckedEvents();
                this.writeReply(msg, servConn);
                servConn.setAsTrue(1);
            }
        }
        catch (Exception e) {
            PeriodicAck.writeException(msg, e, false, servConn);
            servConn.setAsTrue(1);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sent periodic ack response for {}", (Object)servConn.getName(), (Object)servConn.getSocketString());
        }
    }
}

