/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.pdx.internal.PdxType;
import org.apache.geode.pdx.internal.TypeRegistry;

public class GetPDXTypeById
extends BaseCommand {
    private static final GetPDXTypeById singleton = new GetPDXTypeById();

    public static Command getCommand() {
        return singleton;
    }

    private GetPDXTypeById() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, ClassNotFoundException {
        PdxType type;
        servConn.setAsTrue(2);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received get pdx type by id request ({} parts) from {}", (Object)servConn.getName(), (Object)msg.getNumberOfParts(), (Object)servConn.getSocketString());
        }
        int pdxId = msg.getPart(0).getInt();
        try {
            GemFireCacheImpl cache = (GemFireCacheImpl)servConn.getCache();
            TypeRegistry registry = cache.getPdxRegistry();
            type = registry.getType(pdxId);
        }
        catch (Exception e) {
            GetPDXTypeById.writeException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        Message responseMsg = servConn.getResponseMessage();
        responseMsg.setMessageType(1);
        responseMsg.setNumberOfParts(1);
        responseMsg.setTransactionId(msg.getTransactionId());
        responseMsg.addObjPart(type);
        responseMsg.send(servConn);
        servConn.setAsTrue(1);
    }
}

