/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.operations.DestroyOperationContext;
import org.apache.geode.cache.operations.RegionDestroyOperationContext;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.EventIDHolder;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.util.Breadcrumbs;
import org.apache.geode.security.GemFireSecurityException;

public class Destroy65
extends BaseCommand {
    private static final Destroy65 singleton = new Destroy65();

    public static Command getCommand() {
        return singleton;
    }

    @Override
    protected void writeReplyWithRefreshMetadata(Message origMsg, ServerConnection servConn, PartitionedRegion pr, byte nwHop) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected void writeReplyWithRefreshMetadata(Message origMsg, ServerConnection servConn, PartitionedRegion pr, boolean entryNotFoundForRemove, byte nwHop, VersionTag tag) throws IOException {
        Message replyMsg = servConn.getReplyMessage();
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        replyMsg.setMessageType(6);
        replyMsg.setNumberOfParts(2);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addBytesPart(new byte[]{pr.getMetadataVersion(), nwHop});
        pr.getPrStats().incPRMetaDataSentCount();
        replyMsg.addIntPart(entryNotFoundForRemove ? 1 : 0);
        replyMsg.send(servConn);
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl with REFRESH_METADAT tx: {}", (Object)servConn.getName(), (Object)origMsg.getTransactionId());
        }
    }

    protected void writeReply(Message origMsg, ServerConnection servConn, boolean entryNotFound, VersionTag tag) throws IOException {
        Message replyMsg = servConn.getReplyMessage();
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        replyMsg.setMessageType(6);
        replyMsg.setNumberOfParts(2);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addBytesPart(OK_BYTES);
        replyMsg.addIntPart(entryNotFound ? 1 : 0);
        replyMsg.send(servConn);
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl tx: {} parts={}", (Object)servConn.getName(), (Object)origMsg.getTransactionId(), (Object)replyMsg.getNumberOfParts());
        }
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, InterruptedException {
        Object operation = null;
        Object expectedOldValue = null;
        String regionName = null;
        Object callbackArg = null;
        Object key = null;
        StringBuffer errMessage = new StringBuffer();
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        CacheServerStats stats = servConn.getCacheServerStats();
        servConn.setAsTrue(2);
        long now = DistributionStats.getStatTime();
        stats.incReadDestroyRequestTime(now - start);
        Part regionNamePart = msg.getPart(0);
        Part keyPart = msg.getPart(1);
        Part expectedOldValuePart = msg.getPart(2);
        try {
            operation = msg.getPart(3).getObject();
            if (operation instanceof Operation && (Operation)operation == Operation.REMOVE || operation instanceof Byte && (Byte)operation == 8) {
                expectedOldValue = expectedOldValuePart.getObject();
            }
        }
        catch (Exception e) {
            Destroy65.writeException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        Part eventPart = msg.getPart(4);
        if (msg.getNumberOfParts() > 5) {
            Part callbackArgPart = msg.getPart(5);
            try {
                callbackArg = callbackArgPart.getObject();
            }
            catch (Exception e) {
                Destroy65.writeException(msg, e, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
        }
        regionName = regionNamePart.getString();
        try {
            key = keyPart.getStringOrObject();
        }
        catch (Exception e) {
            Destroy65.writeException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received destroy65 request ({} bytes; op={}) from {} for region {} key {}{} txId {}", (Object)servConn.getName(), (Object)msg.getPayloadLength(), operation, (Object)servConn.getSocketString(), (Object)regionName, key, (Object)(operation == Operation.REMOVE ? " value=" + expectedOldValue : ""), (Object)msg.getTransactionId());
        }
        boolean entryNotFoundForRemove = false;
        if (key == null || regionName == null) {
            if (key == null) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.Destroy_0_THE_INPUT_KEY_FOR_THE_DESTROY_REQUEST_IS_NULL, servConn.getName()));
                errMessage.append(LocalizedStrings.Destroy__THE_INPUT_KEY_FOR_THE_DESTROY_REQUEST_IS_NULL.toLocalizedString());
            }
            if (regionName == null) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.Destroy_0_THE_INPUT_REGION_NAME_FOR_THE_DESTROY_REQUEST_IS_NULL, servConn.getName()));
                errMessage.append(LocalizedStrings.Destroy__THE_INPUT_REGION_NAME_FOR_THE_DESTROY_REQUEST_IS_NULL.toLocalizedString());
            }
            Destroy65.writeErrorResponse(msg, 10, errMessage.toString(), servConn);
            servConn.setAsTrue(1);
            return;
        }
        LocalRegion region = (LocalRegion)servConn.getCache().getRegion(regionName);
        if (region == null) {
            String reason = LocalizedStrings.Destroy__0_WAS_NOT_FOUND_DURING_DESTROY_REQUEST.toLocalizedString(regionName);
            Destroy65.writeRegionDestroyedEx(msg, regionName, reason, servConn);
            servConn.setAsTrue(1);
            return;
        }
        ByteBuffer eventIdPartsBuffer = ByteBuffer.wrap(eventPart.getSerializedForm());
        long threadId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
        long sequenceId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
        EventID eventId = new EventID(servConn.getEventMemberIDByteArray(), threadId, sequenceId);
        EventIDHolder clientEvent = new EventIDHolder(eventId);
        Breadcrumbs.setEventId(eventId);
        if (msg.isRetry()) {
            clientEvent.setPossibleDuplicate(true);
            if (region.getAttributes().getConcurrencyChecksEnabled()) {
                clientEvent.setRegion(region);
                if (!this.recoverVersionTagForRetriedOperation(clientEvent)) {
                    clientEvent.setPossibleDuplicate(false);
                }
            }
        }
        try {
            this.securityService.authorizeRegionWrite(regionName, key.toString());
            AuthorizeRequest authzRequest = servConn.getAuthzRequest();
            if (authzRequest != null) {
                if (DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                    RegionDestroyOperationContext destroyContext = authzRequest.destroyRegionAuthorize((String)key, callbackArg);
                    callbackArg = destroyContext.getCallbackArg();
                } else {
                    DestroyOperationContext destroyContext = authzRequest.destroyAuthorize(regionName, key, callbackArg);
                    callbackArg = destroyContext.getCallbackArg();
                }
            }
            if (operation == null || operation == Operation.DESTROY) {
                region.basicBridgeDestroy(key, callbackArg, servConn.getProxyID(), true, clientEvent);
            } else {
                try {
                    if (expectedOldValue == null) {
                        expectedOldValue = Token.INVALID;
                    }
                    if (operation == Operation.REMOVE && msg.isRetry() && clientEvent.getVersionTag() != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("remove(k,v) operation was successful last time with version {}", (Object)clientEvent.getVersionTag());
                        }
                        try {
                            region.basicBridgeRemove(key, expectedOldValue, callbackArg, servConn.getProxyID(), true, clientEvent);
                        }
                        catch (EntryNotFoundException destroyContext) {}
                    } else {
                        region.basicBridgeRemove(key, expectedOldValue, callbackArg, servConn.getProxyID(), true, clientEvent);
                        if (logger.isDebugEnabled()) {
                            logger.debug("region.remove succeeded");
                        }
                    }
                }
                catch (EntryNotFoundException e) {
                    servConn.setModificationInfo(true, regionName, key);
                    if (logger.isDebugEnabled()) {
                        logger.debug("writing entryNotFound response");
                    }
                    entryNotFoundForRemove = true;
                }
            }
            servConn.setModificationInfo(true, regionName, key);
        }
        catch (EntryNotFoundException e) {
            logger.info(LocalizedMessage.create(LocalizedStrings.Destroy_0_DURING_ENTRY_DESTROY_NO_ENTRY_WAS_FOUND_FOR_KEY_1, new Object[]{servConn.getName(), key}));
            entryNotFoundForRemove = true;
        }
        catch (RegionDestroyedException rde) {
            Destroy65.writeException(msg, rde, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        catch (Exception e) {
            Destroy65.checkForInterrupt(servConn, e);
            Destroy65.writeException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            if (e instanceof GemFireSecurityException) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Unexpected Security exception", (Object)servConn.getName(), (Object)e);
                }
            } else {
                logger.warn(LocalizedMessage.create(LocalizedStrings.Destroy_0_UNEXPECTED_EXCEPTION, servConn.getName()), (Throwable)e);
            }
            return;
        }
        now = DistributionStats.getStatTime();
        stats.incProcessDestroyTime(now - start);
        if (region instanceof PartitionedRegion) {
            PartitionedRegion pr = (PartitionedRegion)region;
            if (pr.getNetworkHopType() != 0) {
                this.writeReplyWithRefreshMetadata(msg, servConn, pr, entryNotFoundForRemove, pr.getNetworkHopType(), clientEvent.getVersionTag());
                pr.clearNetworkHopData();
            } else {
                this.writeReply(msg, servConn, entryNotFoundForRemove | clientEvent.getIsRedestroyedEntry(), clientEvent.getVersionTag());
            }
        } else {
            this.writeReply(msg, servConn, entryNotFoundForRemove | clientEvent.getIsRedestroyedEntry(), clientEvent.getVersionTag());
        }
        servConn.setAsTrue(1);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sent destroy response for region {} key {}", (Object)servConn.getName(), (Object)regionName, key);
        }
        stats.incWriteDestroyResponseTime(DistributionStats.getStatTime() - start);
    }
}

