/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.TXCommitMessage;
import org.apache.geode.internal.cache.TXId;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;

public class CommitCommand
extends BaseCommand {
    private static final CommitCommand singleton = new CommitCommand();

    public static Command getCommand() {
        return singleton;
    }

    private CommitCommand() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException {
        servConn.setAsTrue(2);
        TXManagerImpl txMgr = (TXManagerImpl)servConn.getCache().getCacheTransactionManager();
        InternalDistributedMember client = (InternalDistributedMember)servConn.getProxyID().getDistributedMember();
        int uniqId = msg.getTransactionId();
        TXId txId = new TXId(client, uniqId);
        TXCommitMessage commitMsg = null;
        if (txMgr.isHostedTxRecentlyCompleted(txId)) {
            commitMsg = txMgr.getRecentlyCompletedMessage(txId);
            if (logger.isDebugEnabled()) {
                logger.debug("TX: returning a recently committed txMessage for tx: {}", (Object)txId);
            }
            if (!txMgr.isExceptionToken(commitMsg)) {
                CommitCommand.writeCommitResponse(commitMsg, msg, servConn);
                commitMsg.setClientVersion(null);
                servConn.setAsTrue(1);
            } else {
                this.sendException(msg, servConn, txMgr.getExceptionForToken(commitMsg, txId));
            }
            txMgr.removeHostedTXState(txId);
            return;
        }
        boolean wasInProgress = txMgr.setInProgress(true);
        TXStateProxy txProxy = txMgr.getTXState();
        Assert.assertTrue(txProxy != null);
        if (logger.isDebugEnabled()) {
            logger.debug("TX: committing client tx: {}", (Object)txId);
        }
        try {
            txId = txProxy.getTxId();
            txProxy.setCommitOnBehalfOfRemoteStub(true);
            txMgr.commit();
            commitMsg = txProxy.getCommitMessage();
            CommitCommand.writeCommitResponse(commitMsg, msg, servConn);
            servConn.setAsTrue(1);
        }
        catch (Exception e) {
            this.sendException(msg, servConn, e);
        }
        finally {
            if (txId != null) {
                txMgr.removeHostedTXState(txId);
            }
            if (!wasInProgress) {
                txMgr.setInProgress(false);
            }
            if (commitMsg != null) {
                commitMsg.setClientVersion(null);
            }
        }
    }

    protected static void writeCommitResponse(TXCommitMessage response, Message origMsg, ServerConnection servConn) throws IOException {
        Message responseMsg = servConn.getResponseMessage();
        responseMsg.setMessageType(1);
        responseMsg.setTransactionId(origMsg.getTransactionId());
        responseMsg.setNumberOfParts(1);
        if (response != null) {
            response.setClientVersion(servConn.getClientVersion());
        }
        responseMsg.addObjPart(response, false);
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        if (logger.isDebugEnabled()) {
            logger.debug("TX: sending a nonNull response for transaction: {}", (Object)new TXId((InternalDistributedMember)servConn.getProxyID().getDistributedMember(), origMsg.getTransactionId()));
        }
        responseMsg.send(servConn);
        origMsg.clearParts();
    }

    private void sendException(Message msg, ServerConnection servConn, Throwable e) throws IOException {
        CommitCommand.writeException(msg, 2, e, false, servConn);
        servConn.setAsTrue(1);
    }
}

