/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;

public class CloseConnection
extends BaseCommand {
    private static final CloseConnection singleton = new CloseConnection();

    public static Command getCommand() {
        return singleton;
    }

    private CloseConnection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException {
        CacheServerStats stats = servConn.getCacheServerStats();
        long oldStart = start;
        boolean respondToClient = servConn.getClientVersion().compareTo(Version.GFE_90) >= 0;
        start = DistributionStats.getStatTime();
        stats.incReadCloseConnectionRequestTime(start - oldStart);
        if (respondToClient) {
            servConn.setAsTrue(2);
        }
        try {
            Part keepalivePart;
            byte[] keepaliveByte;
            servConn.setClientDisconnectCleanly();
            String clientHost = servConn.getSocketHost();
            int clientPort = servConn.getSocketPort();
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Received close request ({} bytes) from {}:{}", (Object)servConn.getName(), (Object)msg.getPayloadLength(), (Object)clientHost, (Object)clientPort);
            }
            boolean keepalive = (keepaliveByte = (keepalivePart = msg.getPart(0)).getSerializedForm()) != null && keepaliveByte[0] != 0;
            servConn.getAcceptor().getCacheClientNotifier().setKeepAlive(servConn.getProxyID(), keepalive);
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Processed close request from {}:{}, keepAlive: {}", (Object)servConn.getName(), (Object)clientHost, (Object)clientPort, (Object)keepalive);
            }
        }
        finally {
            if (respondToClient) {
                this.writeReply(msg, servConn);
            }
            servConn.setFlagProcessMessagesAsFalse();
            stats.incProcessCloseConnectionTime(DistributionStats.getStatTime() - start);
        }
    }
}

