/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.security.Principal;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.Cache;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.tier.Acceptor;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.ClientHandShake;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.InternalClientMembership;
import org.apache.geode.internal.cache.tier.MessageType;
import org.apache.geode.internal.cache.tier.sockets.AcceptorImpl;
import org.apache.geode.internal.cache.tier.sockets.AuthIds;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.ClientHealthMonitor;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.ClientUserAuths;
import org.apache.geode.internal.cache.tier.sockets.CommandInitializer;
import org.apache.geode.internal.cache.tier.sockets.HandShake;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.MessageIdExtractor;
import org.apache.geode.internal.cache.tier.sockets.MessageStats;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerHandShakeProcessor;
import org.apache.geode.internal.cache.tier.sockets.UserAuthAttributes;
import org.apache.geode.internal.cache.tier.sockets.command.Default;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.AuthorizeRequestPP;
import org.apache.geode.internal.security.IntegratedSecurityService;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.util.Breadcrumbs;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.AuthenticationRequiredException;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadState;

public class ServerConnection
implements Runnable {
    private static final Logger logger = LogService.getLogger();
    private static final int TIMEOUT_BUFFER_FOR_CONNECTION_CLEANUP_MS = 5000;
    private Map commands;
    private SecurityService securityService;
    protected final CacheServerStats stats;
    private static final ConcurrentHashMap<Integer, LinkedBlockingQueue<ByteBuffer>> commBufferMap = new ConcurrentHashMap(4, 0.75f, 1);
    private Socket theSocket;
    private ByteBuffer commBuffer;
    private final CachedRegionHelper crHelper;
    private String name;
    private Message requestMsg;
    private Message replyMsg;
    private Message responseMsg;
    private Message errorMsg;
    private ChunkedMessage queryResponseMsg;
    private ChunkedMessage chunkedResponseMsg;
    private ChunkedMessage executeFunctionResponseMsg;
    private ChunkedMessage registerInterestResponseMsg;
    private ChunkedMessage keySetResponseMsg;
    private final InternalLogWriter logWriter;
    private final InternalLogWriter securityLogWriter;
    private final AcceptorImpl acceptor;
    private Thread owner;
    private ClientHandShake handshake;
    private int handShakeTimeout;
    private final Object handShakeMonitor;
    private volatile int requestSpecificTimeout;
    private int latestBatchIdReplied;
    ClientProxyMembershipID proxyId;
    byte[] memberIdByteArray;
    private AuthorizeRequest authzRequest;
    private AuthorizeRequestPP postAuthzRequest;
    private final byte communicationMode;
    private final String communicationModeStr;
    private long processingMessageStartTime;
    private Object processingMessageLock;
    private static ConcurrentHashMap<ClientProxyMembershipID, ClientUserAuths> proxyIdVsClientUserAuths = new ConcurrentHashMap();
    private ClientUserAuths clientUserAuths;
    private long connectionId;
    private Random randomConnectionIdGen;
    private Part securePart;
    private Principal principal;
    private MessageIdExtractor messageIdExtractor;
    public static boolean TEST_VERSION_AFTER_HANDSHAKE_FLAG = false;
    public static short testVersionAfterHandshake = (short)4;
    private static final ThreadLocal<Byte> executeFunctionOnLocalNodeOnly = new ThreadLocal<Byte>(){

        @Override
        protected Byte initialValue() {
            return (byte)0;
        }
    };
    private boolean incedCleanupTableRef;
    private boolean incedCleanupProxyIdTableRef;
    private final Object chmLock;
    private boolean chmRegistered;
    private boolean doHandshake;
    private boolean clientDisconnectedCleanly;
    private Throwable clientDisconnectedException;
    private int failureCount;
    private boolean processMessages;
    private final Object terminationLock;
    private boolean terminated;
    private static boolean forceClientCrashEvent = false;
    private final Object ownerLock;
    private boolean requiresResponse;
    private boolean requiresChunkedResponse;
    private boolean potentialModification;
    private boolean responded;
    private Object modKey;
    private String modRegion;
    private long userAuthId;

    public static ByteBuffer allocateCommBuffer(int size, Socket sock) {
        if (sock.getChannel() == null) {
            return ByteBuffer.allocate(size);
        }
        LinkedBlockingQueue<ByteBuffer> q = commBufferMap.get(size);
        ByteBuffer result = null;
        if (q != null) {
            result = q.poll();
        }
        if (result == null) {
            result = ByteBuffer.allocateDirect(size);
        } else {
            result.position(0);
            result.limit(result.capacity());
        }
        return result;
    }

    public static void releaseCommBuffer(ByteBuffer bb) {
        if (bb != null && bb.isDirect()) {
            LinkedBlockingQueue<ByteBuffer> q = commBufferMap.get(bb.capacity());
            if (q == null) {
                q = new LinkedBlockingQueue();
                LinkedBlockingQueue<ByteBuffer> oldQ = commBufferMap.putIfAbsent(bb.capacity(), q);
                if (oldQ != null) {
                    q = oldQ;
                }
            }
            q.offer(bb);
        }
    }

    public static void emptyCommBufferPool() {
        for (LinkedBlockingQueue<ByteBuffer> q : commBufferMap.values()) {
            q.clear();
        }
    }

    public ServerConnection(Socket s, Cache c, CachedRegionHelper helper, CacheServerStats stats, int hsTimeout, int socketBufferSize, String communicationModeStr, byte communicationMode, Acceptor acceptor) {
        block5: {
            this.securityService = IntegratedSecurityService.getSecurityService();
            this.name = null;
            this.requestMsg = new Message(2, Version.CURRENT);
            this.replyMsg = new Message(1, Version.CURRENT);
            this.responseMsg = new Message(1, Version.CURRENT);
            this.errorMsg = new Message(1, Version.CURRENT);
            this.queryResponseMsg = new ChunkedMessage(2, Version.CURRENT);
            this.chunkedResponseMsg = new ChunkedMessage(1, Version.CURRENT);
            this.executeFunctionResponseMsg = new ChunkedMessage(1, Version.CURRENT);
            this.registerInterestResponseMsg = new ChunkedMessage(1, Version.CURRENT);
            this.keySetResponseMsg = new ChunkedMessage(1, Version.CURRENT);
            this.handShakeMonitor = new Object();
            this.requestSpecificTimeout = -1;
            this.latestBatchIdReplied = -1;
            this.processingMessageStartTime = -1L;
            this.processingMessageLock = new Object();
            this.connectionId = 26739L;
            this.randomConnectionIdGen = null;
            this.securePart = null;
            this.messageIdExtractor = new MessageIdExtractor();
            this.incedCleanupTableRef = false;
            this.incedCleanupProxyIdTableRef = false;
            this.chmLock = new Object();
            this.chmRegistered = false;
            this.doHandshake = true;
            this.clientDisconnectedCleanly = false;
            this.failureCount = 0;
            this.processMessages = true;
            this.terminationLock = new Object();
            this.terminated = false;
            this.ownerLock = new Object();
            this.modKey = null;
            this.modRegion = null;
            StringBuffer buffer = new StringBuffer(100);
            if (((AcceptorImpl)acceptor).isGatewayReceiver()) {
                buffer.append("GatewayReceiver connection from [");
            } else {
                buffer.append("Server connection from [");
            }
            buffer.append(communicationModeStr).append(" host address=").append(s.getInetAddress().getHostAddress()).append("; ").append(communicationModeStr).append(" port=").append(s.getPort()).append("]");
            this.name = buffer.toString();
            this.stats = stats;
            this.acceptor = (AcceptorImpl)acceptor;
            this.crHelper = helper;
            this.logWriter = (InternalLogWriter)c.getLoggerI18n();
            this.securityLogWriter = (InternalLogWriter)c.getSecurityLoggerI18n();
            this.communicationModeStr = communicationModeStr;
            this.communicationMode = communicationMode;
            this.principal = null;
            this.authzRequest = null;
            this.postAuthzRequest = null;
            this.randomConnectionIdGen = new Random(this.hashCode());
            boolean isDebugEnabled = logger.isDebugEnabled();
            try {
                this.initStreams(s, socketBufferSize, stats);
                if (isDebugEnabled) {
                    logger.debug("{}: Accepted client connection from {}[client host name={}; client host address={}; client port={}]", (Object)this.getName(), (Object)s.getInetAddress().getCanonicalHostName(), (Object)s.getInetAddress().getHostAddress(), (Object)s.getPort());
                }
                this.handShakeTimeout = hsTimeout;
            }
            catch (Exception e) {
                if (!isDebugEnabled) break block5;
                logger.debug("While creating server connection", (Throwable)e);
            }
        }
    }

    public AcceptorImpl getAcceptor() {
        return this.acceptor;
    }

    public static void executeFunctionOnLocalNodeOnly(Byte value) {
        byte b = value;
        executeFunctionOnLocalNodeOnly.set(b);
    }

    public static Byte isExecuteFunctionOnLocalNodeOnly() {
        return executeFunctionOnLocalNodeOnly.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyClientConnection() {
        Object object = this.handShakeMonitor;
        synchronized (object) {
            if (this.handshake == null) {
                boolean readHandShake = ServerHandShakeProcessor.readHandShake(this);
                if (readHandShake) {
                    if (this.handshake.isOK()) {
                        try {
                            return this.processHandShake();
                        }
                        catch (CancelException e) {
                            if (!this.crHelper.isShutdown()) {
                                logger.warn(LocalizedMessage.create(LocalizedStrings.ServerConnection_0_UNEXPECTED_CANCELLATION, this.getName()), (Throwable)e);
                            }
                            this.cleanup();
                            return false;
                        }
                    }
                    this.crHelper.checkCancelInProgress(null);
                    logger.warn(LocalizedMessage.create(LocalizedStrings.ServerConnection_0_RECEIVED_UNKNOWN_HANDSHAKE_REPLY_CODE_1, new Object[]{this.name, new Byte(this.handshake.getCode())}));
                    this.refuseHandshake(LocalizedStrings.ServerConnection_RECEIVED_UNKNOWN_HANDSHAKE_REPLY_CODE.toLocalizedString(), (byte)61);
                    return false;
                }
                this.stats.incFailedConnectionAttempts();
                this.cleanup();
                return false;
            }
        }
        return true;
    }

    protected Map getCommands() {
        return this.commands;
    }

    protected Socket getSocket() {
        return this.theSocket;
    }

    protected int getHandShakeTimeout() {
        return this.handShakeTimeout;
    }

    protected DistributedSystem getDistributedSystem() {
        return this.getCache().getDistributedSystem();
    }

    public Cache getCache() {
        return this.crHelper.getCache();
    }

    public ClientHandShake getHandshake() {
        return this.handshake;
    }

    public void setHandshake(ClientHandShake handshake) {
        this.handshake = handshake;
        Version v = handshake.getVersion();
        this.replyMsg.setVersion(v);
        this.requestMsg.setVersion(v);
        this.responseMsg.setVersion(v);
        this.errorMsg.setVersion(v);
        this.queryResponseMsg.setVersion(v);
        this.chunkedResponseMsg.setVersion(v);
        this.executeFunctionResponseMsg.setVersion(v);
        this.registerInterestResponseMsg.setVersion(v);
        this.keySetResponseMsg.setVersion(v);
    }

    public void setRequestMsg(Message requestMsg) {
        this.requestMsg = requestMsg;
    }

    public Version getClientVersion() {
        return this.handshake.getVersion();
    }

    protected void setProxyId(ClientProxyMembershipID proxyId) {
        this.proxyId = proxyId;
        this.memberIdByteArray = EventID.getMembershipId(proxyId);
        this.name = "Server connection from [" + proxyId + "; port=" + this.theSocket.getPort() + "]";
    }

    protected void setPrincipal(Principal principal) {
        this.principal = principal;
    }

    public long setUserAuthorizeAndPostAuthorizeRequest(AuthorizeRequest authzRequest, AuthorizeRequestPP postAuthzRequest) throws IOException {
        UserAuthAttributes userAuthAttr = new UserAuthAttributes(authzRequest, postAuthzRequest);
        if (this.clientUserAuths == null) {
            this.initializeClientUserAuths();
        }
        try {
            return this.clientUserAuths.putUserAuth(userAuthAttr);
        }
        catch (NullPointerException npe) {
            if (this.isTerminated()) {
                throw new IOException("Server connection is terminated.");
            }
            throw npe;
        }
    }

    public InternalLogWriter getSecurityLogWriter() {
        return this.securityLogWriter;
    }

    private Map getCleanupTable() {
        return this.acceptor.getClientHealthMonitor().getCleanupTable();
    }

    private Map getCleanupProxyIdTable() {
        return this.acceptor.getClientHealthMonitor().getCleanupProxyIdTable();
    }

    private ClientHealthMonitor getClientHealthMonitor() {
        return this.acceptor.getClientHealthMonitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean processHandShake() {
        int qSize;
        int epType;
        Counter numRefs;
        boolean isDebugEnabled;
        boolean registerClient;
        boolean clientJoined;
        boolean result;
        block56: {
            boolean bl;
            result = false;
            clientJoined = false;
            registerClient = false;
            isDebugEnabled = logger.isDebugEnabled();
            try {
                CacheClientProxy proxy;
                Map map = this.getCleanupTable();
                // MONITORENTER : map
                numRefs = (Counter)this.getCleanupTable().get(this.handshake);
                epType = 0;
                qSize = 0;
                if (!this.proxyId.isDurable()) break block56;
                if (isDebugEnabled) {
                    logger.debug("looking if the Proxy existed for this durable client or not :{}", (Object)this.proxyId);
                }
                if ((proxy = this.getAcceptor().getCacheClientNotifier().getClientProxy(this.proxyId)) != null && proxy.waitRemoval()) {
                    proxy = this.getAcceptor().getCacheClientNotifier().getClientProxy(this.proxyId);
                }
                if (proxy != null) {
                    if (isDebugEnabled) {
                        logger.debug("Proxy existed for this durable client :{} and proxy : {}", (Object)this.proxyId, (Object)proxy);
                    }
                    if (proxy.isPrimary()) {
                        epType = 2;
                        qSize = proxy.getQueueSize();
                    } else {
                        epType = 1;
                        qSize = proxy.getQueueSize();
                    }
                }
                if (numRefs != null || proxy == null || proxy.isPaused()) break block56;
                String handshakeRefusalMessage = LocalizedStrings.ServerConnection_DUPLICATE_DURABLE_CLIENTID_0.toLocalizedString(this.proxyId.getDurableId());
                logger.warn(LocalizedMessage.create(LocalizedStrings.TWO_ARG_COLON, new Object[]{this.name, handshakeRefusalMessage}));
                this.refuseHandshake(handshakeRefusalMessage, (byte)64);
                bl = result;
                // MONITOREXIT : map
                if (this.isTerminated()) return false;
                if (!result) {
                    return false;
                }
                Map map2 = this.getCleanupProxyIdTable();
            }
            catch (Throwable throwable) {
                if (this.isTerminated()) return false;
                if (!result) {
                    return false;
                }
                Map map = this.getCleanupProxyIdTable();
                // MONITORENTER : map
                Counter numRefs2 = (Counter)this.getCleanupProxyIdTable().get(this.proxyId);
                if (numRefs2 != null) {
                    numRefs2.incr();
                } else {
                    registerClient = true;
                    numRefs2 = new Counter();
                    numRefs2.incr();
                    this.getCleanupProxyIdTable().put(this.proxyId, numRefs2);
                    InternalDistributedMember internalDistributedMember = (InternalDistributedMember)this.proxyId.getDistributedMember();
                }
                this.incedCleanupProxyIdTableRef = true;
                // MONITOREXIT : map
                if (isDebugEnabled) {
                    logger.debug("{}registering client {}", (Object)(registerClient ? "" : "not "), (Object)this.proxyId);
                }
                this.crHelper.checkCancelInProgress(null);
                if (clientJoined && this.isFiringMembershipEvents()) {
                    InternalClientMembership.notifyClientJoined(this.proxyId.getDistributedMember());
                }
                ClientHealthMonitor chm = this.acceptor.getClientHealthMonitor();
                Object object = this.chmLock;
                // MONITORENTER : object
                this.chmRegistered = true;
                // MONITOREXIT : object
                if (registerClient) {
                    chm.registerClient(this.proxyId);
                }
                chm.addConnection(this.proxyId, this);
                this.acceptor.getConnectionListener().connectionOpened(registerClient, this.communicationMode);
                throw throwable;
            }
            Counter numRefs3 = (Counter)this.getCleanupProxyIdTable().get(this.proxyId);
            if (numRefs3 != null) {
                numRefs3.incr();
            } else {
                registerClient = true;
                numRefs3 = new Counter();
                numRefs3.incr();
                this.getCleanupProxyIdTable().put(this.proxyId, numRefs3);
                InternalDistributedMember internalDistributedMember = (InternalDistributedMember)this.proxyId.getDistributedMember();
            }
            this.incedCleanupProxyIdTableRef = true;
            // MONITOREXIT : map2
            if (isDebugEnabled) {
                logger.debug("{}registering client {}", (Object)(registerClient ? "" : "not "), (Object)this.proxyId);
            }
            this.crHelper.checkCancelInProgress(null);
            if (clientJoined && this.isFiringMembershipEvents()) {
                InternalClientMembership.notifyClientJoined(this.proxyId.getDistributedMember());
            }
            ClientHealthMonitor chm = this.acceptor.getClientHealthMonitor();
            Object object = this.chmLock;
            // MONITORENTER : object
            this.chmRegistered = true;
            // MONITOREXIT : object
            if (registerClient) {
                chm.registerClient(this.proxyId);
            }
            chm.addConnection(this.proxyId, this);
            this.acceptor.getConnectionListener().connectionOpened(registerClient, this.communicationMode);
            return bl;
        }
        if (numRefs != null) {
            if (this.acceptHandShake((byte)epType, qSize)) {
                numRefs.incr();
                this.incedCleanupTableRef = true;
                result = true;
            }
            boolean bl = result;
            // MONITOREXIT : map
            if (this.isTerminated()) return false;
            if (!result) {
                return false;
            }
            Map handshakeRefusalMessage = this.getCleanupProxyIdTable();
            // MONITORENTER : handshakeRefusalMessage
            Object numRefs4 = (Counter)this.getCleanupProxyIdTable().get(this.proxyId);
            if (numRefs4 != null) {
                ((Counter)numRefs4).incr();
            } else {
                registerClient = true;
                numRefs4 = new Counter();
                ((Counter)numRefs4).incr();
                this.getCleanupProxyIdTable().put(this.proxyId, numRefs4);
                InternalDistributedMember internalDistributedMember = (InternalDistributedMember)this.proxyId.getDistributedMember();
            }
            this.incedCleanupProxyIdTableRef = true;
            // MONITOREXIT : handshakeRefusalMessage
            if (isDebugEnabled) {
                logger.debug("{}registering client {}", (Object)(registerClient ? "" : "not "), (Object)this.proxyId);
            }
            this.crHelper.checkCancelInProgress(null);
            if (clientJoined && this.isFiringMembershipEvents()) {
                InternalClientMembership.notifyClientJoined(this.proxyId.getDistributedMember());
            }
            ClientHealthMonitor chm = this.acceptor.getClientHealthMonitor();
            numRefs4 = this.chmLock;
            // MONITORENTER : numRefs4
            this.chmRegistered = true;
            // MONITOREXIT : numRefs4
            if (registerClient) {
                chm.registerClient(this.proxyId);
            }
            chm.addConnection(this.proxyId, this);
            this.acceptor.getConnectionListener().connectionOpened(registerClient, this.communicationMode);
            return bl;
        }
        if (this.acceptHandShake((byte)epType, qSize)) {
            clientJoined = true;
            numRefs = new Counter();
            this.getCleanupTable().put(this.handshake, numRefs);
            numRefs.incr();
            this.incedCleanupTableRef = true;
            this.stats.incCurrentClients();
            result = true;
        }
        boolean bl = result;
        // MONITOREXIT : map
        if (this.isTerminated()) return false;
        if (!result) {
            return false;
        }
        Object chm = this.getCleanupProxyIdTable();
        // MONITORENTER : chm
        Counter numRefs5 = (Counter)this.getCleanupProxyIdTable().get(this.proxyId);
        if (numRefs5 != null) {
            numRefs5.incr();
        } else {
            registerClient = true;
            numRefs5 = new Counter();
            numRefs5.incr();
            this.getCleanupProxyIdTable().put(this.proxyId, numRefs5);
            InternalDistributedMember internalDistributedMember = (InternalDistributedMember)this.proxyId.getDistributedMember();
        }
        this.incedCleanupProxyIdTableRef = true;
        // MONITOREXIT : chm
        if (isDebugEnabled) {
            logger.debug("{}registering client {}", (Object)(registerClient ? "" : "not "), (Object)this.proxyId);
        }
        this.crHelper.checkCancelInProgress(null);
        if (clientJoined && this.isFiringMembershipEvents()) {
            InternalClientMembership.notifyClientJoined(this.proxyId.getDistributedMember());
        }
        chm = this.acceptor.getClientHealthMonitor();
        Object object = this.chmLock;
        // MONITORENTER : object
        this.chmRegistered = true;
        // MONITOREXIT : object
        if (registerClient) {
            ((ClientHealthMonitor)chm).registerClient(this.proxyId);
        }
        ((ClientHealthMonitor)chm).addConnection(this.proxyId, this);
        this.acceptor.getConnectionListener().connectionOpened(registerClient, this.communicationMode);
        return bl;
    }

    private boolean isFiringMembershipEvents() {
        return this.acceptor.isRunning() && !((GemFireCacheImpl)this.acceptor.getCachedRegionHelper().getCache()).isClosed() && !this.acceptor.getCachedRegionHelper().getCache().getCancelCriterion().isCancelInProgress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refuseHandshake(String msg, byte exception) {
        try {
            ServerHandShakeProcessor.refuse(this.theSocket.getOutputStream(), msg, exception);
        }
        catch (IOException iOException) {
        }
        finally {
            this.stats.incFailedConnectionAttempts();
            this.cleanup();
        }
    }

    private boolean acceptHandShake(byte epType, int qSize) {
        try {
            this.handshake.accept(this.theSocket.getOutputStream(), this.theSocket.getInputStream(), epType, qSize, this.communicationMode, this.principal);
        }
        catch (IOException ioe) {
            if (!this.crHelper.isShutdown() && !this.isTerminated()) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.ServerConnection_0_HANDSHAKE_ACCEPT_FAILED_ON_SOCKET_1_2, new Object[]{this.name, this.theSocket, ioe}));
            }
            this.cleanup();
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Accepted handshake", (Object)this.name);
        }
        if (this.communicationMode == 107) {
            this.stats.incCurrentQueueConnections();
        } else {
            this.stats.incCurrentClientConnections();
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setCq(String cqName, boolean isDurable) throws Exception {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (this.requestMsg.isSecureMode()) {
            if (isDebugEnabled) {
                logger.debug("setCq() security header found registering CQname = {}", (Object)cqName);
            }
            try {
                byte[] secureBytes = this.requestMsg.getSecureBytes();
                secureBytes = ((HandShake)this.handshake).decryptBytes(secureBytes);
                AuthIds aIds = new AuthIds(secureBytes);
                long uniqueId = aIds.getUniqueId();
                CacheClientProxy proxy = this.getAcceptor().getCacheClientNotifier().getClientProxy(this.proxyId);
                if (proxy == null) return;
                proxy.setCQVsUserAuth(cqName, uniqueId, isDurable);
                return;
            }
            catch (Exception ex) {
                if (!isDebugEnabled) throw ex;
                logger.debug("While setting cq got exception ", (Throwable)ex);
                throw ex;
            }
        } else {
            if (!isDebugEnabled) return;
            logger.debug("setCq() security header is not found ");
        }
    }

    public void removeCq(String cqName, boolean isDurable) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (this.requestMsg.isSecureMode()) {
            if (isDebugEnabled) {
                logger.debug("removeCq() security header found registering CQname = {}", (Object)cqName);
            }
            try {
                this.clientUserAuths.removeUserAuthAttributesForCq(cqName, isDurable);
            }
            catch (Exception ex) {
                if (isDebugEnabled) {
                    logger.debug("While setting cq got exception ", (Throwable)ex);
                }
            }
        } else if (isDebugEnabled) {
            logger.debug("removeCq() security header is not found");
        }
    }

    private void doHandshake() {
        if (this.verifyClientConnection()) {
            this.initializeCommands();
            if (this.getCommunicationMode() != 103) {
                this.initializeClientUserAuths();
            }
        }
        if (TEST_VERSION_AFTER_HANDSHAKE_FLAG) {
            Assert.assertTrue(this.handshake.getVersion().ordinal() == testVersionAfterHandshake, "Found different version after handshake");
            TEST_VERSION_AFTER_HANDSHAKE_FLAG = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNormalMsg() {
        Message msg = null;
        msg = BaseCommand.readRequest(this);
        ThreadState threadState = null;
        try {
            if (msg != null) {
                long uniqueId;
                Subject subject;
                Command command;
                if (!this.processMessages || this.crHelper.isShutdown()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{} ignoring message of type {} from client {} due to shutdown.", (Object)this.getName(), (Object)MessageType.getString(msg.getMessageType()), (Object)this.proxyId);
                    }
                    return;
                }
                if (msg.getMessageType() != 5 && msg.getNumberOfParts() <= 0) {
                    ++this.failureCount;
                    if (this.failureCount > 3) {
                        this.processMessages = false;
                        return;
                    }
                    return;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("{} received {} with txid {}", (Object)this.getName(), (Object)MessageType.getString(msg.getMessageType()), (Object)msg.getTransactionId());
                    if (msg.getTransactionId() < -1) {
                        msg.setTransactionId(-1);
                    }
                }
                if (msg.getMessageType() != 5) {
                    this.acceptor.getClientHealthMonitor().receivedPing(this.proxyId);
                }
                if ((command = this.getCommand(msg.getMessageType())) == null) {
                    command = Default.getCommand();
                }
                if (AcceptorImpl.isIntegratedSecurity() && !this.isInternalMessage() && this.communicationMode != 103 && (subject = this.clientUserAuths.getSubject(uniqueId = this.getUniqueId())) != null) {
                    threadState = this.securityService.bindSubject(subject);
                }
                command.execute(msg, this);
            }
        }
        finally {
            this.setNotProcessingMessage();
            this.clearRequestMsg();
            if (threadState != null) {
                threadState.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTerminated() {
        Object object = this.terminationLock;
        synchronized (object) {
            return this.terminated;
        }
    }

    private void cleanClientAuths() {
        if (this.clientUserAuths != null) {
            this.clientUserAuths.cleanup(false);
        }
    }

    void handleTermination() {
        if (this.crHelper.isShutdown()) {
            this.setClientDisconnectCleanly();
        }
        this.handleTermination(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleTermination(boolean timedOut) {
        Counter numRefs;
        boolean cleanupStats = false;
        Object object = this.terminationLock;
        synchronized (object) {
            if (this.terminated) {
                return;
            }
            this.terminated = true;
        }
        boolean clientDeparted = false;
        boolean unregisterClient = false;
        this.setNotProcessingMessage();
        Map map = this.getCleanupTable();
        synchronized (map) {
            if (this.incedCleanupTableRef) {
                this.incedCleanupTableRef = false;
                cleanupStats = true;
                numRefs = (Counter)this.getCleanupTable().get(this.handshake);
                if (numRefs != null) {
                    numRefs.decr();
                    if (numRefs.getCnt() <= 0) {
                        clientDeparted = true;
                        this.getCleanupTable().remove(this.handshake);
                        this.stats.decCurrentClients();
                    }
                }
                if (this.communicationMode == 107) {
                    this.stats.decCurrentQueueConnections();
                } else {
                    this.stats.decCurrentClientConnections();
                }
            }
        }
        map = this.getCleanupProxyIdTable();
        synchronized (map) {
            if (this.incedCleanupProxyIdTableRef) {
                this.incedCleanupProxyIdTableRef = false;
                numRefs = (Counter)this.getCleanupProxyIdTable().get(this.proxyId);
                if (numRefs != null) {
                    numRefs.decr();
                    if (numRefs.getCnt() <= 0) {
                        unregisterClient = true;
                        this.getCleanupProxyIdTable().remove(this.proxyId);
                        proxyIdVsClientUserAuths.remove(this.proxyId);
                        InternalDistributedMember internalDistributedMember = (InternalDistributedMember)this.proxyId.getDistributedMember();
                    }
                }
            }
        }
        this.cleanup(timedOut);
        if (this.getAcceptor().isRunning() && clientDeparted && this.isFiringMembershipEvents()) {
            if (this.clientDisconnectedCleanly && !forceClientCrashEvent) {
                InternalClientMembership.notifyClientLeft(this.proxyId.getDistributedMember());
            } else {
                InternalClientMembership.notifyClientCrashed(this.proxyId.getDistributedMember());
            }
        }
        boolean needsUnregister = false;
        Object object2 = this.chmLock;
        synchronized (object2) {
            if (this.chmRegistered) {
                needsUnregister = true;
                this.chmRegistered = false;
            }
        }
        if (unregisterClient) {
            this.cleanClientAuths();
        }
        this.clientUserAuths = null;
        if (needsUnregister) {
            this.acceptor.getClientHealthMonitor().removeConnection(this.proxyId, this);
            if (unregisterClient) {
                this.acceptor.getClientHealthMonitor().unregisterClient(this.proxyId, this.getAcceptor(), this.clientDisconnectedCleanly, this.clientDisconnectedException);
            }
        }
        if (cleanupStats) {
            this.acceptor.getConnectionListener().connectionClosed(clientDeparted, this.communicationMode);
        }
    }

    private void doOneMessage() {
        if (this.doHandshake) {
            this.doHandshake();
            this.doHandshake = false;
        } else {
            this.resetTransientData();
            this.doNormalMsg();
        }
    }

    private void initializeClientUserAuths() {
        this.clientUserAuths = ServerConnection.getClientUserAuths(this.proxyId);
    }

    static ClientUserAuths getClientUserAuths(ClientProxyMembershipID proxyId) {
        ClientUserAuths cua = new ClientUserAuths(proxyId.hashCode());
        ClientUserAuths retCua = proxyIdVsClientUserAuths.putIfAbsent(proxyId, cua);
        if (retCua == null) {
            return cua;
        }
        return retCua;
    }

    private void initializeCommands() {
        this.commands = CommandInitializer.getCommands(this);
    }

    private Command getCommand(Integer messageType2) {
        Command cc = (Command)this.commands.get(messageType2);
        return cc;
    }

    public boolean removeUserAuth(Message msg, boolean keepalive) {
        try {
            byte[] secureBytes = msg.getSecureBytes();
            secureBytes = ((HandShake)this.handshake).decryptBytes(secureBytes);
            AuthIds aIds = new AuthIds(secureBytes);
            long connId = aIds.getConnectionId();
            if (connId != this.connectionId) {
                throw new AuthenticationFailedException("Authentication failed");
            }
            try {
                boolean removed = this.clientUserAuths.removeSubject(aIds.getUniqueId());
                if (!removed) {
                    removed = this.clientUserAuths.removeUserId(aIds.getUniqueId(), keepalive);
                }
                return removed;
            }
            catch (NullPointerException npe) {
                logger.debug("Exception {}", (Throwable)npe);
                return false;
            }
        }
        catch (Exception ex) {
            throw new AuthenticationFailedException("Authentication failed", ex);
        }
    }

    public byte[] setCredentials(Message msg) throws Exception {
        try {
            long uniqueId;
            if (!AcceptorImpl.isAuthenticationRequired() && msg.isSecureMode()) {
                return new byte[0];
            }
            if (!msg.isSecureMode()) {
                throw new AuthenticationFailedException("Authentication failed");
            }
            byte[] secureBytes = msg.getSecureBytes();
            AuthIds aIds = new AuthIds(secureBytes = ((HandShake)this.handshake).decryptBytes(secureBytes));
            long connId = aIds.getConnectionId();
            if (connId != this.connectionId) {
                throw new AuthenticationFailedException("Authentication failed");
            }
            byte[] credBytes = msg.getPart(0).getSerializedForm();
            credBytes = ((HandShake)this.handshake).decryptBytes(credBytes);
            ByteArrayInputStream bis = new ByteArrayInputStream(credBytes);
            DataInputStream dinp = new DataInputStream(bis);
            Properties credentials = DataSerializer.readProperties(dinp);
            DistributedSystem system = this.getDistributedSystem();
            String methodName = system.getProperties().getProperty("security-client-authenticator");
            Object principal = HandShake.verifyCredentials(methodName, credentials, system.getSecurityProperties(), (InternalLogWriter)system.getLogWriter(), (InternalLogWriter)system.getSecurityLogWriter(), this.proxyId.getDistributedMember());
            if (principal instanceof Subject) {
                Subject subject = (Subject)principal;
                uniqueId = this.clientUserAuths.putSubject(subject);
                logger.info(this.clientUserAuths);
            } else {
                uniqueId = ServerHandShakeProcessor.getUniqueId(this, (Principal)principal);
            }
            return this.encryptId(uniqueId, this);
        }
        catch (AuthenticationFailedException afe) {
            throw afe;
        }
        catch (AuthenticationRequiredException are) {
            throw are;
        }
        catch (Exception e) {
            throw new AuthenticationFailedException("REPLY_REFUSED", e);
        }
    }

    private void setSecurityPart() {
        try {
            this.connectionId = this.randomConnectionIdGen.nextLong();
            this.securePart = new Part();
            byte[] id = this.encryptId(this.connectionId, this);
            this.securePart.setPartState(id, false);
        }
        catch (Exception ex) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.ServerConnection_SERVER_FAILED_TO_ENCRYPT_DATA_0, ex));
            throw new GemFireSecurityException("Server failed to encrypt response message.");
        }
    }

    public Part updateAndGetSecurityPart() {
        if (AcceptorImpl.isAuthenticationRequired() && this.handshake.getVersion().compareTo(Version.GFE_65) >= 0 && this.communicationMode != 103 && !this.requestMsg.getAndResetIsMetaRegion() && !this.isInternalMessage()) {
            this.setSecurityPart();
            return this.securePart;
        }
        if (AcceptorImpl.isAuthenticationRequired() && logger.isDebugEnabled()) {
            logger.debug("ServerConnection.updateAndGetSecurityPart() not adding security part for msg type {}", (Object)MessageType.getString(this.requestMsg.msgType));
        }
        return null;
    }

    private boolean isInternalMessage() {
        return this.requestMsg.msgType == 53 || this.requestMsg.msgType == 18 || this.requestMsg.msgType == 48 || this.requestMsg.msgType == 73 || this.requestMsg.msgType == 71 || this.requestMsg.msgType == -1 || this.requestMsg.msgType == 31 || this.requestMsg.msgType == 49 || this.requestMsg.msgType == 52 || this.requestMsg.msgType == 5 || this.requestMsg.msgType == 67 || this.requestMsg.msgType == 51 || this.requestMsg.msgType == 68 || this.requestMsg.msgType == 94 || this.requestMsg.msgType == 93 || this.requestMsg.msgType == 92 || this.requestMsg.msgType == 81 || this.requestMsg.msgType == 88 || this.requestMsg.msgType == 90 || this.requestMsg.msgType == 91 || this.requestMsg.msgType == 96 || this.requestMsg.msgType == 97 || this.requestMsg.msgType == 98 || this.requestMsg.msgType == 101 || this.requestMsg.msgType == 102 || this.requestMsg.msgType == 85 || this.requestMsg.msgType == 87;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.setOwner();
        if (this.getAcceptor().isSelector()) {
            boolean finishedMsg = false;
            try {
                this.stats.decThreadQueueSize();
                if (this.isTerminated()) return;
                Message.setTLCommBuffer(this.getAcceptor().takeCommBuffer());
                this.doOneMessage();
                if (!this.processMessages || this.crHelper.isShutdown()) return;
                this.registerWithSelector();
                finishedMsg = true;
                return;
            }
            catch (ClosedChannelException closedChannelException) {
                return;
            }
            catch (CancelException cancelException) {
                return;
            }
            catch (IOException ex) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.ServerConnection_0__UNEXPECTED_EXCEPTION, ex));
                this.setClientDisconnectedException(ex);
                return;
            }
            finally {
                this.getAcceptor().releaseCommBuffer(Message.setTLCommBuffer(null));
                this.unsetOwner();
                this.setNotProcessingMessage();
                this.unsetRequestSpecificTimeout();
                if (!finishedMsg) {
                    try {
                        this.handleTermination();
                    }
                    catch (CancelException cancelException) {}
                }
            }
        }
        try {
            while (this.processMessages && !this.crHelper.isShutdown()) {
                try {
                    this.doOneMessage();
                }
                catch (CancelException cancelException) {}
                continue;
                finally {
                    this.unsetRequestSpecificTimeout();
                    Breadcrumbs.clearBreadcrumb();
                }
            }
            return;
        }
        finally {
            try {
                this.unsetRequestSpecificTimeout();
                this.handleTermination();
                DistributedSystem.releaseThreadsSockets();
            }
            catch (CancelException cancelException) {}
        }
    }

    public void registerWithSelector() throws IOException {
        this.getSelectableChannel().configureBlocking(false);
        this.getAcceptor().registerSC(this);
    }

    public SelectableChannel getSelectableChannel() {
        return this.theSocket.getChannel();
    }

    public void registerWithSelector2(Selector s) throws IOException {
        this.getSelectableChannel().register(s, 1, this);
    }

    public void makeBlocking() throws IOException {
        SocketChannel c = this.theSocket.getChannel();
        ((SelectableChannel)c).configureBlocking(true);
    }

    public static void setForceClientCrashEvent(boolean value) {
        forceClientCrashEvent = value;
    }

    public String getMembershipID() {
        return this.proxyId.getDSMembership();
    }

    public int getSocketPort() {
        return this.theSocket.getPort();
    }

    public String getSocketHost() {
        return this.theSocket.getInetAddress().getHostAddress();
    }

    protected byte getCommunicationMode() {
        return this.communicationMode;
    }

    protected String getCommunicationModeString() {
        return this.communicationModeStr;
    }

    protected InetAddress getSocketAddress() {
        return this.theSocket.getInetAddress();
    }

    public void setRequestSpecificTimeout(int requestSpecificTimeout) {
        this.requestSpecificTimeout = requestSpecificTimeout;
    }

    private void unsetRequestSpecificTimeout() {
        this.requestSpecificTimeout = -1;
    }

    int getClientReadTimeout() {
        if (this.requestSpecificTimeout == -1) {
            return this.handshake.getClientReadTimeout();
        }
        return this.requestSpecificTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isProcessingMessage() {
        if (this.isTerminated()) {
            return false;
        }
        Object object = this.processingMessageLock;
        synchronized (object) {
            return this.basicIsProcessingMessage();
        }
    }

    private boolean basicIsProcessingMessage() {
        return this.processingMessageStartTime != -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setProcessingMessage() {
        Object object = this.processingMessageLock;
        synchronized (object) {
            this.processingMessageStartTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateProcessingMessage() {
        Object object = this.processingMessageLock;
        synchronized (object) {
            if (this.processingMessageStartTime != -1L) {
                this.processingMessageStartTime = System.currentTimeMillis();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setNotProcessingMessage() {
        Object object = this.processingMessageLock;
        synchronized (object) {
            this.processingMessageStartTime = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getCurrentMessageProcessingTime() {
        long result;
        Object object = this.processingMessageLock;
        synchronized (object) {
            result = this.processingMessageStartTime;
        }
        if (result != -1L) {
            result = System.currentTimeMillis() - result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasBeenTimedOutOnClient() {
        int timeout = this.getClientReadTimeout();
        if (timeout > 0) {
            timeout += 5000;
            Object object = this.processingMessageLock;
            synchronized (object) {
                if (this.getCurrentMessageProcessingTime() > (long)timeout) {
                    return true;
                }
            }
        }
        return false;
    }

    public String getSocketString() {
        try {
            StringBuffer buffer = new StringBuffer(50).append(this.theSocket.getInetAddress()).append(':').append(this.theSocket.getPort()).append(" timeout: ").append(this.theSocket.getSoTimeout());
            return buffer.toString();
        }
        catch (Exception e) {
            return LocalizedStrings.ServerConnection_ERROR_IN_GETSOCKETSTRING_0.toLocalizedString(e.getLocalizedMessage());
        }
    }

    void clearRequestMsg() {
        this.requestMsg.clear();
    }

    public void incrementLatestBatchIdReplied(int justProcessed) {
        if (justProcessed - this.latestBatchIdReplied != 1) {
            this.stats.incOutOfOrderBatchIds();
            logger.warn(LocalizedMessage.create(LocalizedStrings.ServerConnection_BATCH_IDS_ARE_OUT_OF_ORDER_SETTING_LATESTBATCHID_TO_0_IT_WAS_1, new Object[]{justProcessed, this.latestBatchIdReplied}));
        }
        this.latestBatchIdReplied = justProcessed;
    }

    public int getLatestBatchIdReplied() {
        return this.latestBatchIdReplied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void interruptOwner() {
        Object object = this.ownerLock;
        synchronized (object) {
            if (this.owner != null) {
                this.owner.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOwner() {
        Object object = this.ownerLock;
        synchronized (object) {
            this.owner = Thread.currentThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsetOwner() {
        Object object = this.ownerLock;
        synchronized (object) {
            this.owner = null;
            Thread.interrupted();
        }
    }

    private void initStreams(Socket s, int socketBufferSize, MessageStats msgStats) {
        try {
            this.theSocket = s;
            this.theSocket.setSendBufferSize(socketBufferSize);
            this.theSocket.setReceiveBufferSize(socketBufferSize);
            this.commBuffer = this.getAcceptor().isSelector() ? null : ServerConnection.allocateCommBuffer(socketBufferSize, s);
            this.requestMsg.setComms(this, this.theSocket, this.commBuffer, msgStats);
            this.replyMsg.setComms(this, this.theSocket, this.commBuffer, msgStats);
            this.responseMsg.setComms(this, this.theSocket, this.commBuffer, msgStats);
            this.errorMsg.setComms(this, this.theSocket, this.commBuffer, msgStats);
            this.chunkedResponseMsg.setComms(this, this.theSocket, this.commBuffer, msgStats);
            this.queryResponseMsg.setComms(this, this.theSocket, this.commBuffer, msgStats);
            this.executeFunctionResponseMsg.setComms(this, this.theSocket, this.commBuffer, msgStats);
            this.registerInterestResponseMsg.setComms(this, this.theSocket, this.commBuffer, msgStats);
            this.keySetResponseMsg.setComms(this, this.theSocket, this.commBuffer, msgStats);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            logger.fatal(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isOpen() {
        return !this.isClosed();
    }

    public boolean isClosed() {
        return this.theSocket == null || !this.theSocket.isConnected() || this.theSocket.isClosed();
    }

    public void cleanup(boolean timedOut) {
        if (this.cleanup() && timedOut) {
            this.stats.incConnectionsTimedOut();
        }
    }

    public boolean cleanup() {
        block12: {
            block11: {
                if (this.isClosed()) {
                    return false;
                }
                if (this.communicationMode == 100 || this.isGatewayConnection() || this.communicationMode == 104) {
                    this.getAcceptor().decClientServerCnxCount();
                }
                try {
                    this.theSocket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (this.authzRequest != null) {
                        this.authzRequest.close();
                        this.authzRequest = null;
                    }
                }
                catch (Exception ex) {
                    if (!this.securityLogWriter.warningEnabled()) break block11;
                    this.securityLogWriter.warning(LocalizedStrings.ServerConnection_0_AN_EXCEPTION_WAS_THROWN_WHILE_CLOSING_CLIENT_AUTHORIZATION_CALLBACK_1, new Object[]{this.name, ex});
                }
            }
            try {
                if (this.postAuthzRequest != null) {
                    this.postAuthzRequest.close();
                    this.postAuthzRequest = null;
                }
            }
            catch (Exception ex) {
                if (!this.securityLogWriter.warningEnabled()) break block12;
                this.securityLogWriter.warning(LocalizedStrings.ServerConnection_0_AN_EXCEPTION_WAS_THROWN_WHILE_CLOSING_CLIENT_POSTPROCESS_AUTHORIZATION_CALLBACK_1, new Object[]{this.name, ex});
            }
        }
        this.getAcceptor().unregisterSC(this);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Closed connection", (Object)this.name);
        }
        this.releaseCommBuffer();
        return true;
    }

    private void releaseCommBuffer() {
        ByteBuffer bb = this.commBuffer;
        if (bb != null) {
            this.commBuffer = null;
            ServerConnection.releaseCommBuffer(bb);
        }
    }

    public static void loadEmergencyClasses() {
    }

    public void emergencyClose() {
        this.terminated = true;
        Socket s = this.theSocket;
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public ClientProxyMembershipID getProxyID() {
        return this.proxyId;
    }

    public CachedRegionHelper getCachedRegionHelper() {
        return this.crHelper;
    }

    public CacheServerStats getCacheServerStats() {
        return this.stats;
    }

    public Message getReplyMessage() {
        return this.replyMsg;
    }

    public ChunkedMessage getChunkedResponseMessage() {
        return this.chunkedResponseMsg;
    }

    public Message getErrorResponseMessage() {
        return this.errorMsg;
    }

    public Message getResponseMessage() {
        return this.responseMsg;
    }

    public Message getRequestMessage() {
        return this.requestMsg;
    }

    public ChunkedMessage getQueryResponseMessage() {
        return this.queryResponseMsg;
    }

    public ChunkedMessage getFunctionResponseMessage() {
        return this.executeFunctionResponseMsg;
    }

    public ChunkedMessage getKeySetResponseMessage() {
        return this.keySetResponseMsg;
    }

    public ChunkedMessage getRegisterInterestResponseMessage() {
        return this.registerInterestResponseMsg;
    }

    void resetTransientData() {
        this.potentialModification = false;
        this.requiresResponse = false;
        this.responded = false;
        this.requiresChunkedResponse = false;
        this.modKey = null;
        this.modRegion = null;
        this.queryResponseMsg.setNumberOfParts(2);
        this.chunkedResponseMsg.setNumberOfParts(1);
        this.executeFunctionResponseMsg.setNumberOfParts(1);
        this.registerInterestResponseMsg.setNumberOfParts(1);
        this.keySetResponseMsg.setNumberOfParts(1);
    }

    String getModRegion() {
        return this.modRegion;
    }

    Object getModKey() {
        return this.modKey;
    }

    boolean getPotentialModification() {
        return this.potentialModification;
    }

    public void setModificationInfo(boolean potentialModification, String modRegion, Object modKey) {
        this.potentialModification = potentialModification;
        this.modRegion = modRegion;
        this.modKey = modKey;
    }

    public void setAsTrue(int boolID) {
        switch (boolID) {
            case 1: {
                this.responded = true;
                break;
            }
            case 2: {
                this.requiresResponse = true;
                break;
            }
            case 3: {
                this.requiresChunkedResponse = true;
                break;
            }
            default: {
                throw new IllegalArgumentException(LocalizedStrings.ServerConnection_THE_ID_PASSED_IS_0_WHICH_DOES_NOT_CORRESPOND_WITH_ANY_TRANSIENT_DATA.toLocalizedString(boolID));
            }
        }
    }

    public boolean getTransientFlag(int boolID) {
        boolean retVal;
        switch (boolID) {
            case 1: {
                retVal = this.responded;
                break;
            }
            case 2: {
                retVal = this.requiresResponse;
                break;
            }
            case 3: {
                retVal = this.requiresChunkedResponse;
                break;
            }
            default: {
                throw new IllegalArgumentException(LocalizedStrings.ServerConnection_THE_ID_PASSED_IS_0_WHICH_DOES_NOT_CORRESPOND_WITH_ANY_TRANSIENT_DATA.toLocalizedString(boolID));
            }
        }
        return retVal;
    }

    public void setFlagProcessMessagesAsFalse() {
        this.processMessages = false;
    }

    boolean getFlagProcessMessages() {
        return this.processMessages;
    }

    public InternalLogWriter getLogWriter() {
        return this.logWriter;
    }

    public void setUserAuthId(long uniqueId) {
        this.userAuthId = uniqueId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] encryptId(long id, ServerConnection servConn) throws Exception {
        try (HeapDataOutputStream hdos = null;){
            hdos = new HeapDataOutputStream(Version.CURRENT);
            hdos.writeLong(id);
            byte[] byArray = ((HandShake)this.handshake).encryptBytes(hdos.toByteArray());
            return byArray;
        }
    }

    public long getUniqueId() {
        long uniqueId = 0L;
        if (this.handshake.getVersion().isPre65() || this.isGatewayConnection()) {
            uniqueId = this.userAuthId;
        } else if (this.requestMsg.isSecureMode()) {
            uniqueId = this.messageIdExtractor.getUniqueIdFromMessage(this.requestMsg, (HandShake)this.handshake, this.connectionId);
        } else {
            throw new AuthenticationRequiredException(LocalizedStrings.HandShake_NO_SECURITY_CREDENTIALS_ARE_PROVIDED.toLocalizedString());
        }
        return uniqueId;
    }

    private boolean isGatewayConnection() {
        return this.getCommunicationMode() == 103;
    }

    public AuthorizeRequest getAuthzRequest() throws AuthenticationRequiredException, IOException {
        if (!AcceptorImpl.isAuthenticationRequired()) {
            return null;
        }
        if (AcceptorImpl.isIntegratedSecurity()) {
            return null;
        }
        long uniqueId = this.getUniqueId();
        UserAuthAttributes uaa = null;
        try {
            uaa = this.clientUserAuths.getUserAuthAttributes(uniqueId);
        }
        catch (NullPointerException npe) {
            if (this.isTerminated()) {
                throw new IOException("Server connection is terminated.");
            }
            logger.debug("Unexpected exception {}", (Throwable)npe);
        }
        if (uaa == null) {
            throw new AuthenticationRequiredException("User authorization attributes not found.");
        }
        AuthorizeRequest authReq = uaa.getAuthzRequest();
        if (logger.isDebugEnabled()) {
            logger.debug("getAuthzRequest() authrequest: {}", (Object)(authReq == null ? "NULL (only authentication is required)" : "not null"));
        }
        return authReq;
    }

    public AuthorizeRequestPP getPostAuthzRequest() throws AuthenticationRequiredException, IOException {
        if (!AcceptorImpl.isAuthenticationRequired()) {
            return null;
        }
        if (AcceptorImpl.isIntegratedSecurity()) {
            return null;
        }
        long uniqueId = this.getUniqueId();
        UserAuthAttributes uaa = null;
        try {
            uaa = this.clientUserAuths.getUserAuthAttributes(uniqueId);
        }
        catch (NullPointerException npe) {
            if (this.isTerminated()) {
                throw new IOException("Server connection is terminated.");
            }
            logger.debug("Unexpected exception {}", (Throwable)npe);
        }
        if (uaa == null) {
            throw new AuthenticationRequiredException("User authorization attributes not found.");
        }
        AuthorizeRequestPP postAuthReq = uaa.getPostAuthzRequest();
        return postAuthReq;
    }

    public byte[] getEventMemberIDByteArray() {
        return this.memberIdByteArray;
    }

    public void setClientDisconnectCleanly() {
        this.clientDisconnectedCleanly = true;
    }

    public void setClientDisconnectedException(Throwable e) {
        this.clientDisconnectedException = e;
    }

    public void setMessageIdExtractor(MessageIdExtractor messageIdExtractor) {
        this.messageIdExtractor = messageIdExtractor;
    }

    public MessageIdExtractor getMessageIdExtractor() {
        return this.messageIdExtractor;
    }

    static final class Counter {
        int cnt;

        Counter() {
        }

        void incr() {
            ++this.cnt;
        }

        int decr() {
            return --this.cnt;
        }

        int getCnt() {
            return this.cnt;
        }
    }
}

