/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerArray;
import org.apache.geode.CancelException;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.Cache;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.SystemTimer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.CacheClientStatus;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.IncomingGatewayStatus;
import org.apache.geode.internal.cache.TXId;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.tier.sockets.AcceptorImpl;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifierStats;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.concurrent.ConcurrentHashSet;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingThreadGroup;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;

public class ClientHealthMonitor {
    private static final Logger logger = LogService.getLogger();
    protected volatile Map _clientHeartbeats = Collections.EMPTY_MAP;
    protected final Object _clientHeartbeatsLock = new Object();
    protected final Map _clientThreads;
    private final Object _clientThreadsLock = new Object();
    protected final Cache _cache;
    private final ClientHealthMonitorThread _clientMonitor;
    static ClientHealthMonitor _instance;
    private static int refCount;
    protected static final long CLIENT_MONITOR_INTERVAL = 1000L;
    private final CacheClientNotifierStats stats;
    private final HashMap cleanupTable = new HashMap();
    private final HashMap cleanupProxyIdTable = new HashMap();
    AtomicIntegerArray numOfClientsPerVersion = new AtomicIntegerArray(51);
    private final Set<TXId> scheduledToBeRemovedTx = Boolean.getBoolean("gemfire.trackScheduledToBeRemovedTx") ? new ConcurrentHashSet() : null;

    public static ClientHealthMonitor getInstance(Cache cache, int maximumTimeBetweenPings, CacheClientNotifierStats stats) {
        ClientHealthMonitor.createInstance(cache, maximumTimeBetweenPings, stats);
        return _instance;
    }

    public static ClientHealthMonitor getInstance() {
        return _instance;
    }

    public static synchronized void shutdownInstance() {
        --refCount;
        if (_instance == null) {
            return;
        }
        if (refCount > 0) {
            return;
        }
        _instance.shutdown();
        boolean interrupted = false;
        try {
            if (ClientHealthMonitor._instance._clientMonitor != null) {
                ClientHealthMonitor._instance._clientMonitor.join();
            }
        }
        catch (InterruptedException e) {
            interrupted = true;
            if (logger.isDebugEnabled()) {
                logger.debug(":Interrupted joining with the ClientHealthMonitor Thread", (Throwable)e);
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        _instance = null;
        refCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerClient(ClientProxyMembershipID proxyID) {
        boolean registerClient = false;
        Object object = this._clientHeartbeatsLock;
        synchronized (object) {
            Map oldClientHeartbeats = this._clientHeartbeats;
            if (!oldClientHeartbeats.containsKey(proxyID)) {
                HashMap<ClientProxyMembershipID, Long> newClientHeartbeats = new HashMap<ClientProxyMembershipID, Long>(oldClientHeartbeats);
                newClientHeartbeats.put(proxyID, System.currentTimeMillis());
                this._clientHeartbeats = newClientHeartbeats;
                registerClient = true;
            }
        }
        if (registerClient) {
            if (this.stats != null) {
                this.stats.incClientRegisterRequests();
            }
            if (logger.isDebugEnabled()) {
                logger.debug(LocalizedMessage.create(LocalizedStrings.ClientHealthMonitor_CLIENTHEALTHMONITOR_REGISTERING_CLIENT_WITH_MEMBER_ID_0, new Object[]{proxyID}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterClient(ClientProxyMembershipID proxyID, boolean clientDisconnectedCleanly, Throwable clientDisconnectException) {
        boolean unregisterClient = false;
        Object object = this._clientHeartbeatsLock;
        synchronized (object) {
            Map oldClientHeartbeats = this._clientHeartbeats;
            if (oldClientHeartbeats.containsKey(proxyID)) {
                unregisterClient = true;
                HashMap newClientHeartbeats = new HashMap(oldClientHeartbeats);
                newClientHeartbeats.remove(proxyID);
                this._clientHeartbeats = newClientHeartbeats;
            }
        }
        if (unregisterClient) {
            if (clientDisconnectedCleanly) {
                if (logger.isDebugEnabled()) {
                    logger.debug(LocalizedMessage.create(LocalizedStrings.ClientHealthMonitor_CLIENTHEALTHMONITOR_UNREGISTERING_CLIENT_WITH_MEMBER_ID_0, new Object[]{proxyID}));
                }
            } else {
                logger.warn(LocalizedMessage.create(LocalizedStrings.ClientHealthMonitor_CLIENTHEALTHMONITOR_UNREGISTERING_CLIENT_WITH_MEMBER_ID_0_DUE_TO_1, new Object[]{proxyID, clientDisconnectException == null ? "Unknown reason" : clientDisconnectException.getLocalizedMessage()}));
            }
            if (this.stats != null) {
                this.stats.incClientUnRegisterRequests();
            }
            this.expireTXStates(proxyID);
        }
    }

    public void unregisterClient(ClientProxyMembershipID proxyID, AcceptorImpl acceptor, boolean clientDisconnectedCleanly, Throwable clientDisconnectException) {
        CacheClientNotifier ccn;
        this.unregisterClient(proxyID, clientDisconnectedCleanly, clientDisconnectException);
        if (acceptor != null && (ccn = acceptor.getCacheClientNotifier()) != null) {
            try {
                ccn.unregisterClient(proxyID, clientDisconnectedCleanly);
            }
            catch (CancelException cancelException) {
                // empty catch block
            }
        }
    }

    public Set<TXId> getScheduledToBeRemovedTx() {
        return this.scheduledToBeRemovedTx;
    }

    private void expireTXStates(ClientProxyMembershipID proxyID) {
        final TXManagerImpl txMgr = (TXManagerImpl)this._cache.getCacheTransactionManager();
        final Set<TXId> txids = txMgr.getTransactionsForClient((InternalDistributedMember)proxyID.getDistributedMember());
        if (this._cache.isClosed()) {
            return;
        }
        long timeout = txMgr.getTransactionTimeToLive() * 1000;
        if (!txids.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("expiring {} transaction contexts for {} timeout={}", (Object)txids.size(), (Object)proxyID, (Object)(timeout / 1000L));
            }
            if (timeout <= 0L) {
                txMgr.removeTransactions(txids, true);
            } else {
                if (this.scheduledToBeRemovedTx != null) {
                    this.scheduledToBeRemovedTx.addAll(txids);
                }
                SystemTimer.SystemTimerTask task = new SystemTimer.SystemTimerTask(){

                    @Override
                    public void run2() {
                        txMgr.removeTransactions(txids, true);
                        if (ClientHealthMonitor.this.scheduledToBeRemovedTx != null) {
                            ClientHealthMonitor.this.scheduledToBeRemovedTx.removeAll(txids);
                        }
                    }
                };
                ((GemFireCacheImpl)this._cache).getCCPTimer().schedule(task, timeout);
            }
        }
    }

    public void removeAllConnectionsAndUnregisterClient(ClientProxyMembershipID proxyID, Throwable t) {
        this.cleanupClientThreads(proxyID, false);
        this.unregisterClient(proxyID, false, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(ClientProxyMembershipID proxyID, ServerConnection connection) {
        Object object = this._clientThreadsLock;
        synchronized (object) {
            HashSet<ServerConnection> serverConnections = (HashSet<ServerConnection>)this._clientThreads.get(proxyID);
            if (serverConnections == null) {
                serverConnections = new HashSet<ServerConnection>();
                this._clientThreads.put(proxyID, serverConnections);
            }
            serverConnections.add(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(ClientProxyMembershipID proxyID, ServerConnection connection) {
        Object object = this._clientThreadsLock;
        synchronized (object) {
            Set serverConnections = (Set)this._clientThreads.get(proxyID);
            if (serverConnections != null) {
                serverConnections.remove(connection);
                if (serverConnections.isEmpty()) {
                    this._clientThreads.remove(proxyID);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedPing(ClientProxyMembershipID proxyID) {
        if (this._clientMonitor == null) {
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("ClientHealthMonitor: Received ping from client with member id {}", (Object)proxyID);
        }
        Object object = this._clientHeartbeatsLock;
        synchronized (object) {
            if (!this._clientHeartbeats.containsKey(proxyID)) {
                this.registerClient(proxyID);
            } else {
                this._clientHeartbeats.put(proxyID, System.currentTimeMillis());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getConnectedClients(Set filterProxies) {
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        Object object = this._clientThreadsLock;
        synchronized (object) {
            for (Map.Entry entry : this._clientThreads.entrySet()) {
                ClientProxyMembershipID proxyID = (ClientProxyMembershipID)entry.getKey();
                if (filterProxies != null && !filterProxies.contains(proxyID)) continue;
                String membershipID = null;
                Set connections = (Set)entry.getValue();
                int socketPort = 0;
                InetAddress socketAddress = null;
                Iterator serverConnections = connections.iterator();
                if (serverConnections.hasNext()) {
                    ServerConnection sc = (ServerConnection)serverConnections.next();
                    socketPort = sc.getSocketPort();
                    socketAddress = sc.getSocketAddress();
                    membershipID = sc.getMembershipID();
                }
                int connectionCount = connections.size();
                String clientString = null;
                clientString = socketAddress == null ? "client member id=" + membershipID : "host name=" + socketAddress.toString() + " host ip=" + socketAddress.getHostAddress() + " client port=" + socketPort + " client member id=" + membershipID;
                Object[] data = null;
                data = (Object[])map.get(membershipID);
                if (data == null) {
                    map.put(membershipID, new Object[]{clientString, connectionCount});
                    continue;
                }
                data[1] = (Integer)data[1] + connectionCount;
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getStatusForAllClients() {
        HashMap<ClientProxyMembershipID, CacheClientStatus> result = new HashMap<ClientProxyMembershipID, CacheClientStatus>();
        Object object = this._clientThreadsLock;
        synchronized (object) {
            block3: for (Map.Entry entry : this._clientThreads.entrySet()) {
                ClientProxyMembershipID proxyID = (ClientProxyMembershipID)entry.getKey();
                CacheClientStatus cci = new CacheClientStatus(proxyID);
                Set connections = (Set)this._clientThreads.get(proxyID);
                if (connections == null) continue;
                String memberId = null;
                for (ServerConnection sc : connections) {
                    byte communicationMode = sc.getCommunicationMode();
                    if (communicationMode != 100 && communicationMode != 101 && communicationMode != 102 && communicationMode != 107) continue;
                    memberId = sc.getMembershipID();
                    cci.setMemberId(memberId);
                    cci.setNumberOfConnections(connections.size());
                    result.put(proxyID, cci);
                    continue block3;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillInClientInfo(Map allClients) {
        Object object = this._clientThreadsLock;
        synchronized (object) {
            for (Map.Entry entry : allClients.entrySet()) {
                ClientProxyMembershipID proxyID = (ClientProxyMembershipID)entry.getKey();
                CacheClientStatus cci = (CacheClientStatus)entry.getValue();
                Set connections = (Set)this._clientThreads.get(proxyID);
                if (connections == null) continue;
                String memberId = null;
                cci.setNumberOfConnections(connections.size());
                ArrayList<Integer> socketPorts = new ArrayList<Integer>();
                ArrayList<InetAddress> socketAddresses = new ArrayList<InetAddress>();
                for (ServerConnection sc : connections) {
                    socketPorts.add(sc.getSocketPort());
                    socketAddresses.add(sc.getSocketAddress());
                    memberId = sc.getMembershipID();
                }
                cci.setMemberId(memberId);
                cci.setSocketPorts(socketPorts);
                cci.setSocketAddresses(socketAddresses);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getConnectedIncomingGateways() {
        HashMap<String, IncomingGatewayStatus> connectedIncomingGateways = new HashMap<String, IncomingGatewayStatus>();
        Object object = this._clientThreadsLock;
        synchronized (object) {
            for (Map.Entry entry : this._clientThreads.entrySet()) {
                ClientProxyMembershipID proxyID = (ClientProxyMembershipID)entry.getKey();
                Set connections = (Set)entry.getValue();
                for (ServerConnection sc : connections) {
                    if (sc.getCommunicationMode() != 103) continue;
                    IncomingGatewayStatus status = new IncomingGatewayStatus(proxyID.getDSMembership(), sc.getSocketAddress(), sc.getSocketPort());
                    connectedIncomingGateways.put(proxyID.getDSMembership(), status);
                }
            }
        }
        return connectedIncomingGateways;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean cleanupClientThreads(ClientProxyMembershipID proxyID, boolean timedOut) {
        boolean result = false;
        Set serverConnections = null;
        Object object = this._clientThreadsLock;
        synchronized (object) {
            serverConnections = (Set)this._clientThreads.remove(proxyID);
        }
        if (serverConnections != null) {
            result = true;
            for (ServerConnection serverConnection : serverConnections) {
                serverConnection.handleTermination(timedOut);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isAnyThreadProcessingMessage(ClientProxyMembershipID proxyID) {
        boolean processingMessage = false;
        Object object = this._clientThreadsLock;
        synchronized (object) {
            Set serverConnections = (Set)this._clientThreads.get(proxyID);
            if (serverConnections != null) {
                for (ServerConnection serverConnection : serverConnections) {
                    if (!serverConnection.isProcessingMessage()) continue;
                    processingMessage = true;
                    break;
                }
            }
        }
        return processingMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateThreads(ClientProxyMembershipID proxyID) {
        HashSet serverConnections = null;
        Object object = this._clientThreadsLock;
        synchronized (object) {
            serverConnections = (HashSet)this._clientThreads.get(proxyID);
            if (serverConnections != null) {
                serverConnections = new HashSet(serverConnections);
            }
        }
        if (serverConnections != null) {
            for (ServerConnection serverConnection : serverConnections) {
                if (!serverConnection.hasBeenTimedOutOnClient()) continue;
                logger.warn(LocalizedMessage.create(LocalizedStrings.ClientHealtMonitor_0_IS_BEING_TERMINATED_BECAUSE_ITS_CLIENT_TIMEOUT_OF_1_HAS_EXPIRED, new Object[]{serverConnection, serverConnection.getClientReadTimeout()}));
                try {
                    serverConnection.handleTermination(true);
                }
                finally {
                    this.removeConnection(proxyID, serverConnection);
                }
            }
        }
    }

    public Map getClientHeartbeats() {
        return this._clientHeartbeats;
    }

    protected synchronized void shutdown() {
        if (this._clientMonitor != null) {
            this._clientMonitor.stopMonitoring();
        }
    }

    protected static synchronized void createInstance(Cache cache, int maximumTimeBetweenPings, CacheClientNotifierStats stats) {
        ++refCount;
        if (_instance != null) {
            return;
        }
        _instance = new ClientHealthMonitor(cache, maximumTimeBetweenPings, stats);
    }

    private ClientHealthMonitor(Cache cache, int maximumTimeBetweenPings, CacheClientNotifierStats stats) {
        this._cache = cache;
        this._clientThreads = new HashMap();
        if (maximumTimeBetweenPings > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Initializing client health monitor thread", (Object)this);
            }
            this._clientMonitor = new ClientHealthMonitorThread(maximumTimeBetweenPings);
            this._clientMonitor.start();
        } else {
            logger.info(LocalizedMessage.create(LocalizedStrings.ClientHealthMonitor_CLIENT_HEALTH_MONITOR_THREAD_DISABLED_DUE_TO_MAXIMUMTIMEBETWEENPINGS_SETTING__0, maximumTimeBetweenPings));
            this._clientMonitor = null;
        }
        this.stats = stats;
    }

    public String toString() {
        return "ClientHealthMonitor@" + Integer.toHexString(System.identityHashCode(this));
    }

    public Map getCleanupProxyIdTable() {
        return this.cleanupProxyIdTable;
    }

    public Map getCleanupTable() {
        return this.cleanupTable;
    }

    public int getNumberOfClientsAtVersion(Version version) {
        return this.numOfClientsPerVersion.get(version.ordinal());
    }

    public int getNumberOfClientsAtOrAboveVersion(Version version) {
        int number = 0;
        for (int i = version.ordinal(); i < this.numOfClientsPerVersion.length(); ++i) {
            number += this.numOfClientsPerVersion.get(i);
        }
        return number;
    }

    public boolean hasDeltaClients() {
        return this.getNumberOfClientsAtOrAboveVersion(Version.GFE_61) > 0;
    }

    static {
        refCount = 0;
    }

    class ClientHealthMonitorThread
    extends Thread {
        protected final int _maximumTimeBetweenPings;
        protected volatile boolean _isStopped;

        protected ClientHealthMonitorThread(int maximumTimeBetweenPings) {
            super((ThreadGroup)LoggingThreadGroup.createThreadGroup("ClientHealthMonitor Thread Group", logger), "ClientHealthMonitor Thread");
            this._isStopped = false;
            this.setDaemon(true);
            this._maximumTimeBetweenPings = maximumTimeBetweenPings;
            logger.info(LocalizedMessage.create(LocalizedStrings.ClientHealthMonitor_CLIENTHEALTHMONITORTHREAD_MAXIMUM_ALLOWED_TIME_BETWEEN_PINGS_0, this._maximumTimeBetweenPings));
            if (maximumTimeBetweenPings == 0 && logger.isDebugEnabled()) {
                logger.debug("zero ping interval detected", (Throwable)new Exception(LocalizedStrings.ClientHealthMonitor_STACK_TRACE_0.toLocalizedString()));
            }
        }

        protected synchronized void stopMonitoring() {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Stopping monitoring", (Object)ClientHealthMonitor.this);
            }
            this._isStopped = true;
            this.interrupt();
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Stopped dispatching", (Object)ClientHealthMonitor.this);
            }
        }

        protected boolean isStopped() {
            return this._isStopped;
        }

        @Override
        public void run() {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Beginning to monitor clients", (Object)ClientHealthMonitor.this);
            }
            while (!this._isStopped) {
                SystemFailure.checkFailure();
                try {
                    Thread.sleep(1000L);
                    if (logger.isTraceEnabled()) {
                        logger.trace("Monitoring {} client(s)", (Object)ClientHealthMonitor.this.getClientHeartbeats().size());
                    }
                    long currentTime = System.currentTimeMillis();
                    if (logger.isTraceEnabled()) {
                        logger.trace("{} starting sweep at {}", (Object)ClientHealthMonitor.this, (Object)currentTime);
                    }
                    for (Map.Entry entry : ClientHealthMonitor.this.getClientHeartbeats().entrySet()) {
                        ClientProxyMembershipID proxyID = (ClientProxyMembershipID)entry.getKey();
                        ClientHealthMonitor.this.validateThreads(proxyID);
                        Long latestHeartbeatValue = (Long)entry.getValue();
                        if (latestHeartbeatValue == null) continue;
                        long latestHeartbeat = latestHeartbeatValue;
                        if (logger.isTraceEnabled()) {
                            logger.trace("{} ms have elapsed since the latest heartbeat for client with member id {}", (Object)(currentTime - latestHeartbeat), (Object)proxyID);
                        }
                        if (currentTime - latestHeartbeat > (long)this._maximumTimeBetweenPings) {
                            if (ClientHealthMonitor.this.isAnyThreadProcessingMessage(proxyID)) {
                                if (!logger.isDebugEnabled()) continue;
                                logger.debug("Monitoring client with member id {}. It has been {} ms since the latest heartbeat. This client would have been terminated but at least one of its threads is processing a message.", entry.getKey(), (Object)(currentTime - latestHeartbeat));
                                continue;
                            }
                            if (!ClientHealthMonitor.this.cleanupClientThreads(proxyID, true)) continue;
                            logger.warn(LocalizedMessage.create(LocalizedStrings.ClientHealthMonitor_MONITORING_CLIENT_WITH_MEMBER_ID_0_IT_HAD_BEEN_1_MS_SINCE_THE_LATEST_HEARTBEAT_MAX_INTERVAL_IS_2_TERMINATED_CLIENT, new Object[]{entry.getKey(), currentTime - latestHeartbeat, this._maximumTimeBetweenPings}));
                            continue;
                        }
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace("Monitoring client with member id {}. It has been {} ms since the latest heartbeat. This client is healthy.", entry.getKey(), (Object)(currentTime - latestHeartbeat));
                    }
                }
                catch (InterruptedException e) {
                    if (this._isStopped) break;
                    logger.warn(LocalizedMessage.create(LocalizedStrings.ClientHealthMonitor_UNEXPECTED_INTERRUPT_EXITING), (Throwable)e);
                    break;
                }
                catch (Exception e) {
                    if (this._isStopped) continue;
                    logger.fatal(LocalizedMessage.create(LocalizedStrings.ClientHealthMonitor_0_AN_UNEXPECTED_EXCEPTION_OCCURRED, ClientHealthMonitor.this), (Throwable)e);
                }
            }
        }
    }
}

