/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.persistence;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.BucketPersistenceAdvisor;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.ProxyBucketRegion;

public class MembershipFlushRequest
extends PooledDistributionMessage
implements MessageWithReply {
    private String regionPath;
    private int processorId;

    public MembershipFlushRequest() {
    }

    public MembershipFlushRequest(String regionPath, int processorId) {
        this.regionPath = regionPath;
        this.processorId = processorId;
    }

    public static void send(Set<InternalDistributedMember> recipients, DM dm, String regionPath) throws ReplyException {
        ReplyProcessor21 processor = new ReplyProcessor21(dm, recipients);
        MembershipFlushRequest msg = new MembershipFlushRequest(regionPath, processor.getProcessorId());
        msg.setRecipients(recipients);
        dm.putOutgoing(msg);
        processor.waitForRepliesUninterruptibly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(DistributionManager dm) {
        int initLevel = 2;
        int oldLevel = LocalRegion.setThreadInitLevelRequirement(initLevel);
        ReplyException exception = null;
        try {
            ProxyBucketRegion[] proxyBuckets;
            Cache cache = CacheFactory.getInstance(dm.getSystem());
            PartitionedRegion region = (PartitionedRegion)cache.getRegion(this.regionPath);
            if (region != null && region.getRegionAdvisor().isInitialized() && (proxyBuckets = region.getRegionAdvisor().getProxyBucketArray()) != null) {
                for (ProxyBucketRegion bucket : proxyBuckets) {
                    BucketPersistenceAdvisor persistenceAdvisor = bucket.getPersistenceAdvisor();
                    if (persistenceAdvisor == null) continue;
                    persistenceAdvisor.flushMembershipChanges();
                }
            }
        }
        catch (RegionDestroyedException replyMsg) {
        }
        catch (CancelException replyMsg) {
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            exception = new ReplyException(t);
        }
        finally {
            LocalRegion.setThreadInitLevelRequirement(oldLevel);
            ReplyMessage replyMsg = new ReplyMessage();
            replyMsg.setRecipient(this.getSender());
            replyMsg.setProcessorId(this.processorId);
            if (exception != null) {
                replyMsg.setException(exception);
            }
            dm.putOutgoing(replyMsg);
        }
    }

    @Override
    public int getDSFID() {
        return 2110;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.processorId = in.readInt();
        this.regionPath = DataSerializer.readString(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.processorId);
        DataSerializer.writeString(this.regionPath, out);
    }
}

