/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.locks;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;

public class TXLockToken
implements DataSerializable {
    private static final long serialVersionUID = 8172108573123093776L;
    private String regionFullPath;
    private Object name;

    public TXLockToken(String regionFullPath, Object name) {
        this.regionFullPath = regionFullPath;
        this.name = name;
    }

    public int hashCode() {
        int result = 17;
        int mult = 37;
        result = 37 * result + (this.regionFullPath == null ? 0 : this.regionFullPath.hashCode());
        result = 37 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof TXLockToken)) {
            return false;
        }
        TXLockToken that = (TXLockToken)other;
        if (!StringUtils.equals(this.regionFullPath, that.regionFullPath)) {
            return false;
        }
        return this.name == that.name || this.name != null && this.name.equals(that.name);
    }

    public String toString() {
        return "[TXLockToken: " + this.regionFullPath + "//" + this.name + "]";
    }

    public TXLockToken() {
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.regionFullPath = DataSerializer.readString(in);
        this.name = DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString(this.regionFullPath, out);
        DataSerializer.writeObject(this.name, out);
    }
}

