/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.execute;

import java.util.Set;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.execute.BucketMovedException;
import org.apache.geode.internal.cache.execute.FunctionStats;
import org.apache.geode.internal.cache.execute.InternalFunctionException;
import org.apache.geode.internal.cache.execute.InternalResultSender;
import org.apache.geode.internal.cache.execute.LocalResultCollector;
import org.apache.geode.internal.cache.execute.ServerToClientFunctionResultSender;
import org.apache.geode.internal.cache.partitioned.PartitionedRegionFunctionStreamingMessage;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;

public final class PartitionedRegionFunctionResultSender
implements InternalResultSender {
    private static final Logger logger = LogService.getLogger();
    PartitionedRegionFunctionStreamingMessage msg = null;
    private final DM dm;
    private final PartitionedRegion pr;
    private final long time;
    private final boolean forwardExceptions;
    private ResultCollector rc;
    private ServerToClientFunctionResultSender serverSender;
    private boolean localLastResultRecieved = false;
    private boolean onlyLocal = false;
    private boolean onlyRemote = false;
    private boolean completelyDoneFromRemote = false;
    private final Function function;
    private boolean enableOrderedResultStreming;
    private Set<Integer> bucketSet;
    private BucketMovedException bme;

    public PartitionedRegionFunctionResultSender(DM dm, PartitionedRegion pr, long time, PartitionedRegionFunctionStreamingMessage msg, Function function, Set<Integer> bucketSet) {
        this.msg = msg;
        this.dm = dm;
        this.pr = pr;
        this.time = time;
        this.function = function;
        this.bucketSet = bucketSet;
        this.forwardExceptions = false;
    }

    public PartitionedRegionFunctionResultSender(DM dm, PartitionedRegion partitionedRegion, long time, ResultCollector rc, ServerToClientFunctionResultSender sender, boolean onlyLocal, boolean onlyRemote, boolean forwardExceptions, Function function, Set<Integer> bucketSet) {
        this.dm = dm;
        this.pr = partitionedRegion;
        this.time = time;
        this.rc = rc;
        this.serverSender = sender;
        this.onlyLocal = onlyLocal;
        this.onlyRemote = onlyRemote;
        this.forwardExceptions = forwardExceptions;
        this.function = function;
        this.bucketSet = bucketSet;
    }

    private void checkForBucketMovement(Object oneResult) {
        if (!(this.forwardExceptions && oneResult instanceof Throwable || this.pr.getDataStore().areAllBucketsHosted(this.bucketSet))) {
            this.bme = new BucketMovedException(LocalizedStrings.FunctionService_BUCKET_MIGRATED_TO_ANOTHER_NODE.toLocalizedString());
            if (this.function.isHA()) {
                throw this.bme;
            }
        }
    }

    @Override
    public void lastResult(Object oneResult) {
        if (!this.function.hasResult()) {
            throw new IllegalStateException(LocalizedStrings.ExecuteFunction_CANNOT_0_RESULTS_HASRESULT_FALSE.toLocalizedString("send"));
        }
        if (this.serverSender != null) {
            if (this.localLastResultRecieved) {
                return;
            }
            if (this.onlyLocal) {
                this.checkForBucketMovement(oneResult);
                if (this.bme != null) {
                    this.clientSend(oneResult, this.dm.getDistributionManagerId());
                    this.lastClientSend(this.dm.getDistributionManagerId(), this.bme);
                } else {
                    this.lastClientSend(this.dm.getDistributionManagerId(), oneResult);
                }
                this.rc.endResults();
                this.localLastResultRecieved = true;
            } else {
                this.lastResult(oneResult, this.rc, false, true, this.dm.getDistributionManagerId());
            }
        } else {
            if (this.msg != null) {
                this.checkForBucketMovement(oneResult);
                try {
                    if (this.bme != null) {
                        this.msg.sendReplyForOneResult(this.dm, this.pr, this.time, oneResult, false, this.enableOrderedResultStreming);
                        throw this.bme;
                    }
                    this.msg.sendReplyForOneResult(this.dm, this.pr, this.time, oneResult, true, this.enableOrderedResultStreming);
                }
                catch (ForceReattemptException e) {
                    throw new FunctionException(e);
                }
                catch (InterruptedException e) {
                    throw new FunctionException(e);
                }
            } else {
                if (this.localLastResultRecieved) {
                    return;
                }
                if (this.onlyLocal) {
                    this.checkForBucketMovement(oneResult);
                    if (this.bme != null) {
                        this.rc.addResult(this.dm.getDistributionManagerId(), oneResult);
                        this.rc.addResult(this.dm.getDistributionManagerId(), this.bme);
                    } else {
                        this.rc.addResult(this.dm.getDistributionManagerId(), oneResult);
                    }
                    this.rc.endResults();
                    this.localLastResultRecieved = true;
                } else {
                    this.lastResult(oneResult, this.rc, false, true, this.dm.getDistributionManagerId());
                }
                FunctionStats.getFunctionStats(this.function.getId(), this.dm.getSystem()).incResultsReceived();
            }
            FunctionStats.getFunctionStats(this.function.getId(), this.dm.getSystem()).incResultsReturned();
        }
    }

    private synchronized void lastResult(Object oneResult, ResultCollector collector, boolean lastRemoteResult, boolean lastLocalResult, DistributedMember memberID) {
        if (lastRemoteResult) {
            this.completelyDoneFromRemote = true;
        }
        if (lastLocalResult) {
            this.localLastResultRecieved = true;
        }
        if (this.serverSender != null) {
            if (this.completelyDoneFromRemote && this.localLastResultRecieved) {
                if (lastLocalResult) {
                    this.checkForBucketMovement(oneResult);
                    if (this.bme != null) {
                        this.clientSend(oneResult, this.dm.getDistributionManagerId());
                        this.lastClientSend(this.dm.getDistributionManagerId(), this.bme);
                    } else {
                        this.lastClientSend(memberID, oneResult);
                    }
                } else {
                    this.lastClientSend(memberID, oneResult);
                }
                collector.endResults();
            } else if (lastLocalResult) {
                this.checkForBucketMovement(oneResult);
                if (this.bme != null) {
                    this.clientSend(oneResult, memberID);
                    this.clientSend(this.bme, memberID);
                } else {
                    this.clientSend(oneResult, memberID);
                }
            } else {
                this.clientSend(oneResult, memberID);
            }
        } else if (this.completelyDoneFromRemote && this.localLastResultRecieved) {
            if (lastLocalResult) {
                this.checkForBucketMovement(oneResult);
                if (this.bme != null) {
                    collector.addResult(memberID, oneResult);
                    collector.addResult(memberID, this.bme);
                } else {
                    collector.addResult(memberID, oneResult);
                }
            } else {
                collector.addResult(memberID, oneResult);
            }
            collector.endResults();
        } else if (lastLocalResult) {
            this.checkForBucketMovement(oneResult);
            if (this.bme != null) {
                collector.addResult(memberID, oneResult);
                collector.addResult(memberID, this.bme);
            } else {
                collector.addResult(memberID, oneResult);
            }
        } else {
            collector.addResult(memberID, oneResult);
        }
    }

    public synchronized void lastResult(Object oneResult, boolean completelyDoneFromRemote, ResultCollector reply, DistributedMember memberID) {
        logger.debug("PartitionedRegionFunctionResultSender Sending lastResult {}", oneResult);
        if (this.serverSender != null) {
            if (completelyDoneFromRemote) {
                if (this.onlyRemote) {
                    this.lastClientSend(memberID, oneResult);
                    reply.endResults();
                } else {
                    this.lastResult(oneResult, reply, true, false, memberID);
                }
            } else {
                this.clientSend(oneResult, memberID);
            }
        } else {
            if (completelyDoneFromRemote) {
                if (this.onlyRemote) {
                    reply.addResult(memberID, oneResult);
                    reply.endResults();
                } else {
                    this.lastResult(oneResult, reply, true, false, memberID);
                }
            } else {
                reply.addResult(memberID, oneResult);
            }
            if (this.dm == null) {
                FunctionStats.getFunctionStats(this.function.getId()).incResultsReceived();
            } else {
                FunctionStats.getFunctionStats(this.function.getId(), this.dm.getSystem()).incResultsReceived();
            }
        }
        if (this.dm == null) {
            FunctionStats.getFunctionStats(this.function.getId()).incResultsReturned();
        } else {
            FunctionStats.getFunctionStats(this.function.getId(), this.dm.getSystem()).incResultsReturned();
        }
    }

    @Override
    public void sendResult(Object oneResult) {
        if (!this.function.hasResult()) {
            throw new IllegalStateException(LocalizedStrings.ExecuteFunction_CANNOT_0_RESULTS_HASRESULT_FALSE.toLocalizedString("send"));
        }
        if (this.serverSender != null) {
            logger.debug("PartitionedRegionFunctionResultSender sending result from local node to client {}", oneResult);
            this.clientSend(oneResult, this.dm.getDistributionManagerId());
        } else {
            if (this.msg != null) {
                try {
                    logger.debug("PartitionedRegionFunctionResultSender sending result from remote node {}", oneResult);
                    this.msg.sendReplyForOneResult(this.dm, this.pr, this.time, oneResult, false, this.enableOrderedResultStreming);
                }
                catch (ForceReattemptException e) {
                    throw new FunctionException(e);
                }
                catch (InterruptedException e) {
                    throw new FunctionException(e);
                }
            } else {
                logger.debug("PartitionedRegionFunctionResultSender adding result to ResultCollector on local node {}", oneResult);
                this.rc.addResult(this.dm.getDistributionManagerId(), oneResult);
                FunctionStats.getFunctionStats(this.function.getId(), this.dm.getSystem()).incResultsReceived();
            }
            FunctionStats.getFunctionStats(this.function.getId(), this.dm.getSystem()).incResultsReturned();
        }
    }

    private void clientSend(Object oneResult, DistributedMember memberID) {
        this.serverSender.sendResult(oneResult, memberID);
    }

    private void lastClientSend(DistributedMember memberID, Object lastResult) {
        this.serverSender.lastResult(lastResult, memberID);
    }

    @Override
    public void sendException(Throwable exception) {
        InternalFunctionException iFunxtionException = new InternalFunctionException(exception);
        this.lastResult(iFunxtionException);
        this.localLastResultRecieved = true;
    }

    @Override
    public void setException(Throwable exception) {
        if (this.serverSender != null) {
            this.serverSender.setException(exception);
        } else {
            ((LocalResultCollector)this.rc).setException(exception);
            logger.info(LocalizedMessage.create(LocalizedStrings.PartitionedRegionFunctionResultSender_UNEXPECTED_EXCEPTION_DURING_FUNCTION_EXECUTION_ON_LOCAL_NODE), exception);
        }
        this.rc.endResults();
        this.localLastResultRecieved = true;
    }

    @Override
    public void enableOrderedResultStreming(boolean enable) {
        this.enableOrderedResultStreming = enable;
    }

    @Override
    public boolean isLocallyExecuted() {
        return this.msg == null;
    }

    @Override
    public boolean isLastResultReceived() {
        return this.localLastResultRecieved;
    }
}

