/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.UUID;
import org.apache.geode.internal.cache.InlineKeyHelper;
import org.apache.geode.internal.cache.OffHeapRegionEntry;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.VersionedThinDiskRegionEntry;
import org.apache.geode.internal.cache.VersionedThinDiskRegionEntryHeap;
import org.apache.geode.internal.cache.VersionedThinDiskRegionEntryOffHeapIntKey;
import org.apache.geode.internal.cache.VersionedThinDiskRegionEntryOffHeapLongKey;
import org.apache.geode.internal.cache.VersionedThinDiskRegionEntryOffHeapObjectKey;
import org.apache.geode.internal.cache.VersionedThinDiskRegionEntryOffHeapStringKey1;
import org.apache.geode.internal.cache.VersionedThinDiskRegionEntryOffHeapStringKey2;
import org.apache.geode.internal.cache.VersionedThinDiskRegionEntryOffHeapUUIDKey;

public abstract class VersionedThinDiskRegionEntryOffHeap
extends VersionedThinDiskRegionEntry
implements OffHeapRegionEntry {
    private static final VersionedThinDiskRegionEntryOffHeapFactory factory = new VersionedThinDiskRegionEntryOffHeapFactory();

    public VersionedThinDiskRegionEntryOffHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedThinDiskRegionEntryOffHeapFactory
    implements RegionEntryFactory {
        private VersionedThinDiskRegionEntryOffHeapFactory() {
        }

        @Override
        public final RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedThinDiskRegionEntryOffHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VersionedThinDiskRegionEntryOffHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedThinDiskRegionEntryOffHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VersionedThinDiskRegionEntryOffHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedThinDiskRegionEntryOffHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VersionedThinDiskRegionEntryOffHeapObjectKey(context, key, value);
        }

        @Override
        public final Class getEntryClass() {
            return VersionedThinDiskRegionEntryOffHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return VersionedThinDiskRegionEntryHeap.getEntryFactory();
        }
    }
}

