/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.geode.CancelCriterion;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionService;
import org.apache.geode.cache.persistence.PartitionOfflineException;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionAdvisee;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.BucketAdvisor;
import org.apache.geode.internal.cache.BucketPersistenceAdvisor;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.CacheDistributionAdvisor;
import org.apache.geode.internal.cache.ColocationHelper;
import org.apache.geode.internal.cache.DiskInitFile;
import org.apache.geode.internal.cache.DiskRegion;
import org.apache.geode.internal.cache.DiskRegionStats;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.FixedPartitionAttributesImpl;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionBucketMgmtHelper;
import org.apache.geode.internal.cache.PartitionedRegionDataStore;
import org.apache.geode.internal.cache.partitioned.Bucket;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.cache.persistence.PersistentMemberManager;
import org.apache.geode.internal.cache.persistence.PersistentMembershipView;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public final class ProxyBucketRegion
implements Bucket {
    private static final Logger logger = LogService.getLogger();
    private final int serialNumber;
    private final int bid;
    private final PartitionedRegion partitionedRegion;
    private final BucketAdvisor advisor;
    private final BucketPersistenceAdvisor persistenceAdvisor;
    private volatile BucketRegion realBucket = null;
    private final AtomicBoolean bucketSick = new AtomicBoolean(false);
    private final Set<DistributedMember> sickHosts = new HashSet<DistributedMember>();
    private final DiskRegion diskRegion;
    private final PartitionedRegion.BucketLock bucketLock;
    public static final String NO_FIXED_PARTITION_NAME = "NO_PARTITION";

    public ProxyBucketRegion(int bid, PartitionedRegion partitionedRegion, InternalRegionArguments internalRegionArgs) {
        this.serialNumber = DistributionAdvisor.createSerialNumber();
        this.bid = bid;
        this.partitionedRegion = partitionedRegion;
        this.advisor = BucketAdvisor.createBucketAdvisor(this, internalRegionArgs.getPartitionedRegionAdvisor());
        this.bucketLock = this.partitionedRegion.getBucketLock(this.bid);
        if (this.partitionedRegion.getDataPolicy().withPersistence()) {
            String regionPath = this.getFullPath();
            PersistentMemberManager memberManager = partitionedRegion.getGemFireCache().getPersistentMemberManager();
            DiskRegionStats diskStats = partitionedRegion.getDiskRegionStats();
            DistributedLockService dl = partitionedRegion.getGemFireCache().getPartitionedRegionLockService();
            DiskStoreImpl ds = partitionedRegion.getDiskStore();
            EvictionAttributes ea = partitionedRegion.getAttributes().getEvictionAttributes();
            EnumSet<DiskInitFile.DiskRegionFlag> diskFlags = EnumSet.noneOf(DiskInitFile.DiskRegionFlag.class);
            if (partitionedRegion.getConcurrencyChecksEnabled()) {
                diskFlags.add(DiskInitFile.DiskRegionFlag.IS_WITH_VERSIONING);
            }
            boolean overflowEnabled = ea != null && ea.getAction().isOverflowToDisk();
            int startingBucketID = -1;
            String partitionName = NO_FIXED_PARTITION_NAME;
            List<FixedPartitionAttributesImpl> fpaList = partitionedRegion.getFixedPartitionAttributesImpl();
            if (fpaList != null) {
                for (FixedPartitionAttributesImpl fpa : fpaList) {
                    if (!fpa.hasBucket(bid)) continue;
                    startingBucketID = fpa.getStartingBucketID();
                    partitionName = fpa.getPartitionName();
                    break;
                }
            }
            this.diskRegion = DiskRegion.create(ds, regionPath, true, partitionedRegion.getPersistBackup(), overflowEnabled, partitionedRegion.isDiskSynchronous(), partitionedRegion.getDiskRegionStats(), partitionedRegion.getCancelCriterion(), partitionedRegion, partitionedRegion.getAttributes(), diskFlags, partitionName, startingBucketID, partitionedRegion.getCompressor(), partitionedRegion.getOffHeap());
            if (fpaList != null) {
                for (FixedPartitionAttributesImpl fpa : fpaList) {
                    if (!fpa.getPartitionName().equals(this.diskRegion.getPartitionName()) || this.diskRegion.getStartingBucketId() == -1) continue;
                    fpa.setStartingBucketID(this.diskRegion.getStartingBucketId());
                    partitionedRegion.getPartitionsMap().put(fpa.getPartitionName(), new Integer[]{fpa.getStartingBucketID(), fpa.getNumBuckets()});
                }
            }
            this.persistenceAdvisor = new BucketPersistenceAdvisor(this.advisor, dl, this.diskRegion, regionPath, diskStats, memberManager, this.bucketLock, this);
        } else {
            this.diskRegion = null;
            this.persistenceAdvisor = null;
        }
    }

    @Override
    public CancelCriterion getCancelCriterion() {
        return this.partitionedRegion.getCache().getCancelCriterion();
    }

    public void close() {
        if (this.persistenceAdvisor != null) {
            this.persistenceAdvisor.close();
        }
        this.advisor.closeAdvisor();
        if (this.diskRegion != null) {
            this.diskRegion.close(null);
        }
    }

    @Override
    public int getSerialNumber() {
        return this.serialNumber;
    }

    @Override
    public DM getDistributionManager() {
        return this.getSystem().getDistributionManager();
    }

    @Override
    public DistributionAdvisor getDistributionAdvisor() {
        return this.advisor;
    }

    @Override
    public CacheDistributionAdvisor getCacheDistributionAdvisor() {
        return this.advisor;
    }

    @Override
    public DistributionAdvisor.Profile getProfile() {
        return this.advisor.createProfile();
    }

    @Override
    public DistributionAdvisee getParentAdvisee() {
        return this.partitionedRegion;
    }

    @Override
    public PartitionedRegion getPartitionedRegion() {
        return this.partitionedRegion;
    }

    @Override
    public InternalDistributedSystem getSystem() {
        return this.partitionedRegion.getCache().getDistributedSystem();
    }

    @Override
    public String getName() {
        return this.getPartitionedRegion().getBucketName(this.bid);
    }

    @Override
    public String getFullPath() {
        return "/__PR/" + this.getPartitionedRegion().getBucketName(this.bid);
    }

    @Override
    public GemFireCacheImpl getCache() {
        return this.partitionedRegion.getCache();
    }

    public RegionService getCacheView() {
        return this.partitionedRegion.getRegionService();
    }

    @Override
    public RegionAttributes getAttributes() {
        return this.partitionedRegion.getAttributes();
    }

    @Override
    public final BucketAdvisor getBucketAdvisor() {
        return this.advisor;
    }

    public void setBucketRegion(BucketRegion br) {
        Assert.assertTrue(this.realBucket == null);
        Assert.assertTrue(!this.advisor.isHosting());
        this.realBucket = br;
        this.partitionedRegion.checkReadiness();
        this.partitionedRegion.checkClosed();
    }

    public void clearBucketRegion(BucketRegion br) {
        Assert.assertTrue(this.realBucket == br);
        this.realBucket = null;
    }

    public void setHosting(boolean value) {
        if (value) {
            PartitionedRegion region = this.getPartitionedRegion();
            Assert.assertTrue(this.realBucket != null);
            Assert.assertTrue(!this.advisor.isHosting());
            if (region.isFixedPartitionedRegion()) {
                List<FixedPartitionAttributesImpl> list = region.getFixedPartitionAttributesImpl();
                if (list != null) {
                    for (FixedPartitionAttributesImpl info : list) {
                        if (!info.hasBucket(this.bid)) continue;
                        this.advisor.setHosting(true);
                        break;
                    }
                }
            } else {
                this.advisor.setHosting(true);
            }
        } else {
            this.advisor.setHosting(false);
            this.realBucket = null;
        }
    }

    public void removeBucket() {
        this.realBucket.removeFromPeersAdvisors(true);
        this.advisor.removeBucket();
        this.realBucket = null;
    }

    public int getBucketRedundancy() {
        return this.getBucketAdvisor().getBucketRedundancy();
    }

    @Override
    public boolean isPrimary() {
        return this.advisor.isPrimary();
    }

    public BucketRegion getCreatedBucketRegion() {
        return this.realBucket;
    }

    public BucketRegion getHostedBucketRegion() {
        if (this.advisor.isHosting()) {
            return this.realBucket;
        }
        return null;
    }

    @Override
    public boolean isHosting() {
        return this.advisor.isHosting();
    }

    @Override
    public void fillInProfile(DistributionAdvisor.Profile profile) {
        BucketRegion bucket;
        if (logger.isDebugEnabled()) {
            logger.debug("ProxyBucketRegion filling in profile: {}", (Object)profile);
        }
        if ((bucket = this.realBucket) != null) {
            bucket.fillInProfile(profile);
        }
    }

    public ProxyBucketRegion initialize() {
        this.advisor.setInitialized();
        return this;
    }

    @Override
    public Set<InternalDistributedMember> getBucketOwners() {
        Set<InternalDistributedMember> s = this.advisor.adviseInitialized();
        if (s == Collections.emptySet()) {
            s = new HashSet<InternalDistributedMember>();
        }
        if (this.isHosting()) {
            s.add(this.partitionedRegion.getDistributionManager().getId());
        }
        return s;
    }

    public int getBucketOwnersCount() {
        return this.advisor.getBucketRedundancy() + 1;
    }

    public final int getBucketId() {
        return this.bid;
    }

    @Override
    public final int getId() {
        return this.getBucketId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBucketSick(DistributedMember member, boolean sick) {
        Set<DistributedMember> set = this.sickHosts;
        synchronized (set) {
            if (sick) {
                this.sickHosts.add(member);
            } else {
                this.sickHosts.remove(member);
            }
            this.bucketSick.set(this.sickHosts.size() > 0);
        }
    }

    public boolean isBucketSick() {
        return this.bucketSick.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DistributedMember> getSickMembers() {
        Set<DistributedMember> set = this.sickHosts;
        synchronized (set) {
            return Collections.unmodifiableSet(new HashSet<DistributedMember>(this.sickHosts));
        }
    }

    public void recoverFromDiskRecursively() {
        this.recoverFromDisk();
        List<PartitionedRegion> colocatedWithList = ColocationHelper.getColocatedChildRegions(this.partitionedRegion);
        for (PartitionedRegion childPR : colocatedWithList) {
            ProxyBucketRegion[] childBucketArray;
            if (!childPR.getDataPolicy().withPersistence() || (childBucketArray = childPR.getRegionAdvisor().getProxyBucketArray()) == null) continue;
            ProxyBucketRegion childBucket = childBucketArray[this.getBucketId()];
            childBucket.recoverFromDisk();
        }
    }

    public void recoverFromDisk() {
        boolean isDebugEnabled = logger.isDebugEnabled();
        RuntimeException exception = null;
        if (isDebugEnabled) {
            logger.debug("{} coming to recover from disk. wasHosting {}", (Object)this.getFullPath(), (Object)this.persistenceAdvisor.wasHosting());
        }
        try {
            if (this.persistenceAdvisor.wasHosting()) {
                PartitionedRegionDataStore.CreateBucketResult result;
                if (isDebugEnabled) {
                    logger.debug("{} used to host data. Attempting to recover.", (Object)this.getFullPath());
                }
                if (this.hasPersistentChildRegion()) {
                    result = this.partitionedRegion.getDataStore().grabBucket(this.bid, this.getDistributionManager().getDistributionManagerId(), true, true, false, null, true);
                } else if (this.partitionedRegion.isShadowPR() && this.partitionedRegion.getColocatedWith() != null) {
                    PartitionedRegion colocatedRegion = ColocationHelper.getColocatedRegion(this.partitionedRegion);
                    if (this.partitionedRegion.getDataPolicy().withPersistence() && !colocatedRegion.getDataPolicy().withPersistence()) {
                        result = colocatedRegion.getDataStore().grabBucket(this.bid, this.getDistributionManager().getDistributionManagerId(), true, true, false, null, true);
                        if (result.nowExists()) {
                            result = this.partitionedRegion.getDataStore().grabBucket(this.bid, null, true, false, false, null, true);
                        }
                    } else {
                        result = this.partitionedRegion.getDataStore().grabBucket(this.bid, null, true, false, false, null, true);
                    }
                } else {
                    result = this.partitionedRegion.getDataStore().grabBucket(this.bid, null, true, false, false, null, true);
                }
                if (result.nowExists()) {
                    return;
                }
                if (result != PartitionedRegionDataStore.CreateBucketResult.REDUNDANCY_ALREADY_SATISFIED) {
                    this.partitionedRegion.checkReadiness();
                    throw new InternalGemFireError("Unable to restore the persistent bucket " + this.getName());
                }
                if (isDebugEnabled) {
                    logger.debug("{} redundancy is already satisfied, so discarding persisted data. Current hosts {}", (Object)this.getFullPath(), (Object)this.advisor.adviseReplicates());
                }
                this.destroyOfflineData();
            }
            if (isDebugEnabled) {
                logger.debug("{} initializing membership view from peers", (Object)this.getFullPath());
            }
            this.persistenceAdvisor.initializeMembershipView();
        }
        catch (RuntimeException e) {
            exception = e;
            throw e;
        }
        finally {
            this.persistenceAdvisor.recoveryDone(exception);
        }
    }

    boolean hasPersistentChildRegion() {
        boolean hasPersistentChildRegion = ColocationHelper.hasPersistentChildRegion(this.partitionedRegion);
        return hasPersistentChildRegion;
    }

    public void destroyOfflineData() {
        Map<InternalDistributedMember, PersistentMemberID> onlineMembers = this.advisor.adviseInitializedPersistentMembers();
        this.persistenceAdvisor.checkMyStateOnMembers(onlineMembers.keySet());
        this.diskRegion.beginDestroyDataStorage();
        this.persistenceAdvisor.finishPendingDestroy();
        if (logger.isDebugEnabled()) {
            logger.debug("destroyed persistent data for {}" + this.getFullPath());
        }
    }

    @Override
    public BucketPersistenceAdvisor getPersistenceAdvisor() {
        return this.persistenceAdvisor;
    }

    @Override
    public DiskRegion getDiskRegion() {
        return this.diskRegion;
    }

    public void finishRemoveBucket() {
        if (this.persistenceAdvisor != null) {
            this.persistenceAdvisor.bucketRemoved();
        }
    }

    public PartitionedRegion.BucketLock getBucketLock() {
        return this.bucketLock;
    }

    public void initializePersistenceAdvisor() {
        this.persistenceAdvisor.initialize();
        List<PartitionedRegion> colocatedWithList = ColocationHelper.getColocatedChildRegions(this.partitionedRegion);
        for (PartitionedRegion childPR : colocatedWithList) {
            ProxyBucketRegion[] childBucketArray = childPR.getRegionAdvisor().getProxyBucketArray();
            if (childBucketArray == null) continue;
            ProxyBucketRegion childBucket = childBucketArray[this.getBucketId()];
            if (childBucket.persistenceAdvisor == null) continue;
            childBucket.persistenceAdvisor.initialize();
        }
    }

    public boolean checkBucketRedundancyBeforeGrab(InternalDistributedMember moveSource, boolean replaceOfflineData) {
        BucketPersistenceAdvisor persistAdvisor;
        int redundancy = this.getBucketAdvisor().getBucketRedundancy();
        PartitionedRegion colocatedRegion = ColocationHelper.getColocatedRegion(this.partitionedRegion);
        if (colocatedRegion != null) {
            return true;
        }
        if (!(replaceOfflineData && redundancy != -1 || (persistAdvisor = this.getPersistenceAdvisor()) == null || persistAdvisor.wasHosting() || !this.advisor.getHadPrimary())) {
            PersistentMembershipView membershipView = persistAdvisor.getMembershipView();
            if (membershipView == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("grabFreeBucket: Can't create bucket because persistence is not yet initialized {}{}{}", (Object)this.partitionedRegion.getPRId(), (Object)":", (Object)this.bid);
                }
                return false;
            }
            Set<PersistentMemberID> offlineMembers = membershipView.getOfflineMembers();
            if (logger.isDebugEnabled()) {
                logger.debug("We didn't host the bucket. Checking redundancy level before creating the bucket. Redundancy={} offline members={}", (Object)redundancy, (Object)offlineMembers);
            }
            if (offlineMembers != null && !offlineMembers.isEmpty() && redundancy == -1) {
                String message = LocalizedStrings.PartitionedRegionDataStore_DATA_OFFLINE_MESSAGE.toLocalizedString(this.partitionedRegion.getFullPath(), this.bid, offlineMembers);
                throw new PartitionOfflineException(offlineMembers, message);
            }
            if (offlineMembers != null) {
                redundancy += offlineMembers.size();
            }
        }
        if (moveSource == null && redundancy >= this.partitionedRegion.getRedundantCopies()) {
            if (logger.isDebugEnabled()) {
                logger.debug("grabFreeBucket: Bucket already meets redundancy level bucketId={}{}{}", (Object)this.partitionedRegion.getPRId(), (Object)":", (Object)this.bid);
            }
            return false;
        }
        if (!PartitionedRegionBucketMgmtHelper.bucketIsAllowedOnThisHost(this, moveSource)) {
            if (logger.isDebugEnabled()) {
                logger.debug("grabFreeBucket: Bucket can't be recovered because we're enforcing that the bucket host must be unique {}{}{}", (Object)this.partitionedRegion.getPRId(), (Object)":", (Object)this.bid);
            }
            return false;
        }
        return true;
    }

    public void waitForPrimaryPersistentRecovery() {
        this.persistenceAdvisor.waitForPrimaryPersistentRecovery();
    }

    public void initializePrimaryElector(InternalDistributedMember creationRequestor) {
        this.advisor.initializePrimaryElector(creationRequestor);
        if (this.persistenceAdvisor != null) {
            this.persistenceAdvisor.setAtomicCreation(creationRequestor != null);
        }
    }

    public void clearPrimaryElector() {
        if (this.persistenceAdvisor != null) {
            this.persistenceAdvisor.setAtomicCreation(false);
        }
    }

    @Override
    public void remoteRegionInitialized(CacheDistributionAdvisor.CacheProfile profile) {
    }
}

