/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.ExternalizableDSFID;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.Version;

public final class Node
extends ExternalizableDSFID {
    private InternalDistributedMember memberId;
    public static final int NONE = 0;
    public static final int ACCESSOR = 1;
    public static final int DATASTORE = 2;
    public static final int ACCESSOR_DATASTORE = 3;
    public static final int FIXED_PR_ACCESSOR = 4;
    public static final int FIXED_PR_DATASTORE = 5;
    private int prType = 0;
    private boolean isPersistent = false;
    private byte cacheLoaderWriterByte;
    private int serialNumber;

    public Node(InternalDistributedMember id, int serialNumber) {
        this.memberId = id;
        this.serialNumber = serialNumber;
    }

    public Node(Node node) {
        this.memberId = node.getMemberId();
        this.serialNumber = node.serialNumber;
    }

    public Node(DataInput in) throws IOException, ClassNotFoundException {
        this.fromData(in);
    }

    public Node() {
    }

    public InternalDistributedMember getMemberId() {
        return this.memberId;
    }

    public boolean isPersistent() {
        return this.isPersistent;
    }

    public void setPersistence(boolean isPersistent) {
        this.isPersistent = isPersistent;
    }

    public String toString() {
        return "Node=[memberId=" + this.memberId + "; prType=" + this.prType + "; isPersistent=" + this.isPersistent + "]";
    }

    public int hashCode() {
        return this.memberId.hashCode() + 31 * this.serialNumber;
    }

    public int getPRType() {
        return this.prType;
    }

    public void setPRType(int type) {
        this.prType = type;
    }

    public void setLoaderWriterByte(byte b) {
        this.cacheLoaderWriterByte = b;
    }

    public boolean isCacheLoaderAttached() {
        return this.cacheLoaderWriterByte == 1 || this.cacheLoaderWriterByte == 3;
    }

    public boolean isCacheWriterAttached() {
        return this.cacheLoaderWriterByte == 2 || this.cacheLoaderWriterByte == 3;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Node) {
            Node n = (Node)obj;
            if (this.memberId.equals(n.memberId) && this.serialNumber == n.serialNumber) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getDSFID() {
        return 126;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        InternalDataSerializer.invokeToData(this.memberId, out);
        out.writeInt(this.prType);
        out.writeBoolean(this.isPersistent);
        out.writeByte(this.cacheLoaderWriterByte);
        out.writeInt(this.serialNumber);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.memberId = new InternalDistributedMember();
        InternalDataSerializer.invokeFromData(this.memberId, in);
        this.prType = in.readInt();
        this.isPersistent = in.readBoolean();
        this.cacheLoaderWriterByte = in.readByte();
        this.serialNumber = in.readInt();
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }
}

