/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.Collections;
import java.util.Set;
import org.apache.geode.cache.Cache;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReliableReplyProcessor21;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.TXId;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXMessage;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class JtaBeforeCompletionMessage
extends TXMessage {
    private static final Logger logger = LogService.getLogger();

    public JtaBeforeCompletionMessage() {
    }

    public JtaBeforeCompletionMessage(int txUniqId, InternalDistributedMember onBehalfOfClientMember, ReplyProcessor21 processor) {
        super(txUniqId, onBehalfOfClientMember, processor);
    }

    public static ReliableReplyProcessor21 send(Cache cache, int txUniqId, InternalDistributedMember onBehalfOfClientMember, DistributedMember recipient) {
        InternalDistributedSystem system = (InternalDistributedSystem)cache.getDistributedSystem();
        Set<DistributedMember> recipients = Collections.singleton(recipient);
        ReliableReplyProcessor21 response = new ReliableReplyProcessor21(system, recipients);
        JtaBeforeCompletionMessage msg = new JtaBeforeCompletionMessage(txUniqId, onBehalfOfClientMember, response);
        msg.setRecipients(recipients);
        system.getDistributionManager().putOutgoing(msg);
        return response;
    }

    @Override
    protected boolean operateOnTx(TXId txId, DistributionManager dm) {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        TXManagerImpl txMgr = cache.getTXMgr();
        if (logger.isDebugEnabled()) {
            logger.debug("JTA: Calling beforeCompletion for :{}", (Object)txId);
        }
        txMgr.getTXState().beforeCompletion();
        return true;
    }

    @Override
    public int getDSFID() {
        return -114;
    }
}

