/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.CacheEvent;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.SerializedCacheValue;
import org.apache.geode.cache.query.internal.CqStateImpl;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.cache.query.internal.cq.CqServiceProvider;
import org.apache.geode.cache.query.internal.cq.ServerCQ;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.ClassLoadUtil;
import org.apache.geode.internal.CopyOnWriteHashSet;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.CacheDistributionAdvisee;
import org.apache.geode.internal.cache.CacheDistributionAdvisor;
import org.apache.geode.internal.cache.DistributedPutAllOperation;
import org.apache.geode.internal.cache.DistributedRemoveAllOperation;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.FilterRoutingInfo;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InterestEvent;
import org.apache.geode.internal.cache.InterestFilter;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.UnregisterAllInterest;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.util.concurrent.CopyOnWriteHashMap;
import org.apache.logging.log4j.Logger;

public class FilterProfile
implements DataSerializableFixedID {
    private static final Logger logger = LogService.getLogger();
    static boolean[] isCQOperation = new boolean[]{false, false, false, false, false, false, false, false, false, true, true, true, true, true};
    private final Map<Object, Set> keysOfInterest = new CopyOnWriteHashMap<Object, Set>();
    private final Map<Object, Set> keysOfInterestInv = new CopyOnWriteHashMap<Object, Set>();
    private final Map<Object, Map<Object, Pattern>> patternsOfInterest = new CopyOnWriteHashMap<Object, Map<Object, Pattern>>();
    private final Map<Object, Map<Object, Pattern>> patternsOfInterestInv = new CopyOnWriteHashMap<Object, Map<Object, Pattern>>();
    private final Map<Object, Map> filtersOfInterest = new CopyOnWriteHashMap<Object, Map>();
    private final Map<Object, Map> filtersOfInterestInv = new CopyOnWriteHashMap<Object, Map>();
    private final Set<Long> allKeyClients = new CopyOnWriteHashSet<Long>();
    private final Set<Long> allKeyClientsInv = new CopyOnWriteHashSet<Long>();
    transient LocalRegion region;
    private transient boolean isLocalProfile;
    AtomicInteger cqCount;
    private final Map cqs = new CopyOnWriteHashMap();
    private DistributedMember memberID;
    IDMap clientMap;
    IDMap cqMap;
    private final Object interestListLock = new Object();
    private volatile Map<InternalDistributedMember, LinkedList<OperationMessage>> filterProfileMsgQueue = new HashMap<InternalDistributedMember, LinkedList<OperationMessage>>();
    static final DistributionAdvisor.Profile[] NO_PROFILES = new DistributionAdvisor.Profile[0];
    private final CacheDistributionAdvisor.CacheProfile localProfile = new CacheDistributionAdvisor.CacheProfile(this);
    private final DistributionAdvisor.Profile[] localProfileArray = new DistributionAdvisor.Profile[]{this.localProfile};
    public static TestHook testHook = null;

    public FilterProfile() {
        this.cqCount = new AtomicInteger();
    }

    public FilterProfile(LocalRegion r) {
        this.region = r;
        this.isLocalProfile = true;
        this.memberID = this.region.getMyId();
        this.cqCount = new AtomicInteger();
        this.clientMap = new IDMap();
        this.cqMap = new IDMap();
        this.localProfile.hasCacheServer = r.getGemFireCache().getCacheServers().size() > 0;
    }

    public static boolean isCqOp(operationType opType) {
        return isCQOperation[opType.ordinal()];
    }

    private Set getAllClientsWithInterest() {
        HashSet<Object> clientsWithInterest = new HashSet<Object>(this.getAllKeyClients());
        clientsWithInterest.addAll(this.getPatternsOfInterest().keySet());
        clientsWithInterest.addAll(this.getFiltersOfInterest().keySet());
        clientsWithInterest.addAll(this.getKeysOfInterest().keySet());
        return clientsWithInterest;
    }

    private Set getAllClientsWithInterestInv() {
        HashSet<Long> clientsWithInterestInv = new HashSet<Long>(this.getAllKeyClientsInv());
        clientsWithInterestInv.addAll(this.getPatternsOfInterestInv().keySet());
        clientsWithInterestInv.addAll(this.getFiltersOfInterestInv().keySet());
        clientsWithInterestInv.addAll(this.getKeysOfInterestInv().keySet());
        return clientsWithInterestInv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set registerClientInterest(Object inputClientID, Object interest, int typeOfInterest, boolean updatesAsInvalidates) {
        HashSet<Object> keysRegistered = new HashSet<Object>();
        operationType opType = null;
        Long clientID = this.getClientIDForMaps(inputClientID);
        Object object = this.interestListLock;
        synchronized (object) {
            switch (typeOfInterest) {
                case 0: {
                    opType = operationType.REGISTER_KEY;
                    Map<Object, Set> koi = updatesAsInvalidates ? this.getKeysOfInterestInv() : this.getKeysOfInterest();
                    this.registerKeyInMap(interest, keysRegistered, clientID, koi);
                    break;
                }
                case 1: {
                    opType = operationType.REGISTER_PATTERN;
                    if (((String)interest).equals(".*")) {
                        Set<Object> akc;
                        Set<Object> set = akc = updatesAsInvalidates ? this.getAllKeyClientsInv() : this.getAllKeyClients();
                        if (!akc.add(clientID)) break;
                        keysRegistered.add(interest);
                        break;
                    }
                    Map<Object, Map<Object, Pattern>> pats = updatesAsInvalidates ? this.getPatternsOfInterestInv() : this.getPatternsOfInterest();
                    this.registerPatternInMap(interest, keysRegistered, clientID, pats);
                    break;
                }
                case 2: {
                    opType = operationType.REGISTER_FILTER;
                    Map<Object, Map> filts = updatesAsInvalidates ? this.getFiltersOfInterestInv() : this.getFiltersOfInterest();
                    this.registerFilterClassInMap(interest, clientID, filts);
                    break;
                }
                default: {
                    throw new InternalGemFireError(LocalizedStrings.CacheClientProxy_UNKNOWN_INTEREST_TYPE.toLocalizedString());
                }
            }
            if (this.isLocalProfile && opType != null) {
                this.sendProfileOperation(clientID, opType, interest, updatesAsInvalidates);
            }
        }
        return keysRegistered;
    }

    private void registerFilterClassInMap(Object interest, Long clientID, Map<Object, Map> filts) {
        InterestFilter filter;
        try {
            Class filterClass = ClassLoadUtil.classFromName((String)interest);
            filter = (InterestFilter)filterClass.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(LocalizedStrings.CacheClientProxy_CLASS_0_NOT_FOUND_IN_CLASSPATH.toLocalizedString(interest), cnfe);
        }
        catch (Exception e) {
            throw new RuntimeException(LocalizedStrings.CacheClientProxy_CLASS_0_COULD_NOT_BE_INSTANTIATED.toLocalizedString(interest), e);
        }
        CopyOnWriteHashMap<Object, InterestFilter> interestMap = filts.get(clientID);
        if (interestMap == null) {
            interestMap = new CopyOnWriteHashMap<Object, InterestFilter>();
            filts.put(clientID, interestMap);
        }
        interestMap.put(interest, filter);
    }

    private void registerPatternInMap(Object interest, Set keysRegistered, Long clientID, Map<Object, Map<Object, Pattern>> pats) {
        Pattern oldPattern;
        Pattern pattern = Pattern.compile((String)interest);
        Map<Object, Pattern> interestMap = pats.get(clientID);
        if (interestMap == null) {
            interestMap = new CopyOnWriteHashMap<Object, Pattern>();
            pats.put(clientID, interestMap);
        }
        if ((oldPattern = interestMap.put(interest, pattern)) == null) {
            keysRegistered.add(interest);
        }
    }

    private void registerKeyInMap(Object interest, Set keysRegistered, Long clientID, Map<Object, Set> koi) {
        CopyOnWriteHashSet interestList = koi.get(clientID);
        if (interestList == null) {
            interestList = new CopyOnWriteHashSet();
            koi.put(clientID, interestList);
        }
        interestList.add(interest);
        keysRegistered.add(interest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set unregisterClientInterest(Object inputClientID, Object interest, int interestType2) {
        Long clientID;
        if (inputClientID instanceof Long) {
            clientID = (Long)inputClientID;
        } else {
            Map<Object, Long> cids = this.clientMap.realIDs;
            clientID = cids.get(inputClientID);
            if (clientID == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("region profile unable to find '{}' for unregistration.  Probably means there is no durable queue.", inputClientID);
                }
                return null;
            }
        }
        HashSet keysUnregistered = new HashSet();
        operationType opType = null;
        Object object = this.interestListLock;
        synchronized (object) {
            switch (interestType2) {
                case 0: {
                    opType = operationType.UNREGISTER_KEY;
                    this.unregisterClientKeys(inputClientID, interest, clientID, keysUnregistered);
                    break;
                }
                case 1: {
                    opType = operationType.UNREGISTER_PATTERN;
                    this.unregisterClientPattern(interest, clientID, keysUnregistered);
                    break;
                }
                case 2: {
                    opType = operationType.UNREGISTER_FILTER;
                    this.unregisterClientFilterClass(interest, clientID);
                    break;
                }
                default: {
                    throw new InternalGemFireError(LocalizedStrings.CacheClientProxy_BAD_INTEREST_TYPE.toLocalizedString());
                }
            }
            if (this.region != null && this.isLocalProfile) {
                this.sendProfileOperation(clientID, opType, interest, false);
            }
        }
        return keysUnregistered;
    }

    private void unregisterClientFilterClass(Object interest, Long clientID) {
        if (interest == UnregisterAllInterest.singleton()) {
            if (this.getFiltersOfInterest().get(clientID) != null) {
                this.getFiltersOfInterest().remove(clientID);
            }
            if (this.getFiltersOfInterestInv().get(clientID) != null) {
                this.getFiltersOfInterestInv().remove(clientID);
            }
            return;
        }
        Map interestMap = this.getFiltersOfInterest().get(clientID);
        if (interestMap != null) {
            interestMap.remove(interest);
            if (interestMap.isEmpty()) {
                this.getFiltersOfInterest().remove(clientID);
            }
        }
        if ((interestMap = this.getFiltersOfInterestInv().get(clientID)) != null) {
            interestMap.remove(interest);
            if (interestMap.isEmpty()) {
                this.getFiltersOfInterestInv().remove(clientID);
            }
        }
    }

    private void unregisterClientPattern(Object interest, Long clientID, Set keysUnregistered) {
        if (interest instanceof String && ((String)interest).equals(".*")) {
            this.unregisterAllKeys(interest, clientID, keysUnregistered);
            return;
        }
        if (interest == UnregisterAllInterest.singleton()) {
            this.unregisterClientIDFromMap(clientID, this.getPatternsOfInterest(), keysUnregistered);
            this.unregisterClientIDFromMap(clientID, this.getPatternsOfInterestInv(), keysUnregistered);
            if (this.getAllKeyClients().remove(clientID)) {
                keysUnregistered.add(".*");
            }
            if (this.getAllKeyClientsInv().remove(clientID)) {
                keysUnregistered.add(".*");
            }
        } else {
            this.unregisterPatternFromMap(this.getPatternsOfInterest(), interest, clientID, keysUnregistered);
            this.unregisterPatternFromMap(this.getPatternsOfInterestInv(), interest, clientID, keysUnregistered);
        }
    }

    private void unregisterPatternFromMap(Map<Object, Map<Object, Pattern>> map, Object interest, Long clientID, Set keysUnregistered) {
        Map<Object, Pattern> interestMap = map.get(clientID);
        if (interestMap != null) {
            Pattern obj = interestMap.remove(interest);
            if (obj != null) {
                keysUnregistered.add(interest);
            }
            if (interestMap.isEmpty()) {
                map.remove(clientID);
            }
        }
    }

    private void unregisterClientIDFromMap(Long clientID, Map interestMap, Set keysUnregistered) {
        Map removed;
        if (interestMap.get(clientID) != null && (removed = (Map)interestMap.remove(clientID)) != null) {
            keysUnregistered.addAll(removed.keySet());
        }
    }

    private void unregisterAllKeys(Object interest, Long clientID, Set keysUnregistered) {
        if (this.getAllKeyClients().remove(clientID)) {
            keysUnregistered.add(interest);
        }
        if (this.getAllKeyClientsInv().remove(clientID)) {
            keysUnregistered.add(interest);
        }
    }

    private void unregisterClientKeys(Object inputClientID, Object interest, Long clientID, Set keysUnregistered) {
        if (interest == UnregisterAllInterest.singleton()) {
            this.clearInterestFor(inputClientID);
            return;
        }
        this.unregisterKeyFromMap(this.getKeysOfInterest(), interest, clientID, keysUnregistered);
        this.unregisterKeyFromMap(this.getKeysOfInterestInv(), interest, clientID, keysUnregistered);
    }

    private void unregisterKeyFromMap(Map<Object, Set> map, Object interest, Long clientID, Set keysUnregistered) {
        Set interestList = map.get(clientID);
        if (interestList != null) {
            boolean removed = interestList.remove(interest);
            if (removed) {
                keysUnregistered.add(interest);
            }
            if (interestList.isEmpty()) {
                map.remove(clientID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set registerClientInterestList(Object inputClientID, List keys, boolean updatesAsInvalidates) {
        Long clientID = this.getClientIDForMaps(inputClientID);
        HashSet keysRegistered = new HashSet(keys);
        Object object = this.interestListLock;
        synchronized (object) {
            Map<Object, Set> koi = updatesAsInvalidates ? this.getKeysOfInterestInv() : this.getKeysOfInterest();
            CopyOnWriteHashSet interestList = (CopyOnWriteHashSet)koi.get(clientID);
            if (interestList == null) {
                interestList = new CopyOnWriteHashSet();
                koi.put(clientID, interestList);
            } else {
                keysRegistered.removeAll(interestList.getSnapshot());
            }
            interestList.addAll(keys);
            if (this.region != null && this.isLocalProfile) {
                this.sendProfileOperation(clientID, operationType.REGISTER_KEYS, keys, updatesAsInvalidates);
            }
        }
        return keysRegistered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set unregisterClientInterestList(Object inputClientID, List keys) {
        Long clientID = this.getClientIDForMaps(inputClientID);
        HashSet keysUnregistered = new HashSet(keys);
        HashSet keysNotUnregistered = new HashSet(keys);
        Object object = this.interestListLock;
        synchronized (object) {
            CopyOnWriteHashSet interestList = (CopyOnWriteHashSet)this.getKeysOfInterest().get(clientID);
            if (interestList != null) {
                keysNotUnregistered.removeAll(interestList.getSnapshot());
                interestList.removeAll(keys);
                if (interestList.isEmpty()) {
                    this.getKeysOfInterest().remove(clientID);
                }
            }
            if ((interestList = (CopyOnWriteHashSet)this.getKeysOfInterestInv().get(clientID)) != null) {
                keysNotUnregistered.removeAll(interestList.getSnapshot());
                interestList.removeAll(keys);
                if (interestList.isEmpty()) {
                    this.getKeysOfInterestInv().remove(clientID);
                }
            }
            if (this.region != null && this.isLocalProfile) {
                this.sendProfileOperation(clientID, operationType.UNREGISTER_KEYS, keys, false);
            }
        }
        keysUnregistered.removeAll(keysNotUnregistered);
        return keysUnregistered;
    }

    public Set getKeysOfInterestFor(Object inputClientID) {
        Long clientID = this.getClientIDForMaps(inputClientID);
        Set keys1 = this.getKeysOfInterest().get(clientID);
        Set keys2 = this.getKeysOfInterestInv().get(clientID);
        if (keys1 == null) {
            if (keys2 == null) {
                return null;
            }
            return Collections.unmodifiableSet(keys2);
        }
        if (keys2 == null) {
            return Collections.unmodifiableSet(keys1);
        }
        HashSet result = new HashSet(keys1);
        result.addAll(keys2);
        return Collections.unmodifiableSet(result);
    }

    public Map<String, Pattern> getPatternsOfInterestFor(Object inputClientID) {
        Long clientID = this.getClientIDForMaps(inputClientID);
        Map<Object, Pattern> patterns1 = this.getPatternsOfInterest().get(clientID);
        Map<Object, Pattern> patterns2 = this.getPatternsOfInterestInv().get(clientID);
        if (patterns1 == null) {
            if (patterns2 == null) {
                return null;
            }
            return Collections.unmodifiableMap(patterns2);
        }
        if (patterns2 == null) {
            return Collections.unmodifiableMap(patterns1);
        }
        HashMap<Object, Pattern> result = new HashMap<Object, Pattern>(patterns1);
        result.putAll(patterns2);
        return Collections.unmodifiableMap(result);
    }

    public boolean hasKeysOfInterestFor(Object inputClientID, boolean wantInvalidations) {
        Long clientID = this.getClientIDForMaps(inputClientID);
        if (wantInvalidations) {
            return this.getKeysOfInterestInv().containsKey(clientID);
        }
        return this.getKeysOfInterest().containsKey(clientID);
    }

    public boolean hasAllKeysInterestFor(Object inputClientID) {
        Long clientID = this.getClientIDForMaps(inputClientID);
        return this.hasAllKeysInterestFor(clientID, false) || this.hasAllKeysInterestFor(clientID, true);
    }

    public boolean hasAllKeysInterestFor(Object inputClientID, boolean wantInvalidations) {
        Long clientID = this.getClientIDForMaps(inputClientID);
        if (wantInvalidations) {
            return this.getAllKeyClientsInv().contains(clientID);
        }
        return this.getAllKeyClients().contains(clientID);
    }

    public boolean hasRegexInterestFor(Object inputClientID, boolean wantInvalidations) {
        Long clientID = this.getClientIDForMaps(inputClientID);
        if (wantInvalidations) {
            return this.getPatternsOfInterestInv().containsKey(clientID);
        }
        return this.getPatternsOfInterest().containsKey(clientID);
    }

    public boolean hasFilterInterestFor(Object inputClientID, boolean wantInvalidations) {
        Long clientID = this.getClientIDForMaps(inputClientID);
        if (wantInvalidations) {
            return this.getFiltersOfInterestInv().containsKey(clientID);
        }
        return this.getFiltersOfInterest().containsKey(clientID);
    }

    public boolean hasInterestFor(Object inputClientID) {
        Long clientID;
        if (inputClientID instanceof Long) {
            clientID = (Long)inputClientID;
        } else {
            Map<Object, Long> cids = this.clientMap.realIDs;
            clientID = cids.get(inputClientID);
            if (clientID == null) {
                return false;
            }
        }
        return this.hasAllKeysInterestFor(clientID, true) || this.hasKeysOfInterestFor(clientID, true) || this.hasRegexInterestFor(clientID, true) || this.hasFilterInterestFor(clientID, true) || this.hasKeysOfInterestFor(clientID, false) || this.hasRegexInterestFor(clientID, false) || this.hasAllKeysInterestFor(clientID, false) || this.hasFilterInterestFor(clientID, false);
    }

    public boolean hasInterest() {
        return !this.getAllKeyClients().isEmpty() || !this.getAllKeyClientsInv().isEmpty() || !this.getKeysOfInterest().isEmpty() || !this.getPatternsOfInterest().isEmpty() || !this.getFiltersOfInterest().isEmpty() || !this.getKeysOfInterestInv().isEmpty() || !this.getPatternsOfInterestInv().isEmpty() || !this.getFiltersOfInterestInv().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInterestFor(Object inputClientID) {
        Long clientID;
        if (inputClientID instanceof Long) {
            clientID = (Long)inputClientID;
        } else {
            Map<Object, Long> cids = this.clientMap.realIDs;
            clientID = cids.get(inputClientID);
            if (clientID == null) {
                return;
            }
        }
        Object object = this.interestListLock;
        synchronized (object) {
            Map<Object, Map> filters;
            Map<Object, Map<Object, Pattern>> pats;
            Map<Object, Set> keys;
            Set<Long> akci;
            Set<Object> akc = this.getAllKeyClients();
            if (akc.contains(clientID)) {
                akc.remove(clientID);
            }
            if ((akci = this.getAllKeyClientsInv()).contains(clientID)) {
                akci.remove(clientID);
            }
            if ((keys = this.getKeysOfInterest()).containsKey(clientID)) {
                keys.remove(clientID);
            }
            if ((keys = this.getKeysOfInterestInv()).containsKey(clientID)) {
                keys.remove(clientID);
            }
            if ((pats = this.getPatternsOfInterest()).containsKey(clientID)) {
                pats.remove(clientID);
            }
            if ((pats = this.getPatternsOfInterestInv()).containsKey(clientID)) {
                pats.remove(clientID);
            }
            if ((filters = this.getFiltersOfInterest()).containsKey(clientID)) {
                filters.remove(clientID);
            }
            if ((filters = this.getFiltersOfInterestInv()).containsKey(clientID)) {
                filters.remove(clientID);
            }
            if (this.clientMap != null) {
                this.clientMap.removeIDMapping(clientID);
            }
            if (this.region != null && this.isLocalProfile) {
                this.sendProfileOperation(clientID, operationType.CLEAR, null, false);
            }
        }
    }

    public int getCqCount() {
        return this.cqCount.get();
    }

    public void incCqCount() {
        this.cqCount.getAndIncrement();
    }

    public void decCqCount() {
        this.cqCount.decrementAndGet();
    }

    public Map getCqMap() {
        return this.cqs;
    }

    public boolean hasCQs() {
        return this.cqCount.get() > 0;
    }

    public ServerCQ getCq(String cqName) {
        return (ServerCQ)this.cqs.get(cqName);
    }

    public void registerCq(ServerCQ cq) {
        this.ensureCqID(cq);
        if (logger.isDebugEnabled()) {
            logger.debug("Adding CQ {} to this members FilterProfile.", (Object)cq.getServerCqName());
        }
        this.cqs.put(cq.getServerCqName(), cq);
        this.incCqCount();
        this.sendCQProfileOperation(operationType.REGISTER_CQ, cq);
    }

    public void stopCq(ServerCQ cq) {
        this.ensureCqID(cq);
        if (logger.isDebugEnabled()) {
            logger.debug("Stopping CQ {} on this members FilterProfile.", (Object)cq.getServerCqName());
        }
        this.sendCQProfileOperation(operationType.STOP_CQ, cq);
    }

    public String generateCqName(String serverCqName) {
        return serverCqName + this.hashCode();
    }

    void processRegisterCq(String serverCqName, ServerCQ ServerCQ2, boolean addToCqMap) {
        FilterProfile pf;
        ServerCQ cq;
        block5: {
            cq = ServerCQ2;
            try {
                CqService cqService = GemFireCacheImpl.getInstance().getCqService();
                cqService.start();
                cq.setCqService(cqService);
                CqStateImpl cqState = (CqStateImpl)cq.getState();
                cq.setName(this.generateCqName(serverCqName));
                cq.registerCq(null, null, cqState.getState());
            }
            catch (Exception ex) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug("Error while initializing the CQs with FilterProfile for CQ {}, Error : {}", (Object)serverCqName, (Object)ex.getMessage(), (Object)ex);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Adding CQ to remote members FilterProfile using name: {}", (Object)serverCqName);
        }
        if (addToCqMap) {
            this.cqs.put(serverCqName, cq);
        }
        if (cq.getCqBaseRegion() != null && (pf = cq.getCqBaseRegion().getFilterProfile()) != null) {
            pf.incCqCount();
        }
    }

    public void processCloseCq(String serverCqName) {
        ServerCQ cq = (ServerCQ)this.cqs.get(serverCqName);
        if (cq != null) {
            block3: {
                try {
                    cq.close(false);
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug("Unable to close the CQ with the filterProfile, on region {} for CQ {}, Error : {}", (Object)this.region.getFullPath(), (Object)serverCqName, (Object)ex.getMessage(), (Object)ex);
                }
            }
            this.cqs.remove(serverCqName);
            cq.getCqBaseRegion().getFilterProfile().decCqCount();
        }
    }

    public void processSetCqState(String serverCqName, ServerCQ ServerCQ2) {
        ServerCQ cq = (ServerCQ)this.cqs.get(serverCqName);
        if (cq != null) {
            CqStateImpl cqState = (CqStateImpl)ServerCQ2.getState();
            cq.setCqState(cqState.getState());
        }
    }

    public void processStopCq(String serverCqName) {
        block3: {
            ServerCQ cq = (ServerCQ)this.cqs.get(serverCqName);
            if (cq != null) {
                try {
                    cq.stop();
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug("Unable to stop the CQ with the filterProfile, on region {} for CQ {}, Error : {}", (Object)this.region.getFullPath(), (Object)serverCqName, (Object)ex.getMessage(), (Object)ex);
                }
            }
        }
    }

    public void setCqState(ServerCQ cq) {
        this.ensureCqID(cq);
        if (logger.isDebugEnabled()) {
            logger.debug("Stopping CQ {} on this members FilterProfile.", (Object)cq.getServerCqName());
        }
        this.sendCQProfileOperation(operationType.SET_CQ_STATE, cq);
    }

    public void closeCq(ServerCQ cq) {
        this.ensureCqID(cq);
        String serverCqName = cq.getServerCqName();
        this.cqs.remove(serverCqName);
        if (this.cqMap != null) {
            this.cqMap.removeIDMapping(cq.getFilterID());
        }
        this.decCqCount();
        this.sendCQProfileOperation(operationType.CLOSE_CQ, cq);
    }

    void cleanupForClient(CacheClientNotifier ccn, ClientProxyMembershipID client) {
        for (Map.Entry cqEntry : this.cqs.entrySet()) {
            ServerCQ cq;
            block3: {
                cq = (ServerCQ)cqEntry.getValue();
                ClientProxyMembershipID clientId = cq.getClientProxyId();
                if (!clientId.equals(client)) continue;
                try {
                    cq.close(false);
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug("Failed to remove CQ from the base region. CqName : {}", (Object)cq.getName());
                }
            }
            this.closeCq(cq);
        }
    }

    void cleanUp() {
        Map tmpCq = this.cqs;
        if (tmpCq.size() > 0) {
            for (Object serverCqName : tmpCq.keySet()) {
                this.processCloseCq((String)serverCqName);
            }
        }
    }

    public boolean entryRequiresOldValue(Object key) {
        if (this.hasCQs()) {
            if (!CqServiceProvider.MAINTAIN_KEYS) {
                return true;
            }
            for (ServerCQ cq : this.cqs.values()) {
                if (!cq.isOldValueRequiredForQueryProcessing(key)) continue;
                return true;
            }
        }
        return false;
    }

    private void sendProfileOperation(Long clientID, operationType opType, Object interest, boolean updatesAsInvalidates) {
        if (this.region == null || !(this.region instanceof PartitionedRegion)) {
            return;
        }
        OperationMessage msg = new OperationMessage();
        msg.regionName = this.region.getFullPath();
        msg.clientID = clientID;
        msg.opType = opType;
        msg.interest = interest;
        msg.updatesAsInvalidates = updatesAsInvalidates;
        this.sendFilterProfileOperation(msg);
    }

    private void sendFilterProfileOperation(OperationMessage msg) {
        Set recipients = ((CacheDistributionAdvisee)((Object)this.region)).getDistributionAdvisor().adviseProfileUpdate();
        msg.setRecipients(recipients);
        ReplyProcessor21 rp = new ReplyProcessor21(this.region.getDistributionManager(), (Collection)recipients);
        msg.processorId = rp.getProcessorId();
        this.region.getDistributionManager().putOutgoing(msg);
        try {
            rp.waitForReplies();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    private void sendCQProfileOperation(operationType opType, ServerCQ cq) {
        block3: {
            if (!(this.region instanceof PartitionedRegion)) {
                return;
            }
            OperationMessage msg = new OperationMessage();
            msg.regionName = this.region.getFullPath();
            msg.opType = opType;
            msg.cq = cq;
            try {
                this.sendFilterProfileOperation(msg);
            }
            catch (Exception ex) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("Error sending CQ request to peers. {}", (Object)ex.getLocalizedMessage(), (Object)ex);
            }
        }
    }

    public FilterRoutingInfo.FilterInfo getLocalFilterRouting(CacheEvent event) {
        FilterRoutingInfo fri = this.getFilterRoutingInfoPart2(null, event);
        if (fri != null) {
            return fri.getLocalFilterInfo();
        }
        return null;
    }

    public CacheDistributionAdvisor.CacheProfile getLocalProfile() {
        return this.localProfile;
    }

    public FilterRoutingInfo getFilterRoutingInfoPart1(CacheEvent event, DistributionAdvisor.Profile[] peerProfiles, Set cacheOpRecipients) {
        boolean anyServers = false;
        for (int i = 0; i < peerProfiles.length; ++i) {
            if (!((CacheDistributionAdvisor.CacheProfile)peerProfiles[i]).hasCacheServer) continue;
            anyServers = true;
            break;
        }
        if (!anyServers && !this.localProfile.hasCacheServer) {
            return null;
        }
        FilterRoutingInfo frInfo = null;
        CqService cqService = this.getCqService(event.getRegion());
        if (cqService.isRunning()) {
            frInfo = new FilterRoutingInfo();
            boolean processLocalProfile = event.getOperation().isEntry() && ((EntryEventImpl)event).getTransactionId() != null;
            this.fillInCQRoutingInfo(event, processLocalProfile, peerProfiles, frInfo);
        }
        if ((frInfo = this.fillInInterestRoutingInfo(event, peerProfiles, frInfo, cacheOpRecipients)) == null || !frInfo.hasMemberWithFilterInfo()) {
            return null;
        }
        return frInfo;
    }

    public FilterRoutingInfo getFilterRoutingInfoPart2(FilterRoutingInfo part1Info, CacheEvent event) {
        FilterRoutingInfo result = part1Info;
        if (this.localProfile.hasCacheServer) {
            boolean isInConflict = event.getOperation().isEntry() && ((EntryEventImpl)event).isConcurrencyConflict();
            CqService cqService = this.getCqService(event.getRegion());
            if (!isInConflict && cqService.isRunning() && this.region != null) {
                if (result == null) {
                    result = new FilterRoutingInfo();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("getting local cq matches for {}", (Object)event);
                }
                this.fillInCQRoutingInfo(event, true, NO_PROFILES, result);
            }
            result = this.fillInInterestRoutingInfo(event, this.localProfileArray, result, Collections.EMPTY_SET);
        }
        return result;
    }

    private void fillInCQRoutingInfo(CacheEvent event, boolean processLocalProfile, DistributionAdvisor.Profile[] peerProfiles, FilterRoutingInfo frInfo) {
        CqService cqService = this.getCqService(event.getRegion());
        if (cqService != null) {
            try {
                CacheDistributionAdvisor.CacheProfile local = processLocalProfile ? this.localProfile : null;
                cqService.processEvents(event, local, peerProfiles, frInfo);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                logger.error(LocalizedMessage.create(LocalizedStrings.CacheClientNotifier_EXCEPTION_OCCURRED_WHILE_PROCESSING_CQS), t);
            }
        }
    }

    private CqService getCqService(Region region) {
        return ((InternalCache)region.getRegionService()).getCqService();
    }

    public void getLocalFilterRoutingForPutAllOp(DistributedPutAllOperation dpao, DistributedPutAllOperation.PutAllEntryData[] putAllData) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (this.region != null && this.localProfile.hasCacheServer) {
            Set clientsInv = null;
            Set clients = null;
            int size = putAllData.length;
            CqService cqService = this.getCqService(dpao.getRegion());
            boolean doCQs = cqService.isRunning() && this.region != null;
            for (int idx = 0; idx < size; ++idx) {
                DistributedPutAllOperation.PutAllEntryData pEntry = putAllData[idx];
                if (pEntry == null) continue;
                EntryEventImpl ev = dpao.getEventForPosition(idx);
                FilterRoutingInfo fri = pEntry.filterRouting;
                FilterRoutingInfo.FilterInfo fi = null;
                if (fri != null) {
                    fi = fri.getLocalFilterInfo();
                }
                if (isDebugEnabled) {
                    logger.debug("Finding locally interested clients for {}", (Object)ev);
                }
                if (doCQs) {
                    if (fri == null) {
                        fri = new FilterRoutingInfo();
                    }
                    this.fillInCQRoutingInfo(ev, true, NO_PROFILES, fri);
                    fi = fri.getLocalFilterInfo();
                }
                if (this.allKeyClientsInv != null || this.keysOfInterestInv != null || this.patternsOfInterestInv != null || this.filtersOfInterestInv != null) {
                    clientsInv = this.getInterestedClients(ev, this.allKeyClientsInv, this.keysOfInterestInv, this.patternsOfInterestInv, this.filtersOfInterestInv);
                }
                if (this.allKeyClients != null || this.keysOfInterest != null || this.patternsOfInterest != null || this.filtersOfInterest != null) {
                    clients = this.getInterestedClients(ev, this.allKeyClients, this.keysOfInterest, this.patternsOfInterest, this.filtersOfInterest);
                }
                if (clients != null || clientsInv != null) {
                    if (fi == null) {
                        fi = new FilterRoutingInfo.FilterInfo();
                    }
                    fi.setInterestedClients(clients);
                    fi.setInterestedClientsInv(clientsInv);
                }
                ev.setLocalFilterInfo(fi);
            }
        }
    }

    public void getLocalFilterRoutingForRemoveAllOp(DistributedRemoveAllOperation op, DistributedRemoveAllOperation.RemoveAllEntryData[] removeAllData) {
        if (this.region != null && this.localProfile.hasCacheServer) {
            Set clientsInv = null;
            Set clients = null;
            int size = removeAllData.length;
            CqService cqService = this.getCqService(op.getRegion());
            boolean doCQs = cqService.isRunning() && this.region != null;
            for (int idx = 0; idx < size; ++idx) {
                DistributedRemoveAllOperation.RemoveAllEntryData pEntry = removeAllData[idx];
                if (pEntry == null) continue;
                EntryEventImpl ev = op.getEventForPosition(idx);
                FilterRoutingInfo fri = pEntry.filterRouting;
                FilterRoutingInfo.FilterInfo fi = null;
                if (fri != null) {
                    fi = fri.getLocalFilterInfo();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Finding locally interested clients for {}", (Object)ev);
                }
                if (doCQs) {
                    if (fri == null) {
                        fri = new FilterRoutingInfo();
                    }
                    this.fillInCQRoutingInfo(ev, true, NO_PROFILES, fri);
                    fi = fri.getLocalFilterInfo();
                }
                if (this.allKeyClientsInv != null || this.keysOfInterestInv != null || this.patternsOfInterestInv != null || this.filtersOfInterestInv != null) {
                    clientsInv = this.getInterestedClients(ev, this.allKeyClientsInv, this.keysOfInterestInv, this.patternsOfInterestInv, this.filtersOfInterestInv);
                }
                if (this.allKeyClients != null || this.keysOfInterest != null || this.patternsOfInterest != null || this.filtersOfInterest != null) {
                    clients = this.getInterestedClients(ev, this.allKeyClients, this.keysOfInterest, this.patternsOfInterest, this.filtersOfInterest);
                }
                if (clients != null || clientsInv != null) {
                    if (fi == null) {
                        fi = new FilterRoutingInfo.FilterInfo();
                    }
                    fi.setInterestedClients(clients);
                    fi.setInterestedClientsInv(clientsInv);
                }
                ev.setLocalFilterInfo(fi);
            }
        }
    }

    public FilterRoutingInfo fillInInterestRoutingInfo(CacheEvent event, DistributionAdvisor.Profile[] profiles, FilterRoutingInfo filterRoutingInfo, Set cacheOpRecipients) {
        Set clientsInv = Collections.EMPTY_SET;
        Set clients = Collections.EMPTY_SET;
        if (logger.isTraceEnabled(LogMarker.BRIDGE_SERVER)) {
            logger.trace(LogMarker.BRIDGE_SERVER, "finding interested clients for {}", (Object)event);
        }
        FilterRoutingInfo frInfo = filterRoutingInfo;
        for (int i = 0; i < profiles.length; ++i) {
            FilterProfile pf;
            CacheDistributionAdvisor.CacheProfile cf = (CacheDistributionAdvisor.CacheProfile)profiles[i];
            if (!cf.hasCacheServer || (pf = cf.filterProfile) == null) continue;
            if (logger.isTraceEnabled(LogMarker.BRIDGE_SERVER)) {
                logger.trace(LogMarker.BRIDGE_SERVER, "Processing {}", (Object)pf);
            }
            if (!pf.hasInterest()) {
                if (pf.isLocalProfile() || !cacheOpRecipients.contains(cf.getDistributedMember())) continue;
                if (frInfo == null) {
                    frInfo = new FilterRoutingInfo();
                }
                frInfo.addInterestedClients(cf.getDistributedMember(), Collections.EMPTY_SET, Collections.EMPTY_SET, false);
                continue;
            }
            if (event.getOperation().isEntry()) {
                EntryEvent entryEvent = (EntryEvent)event;
                if (pf.allKeyClientsInv != null || pf.keysOfInterestInv != null || pf.patternsOfInterestInv != null || pf.filtersOfInterestInv != null) {
                    clientsInv = pf.getInterestedClients(entryEvent, pf.allKeyClientsInv, pf.keysOfInterestInv, pf.patternsOfInterestInv, pf.filtersOfInterestInv);
                }
                if (pf.allKeyClients != null || pf.keysOfInterest != null || pf.patternsOfInterest != null || pf.filtersOfInterest != null) {
                    clients = pf.getInterestedClients(entryEvent, pf.allKeyClients, pf.keysOfInterest, pf.patternsOfInterest, pf.filtersOfInterest);
                }
            } else if (event.getOperation().isRegionDestroy() || event.getOperation().isClear()) {
                clientsInv = pf.getAllClientsWithInterestInv();
                clients = pf.getAllClientsWithInterest();
            } else {
                return frInfo;
            }
            if (pf.isLocalProfile) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Setting local interested clients={} and clientsInv={}", (Object)clients, (Object)clientsInv);
                }
                if (frInfo == null) {
                    frInfo = new FilterRoutingInfo();
                }
                frInfo.setLocalInterestedClients(clients, clientsInv);
                continue;
            }
            if (!cacheOpRecipients.contains(cf.getDistributedMember()) && (clients == null || clients.isEmpty()) && (clientsInv == null || clientsInv.isEmpty())) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Adding interested clients={} and clientsIn={} to {}", (Object)clients, (Object)clientsInv, (Object)filterRoutingInfo);
            }
            if (frInfo == null) {
                frInfo = new FilterRoutingInfo();
            }
            frInfo.addInterestedClients(cf.getDistributedMember(), clients, clientsInv, this.clientMap.hasLongID);
        }
        return frInfo;
    }

    private Set getInterestedClients(EntryEvent event, Set akc, Map<Object, Set> koi, Map<Object, Map<Object, Pattern>> pats, Map<Object, Map> foi) {
        HashSet<Object> result = null;
        if (akc != null) {
            result = new HashSet<Object>(akc);
            if (logger.isDebugEnabled()) {
                logger.debug("these clients matched for all-keys: {}", (Object)akc);
            }
        }
        if (koi != null) {
            for (Map.Entry<Object, Set> entry : koi.entrySet()) {
                Set keys = entry.getValue();
                if (!keys.contains(event.getKey())) continue;
                Object clientID = entry.getKey();
                if (result == null) {
                    result = new HashSet();
                }
                result.add(clientID);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("client {} matched for key list (size {})", clientID, (Object)koi.get(clientID).size());
            }
        }
        if (pats != null && event.getKey() instanceof String) {
            block1: for (Map.Entry<Object, Object> entry : pats.entrySet()) {
                String stringKey = (String)event.getKey();
                Map interestList = (Map)entry.getValue();
                for (Pattern keyPattern : interestList.values()) {
                    if (!keyPattern.matcher(stringKey).matches()) continue;
                    Object clientID = entry.getKey();
                    if (result == null) {
                        result = new HashSet();
                    }
                    result.add(clientID);
                    if (!logger.isDebugEnabled()) continue block1;
                    logger.debug("client {} matched for pattern ({})", clientID, (Object)pats.get(clientID));
                    continue block1;
                }
            }
        }
        if (foi != null && foi.size() > 0) {
            SerializedCacheValue serValue = event.getSerializedNewValue();
            boolean bl = serValue != null;
            Object value = !bl ? event.getNewValue() : (Object)serValue.getSerializedValue();
            InterestEvent iev = new InterestEvent(event.getKey(), value, !bl);
            Operation op = event.getOperation();
            block3: for (Map.Entry<Object, Map> entry : foi.entrySet()) {
                Map interestList = entry.getValue();
                for (InterestFilter filter : interestList.values()) {
                    if (!(op.isCreate() && filter.notifyOnCreate(iev) || op.isUpdate() && filter.notifyOnUpdate(iev) || op.isDestroy() && filter.notifyOnDestroy(iev)) && (!op.isInvalidate() || !filter.notifyOnInvalidate(iev))) continue;
                    Object clientID = entry.getKey();
                    if (result == null) {
                        result = new HashSet();
                    }
                    result.add(clientID);
                    if (!logger.isDebugEnabled()) continue block3;
                    logger.debug("client {} matched for filter ({})", clientID, (Object)this.getFiltersOfInterest().get(clientID));
                    continue block3;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        InternalDistributedMember id = new InternalDistributedMember();
        InternalDataSerializer.invokeFromData(id, in);
        this.memberID = id;
        this.allKeyClients.addAll(InternalDataSerializer.readSetOfLongs(in));
        this.keysOfInterest.putAll(DataSerializer.readHashMap(in));
        this.patternsOfInterest.putAll(DataSerializer.readHashMap(in));
        this.filtersOfInterest.putAll(DataSerializer.readHashMap(in));
        this.allKeyClientsInv.addAll(InternalDataSerializer.readSetOfLongs(in));
        this.keysOfInterestInv.putAll(DataSerializer.readHashMap(in));
        this.patternsOfInterestInv.putAll(DataSerializer.readHashMap(in));
        this.filtersOfInterestInv.putAll(DataSerializer.readHashMap(in));
        int numCQs = InternalDataSerializer.readArrayLength(in);
        if (numCQs > 0) {
            int oldLevel = LocalRegion.setThreadInitLevelRequirement(2);
            try {
                for (int i = 0; i < numCQs; ++i) {
                    String serverCqName = DataSerializer.readString(in);
                    ServerCQ cq = CqServiceProvider.readCq(in);
                    this.processRegisterCq(serverCqName, cq, false);
                    this.cqs.put(serverCqName, cq);
                }
            }
            finally {
                LocalRegion.setThreadInitLevelRequirement(oldLevel);
            }
        }
    }

    @Override
    public int getDSFID() {
        return 119;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        InternalDataSerializer.invokeToData((InternalDistributedMember)this.memberID, out);
        InternalDataSerializer.writeSetOfLongs(this.allKeyClients, this.clientMap.hasLongID, out);
        DataSerializer.writeHashMap(this.keysOfInterest, out);
        DataSerializer.writeHashMap(this.patternsOfInterest, out);
        DataSerializer.writeHashMap(this.filtersOfInterest, out);
        InternalDataSerializer.writeSetOfLongs(this.allKeyClientsInv, this.clientMap.hasLongID, out);
        DataSerializer.writeHashMap(this.keysOfInterestInv, out);
        DataSerializer.writeHashMap(this.patternsOfInterestInv, out);
        DataSerializer.writeHashMap(this.filtersOfInterestInv, out);
        Map theCQs = this.cqs;
        int size = theCQs.size();
        InternalDataSerializer.writeArrayLength(size, out);
        for (Map.Entry entry : theCQs.entrySet()) {
            String name = (String)entry.getKey();
            ServerCQ cq = (ServerCQ)entry.getValue();
            DataSerializer.writeString(name, out);
            InternalDataSerializer.invokeToData(cq, out);
        }
    }

    private Map<Object, Set> getKeysOfInterest() {
        return this.keysOfInterest;
    }

    private Map<Object, Set> getKeysOfInterestInv() {
        return this.keysOfInterestInv;
    }

    private Map<Object, Map<Object, Pattern>> getPatternsOfInterest() {
        return this.patternsOfInterest;
    }

    private Map<Object, Map<Object, Pattern>> getPatternsOfInterestInv() {
        return this.patternsOfInterestInv;
    }

    Map<Object, Map> getFiltersOfInterestInv() {
        return this.filtersOfInterestInv;
    }

    private Map<Object, Map> getFiltersOfInterest() {
        return this.filtersOfInterest;
    }

    private Set<Object> getAllKeyClients() {
        Set<Object> allKeysRef = this.allKeyClients;
        if (testHook != null) {
            testHook.await();
        }
        return allKeysRef;
    }

    public int getAllKeyClientsSize() {
        return this.getAllKeyClients().size();
    }

    private Set<Long> getAllKeyClientsInv() {
        return this.allKeyClientsInv;
    }

    public int getAllKeyClientsInvSize() {
        return this.getAllKeyClientsInv().size();
    }

    private Long getClientIDForMaps(Object inputClientID) {
        Long clientID = inputClientID instanceof Long ? (Long)inputClientID : this.clientMap.getWireID(inputClientID);
        return clientID;
    }

    public String toString() {
        boolean isDebugEnabled = logger.isTraceEnabled(LogMarker.BRIDGE_SERVER);
        return "FilterProfile(id=" + (this.isLocalProfile ? "local" : this.memberID) + ";  numCQs: " + (this.cqCount == null ? 0 : this.cqCount.get()) + (isDebugEnabled ? ";  " + this.getClientMappingString() : "") + (isDebugEnabled ? ";  " + this.getCqMappingString() : "") + ")";
    }

    private String getClientMappingString() {
        if (this.clientMap == null) {
            return "";
        }
        Map<Long, Object> wids = this.clientMap.wireIDs;
        if (wids.size() == 0) {
            return "clients[]";
        }
        TreeSet<Long> sorted = new TreeSet<Long>(wids.keySet());
        StringBuffer result = new StringBuffer(sorted.size() * 70);
        result.append("clients[");
        Iterator it = sorted.iterator();
        int i = 1;
        while (it.hasNext()) {
            Long wireID = (Long)it.next();
            result.append(wireID).append("={").append(wids.get(wireID)).append('}');
            if (it.hasNext()) {
                result.append(", ");
            }
            ++i;
        }
        result.append("]");
        return result.toString();
    }

    private String getCqMappingString() {
        if (this.cqMap == null) {
            return "";
        }
        Map<Long, Object> wids = this.cqMap.wireIDs;
        if (wids.size() == 0) {
            return "cqs[]";
        }
        TreeSet<Long> sorted = new TreeSet<Long>(wids.keySet());
        StringBuffer result = new StringBuffer(sorted.size() * 70);
        result.append("cqs[");
        Iterator it = sorted.iterator();
        int i = 1;
        while (it.hasNext()) {
            Long wireID = (Long)it.next();
            result.append(wireID).append("={").append(wids.get(wireID)).append('}');
            if (it.hasNext()) {
                result.append(", ");
            }
            ++i;
        }
        result.append("]");
        return result.toString();
    }

    public Set getRealClientIDs(Collection integerIDs) {
        return this.clientMap.getRealIDs(integerIDs);
    }

    public Set getRealCqIDs(Collection integerIDs) {
        return this.cqMap.getRealIDs(integerIDs);
    }

    public String getRealCqID(Long integerID) {
        return (String)this.cqMap.getRealID(integerID);
    }

    private void ensureCqID(ServerCQ cq) {
        if (cq.getFilterID() == null) {
            assert (this.isLocalProfile);
            cq.setFilterID(this.cqMap.getWireID(cq.getServerCqName()));
        }
    }

    public boolean isLocalProfile() {
        return this.isLocalProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getQueuedFilterProfileMsgs(InternalDistributedMember member) {
        Map<InternalDistributedMember, LinkedList<OperationMessage>> map = this.filterProfileMsgQueue;
        synchronized (map) {
            if (this.filterProfileMsgQueue.containsKey(member)) {
                return new LinkedList(this.filterProfileMsgQueue.get(member));
            }
        }
        return Collections.EMPTY_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List removeQueuedFilterProfileMsgs(InternalDistributedMember member) {
        Map<InternalDistributedMember, LinkedList<OperationMessage>> map = this.filterProfileMsgQueue;
        synchronized (map) {
            if (this.filterProfileMsgQueue.containsKey(member)) {
                return new LinkedList(this.filterProfileMsgQueue.remove(member));
            }
        }
        return Collections.EMPTY_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToFilterProfileQueue(InternalDistributedMember member, OperationMessage message) {
        if (logger.isDebugEnabled()) {
            logger.debug("Adding message to filter profile queue: {} for member : {}", (Object)message, (Object)member);
        }
        Map<InternalDistributedMember, LinkedList<OperationMessage>> map = this.filterProfileMsgQueue;
        synchronized (map) {
            LinkedList<OperationMessage> msgs = this.filterProfileMsgQueue.get(member);
            if (msgs == null) {
                msgs = new LinkedList();
                this.filterProfileMsgQueue.put(member, msgs);
            }
            msgs.add(message);
        }
    }

    public void processQueuedFilterProfileMsgs(List msgs) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (msgs != null) {
            Iterator iter = msgs.iterator();
            while (iter.hasNext()) {
                try {
                    OperationMessage msg = (OperationMessage)iter.next();
                    if (isDebugEnabled) {
                        logger.debug("Processing the queued filter profile message :{}", (Object)msg);
                    }
                    msg.processRequest(this);
                }
                catch (Exception ex) {
                    logger.warn("Exception thrown while processing queued profile messages.", (Throwable)ex);
                }
            }
        }
    }

    public boolean isInterestedInAllKeys(Object id) {
        if (!this.clientMap.hasWireID(id)) {
            return false;
        }
        return this.getAllKeyClients().contains(this.clientMap.getWireID(id));
    }

    public boolean isInterestedInAllKeysInv(Object id) {
        if (!this.clientMap.hasWireID(id)) {
            return false;
        }
        return this.getAllKeyClientsInv().contains(this.clientMap.getWireID(id));
    }

    public Set getKeysOfInterest(Object id) {
        if (!this.clientMap.hasWireID(id)) {
            return null;
        }
        return this.getKeysOfInterest().get(this.clientMap.getWireID(id));
    }

    public int getKeysOfInterestSize() {
        return this.getKeysOfInterest().size();
    }

    public Set getKeysOfInterestInv(Object id) {
        if (!this.clientMap.hasWireID(id)) {
            return null;
        }
        return this.getKeysOfInterestInv().get(this.clientMap.getWireID(id));
    }

    public int getKeysOfInterestInvSize() {
        return this.getKeysOfInterestInv().size();
    }

    public Set getPatternsOfInterest(Object id) {
        if (!this.clientMap.hasWireID(id)) {
            return null;
        }
        Map<Object, Pattern> patterns = this.getPatternsOfInterest().get(this.clientMap.getWireID(id));
        if (patterns != null) {
            return new HashSet<Object>(patterns.keySet());
        }
        return null;
    }

    public int getPatternsOfInterestSize() {
        return this.getPatternsOfInterest().size();
    }

    public Set getPatternsOfInterestInv(Object id) {
        if (!this.clientMap.hasWireID(id)) {
            return null;
        }
        Map<Object, Pattern> interests = this.getPatternsOfInterestInv().get(this.clientMap.getWireID(id));
        if (interests != null) {
            return new HashSet<Object>(interests.keySet());
        }
        return null;
    }

    public int getPatternsOfInterestInvSize() {
        return this.getPatternsOfInterestInv().size();
    }

    public Set getFiltersOfInterest(Object id) {
        if (!this.clientMap.hasWireID(id)) {
            return null;
        }
        Map interests = this.getFiltersOfInterest().get(this.clientMap.getWireID(id));
        if (interests != null) {
            return new HashSet(interests.keySet());
        }
        return null;
    }

    public Set getFiltersOfInterestInv(Object id) {
        if (!this.clientMap.hasWireID(id)) {
            return null;
        }
        Map interests = this.getFiltersOfInterestInv().get(this.clientMap.getWireID(id));
        if (interests != null) {
            return new HashSet(interests.keySet());
        }
        return null;
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    public static interface TestHook {
        public void await();

        public void release();
    }

    class IDMap {
        long nextID = 1L;
        Map<Object, Long> realIDs = new ConcurrentHashMap<Object, Long>();
        Map<Long, Object> wireIDs = new ConcurrentHashMap<Long, Object>();
        boolean hasLongID;

        IDMap() {
        }

        synchronized boolean hasWireID(Object realId) {
            return this.realIDs.containsKey(realId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Long getWireID(Object realId) {
            Long result = this.realIDs.get(realId);
            if (result == null) {
                IDMap iDMap = this;
                synchronized (iDMap) {
                    result = this.realIDs.get(realId);
                    if (result == null) {
                        if (this.nextID == Integer.MAX_VALUE) {
                            this.hasLongID = true;
                        }
                        result = this.nextID++;
                        this.realIDs.put(realId, result);
                        this.wireIDs.put(result, realId);
                    }
                }
                if (logger.isTraceEnabled(LogMarker.BRIDGE_SERVER)) {
                    logger.trace(LogMarker.BRIDGE_SERVER, "Profile for {} mapped {} to {}", (Object)FilterProfile.this.region.getFullPath(), realId, (Object)result);
                }
            }
            return result;
        }

        Object getRealID(Long wireID) {
            return this.wireIDs.get(wireID);
        }

        public Set getRealIDs(Collection integerIDs) {
            if (integerIDs.size() == 0) {
                return Collections.emptySet();
            }
            HashSet<Object> result = new HashSet<Object>(integerIDs.size());
            Map<Long, Object> wids = this.wireIDs;
            for (Object id : integerIDs) {
                Object realID = wids.get(id);
                if (realID == null) continue;
                result.add(realID);
            }
            return result;
        }

        void removeIDMapping(Long mappedId) {
            Object clientId = this.wireIDs.remove(mappedId);
            if (clientId != null) {
                this.realIDs.remove(clientId);
            }
        }
    }

    public static class OperationMessage
    extends HighPriorityDistributionMessage
    implements MessageWithReply {
        public long profileVersion;
        boolean updatesAsInvalidates;
        String regionName;
        operationType opType;
        long clientID;
        Object interest;
        int processorId;
        ServerCQ cq;
        String serverCqName;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected void process(DistributionManager dm) {
            try {
                CacheDistributionAdvisee r = this.findRegion();
                if (r == null) {
                    if (!logger.isDebugEnabled()) return;
                    logger.debug("Region not found, so ignoring filter profile update: {}", (Object)this);
                    return;
                }
                if (!(r instanceof PartitionedRegion)) {
                    return;
                }
                CacheDistributionAdvisor cda = (CacheDistributionAdvisor)r.getDistributionAdvisor();
                CacheDistributionAdvisor.CacheProfile cp = (CacheDistributionAdvisor.CacheProfile)cda.getProfile(this.getSender());
                if (cp == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("No cache profile to update, adding filter profile message to queue. Message :{}", (Object)this);
                    }
                    FilterProfile localFP = ((PartitionedRegion)r).getFilterProfile();
                    localFP.addToFilterProfileQueue(this.getSender(), this);
                    dm.getCancelCriterion().checkCancelInProgress(null);
                    return;
                }
                cp.hasCacheServer = true;
                FilterProfile fp = cp.filterProfile;
                if (fp == null) {
                    if (!logger.isDebugEnabled()) return;
                    logger.debug("No filter profile to update: {}", (Object)this);
                    return;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Processing the filter profile request for : {}", (Object)this);
                }
                this.processRequest(fp);
                return;
            }
            catch (RuntimeException e) {
                logger.warn("Exception thrown while processing profile update", (Throwable)e);
                return;
            }
            finally {
                ReplyMessage reply = new ReplyMessage();
                reply.setProcessorId(this.processorId);
                reply.setRecipient(this.getSender());
                try {
                    dm.putOutgoing(reply);
                }
                catch (CancelException cancelException) {}
            }
        }

        public void processRequest(FilterProfile fp) {
            switch (this.opType) {
                case REGISTER_KEY: {
                    fp.registerClientInterest(this.clientID, this.interest, 0, this.updatesAsInvalidates);
                    break;
                }
                case REGISTER_PATTERN: {
                    fp.registerClientInterest(this.clientID, this.interest, 1, this.updatesAsInvalidates);
                    break;
                }
                case REGISTER_FILTER: {
                    fp.registerClientInterest(this.clientID, this.interest, 2, this.updatesAsInvalidates);
                    break;
                }
                case REGISTER_KEYS: {
                    fp.registerClientInterestList(this.clientID, (List)this.interest, this.updatesAsInvalidates);
                    break;
                }
                case UNREGISTER_KEY: {
                    fp.unregisterClientInterest(this.clientID, this.interest, 0);
                    break;
                }
                case UNREGISTER_PATTERN: {
                    fp.unregisterClientInterest(this.clientID, this.interest, 1);
                    break;
                }
                case UNREGISTER_FILTER: {
                    fp.unregisterClientInterest(this.clientID, this.interest, 2);
                    break;
                }
                case UNREGISTER_KEYS: {
                    fp.unregisterClientInterestList(this.clientID, (List)this.interest);
                    break;
                }
                case CLEAR: {
                    fp.clearInterestFor(this.clientID);
                    break;
                }
                case HAS_CQ: {
                    fp.cqCount.set(1);
                    break;
                }
                case REGISTER_CQ: {
                    fp.processRegisterCq(this.serverCqName, this.cq, true);
                    break;
                }
                case CLOSE_CQ: {
                    fp.processCloseCq(this.serverCqName);
                    break;
                }
                case STOP_CQ: {
                    fp.processStopCq(this.serverCqName);
                    break;
                }
                case SET_CQ_STATE: {
                    fp.processSetCqState(this.serverCqName, this.cq);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown filter profile operation type in operation: " + this);
                }
            }
        }

        private CacheDistributionAdvisee findRegion() {
            CacheDistributionAdvisee result = null;
            GemFireCacheImpl cache = null;
            try {
                LocalRegion lr;
                cache = GemFireCacheImpl.getInstance();
                if (cache != null && (lr = cache.getRegionByPathForProcessing(this.regionName)) instanceof CacheDistributionAdvisee) {
                    result = (CacheDistributionAdvisee)((Object)lr);
                }
            }
            catch (CancelException cancelException) {
                // empty catch block
            }
            return result;
        }

        @Override
        public int getDSFID() {
            return -116;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeInt(this.processorId);
            out.writeUTF(this.regionName);
            out.writeShort(this.opType.ordinal());
            out.writeBoolean(this.updatesAsInvalidates);
            out.writeLong(this.profileVersion);
            if (FilterProfile.isCqOp(this.opType)) {
                out.writeUTF(this.cq.getServerCqName());
                if (this.opType == operationType.REGISTER_CQ || this.opType == operationType.SET_CQ_STATE) {
                    InternalDataSerializer.invokeToData(this.cq, out);
                }
            } else {
                out.writeLong(this.clientID);
                DataSerializer.writeObject(this.interest, out);
            }
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.processorId = in.readInt();
            this.regionName = in.readUTF();
            this.opType = operationType.values()[in.readShort()];
            this.updatesAsInvalidates = in.readBoolean();
            this.profileVersion = in.readLong();
            if (FilterProfile.isCqOp(this.opType)) {
                this.serverCqName = in.readUTF();
                if (this.opType == operationType.REGISTER_CQ || this.opType == operationType.SET_CQ_STATE) {
                    this.cq = CqServiceProvider.readCq(in);
                }
            } else {
                this.clientID = in.readLong();
                this.interest = DataSerializer.readObject(in);
            }
        }

        @Override
        public String toString() {
            return this.getShortClassName() + "(processorId=" + this.processorId + "; region=" + this.regionName + "; operation=" + (Object)((Object)this.opType) + "; clientID=" + this.clientID + "; profileVersion=" + this.profileVersion + (FilterProfile.isCqOp(this.opType) ? "; CqName=" + this.serverCqName : "") + ")";
        }
    }

    public static enum interestType {
        NONE,
        UPDATES,
        INVALIDATES;

    }

    static enum operationType {
        REGISTER_KEY,
        REGISTER_KEYS,
        REGISTER_PATTERN,
        REGISTER_FILTER,
        UNREGISTER_KEY,
        UNREGISTER_KEYS,
        UNREGISTER_PATTERN,
        UNREGISTER_FILTER,
        CLEAR,
        HAS_CQ,
        REGISTER_CQ,
        CLOSE_CQ,
        STOP_CQ,
        SET_CQ_STATE;

    }
}

