/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.SystemTimer;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCacheEvent;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.ha.ThreadIdentifier;
import org.apache.geode.internal.cache.versions.RegionVersionVector;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.util.concurrent.StoppableCountDownLatch;
import org.apache.logging.log4j.Logger;

public class EventTracker {
    private static final Logger logger = LogService.getLogger();
    protected final ConcurrentMap<ThreadIdentifier, EventSeqnoHolder> recordedEvents = new ConcurrentHashMap<ThreadIdentifier, EventSeqnoHolder>(100);
    private final ConcurrentMap<ThreadIdentifier, BulkOpProcessed> recordedBulkOps = new ConcurrentHashMap<ThreadIdentifier, BulkOpProcessed>(100);
    private final ConcurrentMap<ThreadIdentifier, BulkOpHolder> recordedBulkOpVersionTags = new ConcurrentHashMap<ThreadIdentifier, BulkOpHolder>(100);
    private volatile InternalDistributedMember initialImageProvider;
    GemFireCacheImpl cache;
    String name;
    volatile boolean initialized;
    final StoppableCountDownLatch initializationLatch;

    public static ExpiryTask startTrackerServices(GemFireCacheImpl cache) {
        long expiryTime = Long.getLong("gemfire.messageTrackingTimeout", 300000L);
        ExpiryTask result = new ExpiryTask(cache, expiryTime);
        cache.getCCPTimer().scheduleAtFixedRate(result, expiryTime, expiryTime);
        return result;
    }

    public static void stopTrackerServices(GemFireCacheImpl cache) {
        cache.getEventTrackerTask().cancel();
    }

    public EventTracker(LocalRegion region) {
        this.cache = region.cache;
        this.name = "Event Tracker for " + region.getName();
        this.initializationLatch = new StoppableCountDownLatch(region.stopper, 1);
    }

    public void start() {
        if (this.cache.getEventTrackerTask() != null) {
            this.cache.getEventTrackerTask().addTracker(this);
        }
    }

    public void stop() {
        if (this.cache.getEventTrackerTask() != null) {
            this.cache.getEventTrackerTask().removeTracker(this);
        }
    }

    public Map<ThreadIdentifier, EventSeqnoHolder> getState() {
        HashMap<ThreadIdentifier, EventSeqnoHolder> result = new HashMap<ThreadIdentifier, EventSeqnoHolder>(this.recordedEvents.size());
        for (Map.Entry entry : this.recordedEvents.entrySet()) {
            EventSeqnoHolder holder = (EventSeqnoHolder)entry.getValue();
            result.put((ThreadIdentifier)entry.getKey(), new EventSeqnoHolder(holder.lastSeqno, null));
        }
        return result;
    }

    public void recordState(InternalDistributedMember provider, Map<ThreadIdentifier, EventSeqnoHolder> state) {
        this.initialImageProvider = provider;
        StringBuffer sb = null;
        if (logger.isDebugEnabled()) {
            sb = new StringBuffer(200);
            sb.append("Recording initial state for ").append(this.name).append(": ");
        }
        for (Map.Entry<ThreadIdentifier, EventSeqnoHolder> entry : state.entrySet()) {
            if (sb != null) {
                sb.append("\n  ").append(entry.getKey().expensiveToString()).append("; sequenceID=").append(entry.getValue());
            }
            this.recordSeqno(entry.getKey(), entry.getValue(), true);
        }
        if (sb != null) {
            logger.debug(sb);
        }
        this.setInitialized();
    }

    public void setInitialized() {
        this.initializationLatch.countDown();
        this.initialized = true;
    }

    public void waitOnInitialization() throws InterruptedException {
        this.initializationLatch.await();
    }

    protected void recordSeqno(ThreadIdentifier membershipID, EventSeqnoHolder evhObj) {
        this.recordSeqno(membershipID, evhObj, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordSeqno(ThreadIdentifier threadID, EventSeqnoHolder evh, boolean ifAbsent) {
        boolean removed;
        if (logger.isDebugEnabled()) {
            logger.debug("recording {} {}", (Object)threadID.expensiveToString(), (Object)evh.toString());
        }
        do {
            removed = false;
            EventSeqnoHolder oldEvh = this.recordedEvents.putIfAbsent(threadID, evh);
            if (oldEvh != null) {
                EventSeqnoHolder eventSeqnoHolder = oldEvh;
                synchronized (eventSeqnoHolder) {
                    if (oldEvh.removed) {
                        removed = true;
                    }
                    if (ifAbsent) {
                        break;
                    }
                    oldEvh.endOfLifeTimer = 0L;
                    if (oldEvh.lastSeqno < evh.lastSeqno) {
                        oldEvh.lastSeqno = evh.lastSeqno;
                        oldEvh.versionTag = evh.versionTag;
                    }
                }
            } else {
                evh.endOfLifeTimer = 0L;
            }
        } while (removed);
    }

    public void recordEvent(InternalCacheEvent event) {
        EventID eventID = event.getEventId();
        if (this.ignoreEvent(event, eventID)) {
            return;
        }
        LocalRegion lr = (LocalRegion)event.getRegion();
        ThreadIdentifier membershipID = new ThreadIdentifier(eventID.getMembershipID(), eventID.getThreadID());
        VersionTag tag = null;
        if (lr.getServerProxy() == null) {
            tag = event.getVersionTag();
            RegionVersionVector v = ((LocalRegion)event.getRegion()).getVersionVector();
            if (v != null && tag != null) {
                tag.setMemberID(v.getCanonicalId(tag.getMemberID()));
                if (tag.getPreviousMemberID() != null) {
                    tag.setPreviousMemberID(v.getCanonicalId(tag.getPreviousMemberID()));
                }
            }
        }
        if (lr.concurrencyChecksEnabled && (event.getOperation().isPutAll() || event.getOperation().isRemoveAll()) && lr.getServerProxy() == null) {
            this.recordBulkOpEvent(event, membershipID);
        }
        EventSeqnoHolder newEvh = new EventSeqnoHolder(eventID.getSequenceID(), tag);
        if (logger.isTraceEnabled()) {
            logger.trace("region event tracker recording {}", (Object)event);
        }
        this.recordSeqno(membershipID, newEvh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordBulkOpEvent(InternalCacheEvent event, ThreadIdentifier tid) {
        RegionVersionVector v;
        EventID eventID = event.getEventId();
        VersionTag tag = event.getVersionTag();
        if (tag == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("recording bulkOp event {} {} {} op={}", (Object)tid.expensiveToString(), (Object)eventID, (Object)tag, (Object)event.getOperation());
        }
        if ((v = ((LocalRegion)event.getRegion()).getVersionVector()) != null) {
            tag.setMemberID(v.getCanonicalId(tag.getMemberID()));
            if (tag.getPreviousMemberID() != null) {
                tag.setPreviousMemberID(v.getCanonicalId(tag.getPreviousMemberID()));
            }
        }
        boolean retry = false;
        do {
            BulkOpHolder old;
            BulkOpHolder bulkOpTracker;
            if ((bulkOpTracker = (BulkOpHolder)this.recordedBulkOpVersionTags.get(tid)) == null && (old = this.recordedBulkOpVersionTags.putIfAbsent(tid, bulkOpTracker = new BulkOpHolder())) != null) {
                retry = true;
                continue;
            }
            BulkOpHolder bulkOpHolder = bulkOpTracker;
            synchronized (bulkOpHolder) {
                if (bulkOpTracker.removed) {
                    retry = true;
                    continue;
                }
                bulkOpTracker.putVersionTag(eventID, event.getVersionTag());
                retry = false;
            }
        } while (retry);
    }

    public boolean hasSeenEvent(InternalCacheEvent event) {
        EventID eventID = event.getEventId();
        if (this.ignoreEvent(event, eventID)) {
            return false;
        }
        return this.hasSeenEvent(eventID, event);
    }

    public boolean hasSeenEvent(EventID eventID) {
        return this.hasSeenEvent(eventID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSeenEvent(EventID eventID, InternalCacheEvent tagHolder) {
        ThreadIdentifier membershipID = new ThreadIdentifier(eventID.getMembershipID(), eventID.getThreadID());
        EventSeqnoHolder evh = (EventSeqnoHolder)this.recordedEvents.get(membershipID);
        if (evh == null) {
            return false;
        }
        EventSeqnoHolder eventSeqnoHolder = evh;
        synchronized (eventSeqnoHolder) {
            if (evh.removed || evh.lastSeqno < eventID.getSequenceID()) {
                return false;
            }
            if (logger.isTraceEnabled(LogMarker.DISTRIBUTION_BRIDGE_SERVER)) {
                logger.trace(LogMarker.DISTRIBUTION_BRIDGE_SERVER, "Cache encountered replay of event with ID {}.  Highest recorded for this source is {}", (Object)eventID, (Object)evh.lastSeqno);
            }
            if (evh.lastSeqno == eventID.getSequenceID() && tagHolder != null && evh.versionTag != null) {
                ((EntryEventImpl)tagHolder).setVersionTag(evh.versionTag);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionTag findVersionTag(EventID eventID) {
        ThreadIdentifier threadID = new ThreadIdentifier(eventID.getMembershipID(), eventID.getThreadID());
        EventSeqnoHolder evh = (EventSeqnoHolder)this.recordedEvents.get(threadID);
        if (evh == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("search for version tag failed as no event is recorded for {}", (Object)threadID.expensiveToString());
            }
            return null;
        }
        EventSeqnoHolder eventSeqnoHolder = evh;
        synchronized (eventSeqnoHolder) {
            if (logger.isDebugEnabled()) {
                logger.debug("search for version tag located last event for {}: {}", (Object)threadID.expensiveToString(), (Object)evh);
            }
            if (evh.lastSeqno != eventID.getSequenceID()) {
                return null;
            }
            if (logger.isTraceEnabled(LogMarker.DISTRIBUTION_BRIDGE_SERVER) && evh.versionTag == null) {
                logger.trace(LogMarker.DISTRIBUTION_BRIDGE_SERVER, "Could not recover version tag.  Found event holder with no version tag for {}", (Object)eventID);
            }
            return evh.versionTag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionTag findVersionTagForGateway(EventID eventID) {
        ThreadIdentifier threadID = new ThreadIdentifier(eventID.getMembershipID(), eventID.getThreadID());
        EventSeqnoHolder evh = (EventSeqnoHolder)this.recordedEvents.get(threadID);
        if (evh == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("search for version tag failed as no event is recorded for {}", (Object)threadID.expensiveToString());
            }
            return null;
        }
        EventSeqnoHolder eventSeqnoHolder = evh;
        synchronized (eventSeqnoHolder) {
            if (logger.isDebugEnabled()) {
                logger.debug("search for version tag located last event for {}: {} {}", (Object)threadID.expensiveToString(), (Object)evh, (Object)eventID.getSequenceID());
            }
            if (evh.lastSeqno < eventID.getSequenceID()) {
                return null;
            }
            if (logger.isTraceEnabled(LogMarker.DISTRIBUTION_BRIDGE_SERVER) && evh.versionTag == null) {
                logger.trace(LogMarker.DISTRIBUTION_BRIDGE_SERVER, "Could not recover version tag.  Found event holder with no version tag for {}", (Object)eventID);
            }
            return evh.versionTag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionTag findVersionTagForBulkOp(EventID eventID) {
        ThreadIdentifier threadID = new ThreadIdentifier(eventID.getMembershipID(), eventID.getThreadID());
        BulkOpHolder evh = (BulkOpHolder)this.recordedBulkOpVersionTags.get(threadID);
        if (evh == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("search for version tag failed as no events are recorded for {}", (Object)threadID.expensiveToString());
            }
            return null;
        }
        BulkOpHolder bulkOpHolder = evh;
        synchronized (bulkOpHolder) {
            if (logger.isDebugEnabled()) {
                logger.debug("search for version tag located event holder for {}: {}", (Object)threadID.expensiveToString(), (Object)evh);
            }
            return evh.entryVersionTags.get(eventID);
        }
    }

    private boolean ignoreEvent(InternalCacheEvent event, EventID eventID) {
        if (eventID == null) {
            return true;
        }
        boolean isVersioned = event.getVersionTag() != null;
        boolean isClient = event.hasClientOrigin();
        if (isVersioned && isClient) {
            return false;
        }
        boolean isEntry = event.getOperation().isEntry();
        boolean isPr = event.getRegion().getAttributes().getDataPolicy().withPartitioning() || ((LocalRegion)event.getRegion()).isUsedForPartitionedRegionBucket();
        return !isClient && isEntry && !isPr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncBulkOp(Runnable r, EventID eventID) {
        Assert.assertTrue(eventID != null);
        ThreadIdentifier membershipID = new ThreadIdentifier(eventID.getMembershipID(), eventID.getThreadID());
        BulkOpProcessed opSyncObj = this.recordedBulkOps.putIfAbsent(membershipID, new BulkOpProcessed(false));
        if (opSyncObj == null) {
            opSyncObj = (BulkOpProcessed)this.recordedBulkOps.get(membershipID);
        }
        BulkOpProcessed bulkOpProcessed = opSyncObj;
        synchronized (bulkOpProcessed) {
            try {
                if (opSyncObj.getStatus() && logger.isDebugEnabled()) {
                    logger.debug("SyncBulkOp: The operation was performed by another thread.");
                } else {
                    this.recordBulkOpStart(membershipID);
                    r.run();
                    opSyncObj.setStatus(true);
                    this.recordedBulkOps.remove(membershipID);
                }
            }
            finally {
                this.recordedBulkOps.remove(membershipID);
            }
        }
    }

    public void recordBulkOpStart(ThreadIdentifier tid) {
        if (logger.isDebugEnabled()) {
            logger.debug("recording bulkOp start for {}", (Object)tid.expensiveToString());
        }
        this.recordedBulkOpVersionTags.remove(tid);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isInitialImageProvider(DistributedMember mbr) {
        return this.initialImageProvider != null && mbr != null && this.initialImageProvider.equals(mbr);
    }

    protected ConcurrentMap<ThreadIdentifier, BulkOpHolder> getRecordedBulkOpVersionTags() {
        return this.recordedBulkOpVersionTags;
    }

    public String toString() {
        return "" + this.name + "(initialized=" + this.initialized + ")";
    }

    static class ExpiryTask
    extends SystemTimer.SystemTimerTask {
        GemFireCacheImpl cache;
        long expiryTime;
        List trackers = new LinkedList();

        public ExpiryTask(GemFireCacheImpl cache, long expiryTime) {
            this.cache = cache;
            this.expiryTime = expiryTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addTracker(EventTracker tracker) {
            List list = this.trackers;
            synchronized (list) {
                this.trackers.add(tracker);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeTracker(EventTracker tracker) {
            List list = this.trackers;
            synchronized (list) {
                this.trackers.remove(tracker);
            }
        }

        int getNumberOfTrackers() {
            return this.trackers.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run2() {
            long now = System.currentTimeMillis();
            long timeout = now - this.expiryTime;
            boolean traceEnabled = logger.isTraceEnabled();
            List list = this.trackers;
            synchronized (list) {
                for (EventTracker tracker : this.trackers) {
                    Object object;
                    Object evh;
                    Map.Entry e;
                    if (traceEnabled) {
                        logger.trace("{} sweeper: starting", (Object)tracker.name);
                    }
                    Iterator it2 = tracker.recordedEvents.entrySet().iterator();
                    while (it2.hasNext()) {
                        e = it2.next();
                        object = evh = (EventSeqnoHolder)e.getValue();
                        synchronized (object) {
                            if (((EventSeqnoHolder)evh).endOfLifeTimer == 0L) {
                                ((EventSeqnoHolder)evh).endOfLifeTimer = now;
                            }
                            if (((EventSeqnoHolder)evh).endOfLifeTimer <= timeout) {
                                ((EventSeqnoHolder)evh).removed = true;
                                ((EventSeqnoHolder)evh).lastSeqno = -1L;
                                if (traceEnabled) {
                                    logger.trace("{} sweeper: removing {}", (Object)tracker.name, e.getKey());
                                }
                                it2.remove();
                            }
                        }
                    }
                    it2 = tracker.recordedBulkOpVersionTags.entrySet().iterator();
                    while (it2.hasNext()) {
                        e = it2.next();
                        object = evh = (BulkOpHolder)e.getValue();
                        synchronized (object) {
                            if (((BulkOpHolder)evh).endOfLifeTimer == 0L) {
                                ((BulkOpHolder)evh).endOfLifeTimer = now;
                            }
                            if (((BulkOpHolder)evh).endOfLifeTimer <= timeout) {
                                ((BulkOpHolder)evh).removed = true;
                                if (logger.isTraceEnabled()) {
                                    logger.trace("{} sweeper: removing bulkOp {}", (Object)tracker.name, e.getKey());
                                }
                                it2.remove();
                            }
                        }
                    }
                    if (!traceEnabled) continue;
                    logger.trace("{} sweeper: done", (Object)tracker.name);
                }
            }
        }
    }

    protected static class BulkOpHolder {
        public boolean removed;
        public Map<EventID, VersionTag> entryVersionTags = new HashMap<EventID, VersionTag>();
        transient long endOfLifeTimer;

        BulkOpHolder() {
        }

        public void putVersionTag(EventID eventId, VersionTag versionTag) {
            this.entryVersionTags.put(eventId, versionTag);
            this.endOfLifeTimer = 0L;
        }

        public String toString() {
            return "BulkOpHolder tags=" + this.entryVersionTags;
        }
    }

    static class BulkOpProcessed {
        private boolean processed;

        BulkOpProcessed(boolean status) {
            this.processed = status;
        }

        void setStatus(boolean status) {
            this.processed = status;
        }

        boolean getStatus() {
            return this.processed;
        }

        public String toString() {
            return "BULKOP(" + this.processed + ")";
        }
    }

    static class EventSeqnoHolder
    implements DataSerializable {
        private static final long serialVersionUID = 8137262960763308046L;
        long lastSeqno = -1L;
        transient long endOfLifeTimer;
        transient boolean removed;
        VersionTag versionTag;

        EventSeqnoHolder(long id, VersionTag versionTag) {
            this.lastSeqno = id;
            this.versionTag = versionTag;
        }

        public EventSeqnoHolder() {
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("seqNo").append(this.lastSeqno);
            if (this.versionTag != null) {
                result.append(",").append(this.versionTag);
            }
            return result.toString();
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            this.lastSeqno = in.readLong();
            this.versionTag = (VersionTag)DataSerializer.readObject(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            out.writeLong(this.lastSeqno);
            DataSerializer.writeObject(this.versionTag, out);
        }
    }
}

