/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.apache.geode.CancelException;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.InvalidDeltaException;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheEvent;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheLoaderException;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.DiskAccessException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.MembershipAttributes;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAccessException;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.RegionDistributionException;
import org.apache.geode.cache.RegionMembershipListener;
import org.apache.geode.cache.ResumptionAction;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.TransactionId;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueImpl;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.cache.persistence.PersistentReplicatesOfflineException;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.LockServiceDestroyedException;
import org.apache.geode.distributed.Role;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionAdvisee;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.locks.DLockRemoteToken;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.i18n.StringId;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.AbstractRegionMap;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.CacheDistributionAdvisee;
import org.apache.geode.internal.cache.CacheDistributionAdvisor;
import org.apache.geode.internal.cache.CacheObserverHolder;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.CreateRegionProcessor;
import org.apache.geode.internal.cache.DestroyOperation;
import org.apache.geode.internal.cache.DestroyRegionOperation;
import org.apache.geode.internal.cache.DiskRegion;
import org.apache.geode.internal.cache.DiskRegionStats;
import org.apache.geode.internal.cache.DistributedClearOperation;
import org.apache.geode.internal.cache.DistributedPutAllOperation;
import org.apache.geode.internal.cache.DistributedRegionFunctionStreamingMessage;
import org.apache.geode.internal.cache.DistributedRemoveAllOperation;
import org.apache.geode.internal.cache.DistributedTombstoneOperation;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.EventTracker;
import org.apache.geode.internal.cache.ExpiryTask;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.ImageState;
import org.apache.geode.internal.cache.InMemoryPersistentMemberView;
import org.apache.geode.internal.cache.InitialImageOperation;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.InvalidateOperation;
import org.apache.geode.internal.cache.InvalidateRegionOperation;
import org.apache.geode.internal.cache.KeyInfo;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEventImpl;
import org.apache.geode.internal.cache.ReliableDistributionData;
import org.apache.geode.internal.cache.ReliableMessageQueue;
import org.apache.geode.internal.cache.RemoteDestroyMessage;
import org.apache.geode.internal.cache.RemoteFetchVersionMessage;
import org.apache.geode.internal.cache.RemoteInvalidateMessage;
import org.apache.geode.internal.cache.RemoteOperationException;
import org.apache.geode.internal.cache.RemotePutMessage;
import org.apache.geode.internal.cache.RemoteRegionOperation;
import org.apache.geode.internal.cache.RoleEventImpl;
import org.apache.geode.internal.cache.SearchLoadAndWriteProcessor;
import org.apache.geode.internal.cache.SendQueueOperation;
import org.apache.geode.internal.cache.StateFlushOperation;
import org.apache.geode.internal.cache.TXStateInterface;
import org.apache.geode.internal.cache.UpdateAttributesProcessor;
import org.apache.geode.internal.cache.UpdateEntryVersionOperation;
import org.apache.geode.internal.cache.UpdateOperation;
import org.apache.geode.internal.cache.VersionTagHolder;
import org.apache.geode.internal.cache.control.InternalResourceManager;
import org.apache.geode.internal.cache.control.MemoryEvent;
import org.apache.geode.internal.cache.execute.DistributedRegionFunctionExecutor;
import org.apache.geode.internal.cache.execute.DistributedRegionFunctionResultSender;
import org.apache.geode.internal.cache.execute.DistributedRegionFunctionResultWaiter;
import org.apache.geode.internal.cache.execute.FunctionStats;
import org.apache.geode.internal.cache.execute.LocalResultCollector;
import org.apache.geode.internal.cache.execute.RegionFunctionContextImpl;
import org.apache.geode.internal.cache.execute.ServerToClientFunctionResultSender;
import org.apache.geode.internal.cache.lru.LRUEntry;
import org.apache.geode.internal.cache.persistence.CreatePersistentRegionProcessor;
import org.apache.geode.internal.cache.persistence.PersistenceAdvisor;
import org.apache.geode.internal.cache.persistence.PersistenceAdvisorImpl;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.cache.persistence.PersistentMemberManager;
import org.apache.geode.internal.cache.persistence.PersistentMemberView;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;
import org.apache.geode.internal.cache.versions.ConcurrentCacheModificationException;
import org.apache.geode.internal.cache.versions.RegionVersionVector;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.cache.wan.AsyncEventQueueConfigurationException;
import org.apache.geode.internal.cache.wan.GatewaySenderConfigurationException;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.sequencelog.RegionLogger;
import org.apache.geode.internal.util.concurrent.StoppableCountDownLatch;
import org.apache.logging.log4j.Logger;

public class DistributedRegion
extends LocalRegion
implements CacheDistributionAdvisee {
    private static final Logger logger = LogService.getLogger();
    public static boolean TEST_HOOK_ADD_PROFILE = false;
    private final Object dlockMonitor = new Object();
    final CacheDistributionAdvisor distAdvisor;
    private DistributedLockService dlockService;
    protected final AdvisorListener advisorListener = new AdvisorListener();
    protected final HashSet missingRequiredRoles = new HashSet();
    protected volatile boolean isMissingRequiredRoles = false;
    private final boolean requiresReliabilityCheck;
    protected final ReliableMessageQueue rmq;
    protected final StoppableCountDownLatch initializationLatchAfterMemberTimeout;
    private final PersistenceAdvisor persistenceAdvisor;
    private final PersistentMemberID persistentId;
    private volatile boolean generateVersionTag = true;
    public static boolean ignoreReconnect = false;
    private final Object clearLock = new Object();
    private static AtomicBoolean loggedNetworkPartitionWarning = new AtomicBoolean(false);
    private boolean isInitializingThread = false;
    private boolean giiMissingRequiredRoles = false;
    private final Set<DistributedMember> memoryThresholdReachedMembers = new CopyOnWriteArraySet<DistributedMember>();
    public static boolean LOCALCLEAR_TESTHOOK;

    protected DistributedRegion(String regionName, RegionAttributes attrs, LocalRegion parentRegion, GemFireCacheImpl cache, InternalRegionArguments internalRegionArgs) {
        super(regionName, attrs, parentRegion, cache, internalRegionArgs);
        this.initializationLatchAfterMemberTimeout = new StoppableCountDownLatch(this.getCancelCriterion(), 1);
        this.distAdvisor = this.createDistributionAdvisor(internalRegionArgs);
        if (this.getDistributionManager().getConfig().getEnableNetworkPartitionDetection() && !this.isInternalRegion() && !attrs.getScope().isAck() && !this.doesNotDistribute() && attrs.getDataPolicy().withStorage()) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.DistributedRegion_REGION_0_1_SPLITBRAIN_CONFIG_WARNING, new Object[]{regionName, attrs.getScope()}));
        }
        if (!this.getDistributionManager().getConfig().getEnableNetworkPartitionDetection() && attrs.getDataPolicy().withPersistence() && !loggedNetworkPartitionWarning.getAndSet(true)) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.DistributedRegion_REGION_0_ENABLE_NETWORK_PARTITION_WARNING, new Object[]{regionName, attrs.getScope()}));
        }
        boolean setRequiresReliabilityCheck = attrs.getMembershipAttributes().hasRequiredRoles() && !attrs.getMembershipAttributes().getLossAction().isAllAccess() && !attrs.getMembershipAttributes().getLossAction().isReconnect();
        HashSet<Role> reqRoles = new HashSet<Role>(attrs.getMembershipAttributes().getRequiredRoles());
        reqRoles.removeAll(this.getSystem().getDistributedMember().getRoles());
        if (reqRoles.isEmpty()) {
            setRequiresReliabilityCheck = false;
        }
        this.requiresReliabilityCheck = setRequiresReliabilityCheck;
        Object tmp = null;
        if (this.requiresReliabilityCheck) {
            // empty if block
        }
        this.rmq = tmp;
        if (internalRegionArgs.isUsedForPartitionedRegionBucket()) {
            this.persistenceAdvisor = internalRegionArgs.getPersistenceAdvisor();
        } else if (this.allowsPersistence()) {
            DistributedLockService dl = cache.getPartitionedRegionLockService();
            try {
                DiskRegionStats diskStats;
                PersistentMemberView storage;
                if (this.getDataPolicy().withPersistence()) {
                    storage = this.getDiskRegion();
                    diskStats = this.getDiskRegion().getStats();
                } else {
                    storage = new InMemoryPersistentMemberView();
                    diskStats = null;
                }
                PersistentMemberManager memberManager = cache.getPersistentMemberManager();
                this.persistenceAdvisor = new PersistenceAdvisorImpl(this.distAdvisor, dl, storage, this.getFullPath(), diskStats, memberManager);
            }
            catch (Exception e) {
                throw new InternalGemFireError("Couldn't recover persistence");
            }
        } else {
            this.persistenceAdvisor = null;
        }
        this.persistentId = this.persistenceAdvisor != null ? this.persistenceAdvisor.generatePersistentID() : null;
    }

    @Override
    public void createEventTracker() {
        this.eventTracker = new EventTracker(this);
        this.eventTracker.start();
    }

    protected CacheDistributionAdvisor createDistributionAdvisor(InternalRegionArguments internalRegionArgs) {
        return CacheDistributionAdvisor.createCacheDistributionAdvisor(this);
    }

    public boolean allowsPersistence() {
        return true;
    }

    @Override
    public boolean requiresOneHopForMissingEntry(EntryEventImpl event) {
        if (event.isOriginRemote()) {
            return false;
        }
        if (event.getOperation().isLocal()) {
            return false;
        }
        if (event.getVersionTag() != null && event.getVersionTag().getRegionVersion() > 0L) {
            return false;
        }
        if (!this.generateVersionTag) {
            return true;
        }
        return this.concurrencyChecksEnabled && this.srp == null && !this.isTX() && this.scope.isDistributed() && !this.dataPolicy.withReplication();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean virtualPut(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) throws TimeoutException, CacheWriterException {
        boolean isTraceEnabled = logger.isTraceEnabled();
        Lock dlock = null;
        if (!(!this.scope.isGlobal() || event.isOriginRemote() || event.isNetSearch() || event.isNetLoad() || event.isLocalLoad() || event.isSingleHopPutOp())) {
            dlock = this.getDistributedLockIfGlobal(event.getKey());
        }
        if (isTraceEnabled) {
            logger.trace("virtualPut invoked for event {}", (Object)event);
        }
        try {
            if (!this.hasSeenEvent(event)) {
                RegionEntry re;
                if (!(!this.requiresOneHopForMissingEntry(event) || (re = this.getRegionEntry(event.getKey())) != null && this.generateVersionTag || event.isBulkOpInProgress() && !this.dataPolicy.withStorage())) {
                    boolean didDistribute = RemotePutMessage.distribute(event, lastModified, false, false, expectedOldValue, requireOldValue, !this.generateVersionTag);
                    if (!didDistribute && isTraceEnabled) {
                        logger.trace("Unable to perform one-hop messaging");
                    }
                    if (!this.generateVersionTag && !didDistribute) {
                        throw new PersistentReplicatesOfflineException();
                    }
                    if (didDistribute) {
                        if (isTraceEnabled) {
                            logger.trace("Event after remotePut operation: {}", (Object)event);
                        }
                        if (event.getVersionTag() == null) {
                            boolean bl = false;
                            return bl;
                        }
                    }
                }
                boolean bl = super.virtualPut(event, ifNew, ifOld, expectedOldValue, requireOldValue, lastModified, overwriteDestroyed);
                return bl;
            }
            if (event.getDeltaBytes() != null && event.getRawNewValue() == null) {
                throw new InvalidDeltaException("Cache encountered replay of event containing delta bytes for key " + event.getKey());
            }
            if (isTraceEnabled) {
                logger.trace("DR.virtualPut: this cache has already seen this event {}", (Object)event);
            }
            if (event.isBulkOpInProgress() && !event.isOriginRemote()) {
                event.getPutAllOperation().addEntry(event, true);
            }
            event.makeCreate();
            if (!this.getConcurrencyChecksEnabled() || event.hasValidVersionTag()) {
                this.distributeUpdate(event, lastModified, ifNew, ifOld, expectedOldValue, requireOldValue);
                event.invokeCallbacks(this, true, true);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (dlock != null) {
                dlock.unlock();
            }
        }
    }

    @Override
    protected RegionEntry basicPutEntry(EntryEventImpl event, long lastModified) throws TimeoutException, CacheWriterException {
        RegionEntry re;
        boolean isTraceEnabled = logger.isTraceEnabled();
        if (isTraceEnabled) {
            logger.trace("basicPutEntry invoked for event {}", (Object)event);
        }
        if (this.requiresOneHopForMissingEntry(event) && ((re = this.getRegionEntry(event.getKey())) == null || !this.generateVersionTag)) {
            boolean ifNew = false;
            boolean ifOld = false;
            boolean didDistribute = RemotePutMessage.distribute(event, lastModified, false, false, null, false, !this.generateVersionTag);
            if (!this.generateVersionTag && !didDistribute) {
                throw new PersistentReplicatesOfflineException();
            }
            if (didDistribute && isTraceEnabled) {
                logger.trace("Event after remotePut for basicPutEntry: {}", (Object)event);
            }
        }
        return super.basicPutEntry(event, lastModified);
    }

    @Override
    public void performPutAllEntry(EntryEventImpl event) {
        if (this.isTX()) {
            event.getPutAllOperation().addEntry(event);
        } else {
            this.getSharedDataView().putEntry(event, false, false, null, false, 0L, false);
        }
    }

    @Override
    public void performRemoveAllEntry(EntryEventImpl event) {
        if (this.isTX()) {
            event.getRemoveAllOperation().addEntry(event);
        } else {
            this.basicDestroy(event, true, null);
        }
    }

    @Override
    public void basicPutPart3(EntryEventImpl event, RegionEntry entry, boolean isInitialized, long lastModified, boolean invokeCallbacks, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue) {
        this.distributeUpdate(event, lastModified, false, false, null, false);
        super.basicPutPart3(event, entry, isInitialized, lastModified, invokeCallbacks, ifNew, ifOld, expectedOldValue, requireOldValue);
    }

    protected void distributeUpdate(EntryEventImpl event, long lastModified, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue) {
        if (!(event.isOriginRemote() || event.isNetSearch() || event.isBulkOpInProgress())) {
            boolean distribute = true;
            if (event.getInhibitDistribution()) {
                distribute = false;
            }
            if (distribute) {
                UpdateOperation op = new UpdateOperation(event, lastModified);
                if (logger.isTraceEnabled()) {
                    logger.trace("distributing operation for event : {} : for region : {}", (Object)event, (Object)this.getName());
                }
                op.distribute();
            }
        }
    }

    protected void setGeneratedVersionTag(boolean generateVersionTag) {
        this.enableConcurrencyChecks();
        this.generateVersionTag = generateVersionTag;
    }

    protected boolean getGenerateVersionTag() {
        return this.generateVersionTag;
    }

    @Override
    protected boolean shouldGenerateVersionTag(RegionEntry entry, EntryEventImpl event) {
        if (logger.isTraceEnabled()) {
            logger.trace("shouldGenerateVersionTag this.generateVersionTag={} ccenabled={} dataPolicy={} event:{}", (Object)this.generateVersionTag, (Object)this.concurrencyChecksEnabled, (Object)this.dataPolicy, (Object)event);
        }
        if (!this.concurrencyChecksEnabled || this.dataPolicy == DataPolicy.EMPTY || !this.generateVersionTag) {
            return false;
        }
        if (this.srp != null) {
            return false;
        }
        if (event.getVersionTag() != null && !event.getVersionTag().isGatewayTag()) {
            return false;
        }
        if (event.getOperation().isLocal()) {
            return false;
        }
        if (!event.isOriginRemote() && this.dataPolicy.withReplication()) {
            return true;
        }
        if (!this.dataPolicy.withReplication() && !this.dataPolicy.withPersistence()) {
            return entry.getVersionStamp().hasValidVersion();
        }
        if (!event.isOriginRemote() && event.getDistributedMember() != null && !event.getDistributedMember().equals(this.getMyId())) {
            return event.getVersionTag() == null;
        }
        return false;
    }

    @Override
    protected void checkForNoAccess() {
        if (this.requiresReliabilityCheck && this.isMissingRequiredRoles && this.getMembershipAttributes().getLossAction().isNoAccess()) {
            HashSet hashSet = this.missingRequiredRoles;
            synchronized (hashSet) {
                if (!this.isMissingRequiredRoles) {
                    return;
                }
                Set roles = Collections.unmodifiableSet(new HashSet(this.missingRequiredRoles));
                throw new RegionAccessException(LocalizedStrings.DistributedRegion_OPERATION_IS_DISALLOWED_BY_LOSSACTION_0_BECAUSE_THESE_REQUIRED_ROLES_ARE_MISSING_1.toLocalizedString(this.getMembershipAttributes().getLossAction(), roles), this.getFullPath(), roles);
            }
        }
    }

    @Override
    protected void checkForLimitedOrNoAccess() {
        if (this.requiresReliabilityCheck && this.isMissingRequiredRoles && (this.getMembershipAttributes().getLossAction().isNoAccess() || this.getMembershipAttributes().getLossAction().isLimitedAccess())) {
            HashSet hashSet = this.missingRequiredRoles;
            synchronized (hashSet) {
                if (!this.isMissingRequiredRoles) {
                    return;
                }
                Set roles = Collections.unmodifiableSet(new HashSet(this.missingRequiredRoles));
                Assert.assertTrue(!roles.isEmpty());
                throw new RegionAccessException(LocalizedStrings.DistributedRegion_OPERATION_IS_DISALLOWED_BY_LOSSACTION_0_BECAUSE_THESE_REQUIRED_ROLES_ARE_MISSING_1.toLocalizedString(this.getMembershipAttributes().getLossAction(), roles), this.getFullPath(), roles);
            }
        }
    }

    @Override
    protected void handleReliableDistribution(ReliableDistributionData data, Set successfulRecipients) {
        this.handleReliableDistribution(data, successfulRecipients, Collections.EMPTY_SET, Collections.EMPTY_SET);
    }

    protected void handleReliableDistribution(ReliableDistributionData data, Set successfulRecipients, Set otherRecipients1, Set otherRecipients2) {
        if (this.requiresReliabilityCheck) {
            MembershipAttributes ra = this.getMembershipAttributes();
            Set recipients = successfulRecipients;
            HashSet<Role> roles = new HashSet<Role>();
            for (InternalDistributedMember mbr : recipients) {
                if (mbr == null) continue;
                roles.addAll(mbr.getRoles());
            }
            for (InternalDistributedMember mbr : otherRecipients1) {
                if (mbr == null) continue;
                roles.addAll(mbr.getRoles());
            }
            for (InternalDistributedMember mbr : otherRecipients2) {
                if (mbr == null) continue;
                roles.addAll(mbr.getRoles());
            }
            HashSet<Role> failedRoles = new HashSet<Role>(ra.getRequiredRoles());
            failedRoles.removeAll(roles);
            if (failedRoles.isEmpty()) {
                return;
            }
            throw new RegionDistributionException(LocalizedStrings.DistributedRegion_OPERATION_DISTRIBUTION_MAY_HAVE_FAILED_TO_NOTIFY_THESE_REQUIRED_ROLES_0.toLocalizedString(failedRoles), this.getFullPath(), failedRoles);
        }
    }

    protected boolean isNoDistributionOk() {
        if (this.requiresReliabilityCheck) {
            MembershipAttributes ra = this.getMembershipAttributes();
            Set<Role> failedRoles = ra.getRequiredRoles();
            throw new RegionDistributionException(LocalizedStrings.DistributedRegion_OPERATION_DISTRIBUTION_WAS_NOT_DONE_TO_THESE_REQUIRED_ROLES_0.toLocalizedString(failedRoles), this.getFullPath(), failedRoles);
        }
        return true;
    }

    public boolean doesNotDistribute() {
        return false;
    }

    @Override
    public boolean shouldSyncForCrashedMember(InternalDistributedMember id) {
        return !this.doesNotDistribute() && super.shouldSyncForCrashedMember(id);
    }

    protected Set adjustForQueuing(Set recipients) {
        Set result = null;
        return result;
    }

    public static boolean intersects(Set a, Set b) {
        Set target;
        Iterator it;
        if (a.size() <= b.size()) {
            it = a.iterator();
            target = b;
        } else {
            it = b.iterator();
            target = a;
        }
        while (it.hasNext()) {
            if (!target.contains(it.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean requiresReliabilityCheck() {
        return this.requiresReliabilityCheck;
    }

    @Override
    protected boolean isExpirationAllowed(ExpiryTask expiry) {
        if (this.requiresReliabilityCheck && this.isMissingRequiredRoles) {
            if (this.getMembershipAttributes().getLossAction().isNoAccess()) {
                return false;
            }
            if (this.getMembershipAttributes().getLossAction().isLimitedAccess() && expiry.isDistributedAction()) {
                return false;
            }
        }
        return true;
    }

    protected boolean resumeReliability(InternalDistributedMember id, Set newlyAcquiredRoles) {
        boolean async = false;
        try {
            ResumptionAction ra = this.getMembershipAttributes().getResumptionAction();
            if (ra.isNone()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Reliability resumption for action of none");
                }
                this.resumeExpiration();
            } else if (ra.isReinitialize()) {
                async = true;
                this.asyncResumeReliability(id, newlyAcquiredRoles);
            }
        }
        catch (Exception e) {
            logger.fatal(LocalizedMessage.create(LocalizedStrings.DistributedRegion_UNEXPECTED_EXCEPTION), (Throwable)e);
        }
        return async;
    }

    private void asyncResumeReliability(final InternalDistributedMember id, final Set newlyAcquiredRoles) throws RejectedExecutionException {
        final ResumptionAction ra = this.getMembershipAttributes().getResumptionAction();
        this.getDistributionManager().getWaitingThreadPool().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block8: {
                    try {
                        Cloneable event;
                        if (!ra.isReinitialize()) break block8;
                        if (logger.isDebugEnabled()) {
                            logger.debug("Reliability resumption for action of reinitialize");
                        }
                        if (!DistributedRegion.this.isDestroyed() && !DistributedRegion.this.cache.isClosed()) {
                            event = new RegionEventImpl((Region)DistributedRegion.this, Operation.REGION_REINITIALIZE, null, false, (DistributedMember)DistributedRegion.this.getMyId(), DistributedRegion.this.generateEventID());
                            DistributedRegion.this.reinitialize(null, (RegionEventImpl)event);
                        }
                        event = DistributedRegion.this.missingRequiredRoles;
                        synchronized (event) {
                            DistributedRegion.this.missingRequiredRoles.notifyAll();
                            if (DistributedRegion.this.hasListener() && id != null) {
                                RoleEventImpl relEvent = new RoleEventImpl((Region)DistributedRegion.this, Operation.REGION_CREATE, null, true, (DistributedMember)id, newlyAcquiredRoles);
                                DistributedRegion.this.dispatchListenerEvent(EnumListenerEvent.AFTER_ROLE_GAIN, relEvent);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.fatal(LocalizedMessage.create(LocalizedStrings.DistributedRegion_UNEXPECTED_EXCEPTION), (Throwable)e);
                    }
                }
            }
        });
    }

    private void resumeExpiration() {
        boolean isNoAccess = this.getMembershipAttributes().getLossAction().isNoAccess();
        boolean isLimitedAccess = this.getMembershipAttributes().getLossAction().isLimitedAccess();
        if (!isNoAccess && !isLimitedAccess) {
            return;
        }
        if (this.getEntryTimeToLive().getTimeout() > 0 && (isNoAccess || isLimitedAccess && this.getEntryTimeToLive().getAction().isDistributed())) {
            this.rescheduleEntryExpiryTasks();
        } else if (this.getEntryIdleTimeout().getTimeout() > 0 && (isNoAccess || isLimitedAccess && this.getEntryIdleTimeout().getAction().isDistributed())) {
            this.rescheduleEntryExpiryTasks();
        } else if (this.getCustomEntryTimeToLive() != null || this.getCustomEntryIdleTimeout() != null) {
            this.rescheduleEntryExpiryTasks();
        }
        if (this.getRegionTimeToLive().getTimeout() > 0 && (isNoAccess || isLimitedAccess && this.getRegionTimeToLive().getAction().isDistributed())) {
            this.addTTLExpiryTask();
        }
        if (this.getRegionIdleTimeout().getTimeout() > 0 && (isNoAccess || isLimitedAccess && this.getRegionIdleTimeout().getAction().isDistributed())) {
            this.addIdleExpiryTask();
        }
    }

    protected boolean lostReliability(InternalDistributedMember id, Set newlyMissingRoles) {
        if (ignoreReconnect) {
            return false;
        }
        boolean async = false;
        try {
            if (this.getMembershipAttributes().getLossAction().isReconnect()) {
                async = true;
                if (this.isInitializingThread) {
                    this.doLostReliability(true, id, newlyMissingRoles);
                } else {
                    this.doLostReliability(false, id, newlyMissingRoles);
                }
            }
        }
        catch (CancelException cce) {
            throw cce;
        }
        catch (Exception e) {
            logger.fatal(LocalizedMessage.create(LocalizedStrings.DistributedRegion_UNEXPECTED_EXCEPTION), (Throwable)e);
        }
        return async;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLostReliability(boolean isInitializing, final InternalDistributedMember id, final Set newlyMissingRoles) {
        block8: {
            try {
                if (!isInitializing) {
                    Thread t = new Thread(LocalizedStrings.DistributedRegion_RECONNECT_DISTRIBUTED_SYSTEM.toLocalizedString()){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                logger.debug("Reliability loss with policy of reconnect and membership thread doing reconnect");
                                DistributedRegion.this.initializationLatchAfterMemberTimeout.await();
                                DistributedRegion.this.getSystem().tryReconnect(false, "Role Loss", DistributedRegion.this.getCache());
                                HashSet hashSet = DistributedRegion.this.missingRequiredRoles;
                                synchronized (hashSet) {
                                    DistributedRegion.this.missingRequiredRoles.notifyAll();
                                    if (DistributedRegion.this.hasListener() && id != null) {
                                        RoleEventImpl relEvent = new RoleEventImpl((Region)DistributedRegion.this, Operation.CACHE_RECONNECT, null, true, (DistributedMember)id, newlyMissingRoles);
                                        DistributedRegion.this.dispatchListenerEvent(EnumListenerEvent.AFTER_ROLE_LOSS, relEvent);
                                    }
                                }
                            }
                            catch (Exception e) {
                                logger.fatal(LocalizedMessage.create(LocalizedStrings.DistributedRegion_UNEXPECTED_EXCEPTION), (Throwable)e);
                            }
                        }
                    };
                    t.setDaemon(true);
                    t.start();
                    break block8;
                }
                this.getSystem().tryReconnect(false, "Role Loss", this.getCache());
                HashSet t = this.missingRequiredRoles;
                synchronized (t) {
                    this.missingRequiredRoles.notifyAll();
                    if (this.hasListener() && id != null) {
                        RoleEventImpl relEvent = new RoleEventImpl((Region)this, Operation.CACHE_RECONNECT, null, true, (DistributedMember)id, newlyMissingRoles);
                        this.dispatchListenerEvent(EnumListenerEvent.AFTER_ROLE_LOSS, relEvent);
                    }
                }
            }
            catch (CancelException ignor) {
                throw ignor;
            }
            catch (Exception e) {
                logger.fatal(LocalizedMessage.create(LocalizedStrings.DistributedRegion_UNEXPECTED_EXCEPTION), (Throwable)e);
            }
        }
    }

    protected void lockCheckReadiness() {
        this.cache.getCancelCriterion().checkCancelInProgress(null);
        this.checkReadiness();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object validatedDestroy(Object key, EntryEventImpl event) throws TimeoutException, EntryNotFoundException, CacheWriterException {
        Lock dlock = this.getDistributedLockIfGlobal(key);
        try {
            Object object = super.validatedDestroy(key, event);
            return object;
        }
        finally {
            if (dlock != null) {
                dlock.unlock();
            }
        }
    }

    @Override
    public void localDestroyNoCallbacks(Object key) {
        super.localDestroyNoCallbacks(key);
        if (this.getScope().isGlobal()) {
            try {
                this.getLockService().freeResources(key);
            }
            catch (LockServiceDestroyedException lockServiceDestroyedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void localDestroy(Object key, Object aCallbackArgument) throws EntryNotFoundException {
        super.localDestroy(key, aCallbackArgument);
        if (this.getScope().isGlobal()) {
            try {
                this.getLockService().freeResources(key);
            }
            catch (LockServiceDestroyedException lockServiceDestroyedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(Object key, Object aCallbackArgument) throws TimeoutException, EntryNotFoundException {
        this.validateKey(key);
        this.validateCallbackArg(aCallbackArgument);
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        Lock dlock = this.getDistributedLockIfGlobal(key);
        try {
            super.validatedInvalidate(key, aCallbackArgument);
        }
        finally {
            if (dlock != null) {
                dlock.unlock();
            }
        }
    }

    @Override
    public Lock getRegionDistributedLock() throws IllegalStateException {
        this.lockCheckReadiness();
        this.checkForLimitedOrNoAccess();
        if (!this.scope.isGlobal()) {
            throw new IllegalStateException(LocalizedStrings.DistributedRegion_DISTRIBUTION_LOCKS_ARE_ONLY_SUPPORTED_FOR_REGIONS_WITH_GLOBAL_SCOPE_NOT_0.toLocalizedString(this.scope));
        }
        return new RegionDistributedLock();
    }

    @Override
    public Lock getDistributedLock(Object key) throws IllegalStateException {
        this.validateKey(key);
        this.lockCheckReadiness();
        this.checkForLimitedOrNoAccess();
        if (!this.scope.isGlobal()) {
            throw new IllegalStateException(LocalizedStrings.DistributedRegion_DISTRIBUTION_LOCKS_ARE_ONLY_SUPPORTED_FOR_REGIONS_WITH_GLOBAL_SCOPE_NOT_0.toLocalizedString(this.scope));
        }
        if (this.isLockingSuspendedByCurrentThread()) {
            throw new IllegalStateException(LocalizedStrings.DistributedRegion_THIS_THREAD_HAS_SUSPENDED_ALL_LOCKING_FOR_THIS_REGION.toLocalizedString());
        }
        return new DistributedLock(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initialize(InputStream snapshotInputStream, InternalDistributedMember imageTarget, InternalRegionArguments internalRegionArgs) throws TimeoutException, IOException, ClassNotFoundException {
        Assert.assertTrue(!this.isInitialized());
        if (logger.isDebugEnabled()) {
            logger.debug("DistributedRegion.initialize BEGIN: {}", (Object)this.getFullPath());
        }
        if (this.scope.isDistributed() && this.concurrencyChecksEnabled) {
            this.createVersionVector();
        }
        if (this.scope.isGlobal()) {
            this.getLockService();
        }
        try {
            try {
                PersistentMemberID persistentId = null;
                boolean recoverFromDisk = this.isRecoveryNeeded();
                DiskRegion dskRgn = this.getDiskRegion();
                if (recoverFromDisk) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("DistributedRegion.getInitialImageAndRecovery: Starting Recovery");
                    }
                    dskRgn.initializeOwner(this);
                    if (logger.isDebugEnabled()) {
                        logger.debug("DistributedRegion.getInitialImageAndRecovery: Finished Recovery");
                    }
                    persistentId = dskRgn.getMyPersistentID();
                }
                this.createOQLIndexes(internalRegionArgs, recoverFromDisk);
                if (this.getDataPolicy().withReplication() || this.getDataPolicy().withPreloaded()) {
                    this.getInitialImageAndRecovery(snapshotInputStream, imageTarget, internalRegionArgs, recoverFromDisk, persistentId);
                } else {
                    new CreateRegionProcessor(this).initializeRegion();
                    if (snapshotInputStream != null) {
                        this.releaseBeforeGetInitialImageLatch();
                        this.loadSnapshotDuringInitialization(snapshotInputStream);
                    }
                }
            }
            catch (DiskAccessException dae) {
                this.handleDiskAccessException(dae, true);
                throw dae;
            }
            this.initMembershipRoles();
            this.isInitializingThread = false;
            super.initialize(null, null, null);
        }
        finally {
            if (this.eventTracker != null) {
                this.eventTracker.setInitialized();
            }
        }
    }

    @Override
    public void initialized() {
        new UpdateAttributesProcessor(this).distribute(false);
    }

    private boolean checkInitialImageForReliability(InternalDistributedMember imageTarget, CacheDistributionAdvisor.InitialImageAdvice advice) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getInitialImageAndRecovery(InputStream snapshotInputStream, InternalDistributedMember imageSrc, InternalRegionArguments internalRegionArgs, boolean recoverFromDisk, PersistentMemberID persistentId) throws TimeoutException {
        boolean isForConversion;
        logger.info(LocalizedMessage.create(LocalizedStrings.DistributedRegion_INITIALIZING_REGION_0, this.getName()));
        ImageState imgState = this.getImageState();
        imgState.init();
        boolean targetRecreated = internalRegionArgs.getRecreateFlag();
        Boolean isCBool = (Boolean)isConversion.get();
        boolean bl = isForConversion = isCBool != null ? isCBool : false;
        if (recoverFromDisk && snapshotInputStream != null && !isForConversion) {
            throw new InternalGemFireError(LocalizedStrings.DistributedRegion_IF_LOADING_A_SNAPSHOT_THEN_SHOULD_NOT_BE_RECOVERING_ISRECOVERING_0_SNAPSHOTSTREAM_1.toLocalizedString(recoverFromDisk, snapshotInputStream));
        }
        CreateRegionProcessor targetProvider = this.dataPolicy.withPersistence() ? new CreatePersistentRegionProcessor(this, this.getPersistenceAdvisor(), recoverFromDisk) : new CreateRegionProcessor(this);
        imgState.setInRecovery(false);
        RegionVersionVector recovered_rvv = null;
        if (this.dataPolicy.withPersistence()) {
            recovered_rvv = this.getVersionVector() == null ? null : this.getVersionVector().getCloneForTransmission();
        }
        targetProvider.initializeRegion();
        if (this.persistenceAdvisor != null) {
            this.persistenceAdvisor.initialize();
        }
        if (!this.isInternalRegion() && !this.isDestroyed) {
            this.cache.getResourceManager().addResourceListener(InternalResourceManager.ResourceType.MEMORY, this);
        }
        this.releaseBeforeGetInitialImageLatch();
        InitialImageOperation.beforeGetInitialImage(this);
        if (snapshotInputStream != null) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("DistributedRegion.getInitialImageAndRecovery: About to load snapshot, isInitialized={}; {}", (Object)this.isInitialized(), (Object)this.getFullPath());
                }
                this.loadSnapshotDuringInitialization(snapshotInputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            this.cleanUpDestroyedTokensAndMarkGIIComplete(InitialImageOperation.GIIStatus.NO_GII);
            return;
        }
        InitialImageOperation iiop = new InitialImageOperation(this, this.entries);
        CacheDistributionAdvisor.InitialImageAdvice advice = null;
        boolean done = false;
        while (!done && !this.isDestroyed()) {
            boolean attemptGetFromOne;
            advice = targetProvider.getInitialImageAdvice(advice);
            this.checkInitialImageForReliability(imageSrc, advice);
            boolean bl2 = attemptGetFromOne = imageSrc != null || this.dataPolicy.withPreloaded() && !advice.preloaded.isEmpty() || !advice.replicates.isEmpty();
            if (attemptGetFromOne) {
                InitialImageOperation.GIIStatus ret_preload;
                InitialImageOperation.GIIStatus ret;
                if (recoverFromDisk && LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER) {
                    CacheObserverHolder.getInstance().afterMarkingGIIStarted();
                }
                if (imageSrc != null) {
                    try {
                        ret = iiop.getFromOne(Collections.singleton(imageSrc), targetRecreated, advice, recoverFromDisk, recovered_rvv);
                        if (InitialImageOperation.GIIStatus.didGII(ret)) {
                            this.giiMissingRequiredRoles = false;
                            this.cleanUpDestroyedTokensAndMarkGIIComplete(ret);
                            done = true;
                            return;
                        }
                    }
                    finally {
                        imageSrc = null;
                    }
                }
                if (InitialImageOperation.GIIStatus.didGII(ret = iiop.getFromOne(advice.replicates, false, advice, recoverFromDisk, recovered_rvv))) {
                    this.cleanUpDestroyedTokensAndMarkGIIComplete(ret);
                    done = true;
                    return;
                }
                if (this.dataPolicy.isPreloaded() && InitialImageOperation.GIIStatus.didGII(ret_preload = iiop.getFromOne(advice.preloaded, false, advice, recoverFromDisk, recovered_rvv))) {
                    this.cleanUpDestroyedTokensAndMarkGIIComplete(ret_preload);
                    done = true;
                    return;
                }
                this.cleanUpAfterFailedGII(recoverFromDisk);
                continue;
            }
            if (this.isDestroyed()) break;
            if (recoverFromDisk) {
                logger.info(LocalizedMessage.create(LocalizedStrings.DistributedRegion_INITIALIZED_FROM_DISK, new Object[]{this.getFullPath(), persistentId, this.getPersistentID()}));
                if (persistentId != null) {
                    RegionLogger.logRecovery(this.getFullPath(), persistentId, this.getDistributionManager().getDistributionManagerId());
                }
            } else {
                RegionLogger.logCreate(this.getFullPath(), this.getDistributionManager().getDistributionManagerId());
                if (this.getPersistentID() != null) {
                    RegionLogger.logPersistence(this.getFullPath(), this.getDistributionManager().getDistributionManagerId(), this.getPersistentID());
                    logger.info(LocalizedMessage.create(LocalizedStrings.DistributedRegion_NEW_PERSISTENT_REGION_CREATED, new Object[]{this.getFullPath(), this.getPersistentID()}));
                }
            }
            this.cleanUpDestroyedTokensAndMarkGIIComplete(InitialImageOperation.GIIStatus.NO_GII);
            done = true;
            return;
        }
    }

    private void synchronizeWith(InternalDistributedMember target, VersionSource idToRecover) {
        InitialImageOperation op = new InitialImageOperation(this, this.entries);
        op.synchronizeWith(target, idToRecover, null);
    }

    public void synchronizeForLostMember(InternalDistributedMember lostMember, VersionSource lostVersionID) {
        if (!this.concurrencyChecksEnabled) {
            return;
        }
        CacheDistributionAdvisor advisor = this.getCacheDistributionAdvisor();
        Set<InternalDistributedMember> targets = advisor.adviseInitializedReplicates();
        for (InternalDistributedMember target : targets) {
            this.synchronizeWith(target, lostVersionID, lostMember);
        }
    }

    private void synchronizeWith(InternalDistributedMember target, VersionSource versionMember, InternalDistributedMember lostMember) {
        InitialImageOperation op = new InitialImageOperation(this, this.entries);
        op.synchronizeWith(target, versionMember, lostMember);
    }

    protected void cleanUpAfterFailedGII(boolean recoverFromDisk) {
        block6: {
            DiskRegion dskRgn = this.getDiskRegion();
            if (recoverFromDisk && dskRgn != null && dskRgn.isBackup()) {
                dskRgn.resetRecoveredEntries(this);
                return;
            }
            if (!this.entries.isEmpty()) {
                this.closeEntries();
                if (this.getDiskRegion() != null) {
                    this.getDiskRegion().clear(this, null);
                }
                this.getImageState().getLeftMembers();
                this.getImageState().getVersionTags();
                if (this.indexManager != null) {
                    try {
                        this.indexManager.rerunIndexCreationQuery();
                    }
                    catch (Exception ex) {
                        if (!logger.isDebugEnabled()) break block6;
                        logger.debug("Exception while clearing indexes after GII failure.", (Throwable)ex);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMembershipRoles() {
        HashSet hashSet;
        Object others2;
        AdvisorListener advisorListener = this.advisorListener;
        synchronized (advisorListener) {
            others2 = this.distAdvisor.addMembershipListenerAndAdviseGeneric(this.advisorListener);
            this.advisorListener.addMembers((Set)others2);
            if (this.getMembershipAttributes().hasRequiredRoles()) {
                hashSet = this.missingRequiredRoles;
                synchronized (hashSet) {
                    this.missingRequiredRoles.addAll(this.getMembershipAttributes().getRequiredRoles());
                    this.missingRequiredRoles.removeAll(this.getSystem().getDistributedMember().getRoles());
                    Iterator iter = others2.iterator();
                    while (iter.hasNext()) {
                        DistributedMember other = (DistributedMember)iter.next();
                        this.missingRequiredRoles.removeAll(other.getRoles());
                    }
                }
            }
        }
        if (this.getMembershipAttributes().hasRequiredRoles()) {
            int memberTimeout = this.getSystem().getConfig().getMemberTimeout();
            if (logger.isDebugEnabled()) {
                logger.debug("Waiting up to {} for required roles.", (Object)memberTimeout);
            }
            try {
                if (this.giiMissingRequiredRoles) {
                    this.isInitializingThread = true;
                    others2 = this.advisorListener;
                    synchronized (others2) {
                        hashSet = this.missingRequiredRoles;
                        synchronized (hashSet) {
                            this.isMissingRequiredRoles = true;
                            this.getCachePerfStats().incReliableRegionsMissing(1);
                            if (this.getMembershipAttributes().getLossAction().isAllAccess()) {
                                this.getCachePerfStats().incReliableRegionsMissingFullAccess(1);
                            } else if (this.getMembershipAttributes().getLossAction().isLimitedAccess()) {
                                this.getCachePerfStats().incReliableRegionsMissingLimitedAccess(1);
                            } else if (this.getMembershipAttributes().getLossAction().isNoAccess()) {
                                this.getCachePerfStats().incReliableRegionsMissingNoAccess(1);
                            }
                            if (logger.isDebugEnabled()) {
                                logger.debug("GetInitialImage had missing required roles.");
                            }
                            this.isInitializingThread = true;
                            this.lostReliability(null, null);
                            if (this.missingRequiredRoles.isEmpty()) {
                                this.isMissingRequiredRoles = false;
                                this.getCachePerfStats().incReliableRegionsMissing(-1);
                                if (this.getMembershipAttributes().getLossAction().isAllAccess()) {
                                    this.getCachePerfStats().incReliableRegionsMissingFullAccess(-1);
                                } else if (this.getMembershipAttributes().getLossAction().isLimitedAccess()) {
                                    this.getCachePerfStats().incReliableRegionsMissingLimitedAccess(-1);
                                } else if (this.getMembershipAttributes().getLossAction().isNoAccess()) {
                                    this.getCachePerfStats().incReliableRegionsMissingNoAccess(-1);
                                }
                                boolean async = this.resumeReliability(null, null);
                                if (async) {
                                    this.advisorListener.destroyed = true;
                                }
                            }
                        }
                    }
                }
                if (!this.getSystem().isLoner()) {
                    this.waitForRequiredRoles(memberTimeout);
                }
                others2 = this.advisorListener;
                synchronized (others2) {
                    hashSet = this.missingRequiredRoles;
                    synchronized (hashSet) {
                        if (this.missingRequiredRoles.isEmpty()) {
                            Assert.assertTrue(!this.isMissingRequiredRoles);
                            if (logger.isDebugEnabled()) {
                                logger.debug("Initialization completed with all required roles present.");
                            }
                        } else {
                            this.isMissingRequiredRoles = true;
                            this.getCachePerfStats().incReliableRegionsMissing(1);
                            if (this.getMembershipAttributes().getLossAction().isAllAccess()) {
                                this.getCachePerfStats().incReliableRegionsMissingFullAccess(1);
                            } else if (this.getMembershipAttributes().getLossAction().isLimitedAccess()) {
                                this.getCachePerfStats().incReliableRegionsMissingLimitedAccess(1);
                            } else if (this.getMembershipAttributes().getLossAction().isNoAccess()) {
                                this.getCachePerfStats().incReliableRegionsMissingNoAccess(1);
                            }
                            if (logger.isDebugEnabled()) {
                                logger.debug("Initialization completed with missing required roles: {}", (Object)this.missingRequiredRoles);
                            }
                            this.isInitializingThread = true;
                            this.lostReliability(null, null);
                        }
                    }
                }
            }
            catch (RegionDestroyedException others2) {
            }
            catch (CancelException ignore) {
                if (this.isInitializingThread) {
                    throw ignore;
                }
            }
            catch (Exception e) {
                logger.fatal(LocalizedMessage.create(LocalizedStrings.DistributedRegion_UNEXPECTED_EXCEPTION), (Throwable)e);
            }
        }
        this.initializationLatchAfterMemberTimeout.countDown();
    }

    private boolean isRecoveryNeeded() {
        return this.getDataPolicy().withPersistence() && this.getDiskRegion().isRecreated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"UL_UNRELEASED_LOCK"})
    protected void cleanUpDestroyedTokensAndMarkGIIComplete(InitialImageOperation.GIIStatus giiStatus) {
        DiskRegion dskRgn = this.getDiskRegion();
        if (dskRgn != null && dskRgn.isBackup()) {
            dskRgn.finishInitializeOwner(this, giiStatus);
        }
        ImageState is = this.getImageState();
        is.lockGII();
        is.getVersionTags();
        is.getLeftMembers();
        RegionVersionVector rvv = is.getClearRegionVersionVector();
        try {
            Iterator keysIt = this.getImageState().getDestroyedEntries();
            while (keysIt.hasNext()) {
                this.entries.removeIfDestroyed(keysIt.next());
            }
            if (rvv != null) {
                this.clearEntries(rvv);
            }
            if (this.persistenceAdvisor != null) {
                this.persistenceAdvisor.setOnline(InitialImageOperation.GIIStatus.didGII(giiStatus), false, this.getPersistentID());
            }
        }
        finally {
            try {
                this.releaseAfterGetInitialImageLatch();
            }
            finally {
                is.unlockGII();
            }
        }
        if (LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER) {
            CacheObserverHolder.getInstance().afterMarkingGIICompleted();
        }
        logger.info(LocalizedMessage.create(LocalizedStrings.DistributedRegion_INITIALIZING_REGION_COMPLETED_0, this.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void basicDestroy(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) throws EntryNotFoundException, CacheWriterException, TimeoutException {
        boolean invokeWriter = cacheWrite;
        boolean hasSeen = false;
        if (this.hasSeenEvent(event)) {
            hasSeen = true;
        }
        this.checkIfReplicatedAndLocalDestroy(event);
        try {
            RegionEntry re;
            if (this.requiresOneHopForMissingEntry(event) && ((re = this.getRegionEntry(event.getKey())) == null || !this.generateVersionTag)) {
                if (this.srp == null) {
                    Assert.assertTrue(!this.dataPolicy.withReplication() || !this.generateVersionTag);
                }
                if (!event.isBulkOpInProgress() || this.dataPolicy.withStorage()) {
                    boolean didDistribute = RemoteDestroyMessage.distribute(event, expectedOldValue, !this.generateVersionTag);
                    if (!this.generateVersionTag && !didDistribute) {
                        throw new PersistentReplicatesOfflineException();
                    }
                    if (didDistribute) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("Event after remoteDestroy operation: {}", (Object)event);
                        }
                        invokeWriter = false;
                        if (event.getVersionTag() == null) {
                            return;
                        }
                    }
                }
            }
            super.basicDestroy(event, invokeWriter, expectedOldValue);
            if (this.scope.isGlobal() && event.isOriginRemote()) {
                try {
                    this.getLockService().freeResources(event.getKey());
                }
                catch (LockServiceDestroyedException lockServiceDestroyedException) {
                    // empty catch block
                }
            }
            return;
        }
        finally {
            if (hasSeen) {
                if (event.isBulkOpInProgress() && !event.isOriginRemote()) {
                    event.getRemoveAllOperation().addEntry(event, true);
                }
                if (!this.getConcurrencyChecksEnabled() || event.hasValidVersionTag()) {
                    this.distributeDestroy(event, expectedOldValue);
                    event.invokeCallbacks(this, true, false);
                }
            }
        }
    }

    @Override
    void basicDestroyPart3(RegionEntry re, EntryEventImpl event, boolean inTokenMode, boolean duringRI, boolean invokeCallbacks, Object expectedOldValue) {
        this.distributeDestroy(event, expectedOldValue);
        super.basicDestroyPart3(re, event, inTokenMode, duringRI, invokeCallbacks, expectedOldValue);
    }

    void distributeDestroy(EntryEventImpl event, Object expectedOldValue) {
        if (event.isDistributed() && !event.isOriginRemote() && !event.isBulkOpInProgress()) {
            boolean distribute;
            boolean bl = distribute = !event.getInhibitDistribution();
            if (distribute) {
                DestroyOperation op = new DestroyOperation(event);
                op.distribute();
            }
        }
    }

    @Override
    boolean evictDestroy(LRUEntry entry) {
        boolean evictDestroyWasDone = super.evictDestroy(entry);
        if (evictDestroyWasDone && this.scope.isGlobal()) {
            try {
                this.getLockService().freeResources(entry.getKey());
            }
            catch (LockServiceDestroyedException lockServiceDestroyedException) {
                // empty catch block
            }
        }
        return evictDestroyWasDone;
    }

    @Override
    void basicInvalidateRegion(RegionEventImpl event) {
        if (!event.isDistributed() && this.getScope().isDistributed() && this.getDataPolicy().withReplication()) {
            throw new IllegalStateException(LocalizedStrings.DistributedRegion_NOT_ALLOWED_TO_DO_A_LOCAL_INVALIDATION_ON_A_REPLICATED_REGION.toLocalizedString());
        }
        if (this.shouldDistributeInvalidateRegion(event)) {
            this.distributeInvalidateRegion(event);
        }
        super.basicInvalidateRegion(event);
    }

    protected boolean shouldDistributeInvalidateRegion(RegionEventImpl event) {
        return event.isDistributed() && !event.isOriginRemote();
    }

    protected void distributeInvalidateRegion(RegionEventImpl event) {
        new InvalidateRegionOperation(event).distribute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void basicDestroyRegion(RegionEventImpl event, boolean cacheWrite, boolean lock, boolean callbackEvents) throws CacheWriterException, TimeoutException {
        String path = this.getFullPath();
        boolean isClose = event.getOperation().isClose();
        if (!isClose) {
            this.cache.beginDestroy(path, this);
        }
        try {
            super.basicDestroyRegion(event, cacheWrite, lock, callbackEvents);
            if (!event.isOriginRemote()) {
                this.distributeDestroyRegion(event, true);
            } else if (!event.isReinitializing()) {
                RegionEventImpl localEvent = new RegionEventImpl((Region)this, Operation.REGION_LOCAL_DESTROY, event.getCallbackArgument(), false, (DistributedMember)this.getMyId(), this.generateEventID());
                this.distributeDestroyRegion(localEvent, false);
            }
            this.notifyBridgeClients(event);
        }
        catch (CancelException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("basicDestroyRegion short-circuited due to cancellation");
            }
        }
        finally {
            if (!isClose) {
                this.cache.endDestroy(path, this);
            }
            RegionLogger.logDestroy(path, this.getMyId(), this.getPersistentID(), isClose);
        }
    }

    @Override
    protected void distributeDestroyRegion(RegionEventImpl event, boolean notifyOfRegionDeparture) {
        if (this.persistenceAdvisor != null) {
            this.persistenceAdvisor.releaseTieLock();
        }
        new DestroyRegionOperation(event, notifyOfRegionDeparture).distribute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void basicInvalidate(EntryEventImpl event) throws EntryNotFoundException {
        boolean hasSeen = false;
        if (this.hasSeenEvent(event)) {
            hasSeen = true;
        }
        try {
            RegionEntry re;
            if (event.isLocalInvalid() && !event.getOperation().isLocal() && this.getScope().isDistributed() && this.getDataPolicy().withReplication()) {
                throw new IllegalStateException(LocalizedStrings.DistributedRegion_NOT_ALLOWED_TO_DO_A_LOCAL_INVALIDATION_ON_A_REPLICATED_REGION.toLocalizedString());
            }
            if (this.requiresOneHopForMissingEntry(event) && ((re = this.getRegionEntry(event.getKey())) == null || !this.generateVersionTag)) {
                if (this.srp == null) {
                    Assert.assertTrue(!this.dataPolicy.withReplication() || !this.generateVersionTag);
                }
                boolean didDistribute = RemoteInvalidateMessage.distribute(event, !this.generateVersionTag);
                if (!this.generateVersionTag && !didDistribute) {
                    throw new PersistentReplicatesOfflineException();
                }
                if (didDistribute) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Event after remoteInvalidate operation: {}", (Object)event);
                    }
                    if (event.getVersionTag() == null) {
                        return;
                    }
                }
            }
            super.basicInvalidate(event);
            return;
        }
        finally {
            if (hasSeen && (!this.getConcurrencyChecksEnabled() || event.hasValidVersionTag())) {
                this.distributeInvalidate(event);
                event.invokeCallbacks(this, true, false);
            }
        }
    }

    @Override
    void basicInvalidatePart3(RegionEntry re, EntryEventImpl event, boolean invokeCallbacks) {
        this.distributeInvalidate(event);
        super.basicInvalidatePart3(re, event, invokeCallbacks);
    }

    void distributeInvalidate(EntryEventImpl event) {
        if (!this.regionInvalid && event.isDistributed() && !event.isOriginRemote() && !this.isTX() && event.isDistributed() && !event.isOriginRemote()) {
            boolean distribute;
            boolean bl = distribute = !event.getInhibitDistribution();
            if (distribute) {
                InvalidateOperation op = new InvalidateOperation(event);
                op.distribute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void basicUpdateEntryVersion(EntryEventImpl event) throws EntryNotFoundException {
        LocalRegion lr = event.getLocalRegion();
        AbstractRegionMap arm = (AbstractRegionMap)lr.getRegionMap();
        try {
            block8: {
                arm.lockForCacheModification(lr, event);
                try {
                    if (this.hasSeenEvent(event)) break block8;
                    super.basicUpdateEntryVersion(event);
                }
                catch (Throwable throwable) {
                    if (!this.getConcurrencyChecksEnabled() || event.hasValidVersionTag()) {
                        this.distributeUpdateEntryVersion(event);
                    }
                    throw throwable;
                }
            }
            if (!this.getConcurrencyChecksEnabled() || event.hasValidVersionTag()) {
                this.distributeUpdateEntryVersion(event);
            }
            return;
        }
        finally {
            arm.releaseCacheModificationLock(lr, event);
        }
    }

    protected void distributeUpdateEntryVersion(EntryEventImpl event) {
        if (!this.regionInvalid && event.isDistributed() && !event.isOriginRemote() && !this.isTX() && event.isDistributed() && !event.isOriginRemote()) {
            UpdateEntryVersionOperation op = new UpdateEntryVersionOperation(event);
            op.distribute();
        }
    }

    @Override
    protected void basicClear(RegionEventImpl ev) {
        Lock dlock = this.getRegionDistributedLockIfGlobal();
        try {
            super.basicClear(ev);
        }
        finally {
            if (dlock != null) {
                dlock.unlock();
            }
        }
    }

    @Override
    void basicClear(RegionEventImpl regionEvent, boolean cacheWrite) {
        if (this.concurrencyChecksEnabled && !this.dataPolicy.withReplication()) {
            boolean retry = false;
            do {
                Set<InternalDistributedMember> repls;
                if ((repls = this.distAdvisor.adviseReplicates()).size() <= 0) continue;
                InternalDistributedMember mbr = repls.iterator().next();
                RemoteRegionOperation op = RemoteRegionOperation.clear(mbr, this);
                try {
                    op.distribute();
                    return;
                }
                catch (CancelException e) {
                    this.stopper.checkCancelInProgress(e);
                    retry = true;
                }
                catch (RemoteOperationException e) {
                    this.stopper.checkCancelInProgress(e);
                    retry = true;
                }
            } while (retry);
        }
        super.basicClear(regionEvent, cacheWrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    void cmnClearRegion(RegionEventImpl regionEvent, boolean cacheWrite, boolean useRVV) {
        block11: {
            boolean enableRVV = useRVV && this.dataPolicy.withReplication() && this.concurrencyChecksEnabled && !this.getDistributionManager().isLoner();
            Object object = this.clearLock;
            synchronized (object) {
                if (enableRVV) {
                    this.distributedLockForClear();
                    try {
                        Set participants = this.getCacheDistributionAdvisor().adviseInvalidateRegion();
                        try {
                            this.obtainWriteLocksForClear(regionEvent, participants);
                            this.clearRegionLocally(regionEvent, cacheWrite, null);
                            if (!regionEvent.isOriginRemote() && regionEvent.isDistributed()) {
                                DistributedClearOperation.clear(regionEvent, null, participants);
                            }
                            break block11;
                        }
                        finally {
                            this.releaseWriteLocksForClear(regionEvent, participants);
                        }
                    }
                    finally {
                        this.distributedUnlockForClear();
                    }
                }
                Set participants = this.getCacheDistributionAdvisor().adviseInvalidateRegion();
                this.clearRegionLocally(regionEvent, cacheWrite, null);
                if (!regionEvent.isOriginRemote() && regionEvent.isDistributed()) {
                    DistributedClearOperation.clear(regionEvent, null, participants);
                }
            }
        }
        this.notifyBridgeClients(regionEvent);
    }

    private void distributedLockForClear() {
        if (!this.scope.isGlobal()) {
            try {
                this.getLockService().lock("_clearOperation", -1L, -1L);
            }
            catch (IllegalStateException e) {
                this.lockCheckReadiness();
                throw e;
            }
        }
    }

    private void distributedUnlockForClear() {
        if (!this.scope.isGlobal()) {
            try {
                this.getLockService().unlock("_clearOperation");
            }
            catch (IllegalStateException e) {
                this.lockCheckReadiness();
                throw e;
            }
        }
    }

    private void obtainWriteLocksForClear(RegionEventImpl regionEvent, Set<InternalDistributedMember> participants) {
        this.lockLocallyForClear(this.getDistributionManager(), this.getMyId(), regionEvent);
        DistributedClearOperation.lockAndFlushToOthers(regionEvent, participants);
    }

    public void lockLocallyForClear(DM dm, InternalDistributedMember locker, CacheEvent event) {
        RegionVersionVector rvv = this.getVersionVector();
        AbstractRegionMap.ARMLockTestHook alth = this.getRegionMap().getARMLockTestHook();
        if (alth != null) {
            alth.beforeLock(this, event);
        }
        if (rvv != null) {
            rvv.lockForClear(this.getFullPath(), dm, locker);
            this.checkReadiness();
            if (this.getAttributes().getScope().isDistributedNoAck()) {
                Set mbrs = this.getDistributionAdvisor().adviseCacheOp();
                StateFlushOperation.flushTo(mbrs, this);
            }
        }
        if (alth != null) {
            alth.afterLock(this, null);
        }
    }

    private void releaseWriteLocksForClear(RegionEventImpl regionEvent, Set<InternalDistributedMember> participants) {
        AbstractRegionMap.ARMLockTestHook alth = this.getRegionMap().getARMLockTestHook();
        if (alth != null) {
            alth.beforeRelease(this, regionEvent);
        }
        this.getVersionVector().unlockForClear(this.getMyId());
        DistributedClearOperation.releaseLocks(regionEvent, participants);
        if (alth != null) {
            alth.afterRelease(this, regionEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForInProgressClear() {
        RegionVersionVector rvv = this.getVersionVector();
        if (rvv != null) {
            Object object = this.clearLock;
            synchronized (object) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Done waiting for clear");
                }
            }
        }
    }

    protected EventID distributeTombstoneGC(Set<Object> keysRemoved) {
        this.getCachePerfStats().incTombstoneGCCount();
        EventID eventId = new EventID(this.getSystem());
        DistributedTombstoneOperation gc = DistributedTombstoneOperation.gc(this, eventId);
        gc.distribute();
        this.notifyClientsOfTombstoneGC(this.getVersionVector().getTombstoneGCVector(), keysRemoved, eventId, null);
        return eventId;
    }

    @Override
    void basicLocalClear(RegionEventImpl rEvent) {
        if (this.getScope().isDistributed() && this.getDataPolicy().withReplication() && !LOCALCLEAR_TESTHOOK) {
            throw new UnsupportedOperationException(LocalizedStrings.DistributedRegion_LOCALCLEAR_IS_NOT_SUPPORTED_ON_DISTRIBUTED_REPLICATED_REGIONS.toLocalizedString());
        }
        super.basicLocalClear(rEvent);
    }

    public final DistributionConfig getDistributionConfig() {
        return this.getSystem().getDistributionManager().getConfig();
    }

    boolean sendQueue(List list, Role role) {
        SendQueueOperation op = new SendQueueOperation(this.getDistributionManager(), this, list, role);
        return op.distribute();
    }

    @Override
    public final CacheDistributionAdvisor getDistributionAdvisor() {
        return this.distAdvisor;
    }

    @Override
    public final CacheDistributionAdvisor getCacheDistributionAdvisor() {
        return this.distAdvisor;
    }

    public final PersistenceAdvisor getPersistenceAdvisor() {
        return this.persistenceAdvisor;
    }

    public final PersistentMemberID getPersistentID() {
        return this.persistentId;
    }

    @Override
    public DistributionAdvisor.Profile getProfile() {
        return this.distAdvisor.createProfile();
    }

    @Override
    public void fillInProfile(DistributionAdvisor.Profile p) {
        assert (p instanceof CacheDistributionAdvisor.CacheProfile);
        CacheDistributionAdvisor.CacheProfile profile = (CacheDistributionAdvisor.CacheProfile)p;
        profile.dataPolicy = this.getDataPolicy();
        profile.hasCacheLoader = this.basicGetLoader() != null;
        profile.hasCacheWriter = this.basicGetWriter() != null;
        profile.hasCacheListener = this.hasListener();
        Assert.assertTrue(this.scope.isDistributed());
        profile.scope = this.scope;
        profile.inRecovery = this.getImageState().getInRecovery();
        profile.isPersistent = this.getDataPolicy().withPersistence();
        profile.setSubscriptionAttributes(this.getSubscriptionAttributes());
        profile.isGatewayEnabled = this.isPdxTypesRegion();
        profile.serialNumber = this.getSerialNumber();
        profile.regionInitialized = this.isInitialized();
        profile.persistentID = this.getPersistentID();
        if (this.getPersistenceAdvisor() != null) {
            profile.persistenceInitialized = this.getPersistenceAdvisor().isOnline();
        }
        profile.hasCacheServer = this.cache.getCacheServers().size() > 0;
        profile.requiresOldValueInEvents = this.dataPolicy.withReplication() && this.filterProfile != null && this.filterProfile.hasCQs();
        profile.gatewaySenderIds = this.getGatewaySenderIds();
        profile.asyncEventQueueIds = this.getAsyncEventQueueIds();
        profile.isOffHeap = this.getOffHeap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DistributedLockService getLockService() {
        Object object = this.dlockMonitor;
        synchronized (object) {
            String svcName = this.getFullPath();
            if (this.dlockService == null) {
                this.dlockService = DistributedLockService.getServiceNamed(svcName);
                if (this.dlockService == null) {
                    this.dlockService = DLockService.create(this.getFullPath(), this.getSystem(), true, false, false);
                }
                if (this.isLockGrantor) {
                    this.dlockService.becomeLockGrantor();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("LockService for {} is using LockLease={}, LockTimeout=", (Object)svcName, (Object)this.getCache().getLockLease(), (Object)this.getCache().getLockTimeout());
                }
            }
            return this.dlockService;
        }
    }

    @Override
    protected boolean isCurrentlyLockGrantor() {
        if (!this.scope.isGlobal()) {
            return false;
        }
        return this.getLockService().isLockGrantor();
    }

    @Override
    public boolean isLockGrantor() {
        if (!this.scope.isGlobal()) {
            return false;
        }
        return this.isLockGrantor;
    }

    @Override
    public void becomeLockGrantor() {
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        if (!this.scope.isGlobal()) {
            throw new IllegalStateException(LocalizedStrings.DistributedRegion_DISTRIBUTION_LOCKS_ARE_ONLY_SUPPORTED_FOR_REGIONS_WITH_GLOBAL_SCOPE_NOT_0.toLocalizedString(this.scope));
        }
        DistributedLockService svc = this.getLockService();
        try {
            super.becomeLockGrantor();
            if (!svc.isLockGrantor()) {
                svc.becomeLockGrantor();
            }
        }
        finally {
            if (!svc.isLockGrantor() && logger.isDebugEnabled()) {
                logger.debug("isLockGrantor is false after becomeLockGrantor for {}", (Object)this.getFullPath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object findObjectInSystem(KeyInfo keyInfo, boolean isCreate, TXStateInterface txState, boolean generateCallbacks, Object localValue, boolean disableCopyOnRead, boolean preferCD, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones) throws CacheLoaderException, TimeoutException {
        this.checkForLimitedOrNoAccess();
        RegionEntry re = null;
        Object key = keyInfo.getKey();
        Object aCallbackArgument = keyInfo.getCallbackArg();
        Operation op = isCreate ? Operation.CREATE : Operation.UPDATE;
        long lastModified = 0L;
        boolean fromServer = false;
        EntryEventImpl event = null;
        Object result = null;
        try {
            block23: {
                if (this.srp != null) {
                    VersionTagHolder holder = new VersionTagHolder();
                    Object value = this.srp.get(key, aCallbackArgument, holder);
                    boolean bl = fromServer = value != null;
                    if (fromServer) {
                        event = EntryEventImpl.create(this, op, key, value, aCallbackArgument, false, this.getMyId(), generateCallbacks);
                        event.setVersionTag(holder.getVersionTag());
                        event.setFromServer(fromServer);
                        if (clientEvent != null && clientEvent.getVersionTag() == null) {
                            clientEvent.setVersionTag(holder.getVersionTag());
                        }
                    }
                }
                if (!fromServer) {
                    event = EntryEventImpl.create(this, op, key, null, aCallbackArgument, false, this.getMyId(), generateCallbacks);
                    if (requestingClient != null) {
                        event.setContext(requestingClient);
                    }
                    SearchLoadAndWriteProcessor processor = SearchLoadAndWriteProcessor.getProcessor();
                    try {
                        processor.initialize(this, key, aCallbackArgument);
                        processor.doSearchAndLoad(event, txState, localValue);
                        if (clientEvent != null && clientEvent.getVersionTag() == null) {
                            clientEvent.setVersionTag(event.getVersionTag());
                        }
                        lastModified = processor.getLastModified();
                    }
                    finally {
                        processor.release();
                    }
                }
                if (event.hasNewValue() && !this.isMemoryThresholdReachedForLoad()) {
                    try {
                        long startPut;
                        block22: {
                            event.setNewEventId(this.cache.getDistributedSystem());
                            startPut = CachePerfStats.getStatTime();
                            this.validateKey(key);
                            try {
                                if (this instanceof BucketRegion && ((BucketRegion)this).getPartitionedRegion().isParallelWanEnabled()) {
                                    ((BucketRegion)this).handleWANEvent(event);
                                }
                                re = this.basicPutEntry(event, lastModified);
                            }
                            catch (ConcurrentCacheModificationException e) {
                                re = this.getRegionEntry(key);
                                if (re == null) break block22;
                                event.setNewValue(re.getValue(this));
                            }
                        }
                        if (!this.isTX()) {
                            this.getCachePerfStats().endPut(startPut, event.isOriginRemote());
                        }
                    }
                    catch (CacheWriterException cwe) {
                        if (!logger.isDebugEnabled()) break block23;
                        logger.debug("findObjectInSystem: writer exception putting entry {} : {}", (Object)event, (Object)cwe);
                    }
                }
            }
            if (isCreate) {
                this.recordMiss(re, key);
            }
            result = preferCD ? event.getRawNewValueAsHeapObject() : event.getNewValue();
            Object object = result;
            return object;
        }
        finally {
            if (event != null) {
                event.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean cacheWriteBeforeDestroy(EntryEventImpl event, Object expectedOldValue) throws CacheWriterException, EntryNotFoundException, TimeoutException {
        boolean result = false;
        if (event.isDistributed()) {
            Set netWriteRecipients;
            CacheWriter localWriter = this.basicGetWriter();
            Set set = netWriteRecipients = localWriter == null ? this.distAdvisor.adviseNetWrite() : null;
            if ((localWriter != null || netWriteRecipients != null && !netWriteRecipients.isEmpty()) && !event.inhibitAllNotifications()) {
                long start = this.getCachePerfStats().startCacheWriterCall();
                try {
                    event.setOldValueFromRegion();
                    SearchLoadAndWriteProcessor processor = SearchLoadAndWriteProcessor.getProcessor();
                    try {
                        processor.initialize(this, event.getKey(), null);
                        processor.doNetWrite(event, netWriteRecipients, localWriter, 1);
                        result = true;
                    }
                    finally {
                        processor.release();
                    }
                }
                finally {
                    this.getCachePerfStats().endCacheWriterCall(start);
                }
            }
            this.serverDestroy(event, expectedOldValue);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean cacheWriteBeforeRegionDestroy(RegionEventImpl event) throws CacheWriterException, TimeoutException {
        boolean result = false;
        if (event.getOperation().isDistributed()) {
            Set netWriteRecipients;
            CacheWriter localWriter = this.basicGetWriter();
            Set set = netWriteRecipients = localWriter == null ? this.distAdvisor.adviseNetWrite() : null;
            if (localWriter != null || netWriteRecipients != null && !netWriteRecipients.isEmpty()) {
                long start = this.getCachePerfStats().startCacheWriterCall();
                try {
                    SearchLoadAndWriteProcessor processor = SearchLoadAndWriteProcessor.getProcessor();
                    try {
                        processor.initialize(this, "preDestroyRegion", null);
                        processor.doNetWrite(event, netWriteRecipients, localWriter, 3);
                        result = true;
                    }
                    finally {
                        processor.release();
                    }
                }
                finally {
                    this.getCachePerfStats().endCacheWriterCall(start);
                }
            }
            this.serverRegionDestroy(event);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void distributedRegionCleanup(RegionEventImpl event) {
        if (event == null || event.getOperation() != Operation.REGION_REINITIALIZE) {
            HashSet hashSet = this.missingRequiredRoles;
            synchronized (hashSet) {
                this.missingRequiredRoles.notifyAll();
            }
        }
        if (this.persistenceAdvisor != null) {
            this.persistenceAdvisor.close();
        }
        this.distAdvisor.close();
        DLockService dls = null;
        this.waitForInProgressClear();
        Object object = this.dlockMonitor;
        synchronized (object) {
            if (this.dlockService != null) {
                dls = (DLockService)this.dlockService;
            }
        }
        if (dls != null) {
            try {
                dls.destroyAndRemove();
            }
            catch (CancelException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("DLS destroy abridged due to shutdown", (Throwable)e);
                }
            }
            catch (Exception ex) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.DistributedRegion_DLS_DESTROY_MAY_HAVE_FAILED_FOR_0, this.getFullPath()), (Throwable)ex);
            }
        }
        if (this.rmq != null) {
            this.rmq.close();
        }
        long timeout = 1000L * (long)this.getCache().getDistributedSystem().getConfig().getAckWaitThreshold();
        Boolean flushOnClose = !Boolean.getBoolean("gemfire.no-flush-on-close");
        if (!this.cache.forcedDisconnect() && flushOnClose.booleanValue() && this.getDistributionManager().getMembershipManager() != null && this.getDistributionManager().getMembershipManager().isConnected()) {
            this.getDistributionAdvisor().forceNewMembershipVersion();
            try {
                this.getDistributionAdvisor().waitForCurrentOperations(timeout);
            }
            catch (Exception e) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.GemFireCache_0_ERROR_CLOSING_REGION_1, new Object[]{this, this.getFullPath()}), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void postCreateRegion() {
        super.postCreateRegion();
        AdvisorListener advisorListener = this.advisorListener;
        synchronized (advisorListener) {
            Set<String> allGatewaySenderIds;
            Set others = this.advisorListener.getInitialMembers();
            CacheListener[] listeners = this.fetchCacheListenersField();
            if (listeners != null) {
                for (int i = 0; i < listeners.length; ++i) {
                    if (!(listeners[i] instanceof RegionMembershipListener)) continue;
                    RegionMembershipListener rml = (RegionMembershipListener)listeners[i];
                    try {
                        DistributedMember[] otherDms = new DistributedMember[others.size()];
                        others.toArray(otherDms);
                        rml.initialMembers(this, otherDms);
                        continue;
                    }
                    catch (VirtualMachineError err) {
                        SystemFailure.initiateFailure(err);
                        throw err;
                    }
                    catch (Throwable t) {
                        SystemFailure.checkFailure();
                        logger.error(LocalizedMessage.create(LocalizedStrings.DistributedRegion_EXCEPTION_OCCURRED_IN_REGIONMEMBERSHIPLISTENER), t);
                    }
                }
            }
            if (!(allGatewaySenderIds = this.getAllGatewaySenderIds()).isEmpty()) {
                for (GatewaySender sender : this.cache.getAllGatewaySenders()) {
                    if (!sender.isParallel() || !allGatewaySenderIds.contains(sender.getId())) continue;
                    if (sender.getId().contains("AsyncEventQueue_")) {
                        throw new AsyncEventQueueConfigurationException(LocalizedStrings.ParallelAsyncEventQueue_0_CAN_NOT_BE_USED_WITH_REPLICATED_REGION_1.toLocalizedString(AsyncEventQueueImpl.getAsyncEventQueueIdFromSenderId(sender.getId()), this.getFullPath()));
                    }
                    throw new GatewaySenderConfigurationException(LocalizedStrings.ParallelGatewaySender_0_CAN_NOT_BE_USED_WITH_REPLICATED_REGION_1.toLocalizedString(sender.getId(), this.getFullPath()));
                }
            }
        }
    }

    @Override
    protected void postDestroyRegion(boolean destroyDiskRegion, RegionEventImpl event) {
        this.distributedRegionCleanup(event);
        try {
            super.postDestroyRegion(destroyDiskRegion, event);
        }
        catch (CancelException e) {
            logger.warn("postDestroyRegion: encountered cancellation", (Throwable)e);
        }
        if (this.rmq != null && destroyDiskRegion) {
            this.rmq.destroy();
        }
    }

    @Override
    void cleanupFailedInitialization() {
        super.cleanupFailedInitialization();
        try {
            RegionEventImpl ev = new RegionEventImpl((Region)this, Operation.REGION_CLOSE, null, false, (DistributedMember)this.getMyId(), this.generateEventID());
            this.distributeDestroyRegion(ev, true);
            this.distributedRegionCleanup(null);
        }
        catch (RegionDestroyedException ev) {
        }
        catch (CancelException ev) {
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.DistributedRegion_ERROR_CLEANING_UP_FAILED_INITIALIZATION, this), t);
        }
    }

    @Override
    void handleCacheClose(Operation op) {
        try {
            super.handleCacheClose(op);
        }
        finally {
            this.distributedRegionCleanup(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cacheWriteBeforePut(EntryEventImpl event, Set netWriteRecipients, CacheWriter localWriter, boolean requireOldValue, Object expectedOldValue) throws CacheWriterException, TimeoutException {
        if ((localWriter != null || netWriteRecipients != null && !netWriteRecipients.isEmpty()) && !event.inhibitAllNotifications()) {
            boolean isNewKey = event.getOperation().isCreate();
            long start = this.getCachePerfStats().startCacheWriterCall();
            try {
                SearchLoadAndWriteProcessor processor = SearchLoadAndWriteProcessor.getProcessor();
                processor.initialize(this, "preUpdate", null);
                try {
                    if (!isNewKey) {
                        processor.doNetWrite(event, netWriteRecipients, localWriter, 2);
                    } else {
                        processor.doNetWrite(event, netWriteRecipients, localWriter, 0);
                    }
                }
                finally {
                    processor.release();
                }
            }
            finally {
                this.getCachePerfStats().endCacheWriterCall(start);
            }
        }
        this.serverPut(event, requireOldValue, expectedOldValue);
    }

    @Override
    protected void cacheListenersChanged(boolean nowHasListener) {
        if (nowHasListener) {
            this.advisorListener.initRMLWrappers();
        }
        new UpdateAttributesProcessor(this).distribute();
    }

    @Override
    protected void cacheWriterChanged(CacheWriter oldWriter) {
        super.cacheWriterChanged(oldWriter);
        if (oldWriter == null ^ this.basicGetWriter() == null) {
            new UpdateAttributesProcessor(this).distribute();
        }
    }

    @Override
    protected void cacheLoaderChanged(CacheLoader oldLoader) {
        super.cacheLoaderChanged(oldLoader);
        if (oldLoader == null ^ this.basicGetLoader() == null) {
            new UpdateAttributesProcessor(this).distribute();
        }
    }

    @Override
    public void addGatewaySenderId(String gatewaySenderId) {
        super.addGatewaySenderId(gatewaySenderId);
        new UpdateAttributesProcessor(this).distribute();
    }

    @Override
    public void removeGatewaySenderId(String gatewaySenderId) {
        super.removeGatewaySenderId(gatewaySenderId);
        new UpdateAttributesProcessor(this).distribute();
    }

    @Override
    public void addAsyncEventQueueId(String asyncEventQueueId) {
        super.addAsyncEventQueueId(asyncEventQueueId);
        new UpdateAttributesProcessor(this).distribute();
    }

    @Override
    public void removeAsyncEventQueueId(String asyncEventQueueId) {
        super.removeAsyncEventQueueId(asyncEventQueueId);
        new UpdateAttributesProcessor(this).distribute();
    }

    @Override
    public void checkSameSenderIdsAvailableOnAllNodes() {
        List<Set<String>> senderIds = this.getCacheDistributionAdvisor().adviseSameGatewaySenderIds(this.getGatewaySenderIds());
        if (!senderIds.isEmpty()) {
            throw new GatewaySenderConfigurationException(LocalizedStrings.Region_REGION_0_HAS_1_GATEWAY_SENDER_IDS_ANOTHER_CACHE_HAS_THE_SAME_REGION_WITH_2_GATEWAY_SENDER_IDS_FOR_REGION_ACROSS_ALL_MEMBERS_IN_DS_GATEWAY_SENDER_IDS_SHOULD_BE_SAME.toLocalizedString(this.getName(), senderIds.get(0), senderIds.get(1)));
        }
        List<Set<String>> asycnQueueIds = this.getCacheDistributionAdvisor().adviseSameAsyncEventQueueIds(this.getAsyncEventQueueIds());
        if (!asycnQueueIds.isEmpty()) {
            throw new GatewaySenderConfigurationException(LocalizedStrings.Region_REGION_0_HAS_1_ASYNC_EVENT_QUEUE_IDS_ANOTHER_CACHE_HAS_THE_SAME_REGION_WITH_2_ASYNC_EVENT_QUEUE_IDS_FOR_REGION_ACROSS_ALL_MEMBERS_IN_DS_ASYNC_EVENT_QUEUE_IDS_SHOULD_BE_SAME.toLocalizedString(this.getName(), asycnQueueIds.get(0), asycnQueueIds.get(1)));
        }
    }

    private boolean isLockingSuspendedByCurrentThread() {
        try {
            return this.getLockService().isLockingSuspendedByCurrentThread();
        }
        catch (IllegalStateException e) {
            this.lockCheckReadiness();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lock getDistributedLockIfGlobal(Object key) throws TimeoutException {
        if (this.getScope().isGlobal()) {
            long timeLeft;
            if (this.isLockingSuspendedByCurrentThread()) {
                return null;
            }
            long start = System.currentTimeMillis();
            long lockTimeout = timeLeft = (long)this.getCache().getLockTimeout();
            StringId msg = null;
            Object[] msgArgs = null;
            while (timeLeft > 0L || lockTimeout == -1L) {
                this.cache.getCancelCriterion().checkCancelInProgress(null);
                boolean interrupted = Thread.interrupted();
                try {
                    Lock dlock = this.getDistributedLock(key);
                    if (dlock.tryLock(timeLeft, TimeUnit.SECONDS)) {
                        Lock lock = dlock;
                        return lock;
                    }
                    msg = LocalizedStrings.DistributedRegion_ATTEMPT_TO_ACQUIRE_DISTRIBUTED_LOCK_FOR_0_FAILED_AFTER_WAITING_1_SECONDS;
                    msgArgs = new Object[]{key, (System.currentTimeMillis() - start) / 1000L};
                    break;
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                    this.cache.getCancelCriterion().checkCancelInProgress(ex);
                    if (lockTimeout <= -1L) continue;
                    timeLeft = (long)this.getCache().getLockTimeout() - (System.currentTimeMillis() - start) / 1000L;
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                }
            }
            if (msg == null) {
                msg = LocalizedStrings.DistributedRegion_TIMED_OUT_AFTER_WAITING_0_SECONDS_FOR_THE_DISTRIBUTED_LOCK_FOR_1;
                msgArgs = new Object[]{this.getCache().getLockTimeout(), key};
            }
            throw new TimeoutException(msg.toLocalizedString(msgArgs));
        }
        return null;
    }

    protected boolean checkEntryNotValid(RegionEntry mapEntry) {
        return mapEntry == null || mapEntry.isRemoved() && !mapEntry.isTombstone();
    }

    @Override
    public Iterator<RegionEntry> getBestIterator(boolean includeValues) {
        DiskRegion dr = this.getDiskRegion();
        if (DiskPage.DISK_PAGE_SIZE > 0L && includeValues && dr != null) {
            dr.waitForAsyncRecovery();
            if (dr.getNumOverflowOnDisk() > 0L) {
                return new DiskSavyIterator();
            }
        }
        return this.entries.regionEntries().iterator();
    }

    protected long getLockLeaseForLock() {
        if (this.getCache().getLockLease() == -1) {
            return -1L;
        }
        return this.getCache().getLockLease() * 1000;
    }

    protected long getLockTimeoutForLock(long time, TimeUnit unit) {
        if (time == -1L) {
            return -1L;
        }
        return TimeUnit.MILLISECONDS.convert(time, unit);
    }

    Lock getRegionDistributedLockIfGlobal() throws TimeoutException {
        if (this.getScope().isGlobal()) {
            if (this.isLockingSuspendedByCurrentThread()) {
                return null;
            }
            Lock dlock = this.getRegionDistributedLock();
            dlock.lock();
            return dlock;
        }
        return null;
    }

    @Override
    public void postPutAllSend(DistributedPutAllOperation putAllOp, VersionedObjectList successfulPuts) {
        if (putAllOp.putAllDataSize > 0) {
            putAllOp.distribute();
        } else if (logger.isDebugEnabled()) {
            logger.debug("DR.postPutAll: no data to distribute");
        }
    }

    @Override
    public void postRemoveAllSend(DistributedRemoveAllOperation op, VersionedObjectList successfulOps) {
        if (op.removeAllDataSize > 0) {
            op.distribute();
        } else {
            this.getCache().getLoggerI18n().fine("DR.postRemoveAll: no data to distribute");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VersionedObjectList basicPutAll(Map<?, ?> map, DistributedPutAllOperation putAllOp, Map<Object, VersionTag> retryVersions) {
        Lock dlock = this.getRegionDistributedLockIfGlobal();
        try {
            VersionedObjectList versionedObjectList = super.basicPutAll(map, putAllOp, retryVersions);
            return versionedObjectList;
        }
        finally {
            if (dlock != null) {
                dlock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VersionedObjectList basicRemoveAll(Collection<Object> keys, DistributedRemoveAllOperation removeAllOp, ArrayList<VersionTag> retryVersions) {
        Lock dlock = this.getRegionDistributedLockIfGlobal();
        try {
            VersionedObjectList versionedObjectList = super.basicRemoveAll(keys, removeAllOp, retryVersions);
            return versionedObjectList;
        }
        finally {
            if (dlock != null) {
                dlock.unlock();
            }
        }
    }

    boolean isMissingRequiredRoles() {
        return this.isMissingRequiredRoles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set waitForRequiredRoles(long timeout) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.checkReadiness();
        if (!this.getMembershipAttributes().hasRequiredRoles()) {
            throw new IllegalStateException(LocalizedStrings.DistributedRegion_REGION_HAS_NOT_BEEN_CONFIGURED_WITH_REQUIRED_ROLES.toLocalizedString());
        }
        if (!this.isMissingRequiredRoles) {
            if (logger.isDebugEnabled()) {
                logger.debug("No missing required roles to wait for.");
            }
            return Collections.EMPTY_SET;
        }
        if (timeout != 0L) {
            if (timeout == -1L) {
                while (this.isMissingRequiredRoles) {
                    this.checkReadiness();
                    this.cache.getCancelCriterion().checkCancelInProgress(null);
                    HashSet hashSet = this.missingRequiredRoles;
                    synchronized (hashSet) {
                        if (this.isMissingRequiredRoles) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("About to wait for missing required roles.");
                            }
                            this.missingRequiredRoles.wait();
                        }
                    }
                }
            } else {
                long endTime = System.currentTimeMillis() + timeout;
                while (this.isMissingRequiredRoles) {
                    this.checkReadiness();
                    this.cache.getCancelCriterion().checkCancelInProgress(null);
                    HashSet hashSet = this.missingRequiredRoles;
                    synchronized (hashSet) {
                        if (this.isMissingRequiredRoles) {
                            long timeToWait = endTime - System.currentTimeMillis();
                            if (timeToWait <= 0L) {
                                break;
                            }
                            if (logger.isDebugEnabled()) {
                                logger.debug("About to wait up to {} milliseconds for missing required roles.", (Object)timeToWait);
                            }
                            this.missingRequiredRoles.wait(timeToWait);
                        }
                    }
                }
            }
        }
        this.checkReadiness();
        if (this.isMissingRequiredRoles) {
            HashSet hashSet = this.missingRequiredRoles;
            synchronized (hashSet) {
                return Collections.unmodifiableSet(new HashSet(this.missingRequiredRoles));
            }
        }
        return Collections.EMPTY_SET;
    }

    public boolean isRoleInRegionMembership(Role role) {
        this.checkReadiness();
        return this.basicIsRoleInRegionMembership(role);
    }

    protected boolean basicIsRoleInRegionMembership(Role role) {
        if (this.getSystem().getDistributedMember().getRoles().contains(role)) {
            return true;
        }
        Set<InternalDistributedMember> members = this.distAdvisor.adviseGeneric();
        for (DistributedMember distributedMember : members) {
            Set<Role> roles = distributedMember.getRoles();
            if (!roles.contains(role)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remoteRegionInitialized(CacheDistributionAdvisor.CacheProfile profile) {
        AdvisorListener advisorListener = this.advisorListener;
        synchronized (advisorListener) {
            if (this.advisorListener.members == null && this.hasListener()) {
                CacheDistributionAdvisor.CacheProfile callback = TEST_HOOK_ADD_PROFILE ? profile : null;
                RegionEventImpl event = new RegionEventImpl(this, Operation.REGION_CREATE, callback, true, profile.peerMemberId);
                this.dispatchListenerEvent(EnumListenerEvent.AFTER_REMOTE_REGION_CREATE, event);
            }
        }
    }

    @Override
    protected void removeSenderFromAdvisor(InternalDistributedMember sender, int serial, boolean regionDestroyed) {
        this.getDistributionAdvisor().removeIdWithSerial(sender, serial, regionDestroyed);
    }

    @Override
    public DistributionAdvisee getParentAdvisee() {
        return (DistributionAdvisee)((Object)this.basicGetParentRegion());
    }

    @Override
    public DistributedMember getOwnerForKey(KeyInfo key) {
        assert (!this.isInternalRegion() || this.isMetaRegionWithTransactions());
        if (!this.getAttributes().getDataPolicy().withStorage() || this.concurrencyChecksEnabled && this.getAttributes().getDataPolicy() == DataPolicy.NORMAL) {
            return this.getRandomReplicate();
        }
        if (this.concurrencyChecksEnabled && !this.generateVersionTag) {
            return this.getRandomPersistentReplicate();
        }
        return super.getOwnerForKey(key);
    }

    @Override
    public ResultCollector executeFunction(DistributedRegionFunctionExecutor execution, Function function, Object args, ResultCollector rc, Set filter, ServerToClientFunctionResultSender sender) {
        DistributedMember target = this.getTransactionalNode();
        if (target != null) {
            if (target.equals(this.getMyId())) {
                return this.executeLocally(execution, function, args, 0, rc, filter, sender);
            }
            return this.executeOnReplicate(execution, function, args, rc, filter, target);
        }
        if (this.getAttributes().getDataPolicy().withReplication() || this.getAttributes().getDataPolicy().withPreloaded()) {
            Set<InternalDistributedMember> singleMember = Collections.singleton(this.getMyId());
            execution.validateExecution(function, singleMember);
            execution.setExecutionNodes(singleMember);
            return this.executeLocally(execution, function, args, 0, rc, filter, sender);
        }
        target = this.getRandomReplicate();
        if (target == null) {
            throw new FunctionException(LocalizedStrings.DistributedRegion_NO_REPLICATED_REGION_FOUND_FOR_EXECUTING_FUNCTION_0.toLocalizedString(function.getId()));
        }
        LocalResultCollector<?, ?> localRC = execution.getLocalResultCollector(function, rc);
        return this.executeOnReplicate(execution, function, args, localRC, filter, target);
    }

    private ResultCollector executeOnReplicate(DistributedRegionFunctionExecutor execution, Function function, Object args, ResultCollector rc, Set filter, DistributedMember target) {
        Set<DistributedMember> singleMember = Collections.singleton(target);
        execution.validateExecution(function, singleMember);
        execution.setExecutionNodes(singleMember);
        HashMap<InternalDistributedMember, Object> memberArgs = new HashMap<InternalDistributedMember, Object>();
        memberArgs.put((InternalDistributedMember)target, execution.getArgumentsForMember(target.getId()));
        DistributedRegionFunctionResultSender resultSender = new DistributedRegionFunctionResultSender(null, rc, function, execution.getServerResultSender());
        DistributedRegionFunctionResultWaiter waiter = new DistributedRegionFunctionResultWaiter(this.getSystem(), this.getFullPath(), rc, function, filter, Collections.singleton(target), memberArgs, resultSender);
        rc = waiter.getFunctionResultFrom(Collections.singleton(target), function, execution);
        return rc;
    }

    private DistributedMember getTransactionalNode() {
        if (this.cache.getTxManager().getTXState() != null) {
            return this.cache.getTxManager().getTXState().getTarget();
        }
        return null;
    }

    public InternalDistributedMember getRandomReplicate() {
        GetRandomReplicate getReplicate = new GetRandomReplicate();
        this.getCacheDistributionAdvisor().accept(getReplicate, null);
        return getReplicate.member;
    }

    public InternalDistributedMember getRandomPersistentReplicate() {
        GetRandomReplicate getPersistentReplicate = new GetRandomReplicate(true);
        this.getCacheDistributionAdvisor().accept(getPersistentReplicate, null);
        return getPersistentReplicate.member;
    }

    void executeOnRegion(DistributedRegionFunctionStreamingMessage msg, Function function, Object args, int prid, Set filter, boolean isReExecute) throws IOException {
        DM dm = this.getDistributionManager();
        DistributedRegionFunctionResultSender resultSender = new DistributedRegionFunctionResultSender(dm, msg, function);
        RegionFunctionContextImpl context = new RegionFunctionContextImpl(function.getId(), this, args, filter, null, null, resultSender, isReExecute);
        FunctionStats stats = FunctionStats.getFunctionStats(function.getId(), dm.getSystem());
        try {
            long start = stats.startTime();
            stats.startFunctionExecution(function.hasResult());
            function.execute(context);
            stats.endFunctionExecution(start, function.hasResult());
        }
        catch (FunctionException functionException) {
            if (logger.isDebugEnabled()) {
                logger.debug("FunctionException occured on remote node  while executing Function: {}", (Object)function.getId(), (Object)functionException);
            }
            stats.endFunctionExecutionWithException(function.hasResult());
            throw functionException;
        }
        catch (CacheClosedException cacheClosedexception) {
            if (logger.isDebugEnabled()) {
                logger.debug("CacheClosedException occured on remote node  while executing Function: {}", (Object)function.getId(), (Object)cacheClosedexception);
            }
            throw cacheClosedexception;
        }
        catch (Exception exception) {
            if (logger.isDebugEnabled()) {
                logger.debug("Exception occured on remote node  while executing Function: {}", (Object)function.getId(), (Object)exception);
            }
            stats.endFunctionExecutionWithException(function.hasResult());
            throw new FunctionException(exception);
        }
    }

    ResultCollector executeLocally(DistributedRegionFunctionExecutor execution, Function function, Object args, int prid, ResultCollector rc, Set filter, ServerToClientFunctionResultSender sender) {
        LocalResultCollector<?, ?> localRC = execution.getLocalResultCollector(function, rc);
        DM dm = this.getDistributionManager();
        DistributedRegionFunctionResultSender resultSender = new DistributedRegionFunctionResultSender(dm, localRC, function, sender);
        RegionFunctionContextImpl context = new RegionFunctionContextImpl(function.getId(), this, args, filter, null, null, resultSender, execution.isReExecute());
        execution.executeFunctionOnLocalNode(function, context, resultSender, dm, this.isTX());
        return localRC;
    }

    @Override
    protected void setMemoryThresholdFlag(MemoryEvent event) {
        Set<InternalDistributedMember> others = this.getCacheDistributionAdvisor().adviseGeneric();
        if (event.isLocal() || others.contains(event.getMember())) {
            if (event.getState().isCritical() && !event.getPreviousState().isCritical() && (event.getType() == InternalResourceManager.ResourceType.HEAP_MEMORY || event.getType() == InternalResourceManager.ResourceType.OFFHEAP_MEMORY && this.getOffHeap())) {
                this.setMemoryThresholdReachedCounterTrue(event.getMember());
            } else if (!event.getState().isCritical() && event.getPreviousState().isCritical() && (event.getType() == InternalResourceManager.ResourceType.HEAP_MEMORY || event.getType() == InternalResourceManager.ResourceType.OFFHEAP_MEMORY && this.getOffHeap())) {
                this.removeMemberFromCriticalList(event.getMember());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMemberFromCriticalList(DistributedMember member) {
        if (logger.isDebugEnabled()) {
            logger.debug("DR: removing member {} from critical member list", (Object)member);
        }
        Set<DistributedMember> set = this.memoryThresholdReachedMembers;
        synchronized (set) {
            this.memoryThresholdReachedMembers.remove(member);
            if (this.memoryThresholdReachedMembers.size() == 0) {
                this.memoryThresholdReached.set(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<DistributedMember> getMemoryThresholdReachedMembers() {
        Set<DistributedMember> set = this.memoryThresholdReachedMembers;
        synchronized (set) {
            return Collections.unmodifiableSet(this.memoryThresholdReachedMembers);
        }
    }

    @Override
    public void initialCriticalMembers(boolean localMemoryIsCritical, Set<InternalDistributedMember> critialMembers) {
        Set<InternalDistributedMember> others = this.getCacheDistributionAdvisor().adviseGeneric();
        for (InternalDistributedMember idm : critialMembers) {
            if (!others.contains(idm)) continue;
            this.setMemoryThresholdReachedCounterTrue(idm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMemoryThresholdReachedCounterTrue(DistributedMember idm) {
        Set<DistributedMember> set = this.memoryThresholdReachedMembers;
        synchronized (set) {
            this.memoryThresholdReachedMembers.add(idm);
            if (this.memoryThresholdReachedMembers.size() > 0) {
                this.memoryThresholdReached.set(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VersionTag fetchRemoteVersionTag(Object key) {
        VersionTag tag = null;
        assert (this.dataPolicy != DataPolicy.REPLICATE);
        TransactionId txId = this.cache.getCacheTransactionManager().suspend();
        try {
            boolean retry = true;
            InternalDistributedMember member = this.getRandomReplicate();
            while (retry) {
                try {
                    if (member == null) {
                        break;
                    }
                    RemoteFetchVersionMessage.FetchVersionResponse response = RemoteFetchVersionMessage.send(member, this, key);
                    tag = response.waitForResponse();
                    retry = false;
                }
                catch (RemoteOperationException e) {
                    member = this.getRandomReplicate();
                    if (member == null || !logger.isDebugEnabled()) continue;
                    logger.debug("Retrying RemoteFetchVersionMessage on member:{}", (Object)member);
                }
            }
        }
        finally {
            if (txId != null) {
                this.cache.getCacheTransactionManager().resume(txId);
            }
        }
        return tag;
    }

    public boolean hasNetLoader() {
        return this.hasNetLoader(this.getCacheDistributionAdvisor());
    }

    static final class GetRandomReplicate
    implements DistributionAdvisor.ProfileVisitor<DistributedMember> {
        private boolean onlyPersistent = false;
        InternalDistributedMember member = null;
        private int randIndex = -1;

        public GetRandomReplicate() {
        }

        public GetRandomReplicate(boolean onlyPersistent) {
            this.onlyPersistent = onlyPersistent;
        }

        @Override
        public boolean visit(DistributionAdvisor advisor, DistributionAdvisor.Profile profile, int profileIndex, int numProfiles, DistributedMember member) {
            CacheDistributionAdvisor.CacheProfile cp = (CacheDistributionAdvisor.CacheProfile)profile;
            if (this.randIndex < 0) {
                this.randIndex = PartitionedRegion.rand.nextInt(numProfiles);
            }
            if (cp.dataPolicy.withReplication() && cp.regionInitialized) {
                if (this.onlyPersistent && !cp.dataPolicy.withPersistence()) {
                    return true;
                }
                this.member = cp.getDistributedMember();
                if (profileIndex >= this.randIndex) {
                    return false;
                }
            }
            return true;
        }
    }

    protected class AdvisorListener
    implements MembershipListener {
        private Set members = new HashSet();
        protected boolean destroyed = false;

        protected AdvisorListener() {
        }

        protected synchronized void addMembers(Set newMembers) {
            this.members.addAll(newMembers);
        }

        protected synchronized Set getInitialMembers() {
            Set initMembers = this.members;
            this.members = null;
            return initMembers;
        }

        @Override
        public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
        }

        @Override
        public void memberSuspect(InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
        }

        protected synchronized void initRMLWrappers() {
            Set<InternalDistributedMember> membersWithThisRegion = DistributedRegion.this.distAdvisor.adviseGeneric();
            DistributedRegion.this.initPostCreateRegionMembershipListeners(membersWithThisRegion);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void memberJoined(InternalDistributedMember id) {
            if (this.destroyed) {
                return;
            }
            if (this.members != null) {
                this.members.add(id);
            }
            if (DistributedRegion.this.getMembershipAttributes().hasRequiredRoles()) {
                HashSet newlyAcquiredRoles = Collections.EMPTY_SET;
                HashSet hashSet = DistributedRegion.this.missingRequiredRoles;
                synchronized (hashSet) {
                    if (DistributedRegion.this.isMissingRequiredRoles) {
                        Set<Role> roles = id.getRoles();
                        newlyAcquiredRoles = new HashSet(DistributedRegion.this.missingRequiredRoles);
                        newlyAcquiredRoles.retainAll(roles);
                        if (!newlyAcquiredRoles.isEmpty()) {
                            if (DistributedRegion.this.rmq != null) {
                                Iterator it = newlyAcquiredRoles.iterator();
                                DM dm = DistributedRegion.this.getDistributionManager();
                                if (it.hasNext()) {
                                    DistributedRegion.this.getCache().getCancelCriterion().checkCancelInProgress(null);
                                    final Role role = (Role)it.next();
                                    dm.getWaitingThreadPool().execute(new Runnable(){

                                        @Override
                                        public void run() {
                                            DistributedRegion.this.rmq.roleReady(role);
                                        }
                                    });
                                }
                            }
                            DistributedRegion.this.missingRequiredRoles.removeAll(newlyAcquiredRoles);
                            if (this.members == null && DistributedRegion.this.missingRequiredRoles.isEmpty()) {
                                DistributedRegion.this.isMissingRequiredRoles = false;
                                DistributedRegion.this.getCachePerfStats().incReliableRegionsMissing(-1);
                                if (DistributedRegion.this.getMembershipAttributes().getLossAction().isAllAccess()) {
                                    DistributedRegion.this.getCachePerfStats().incReliableRegionsMissingFullAccess(-1);
                                } else if (DistributedRegion.this.getMembershipAttributes().getLossAction().isLimitedAccess()) {
                                    DistributedRegion.this.getCachePerfStats().incReliableRegionsMissingLimitedAccess(-1);
                                } else if (DistributedRegion.this.getMembershipAttributes().getLossAction().isNoAccess()) {
                                    DistributedRegion.this.getCachePerfStats().incReliableRegionsMissingNoAccess(-1);
                                }
                                boolean async = DistributedRegion.this.resumeReliability(id, newlyAcquiredRoles);
                                if (async) {
                                    this.destroyed = true;
                                }
                            }
                        }
                    }
                    if (!this.destroyed) {
                        DistributedRegion.this.missingRequiredRoles.notifyAll();
                    }
                }
                if (!this.destroyed && this.members == null && DistributedRegion.this.hasListener() && !newlyAcquiredRoles.isEmpty()) {
                    RoleEventImpl relEvent = new RoleEventImpl((Region)DistributedRegion.this, Operation.REGION_CREATE, null, true, (DistributedMember)id, newlyAcquiredRoles);
                    DistributedRegion.this.dispatchListenerEvent(EnumListenerEvent.AFTER_ROLE_GAIN, relEvent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void memberDeparted(InternalDistributedMember id, boolean crashed) {
            if (this.destroyed) {
                return;
            }
            if (this.members != null) {
                this.members.remove(id);
            }
            if (this.members == null && DistributedRegion.this.hasListener()) {
                RegionEventImpl event = new RegionEventImpl(DistributedRegion.this, Operation.REGION_CLOSE, null, true, id);
                if (crashed) {
                    DistributedRegion.this.dispatchListenerEvent(EnumListenerEvent.AFTER_REMOTE_REGION_CRASH, event);
                } else if (DestroyRegionOperation.isRegionDepartureNotificationOk()) {
                    DistributedRegion.this.dispatchListenerEvent(EnumListenerEvent.AFTER_REMOTE_REGION_DEPARTURE, event);
                }
            }
            if (DistributedRegion.this.getMembershipAttributes().hasRequiredRoles()) {
                HashSet<Role> newlyMissingRoles = Collections.EMPTY_SET;
                HashSet hashSet = DistributedRegion.this.missingRequiredRoles;
                synchronized (hashSet) {
                    Set<Role> roles = id.getRoles();
                    for (Role role : roles) {
                        boolean async;
                        if (!DistributedRegion.this.getMembershipAttributes().getRequiredRoles().contains(role) || DistributedRegion.this.basicIsRoleInRegionMembership(role)) continue;
                        if (newlyMissingRoles == Collections.EMPTY_SET) {
                            newlyMissingRoles = new HashSet<Role>();
                        }
                        newlyMissingRoles.add(role);
                        if (this.members != null || DistributedRegion.this.isMissingRequiredRoles) continue;
                        DistributedRegion.this.isMissingRequiredRoles = true;
                        DistributedRegion.this.getCachePerfStats().incReliableRegionsMissing(1);
                        if (DistributedRegion.this.getMembershipAttributes().getLossAction().isAllAccess()) {
                            DistributedRegion.this.getCachePerfStats().incReliableRegionsMissingFullAccess(1);
                        } else if (DistributedRegion.this.getMembershipAttributes().getLossAction().isLimitedAccess()) {
                            DistributedRegion.this.getCachePerfStats().incReliableRegionsMissingLimitedAccess(1);
                        } else if (DistributedRegion.this.getMembershipAttributes().getLossAction().isNoAccess()) {
                            DistributedRegion.this.getCachePerfStats().incReliableRegionsMissingNoAccess(1);
                        }
                        if (!(async = DistributedRegion.this.lostReliability(id, newlyMissingRoles))) continue;
                        this.destroyed = true;
                    }
                    if (!this.destroyed) {
                        DistributedRegion.this.missingRequiredRoles.addAll(newlyMissingRoles);
                        DistributedRegion.this.missingRequiredRoles.notifyAll();
                    }
                }
                if (!this.destroyed && this.members == null && DistributedRegion.this.hasListener() && !newlyMissingRoles.isEmpty()) {
                    RoleEventImpl relEvent = new RoleEventImpl((Region)DistributedRegion.this, Operation.REGION_CLOSE, null, true, (DistributedMember)id, newlyMissingRoles);
                    DistributedRegion.this.dispatchListenerEvent(EnumListenerEvent.AFTER_ROLE_LOSS, relEvent);
                }
            }
        }
    }

    private class RegionDistributedLock
    implements Lock {
        @Override
        public void lock() {
            try {
                boolean locked = DistributedRegion.this.getLockService().suspendLocking(-1L);
                Assert.assertTrue(locked, "Failed to acquire RegionDistributedLock");
            }
            catch (IllegalStateException ex) {
                DistributedRegion.this.lockCheckReadiness();
                throw ex;
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            try {
                boolean locked = DistributedRegion.this.getLockService().suspendLockingInterruptibly(-1L);
                Assert.assertTrue(locked, "Failed to acquire RegionDistributedLock");
            }
            catch (IllegalStateException ex) {
                DistributedRegion.this.lockCheckReadiness();
                throw ex;
            }
        }

        @Override
        public boolean tryLock() {
            try {
                return DistributedRegion.this.getLockService().suspendLocking(0L);
            }
            catch (IllegalStateException ex) {
                DistributedRegion.this.lockCheckReadiness();
                throw ex;
            }
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            try {
                return DistributedRegion.this.getLockService().suspendLockingInterruptibly(DistributedRegion.this.getLockTimeoutForLock(time, unit));
            }
            catch (IllegalStateException ex) {
                DistributedRegion.this.lockCheckReadiness();
                throw ex;
            }
        }

        @Override
        public void unlock() {
            try {
                DistributedRegion.this.getLockService().resumeLocking();
            }
            catch (IllegalStateException ex) {
                DistributedRegion.this.lockCheckReadiness();
                throw ex;
            }
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException(LocalizedStrings.DistributedRegion_NEWCONDITION_UNSUPPORTED.toLocalizedString());
        }
    }

    private class DistributedLock
    implements Lock {
        private final Object key;

        public DistributedLock(Object key) {
            this.key = key;
        }

        @Override
        public void lock() {
            try {
                boolean locked = this.basicTryLock(-1L, TimeUnit.MILLISECONDS, false);
                if (!locked) {
                    DistributedRegion.this.lockCheckReadiness();
                }
                Assert.assertTrue(locked, "Failed to acquire DistributedLock");
            }
            catch (IllegalStateException ex) {
                DistributedRegion.this.lockCheckReadiness();
                throw ex;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                DistributedRegion.this.lockCheckReadiness();
                Assert.assertTrue(false, "Failed to acquire DistributedLock");
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            try {
                boolean locked = this.basicTryLock(-1L, TimeUnit.MILLISECONDS, true);
                if (!locked) {
                    DistributedRegion.this.lockCheckReadiness();
                }
                Assert.assertTrue(locked, "Failed to acquire DistributedLock");
            }
            catch (IllegalStateException ex) {
                DistributedRegion.this.lockCheckReadiness();
                throw ex;
            }
        }

        @Override
        public boolean tryLock() {
            try {
                ReplyProcessor21.forceSevereAlertProcessing();
                boolean bl = DistributedRegion.this.getLockService().lock(this.key, 0L, DistributedRegion.this.getLockLeaseForLock());
                return bl;
            }
            catch (IllegalStateException ex) {
                DistributedRegion.this.lockCheckReadiness();
                throw ex;
            }
            finally {
                ReplyProcessor21.unforceSevereAlertProcessing();
            }
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return this.basicTryLock(time, unit, true);
        }

        private boolean basicTryLock(long time, TimeUnit unit, boolean interruptible) throws InterruptedException {
            long waitInterval;
            long ackWaitThreshold;
            long end;
            DM dm = DistributedRegion.this.getDistributionManager();
            long start = System.currentTimeMillis();
            long timeoutMS = DistributedRegion.this.getLockTimeoutForLock(time, unit);
            if (timeoutMS < 0L) {
                timeoutMS = Long.MAX_VALUE;
                end = Long.MAX_VALUE;
            } else {
                end = start + timeoutMS;
            }
            long ackSAThreshold = DistributedRegion.this.getSystem().getConfig().getAckSevereAlertThreshold() * 1000;
            boolean suspected = false;
            boolean severeAlertIssued = false;
            DistributedMember lockHolder = null;
            if (ackSAThreshold > 0L) {
                waitInterval = ackWaitThreshold = (long)(DistributedRegion.this.getSystem().getConfig().getAckWaitThreshold() * 1000);
            } else {
                waitInterval = timeoutMS;
                ackWaitThreshold = 0L;
            }
            do {
                try {
                    DLockRemoteToken remoteToken;
                    long elapsed;
                    waitInterval = Math.min(end - System.currentTimeMillis(), waitInterval);
                    ReplyProcessor21.forceSevereAlertProcessing();
                    boolean gotLock = interruptible ? DistributedRegion.this.getLockService().lockInterruptibly(this.key, waitInterval, DistributedRegion.this.getLockLeaseForLock()) : DistributedRegion.this.getLockService().lock(this.key, waitInterval, DistributedRegion.this.getLockLeaseForLock());
                    if (gotLock) {
                        boolean bl = true;
                        return bl;
                    }
                    if (ackSAThreshold <= 0L || (elapsed = System.currentTimeMillis() - start) <= ackWaitThreshold) continue;
                    if (!suspected) {
                        suspected = true;
                        severeAlertIssued = false;
                        waitInterval = ackSAThreshold;
                        remoteToken = ((DLockService)DistributedRegion.this.getLockService()).queryLock(this.key);
                        lockHolder = remoteToken.getLessee();
                        if (lockHolder == null) continue;
                        dm.getMembershipManager().suspectMember(lockHolder, "Has not released a global region entry lock in over " + ackWaitThreshold / 1000L + " seconds");
                        continue;
                    }
                    if (elapsed <= ackSAThreshold) continue;
                    remoteToken = ((DLockService)DistributedRegion.this.getLockService()).queryLock(this.key);
                    if (lockHolder != null && remoteToken.getLessee() != null && lockHolder.equals(remoteToken.getLessee())) {
                        if (severeAlertIssued) continue;
                        severeAlertIssued = true;
                        logger.fatal(LocalizedMessage.create(LocalizedStrings.DistributedRegion_0_SECONDS_HAVE_ELAPSED_WAITING_FOR_GLOBAL_REGION_ENTRY_LOCK_HELD_BY_1, new Object[]{ackWaitThreshold + ackSAThreshold, lockHolder}));
                        continue;
                    }
                    suspected = false;
                    waitInterval = ackWaitThreshold;
                    lockHolder = null;
                }
                catch (IllegalStateException ex) {
                    DistributedRegion.this.lockCheckReadiness();
                    throw ex;
                }
                finally {
                    ReplyProcessor21.unforceSevereAlertProcessing();
                }
            } while (System.currentTimeMillis() < end);
            return false;
        }

        @Override
        public void unlock() {
            try {
                ReplyProcessor21.forceSevereAlertProcessing();
                DistributedRegion.this.getLockService().unlock(this.key);
                if (!DistributedRegion.this.entries.containsKey(this.key)) {
                    DistributedRegion.this.getLockService().freeResources(this.key);
                }
            }
            catch (IllegalStateException ex) {
                DistributedRegion.this.lockCheckReadiness();
                throw ex;
            }
            finally {
                ReplyProcessor21.unforceSevereAlertProcessing();
            }
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException(LocalizedStrings.DistributedRegion_NEWCONDITION_UNSUPPORTED.toLocalizedString());
        }
    }

    static class DiskPage
    extends DiskPosition {
        static final long DISK_PAGE_SIZE = Long.getLong("gemfire.DISK_PAGE_SIZE", 8192L);

        DiskPage(DiskPosition dp) {
            this.setPosition(dp.oplogId, dp.offset / DISK_PAGE_SIZE);
        }
    }

    public static class DiskPosition
    implements Comparable<DiskPosition> {
        private long oplogId;
        private long offset;

        DiskPosition() {
        }

        void setPosition(long oplogId, long offset) {
            this.oplogId = oplogId;
            this.offset = offset;
        }

        public int hashCode() {
            return Long.valueOf(this.oplogId ^ this.offset).hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof DiskPosition) {
                DiskPosition other = (DiskPosition)o;
                return this.oplogId == other.oplogId && this.offset == other.offset;
            }
            return false;
        }

        @Override
        public int compareTo(DiskPosition o) {
            int result = Long.signum(this.oplogId - o.oplogId);
            if (result == 0) {
                result = Long.signum(this.offset - o.offset);
            }
            return result;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("<").append(this.oplogId).append(":").append(this.offset).append(">");
            return sb.toString();
        }
    }

    private class DiskSavyIterator
    implements Iterator<RegionEntry> {
        private boolean usingIt = true;
        private Iterator<?> it;
        private Iterator<RegionEntry> subIt;
        private final TreeMap<DiskPage, Object> diskMap;

        public DiskSavyIterator() {
            this.it = DistributedRegion.this.entries.regionEntries().iterator();
            this.subIt = null;
            this.diskMap = new TreeMap();
        }

        @Override
        public boolean hasNext() {
            boolean result;
            if (this.subIt != null) {
                result = this.subIt.hasNext();
                if (!result) {
                    this.subIt = null;
                } else {
                    return result;
                }
            }
            result = this.it.hasNext();
            if (this.usingIt && !result) {
                this.usingIt = false;
                this.it = this.diskMap.values().iterator();
                result = this.it.hasNext();
            }
            return result;
        }

        @Override
        public RegionEntry next() {
            block5: {
                RegionEntry re;
                block6: {
                    do {
                        ArrayList<RegionEntry> al;
                        DiskPosition dp;
                        if (this.subIt != null) {
                            return this.subIt.next();
                        }
                        if (!this.usingIt) break block5;
                        re = (RegionEntry)this.it.next();
                        if (!re.isOverflowedToDisk(DistributedRegion.this, dp = new DiskPosition())) break block6;
                        DiskPage dPage = new DiskPage(dp);
                        Object v = this.diskMap.get(dPage);
                        if (v == null) {
                            this.diskMap.put(dPage, re);
                            continue;
                        }
                        if (v instanceof ArrayList) {
                            al = (ArrayList<RegionEntry>)v;
                            al.add(re);
                            continue;
                        }
                        al = new ArrayList<RegionEntry>();
                        al.add((RegionEntry)v);
                        al.add(re);
                        this.diskMap.put(dPage, al);
                    } while (this.hasNext() || $assertionsDisabled);
                    throw new AssertionError();
                }
                return re;
            }
            Object v = this.it.next();
            if (v instanceof ArrayList) {
                ArrayList al = (ArrayList)v;
                this.subIt = al.iterator();
                return this.subIt.next();
            }
            return (RegionEntry)v;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

