/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAlgorithm;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.AbstractRegionMap;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.DiskEntry;
import org.apache.geode.internal.cache.DiskRegion;
import org.apache.geode.internal.cache.EvictionAttributesImpl;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PlaceHolderDiskRegion;
import org.apache.geode.internal.cache.RegionClearedException;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.RegionMap;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.control.InternalResourceManager;
import org.apache.geode.internal.cache.lru.EnableLRU;
import org.apache.geode.internal.cache.lru.HeapEvictor;
import org.apache.geode.internal.cache.lru.HeapLRUCapacityController;
import org.apache.geode.internal.cache.lru.LRUAlgorithm;
import org.apache.geode.internal.cache.lru.LRUEntry;
import org.apache.geode.internal.cache.lru.LRUStatistics;
import org.apache.geode.internal.cache.lru.MemLRUCapacityController;
import org.apache.geode.internal.cache.lru.NewLIFOClockHand;
import org.apache.geode.internal.cache.lru.NewLRUClockHand;
import org.apache.geode.internal.cache.versions.RegionVersionVector;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.offheap.StoredObject;
import org.apache.geode.internal.size.ReflectionSingleObjectSizer;
import org.apache.logging.log4j.Logger;

public abstract class AbstractLRURegionMap
extends AbstractRegionMap {
    private static final Logger logger = LogService.getLogger();
    private LRUAlgorithm evictionController;
    private final ThreadLocal lruDelta = new ThreadLocal();
    private final ThreadLocal mustRemove = new ThreadLocal();
    private final ThreadLocal callbackDisabled = new ThreadLocal();

    protected abstract void _setCCHelper(EnableLRU var1);

    protected abstract EnableLRU _getCCHelper();

    protected abstract void _setLruList(NewLRUClockHand var1);

    protected abstract NewLRUClockHand _getLruList();

    protected AbstractLRURegionMap(InternalRegionArguments internalRegionArgs) {
        super(internalRegionArgs);
    }

    protected void initialize(Object owner, RegionMap.Attributes attr, InternalRegionArguments internalRegionArgs) {
        LRUAlgorithm ec;
        EvictionAlgorithm ea;
        super.initialize(owner, attr, internalRegionArgs, true);
        if (owner instanceof LocalRegion) {
            ea = ((LocalRegion)owner).getEvictionAttributes().getAlgorithm();
            ec = ((LocalRegion)owner).getEvictionController();
        } else if (owner instanceof PlaceHolderDiskRegion) {
            PlaceHolderDiskRegion phdr = (PlaceHolderDiskRegion)owner;
            ea = phdr.getActualLruAlgorithm();
            ec = ((EvictionAttributesImpl)phdr.getEvictionAttributes()).createEvictionController(null, phdr.getOffHeap());
        } else {
            throw new IllegalStateException("expected LocalRegion or PlaceHolderDiskRegion");
        }
        this.evictionController = ec;
        if (ea.isLRUMemory()) {
            ((MemLRUCapacityController)ec).setEntryOverHead(this.getEntryOverHead());
        }
        if (ea.isLRUHeap()) {
            ((HeapLRUCapacityController)ec).setEntryOverHead(this.getEntryOverHead());
        }
        this._setCCHelper(AbstractLRURegionMap.getHelper(ec));
        if (ea == EvictionAlgorithm.LIFO_ENTRY || ea == EvictionAlgorithm.LIFO_MEMORY) {
            this._setLruList(new NewLIFOClockHand(owner, this._getCCHelper(), internalRegionArgs));
        } else {
            this._setLruList(new NewLRUClockHand(owner, this._getCCHelper(), internalRegionArgs));
        }
    }

    @Override
    public void changeOwner(LocalRegion r) {
        super.changeOwner(r);
        this._getLruList().setBucketRegion(r);
        this.evictionController.setBucketRegion(r);
    }

    private int getDelta() {
        Object d = this.lruDelta.get();
        this.lruDelta.set(null);
        if (d == null) {
            return 0;
        }
        return (Integer)d;
    }

    private void setDelta(int delta) {
        Integer delt;
        if (!this.getCallbackDisabled()) {
            if (this.getMustRemove()) {
                this.lruUpdateCallback();
            }
            this.setMustRemove(true);
        }
        if ((delt = (Integer)this.lruDelta.get()) != null) {
            delta += delt.intValue();
        }
        this.lruDelta.set(delta);
    }

    public boolean beginChangeValueForm(LRUEntry le, CachedDeserializable cd2, Object v) {
        if (this._getCCHelper().getEvictionAlgorithm().isLRUEntry()) {
            return false;
        }
        Object curVal = le._getValue();
        if (curVal != cd2) {
            if (cd2 instanceof StoredObject) {
                if (!cd2.equals(curVal)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        boolean result = false;
        int delta = le.updateEntrySize(this._getCCHelper(), new CDValueWrapper(v));
        if (delta != 0) {
            result = true;
            boolean disabledLURCallbacks = this.disableLruUpdateCallback();
            this.setDelta(delta);
            if (disabledLURCallbacks) {
                this.enableLruUpdateCallback();
            }
        }
        if (this._getCCHelper().getEvictionAlgorithm().isLRUHeap() && this._isOwnerALocalRegion() && this._getOwner() instanceof BucketRegion && HeapEvictor.EVICT_HIGH_ENTRY_COUNT_BUCKETS_FIRST) {
            result = false;
        }
        return result;
    }

    public void finishChangeValueForm() {
        this.lruUpdateCallback();
    }

    private boolean getMustRemove() {
        Object d = this.mustRemove.get();
        if (d == null) {
            return false;
        }
        return (Boolean)d;
    }

    private void setMustRemove(boolean b) {
        this.mustRemove.set(b ? Boolean.TRUE : null);
    }

    private boolean getCallbackDisabled() {
        Object d = this.callbackDisabled.get();
        if (d == null) {
            return false;
        }
        return (Boolean)d;
    }

    private void setCallbackDisabled(boolean b) {
        this.callbackDisabled.set(b ? Boolean.TRUE : Boolean.FALSE);
    }

    public int getEntryOverHead() {
        RegionEntryFactory f = this.getEntryFactory();
        if (f == null) {
            return 0;
        }
        return (int)ReflectionSingleObjectSizer.sizeof(f.getEntryClass());
    }

    public final void audit() {
        if (logger.isTraceEnabled(LogMarker.LRU)) {
            logger.trace(LogMarker.LRU, "Size of LRUMap = {}", (Object)this.sizeInVM());
        }
        this._getLruList().audit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int evictEntry(LRUEntry entry, LRUStatistics stats) throws RegionClearedException {
        EvictionAction action = this._getCCHelper().getEvictionAction();
        LocalRegion region = this._getOwner();
        if (action.isLocalDestroy()) {
            int size = entry.getEntrySize();
            if (region.evictDestroy(entry)) {
                return size;
            }
            return 0;
        }
        if (action.isOverflowToDisk()) {
            boolean result;
            Assert.assertTrue(entry instanceof DiskEntry);
            int change = 0;
            LRUEntry lRUEntry = entry;
            synchronized (lRUEntry) {
                if (entry.isInUseByTransaction()) {
                    entry.unsetEvicted();
                    if (logger.isTraceEnabled(LogMarker.LRU)) {
                        logger.trace(LogMarker.LRU, "No eviction of transactional entry for key={}", entry.getKey());
                    }
                    return 0;
                }
                Token entryVal = entry.getValueAsToken();
                if (entryVal == null) {
                    if (logger.isTraceEnabled(LogMarker.LRU)) {
                        logger.trace(LogMarker.LRU, "no need to evict already evicted key={}", entry.getKey());
                    }
                    return 0;
                }
                if (Token.isInvalidOrRemoved(entryVal)) {
                    if (logger.isTraceEnabled(LogMarker.LRU)) {
                        logger.trace(LogMarker.LRU, "no need to evict {} token for key={}", (Object)entryVal, entry.getKey());
                    }
                    return 0;
                }
                entry.setEvicted();
                change = DiskEntry.Helper.overflowToDisk((DiskEntry)((Object)entry), region, this._getCCHelper());
            }
            boolean bl = result = change < 0;
            if (result) {
                if (this._getOwner() instanceof BucketRegion) {
                    BucketRegion bucketRegion = (BucketRegion)this._getOwner();
                    bucketRegion.updateCounter(change);
                    stats.updateCounter(change);
                } else {
                    stats.updateCounter(change);
                }
            } else if (logger.isTraceEnabled(LogMarker.LRU)) {
                logger.trace(LogMarker.LRU, "no need to evict token for key={} because moving its value to disk resulted in a net change of {} bytes.", entry.getKey(), (Object)change);
            }
            return change * -1;
        }
        throw new InternalGemFireException(LocalizedStrings.AbstractLRURegionMap_UNKNOWN_EVICTION_ACTION_0.toLocalizedString(action));
    }

    protected final void changeTotalEntrySize(int delta) {
        if (this._isOwnerALocalRegion() && this._getOwner() instanceof BucketRegion) {
            BucketRegion bucketRegion = (BucketRegion)this._getOwner();
            bucketRegion.updateCounter(delta);
        }
        this._getLruList().stats().updateCounter(delta);
        if (delta > 0 && logger.isTraceEnabled(LogMarker.LRU)) {
            logger.trace(LogMarker.LRU, "total lru size is now: {}", (Object)this.getTotalEntrySize());
        }
    }

    private static EnableLRU getHelper(LRUAlgorithm ec) {
        return ec.getLRUHelper();
    }

    @Override
    public void evictValue(Object key) {
        throw new IllegalStateException("The evictValue is not supported on regions with eviction attributes.");
    }

    protected final long getLimit() {
        if (this._getOwner() instanceof BucketRegion) {
            BucketRegion bucketRegion = (BucketRegion)this._getOwner();
            return bucketRegion.getLimit();
        }
        return this._getLruList().stats().getLimit();
    }

    public final LRUStatistics getLRUStatistics() {
        return this._getLruList().stats();
    }

    protected final long getTotalEntrySize() {
        if (this._getOwnerObject() instanceof BucketRegion) {
            BucketRegion bucketRegion = (BucketRegion)this._getOwner();
            return bucketRegion.getCounter();
        }
        return this._getLruList().stats().getCounter();
    }

    @Override
    public final void lruUpdateCallback() {
        boolean isDebugEnabled_LRU;
        block30: {
            int delta;
            isDebugEnabled_LRU = logger.isTraceEnabled(LogMarker.LRU);
            if (this.getCallbackDisabled()) {
                return;
            }
            int bytesToEvict = delta = this.getDelta();
            this.resetThreadLocals();
            if (isDebugEnabled_LRU && this._isOwnerALocalRegion()) {
                logger.trace(LogMarker.LRU, "lruUpdateCallback; list size is: {}; actual size is: {}; map size is: {}; delta is: {}; limit is: {}; tombstone count={}", (Object)this.getTotalEntrySize(), (Object)this._getLruList().getExpensiveListCount(), (Object)this.size(), (Object)delta, (Object)this.getLimit(), (Object)this._getOwner().getTombstoneCount());
            }
            LRUStatistics stats = this._getLruList().stats();
            if (!this._isOwnerALocalRegion()) {
                this.changeTotalEntrySize(delta);
            } else {
                if (this._getCCHelper().getEvictionAlgorithm().isLRUHeap()) {
                    this.changeTotalEntrySize(delta);
                    try {
                        while (bytesToEvict > 0 && this._getCCHelper().mustEvict(stats, this._getOwner(), bytesToEvict)) {
                            boolean evictFromThisRegion = true;
                            if (HeapEvictor.EVICT_HIGH_ENTRY_COUNT_BUCKETS_FIRST && this._getOwner() instanceof BucketRegion) {
                                long bytesEvicted = 0L;
                                long totalBytesEvicted = 0L;
                                List<BucketRegion> regions = ((BucketRegion)this._getOwner()).getPartitionedRegion().getSortedBuckets();
                                Iterator<BucketRegion> iter = regions.iterator();
                                while (iter.hasNext()) {
                                    BucketRegion region = iter.next();
                                    if (region.getBucketAdvisor().isPrimary()) continue;
                                    try {
                                        bytesEvicted = ((AbstractLRURegionMap)region.entries).centralizedLruUpdateCallback();
                                        if (bytesEvicted == 0L) {
                                            iter.remove();
                                        } else {
                                            evictFromThisRegion = false;
                                        }
                                        totalBytesEvicted += bytesEvicted;
                                        bytesToEvict = (int)((long)bytesToEvict - bytesEvicted);
                                        if (bytesEvicted > (long)bytesToEvict) {
                                            bytesToEvict = 0;
                                            break;
                                        }
                                        if (totalBytesEvicted <= (long)bytesToEvict) continue;
                                        break;
                                    }
                                    catch (RegionDestroyedException rd) {
                                        region.cache.getCancelCriterion().checkCancelInProgress(rd);
                                    }
                                    catch (Exception e) {
                                        region.cache.getCancelCriterion().checkCancelInProgress(e);
                                        logger.warn(LocalizedMessage.create(LocalizedStrings.Eviction_EVICTOR_TASK_EXCEPTION, new Object[]{e.getMessage()}), (Throwable)e);
                                    }
                                }
                            }
                            if (!evictFromThisRegion) continue;
                            LRUEntry removalEntry = (LRUEntry)this._getLruList().getLRUEntry();
                            if (removalEntry != null) {
                                int sizeOfValue = this.evictEntry(removalEntry, stats);
                                if (sizeOfValue == 0) continue;
                                bytesToEvict -= sizeOfValue;
                                if (isDebugEnabled_LRU) {
                                    logger.trace(LogMarker.LRU, "evicted entry key={} total entry size is now: {} bytesToEvict :{}", removalEntry.getKey(), (Object)this.getTotalEntrySize(), (Object)bytesToEvict);
                                }
                                stats.incEvictions();
                                if (this._isOwnerALocalRegion() && this._getOwner() instanceof BucketRegion) {
                                    ((BucketRegion)this._getOwner()).incEvictions(1L);
                                }
                                if (isDebugEnabled_LRU) {
                                    logger.trace(LogMarker.LRU, "evictions={}", (Object)stats.getEvictions());
                                }
                                this._getCCHelper().afterEviction();
                                continue;
                            }
                            if (this.getTotalEntrySize() != 0L && isDebugEnabled_LRU) {
                                logger.trace(LogMarker.LRU, "leaving evict loop early");
                            }
                            break block30;
                        }
                        break block30;
                    }
                    catch (RegionClearedException e) {
                        if (isDebugEnabled_LRU) {
                            logger.trace(LogMarker.LRU, "exception ={}", e.getCause());
                        }
                        break block30;
                    }
                }
                try {
                    while (bytesToEvict > 0 && this._getCCHelper().mustEvict(stats, this._getOwner(), bytesToEvict)) {
                        LRUEntry removalEntry = (LRUEntry)this._getLruList().getLRUEntry();
                        if (removalEntry != null) {
                            if (this.evictEntry(removalEntry, stats) == 0) continue;
                            if (isDebugEnabled_LRU) {
                                logger.trace(LogMarker.LRU, "evicted entry key(2)={} total entry size is now: {} bytesToEvict :", removalEntry.getKey(), (Object)this.getTotalEntrySize(), (Object)bytesToEvict);
                            }
                            stats.incEvictions();
                            if (this._isOwnerALocalRegion() && this._getOwner() instanceof BucketRegion) {
                                ((BucketRegion)this._getOwner()).incEvictions(1L);
                            }
                            if (isDebugEnabled_LRU) {
                                logger.trace(LogMarker.LRU, "evictions={}", (Object)stats.getEvictions());
                            }
                            this._getCCHelper().afterEviction();
                            continue;
                        }
                        if (this.getTotalEntrySize() == 0L || !isDebugEnabled_LRU) break;
                        logger.trace(LogMarker.LRU, "leaving evict loop early");
                        break;
                    }
                    this.changeTotalEntrySize(delta);
                }
                catch (RegionClearedException e) {
                    if (!isDebugEnabled_LRU) break block30;
                    logger.debug("exception ={}", e.getCause());
                }
            }
        }
        if (isDebugEnabled_LRU) {
            logger.trace(LogMarker.LRU, "callback complete.  LRU size is now {}", (Object)this._getLruList().stats().getCounter());
        }
    }

    private boolean mustEvict() {
        LocalRegion owner = this._getOwner();
        InternalResourceManager resourceManager = owner.getCache().getResourceManager();
        boolean monitorStateIsEviction = !owner.getAttributes().getOffHeap() ? resourceManager.getHeapMonitor().getState().isEviction() : resourceManager.getOffHeapMonitor().getState().isEviction();
        return monitorStateIsEviction && this.sizeInVM() > 0;
    }

    public final int centralizedLruUpdateCallback() {
        int evictedBytes;
        boolean isDebugEnabled_LRU;
        block10: {
            isDebugEnabled_LRU = logger.isTraceEnabled(LogMarker.LRU);
            evictedBytes = 0;
            if (this.getCallbackDisabled()) {
                return evictedBytes;
            }
            this.getDelta();
            this.resetThreadLocals();
            if (isDebugEnabled_LRU) {
                logger.trace(LogMarker.LRU, "centralLruUpdateCallback: lru size is now {}, limit is: {}", (Object)this.getTotalEntrySize(), (Object)this.getLimit());
            }
            LRUStatistics stats = this._getLruList().stats();
            try {
                while (this.mustEvict() && evictedBytes == 0) {
                    LRUEntry removalEntry = (LRUEntry)this._getLruList().getLRUEntry();
                    if (removalEntry != null) {
                        evictedBytes = this.evictEntry(removalEntry, stats);
                        if (evictedBytes == 0) continue;
                        if (this._getOwner() instanceof BucketRegion) {
                            ((BucketRegion)this._getOwner()).incEvictions(1L);
                        }
                        stats.incEvictions();
                        if (isDebugEnabled_LRU) {
                            logger.debug("evictions={}", (Object)stats.getEvictions());
                        }
                        this._getCCHelper().afterEviction();
                        continue;
                    }
                    if (this.getTotalEntrySize() != 0L && isDebugEnabled_LRU) {
                        logger.trace(LogMarker.LRU, "leaving evict loop early");
                    }
                    break;
                }
            }
            catch (RegionClearedException rce) {
                if (!isDebugEnabled_LRU) break block10;
                logger.trace(LogMarker.LRU, "exception ={}", rce.getCause());
            }
        }
        if (isDebugEnabled_LRU) {
            logger.trace(LogMarker.LRU, "callback complete");
        }
        return evictedBytes;
    }

    public final void updateStats() {
        int delta = this.getDelta();
        this.resetThreadLocals();
        if (logger.isTraceEnabled(LogMarker.LRU)) {
            logger.trace(LogMarker.LRU, "updateStats - delta is: {} total is: {} limit is: {}", (Object)delta, (Object)this.getTotalEntrySize(), (Object)this.getLimit());
        }
        if (delta != 0) {
            this.changeTotalEntrySize(delta);
        }
    }

    @Override
    public final boolean disableLruUpdateCallback() {
        if (this.getCallbackDisabled()) {
            return false;
        }
        this.setCallbackDisabled(true);
        return true;
    }

    @Override
    public final void enableLruUpdateCallback() {
        this.setCallbackDisabled(false);
    }

    public final void disableLruUpdateCallbackForInline() {
        this.setCallbackDisabled(true);
    }

    public final void enableLruUpdateCallbackForInline() {
        this.setCallbackDisabled(false);
    }

    @Override
    public final void resetThreadLocals() {
        this.mustRemove.set(null);
        this.lruDelta.set(null);
        this.callbackDisabled.set(null);
    }

    @Override
    public final Set<VersionSource> clear(RegionVersionVector rvv) {
        this._getLruList().clear(rvv);
        return super.clear(rvv);
    }

    @Override
    protected final void lruEntryCreate(RegionEntry re) {
        boolean possibleClear;
        LRUEntry e = (LRUEntry)re;
        if (logger.isTraceEnabled(LogMarker.LRU)) {
            logger.trace(LogMarker.LRU, "lruEntryCreate for key={}; list size is: {}; actual size is: {}; map size is: {}; entry size: {}; in lru clock: {}", re.getKey(), (Object)this.getTotalEntrySize(), (Object)this._getLruList().getExpensiveListCount(), (Object)this.size(), (Object)e.getEntrySize(), (Object)(!e.testEvicted() ? 1 : 0));
        }
        e.unsetEvicted();
        NewLRUClockHand lruList = this._getLruList();
        DiskRegion disk = this._getOwner().getDiskRegion();
        boolean bl = possibleClear = disk != null && disk.didClearCountChange();
        if (!possibleClear || this._getOwner().basicGetEntry(re.getKey()) == re) {
            lruList.appendEntry(e);
            this.lruEntryUpdate(e);
        }
    }

    @Override
    protected final void lruEntryUpdate(RegionEntry re) {
        LRUEntry e = (LRUEntry)re;
        this.setDelta(e.updateEntrySize(this._getCCHelper()));
        if (logger.isDebugEnabled()) {
            logger.debug("lruEntryUpdate for key={} size={}", re.getKey(), (Object)e.getEntrySize());
        }
        NewLRUClockHand lruList = this._getLruList();
        if (this._isOwnerALocalRegion()) {
            boolean possibleClear;
            DiskRegion disk = this._getOwner().getDiskRegion();
            boolean bl = possibleClear = disk != null && disk.didClearCountChange();
            if (!possibleClear || this._getOwner().basicGetEntry(re.getKey()) == re) {
                if (e instanceof DiskEntry && !e.testEvicted()) {
                    lruList.appendEntry(e);
                }
                e.resetRefCount(lruList);
            }
        } else if (!e.testEvicted()) {
            lruList.appendEntry(e);
        }
    }

    @Override
    protected final void lruEntryDestroy(RegionEntry re) {
        LRUEntry e = (LRUEntry)re;
        if (logger.isTraceEnabled(LogMarker.LRU)) {
            logger.trace(LogMarker.LRU, "lruEntryDestroy for key={}; list size is: {}; actual size is: {}; map size is: {}; entry size: {}; in lru clock: {}", re.getKey(), (Object)this.getTotalEntrySize(), (Object)this._getLruList().getExpensiveListCount(), (Object)this.size(), (Object)e.getEntrySize(), (Object)(!e.testEvicted() ? 1 : 0));
        }
        this._getLruList().unlinkEntry(e);
        this.changeTotalEntrySize(-1 * e.getEntrySize());
        Token vTok = re.getValueAsToken();
        if (vTok == Token.DESTROYED || vTok == Token.TOMBSTONE) {
            e.updateEntrySize(this._getCCHelper());
        }
    }

    @Override
    public final void lruEntryFaultIn(LRUEntry e) {
        if (logger.isDebugEnabled()) {
            logger.debug("lruEntryFaultIn for key={} size={}", e.getKey(), (Object)e.getEntrySize());
        }
        NewLRUClockHand lruList = this._getLruList();
        if (this._isOwnerALocalRegion()) {
            boolean possibleClear;
            DiskRegion disk = this._getOwner().getDiskRegion();
            boolean bl = possibleClear = disk != null && disk.didClearCountChange();
            if (!possibleClear || this._getOwner().basicGetEntry(e.getKey()) == e) {
                this.lruEntryUpdate(e);
                e.unsetEvicted();
                lruList.appendEntry(e);
            }
        } else {
            this.lruEntryUpdate(e);
            lruList.appendEntry(e);
        }
    }

    @Override
    public final void decTxRefCount(RegionEntry re) {
        LocalRegion lr = null;
        if (this._isOwnerALocalRegion()) {
            lr = this._getOwner();
        }
        ((LRUEntry)re).decRefCount(this._getLruList(), lr);
    }

    @Override
    public final boolean lruLimitExceeded() {
        return this._getCCHelper().mustEvict(this._getLruList().stats(), null, 0);
    }

    @Override
    public void lruCloseStats() {
        this._getLruList().closeStats();
    }

    @Override
    final boolean confirmEvictionDestroy(RegionEntry re) {
        LRUEntry lruRe = (LRUEntry)re;
        if (lruRe.isInUseByTransaction() || lruRe.isDestroyed()) {
            lruRe.unsetEvicted();
            return false;
        }
        return true;
    }

    public static class CDValueWrapper {
        private final Object v;

        CDValueWrapper(Object v) {
            this.v = v;
        }

        public Object getValue() {
            return this.v;
        }
    }
}

