/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.GemFireCacheException;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.CacheStatistics;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.StatisticsDisabledException;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.CacheDisplay;
import org.apache.geode.internal.admin.remote.Cancellable;
import org.apache.geode.internal.admin.remote.RemoteCacheStatistics;
import org.apache.geode.internal.admin.remote.RemoteObjectName;

public final class ObjectDetailsResponse
extends AdminResponse
implements Cancellable {
    private Object objectValue;
    private Object userAttribute;
    private RemoteCacheStatistics stats;
    private transient boolean cancelled;
    private static Object lastObjectNameFound = null;

    public static ObjectDetailsResponse create(DistributionManager dm, InternalDistributedMember recipient) {
        ObjectDetailsResponse m = new ObjectDetailsResponse();
        m.setRecipient(recipient);
        return m;
    }

    void buildDetails(Region r, Object objName, int inspectionType) {
        try {
            objName = ObjectDetailsResponse.getObjectName(r, objName);
            if (this.cancelled) {
                return;
            }
            if (r.containsKey(objName)) {
                if (this.cancelled) {
                    return;
                }
                Region.Entry e = r.getEntry(objName);
                Object v = e.getValue();
                if (this.cancelled) {
                    return;
                }
                this.objectValue = CacheDisplay.getCachedObjectDisplay(v, inspectionType);
                if (this.cancelled) {
                    return;
                }
                this.userAttribute = CacheDisplay.getCachedObjectDisplay(e.getUserAttribute(), inspectionType);
                if (this.cancelled) {
                    return;
                }
                try {
                    this.stats = new RemoteCacheStatistics(e.getStatistics());
                }
                catch (StatisticsDisabledException statisticsDisabledException) {}
            }
        }
        catch (CacheException ex) {
            throw new GemFireCacheException(ex);
        }
    }

    @Override
    public synchronized void cancel() {
        this.cancelled = true;
    }

    public Object getObjectValue() {
        return this.objectValue;
    }

    public Object getUserAttribute() {
        return this.userAttribute;
    }

    public CacheStatistics getStatistics() {
        return this.stats;
    }

    @Override
    public int getDSFID() {
        return 1038;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.objectValue, out);
        DataSerializer.writeObject(this.userAttribute, out);
        DataSerializer.writeObject(this.stats, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.objectValue = DataSerializer.readObject(in);
        this.userAttribute = DataSerializer.readObject(in);
        this.stats = (RemoteCacheStatistics)DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return "ObjectDetailsResponse from " + this.getRecipient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static Object getObjectName(Region r, Object objName) throws CacheException {
        if (!(objName instanceof RemoteObjectName)) return objName;
        Class<ObjectDetailsResponse> clazz = ObjectDetailsResponse.class;
        // MONITORENTER : org.apache.geode.internal.admin.remote.ObjectDetailsResponse.class
        if (objName.equals(lastObjectNameFound)) {
            // MONITOREXIT : clazz
            return lastObjectNameFound;
        }
        // MONITOREXIT : clazz
        Object obj = null;
        Set keys = r.keys();
        Object object = r;
        // MONITORENTER : object
        for (Object o : keys) {
            if (!objName.equals(o)) continue;
            Class<ObjectDetailsResponse> clazz2 = ObjectDetailsResponse.class;
            // MONITORENTER : org.apache.geode.internal.admin.remote.ObjectDetailsResponse.class
            lastObjectNameFound = o;
            // MONITOREXIT : clazz2
            obj = o;
            break;
        }
        // MONITOREXIT : object
        if (obj != null) {
            return obj;
        }
        object = ObjectDetailsResponse.class;
        // MONITORENTER : org.apache.geode.internal.admin.remote.ObjectDetailsResponse.class
        lastObjectNameFound = objName;
        // MONITOREXIT : object
        return objName;
    }
}

