/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.cache.CacheServerLauncher;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.logging.log4j.Logger;

public final class FetchHostResponse
extends AdminResponse {
    private static final Logger logger = LogService.getLogger();
    InetAddress host;
    File geodeHomeDir;
    File workingDir;
    long birthDate;
    boolean isDedicatedCacheServer = false;
    String name;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FetchHostResponse create(DistributionManager dm, InternalDistributedMember recipient) {
        FetchHostResponse m = new FetchHostResponse();
        m.setRecipient(recipient);
        try {
            InetAddress host = null;
            String bindAddress = dm.getConfig().getBindAddress();
            try {
                if (bindAddress != null && !bindAddress.equals("")) {
                    host = InetAddress.getByName(bindAddress);
                }
            }
            catch (UnknownHostException unknownHostException) {
            }
            finally {
                if (host == null) {
                    host = SocketCreator.getLocalHost();
                }
            }
            m.host = host;
            m.isDedicatedCacheServer = CacheServerLauncher.isDedicatedCacheServer;
            DistributionConfig config = dm.getSystem().getConfig();
            m.name = config.getName();
            m.workingDir = new File(System.getProperty("user.dir")).getAbsoluteFile();
            URL url = GemFireVersion.getJarURL();
            if (url == null) {
                throw new IllegalStateException(LocalizedStrings.FetchHostResponse_COULD_NOT_FIND_GEMFIREJAR.toLocalizedString());
            }
            String path = url.getPath();
            if (path.startsWith("file:")) {
                path = path.substring("file:".length());
            }
            File gemfireJar = new File(path);
            File lib = gemfireJar.getParentFile();
            File product = lib.getParentFile();
            m.geodeHomeDir = product.getCanonicalFile();
        }
        catch (Exception ex) {
            if (dm != null && !dm.getCancelCriterion().isCancelInProgress()) {
                logger.debug(ex.getMessage(), (Throwable)ex);
            }
            m.name = m.name != null ? m.name : "";
            m.host = m.host != null ? m.host : null;
            m.geodeHomeDir = m.geodeHomeDir != null ? m.geodeHomeDir : new File("");
            m.workingDir = m.workingDir != null ? m.workingDir : new File(System.getProperty("user.dir")).getAbsoluteFile();
        }
        return m;
    }

    public InetAddress getHost() {
        return this.host;
    }

    public File getGeodeHomeDir() {
        return this.geodeHomeDir;
    }

    public File getWorkingDirectory() {
        return this.workingDir;
    }

    public long getBirthDate() {
        return this.birthDate;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDedicatedCacheServer() {
        return this.isDedicatedCacheServer;
    }

    @Override
    public int getDSFID() {
        return 1026;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeString(this.name, out);
        DataSerializer.writeObject(this.host, out);
        DataSerializer.writeObject(this.geodeHomeDir, out);
        DataSerializer.writeObject(this.workingDir, out);
        out.writeLong(this.birthDate);
        out.writeBoolean(this.isDedicatedCacheServer);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.name = DataSerializer.readString(in);
        this.host = (InetAddress)DataSerializer.readObject(in);
        this.geodeHomeDir = (File)DataSerializer.readObject(in);
        this.workingDir = (File)DataSerializer.readObject(in);
        this.birthDate = in.readLong();
        this.isDedicatedCacheServer = in.readBoolean();
    }

    @Override
    public String toString() {
        return LocalizedStrings.FetchHostResponse_FETCHHOSTRESPONSE_FOR_0_HOST_1.toLocalizedString(this.getRecipient(), this.host);
    }
}

