/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.messenger;

import org.apache.geode.distributed.internal.membership.gms.messenger.JGAddress;
import org.apache.geode.internal.Version;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;

public class GMSPingPonger {
    private byte[] pingInBytes = new byte[]{112, 105, 110, 103};
    private byte[] pongInBytes = new byte[]{112, 111, 110, 103};

    public boolean isPingMessage(byte[] buffer) {
        return buffer.length == 4 && buffer[0] == 112 && buffer[1] == 105 && buffer[2] == 110 && buffer[3] == 103;
    }

    public boolean isPongMessage(byte[] buffer) {
        return buffer.length == 4 && buffer[0] == 112 && buffer[1] == 111 && buffer[2] == 110 && buffer[3] == 103;
    }

    public void sendPongMessage(JChannel channel, Address src, Address dest) throws Exception {
        channel.send(this.createPongMessage(src, dest));
    }

    public Message createPongMessage(Address src, Address dest) {
        return this.createJGMessage(this.pongInBytes, src, dest, Version.CURRENT_ORDINAL);
    }

    public Message createPingMessage(Address src, Address dest) {
        return this.createJGMessage(this.pingInBytes, src, dest, Version.CURRENT_ORDINAL);
    }

    public void sendPingMessage(JChannel channel, Address src, JGAddress dest) throws Exception {
        channel.send(this.createPingMessage(src, dest));
    }

    private Message createJGMessage(byte[] msgBytes, Address src, Address dest, short version) {
        Message msg = new Message();
        msg.setDest(dest);
        msg.setSrc(src);
        msg.setObject(msgBytes);
        msg.setFlag(Message.Flag.NO_RELIABILITY);
        msg.setFlag(Message.Flag.NO_FC);
        msg.setFlag(Message.Flag.DONT_BUNDLE);
        msg.setFlag(Message.Flag.OOB);
        return msg;
    }
}

