/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.messages;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.membership.NetView;

public class ViewAckMessage
extends HighPriorityDistributionMessage {
    int viewId;
    boolean preparing;
    NetView alternateView;

    public ViewAckMessage(InternalDistributedMember recipient, int viewId, boolean preparing) {
        this.setRecipient(recipient);
        this.viewId = viewId;
        this.preparing = preparing;
    }

    public ViewAckMessage(InternalDistributedMember recipient, NetView alternateView) {
        this.setRecipient(recipient);
        this.alternateView = alternateView;
        this.preparing = true;
    }

    public ViewAckMessage() {
    }

    public int getViewId() {
        return this.viewId;
    }

    public NetView getAlternateView() {
        return this.alternateView;
    }

    public boolean isPrepareAck() {
        return this.preparing;
    }

    @Override
    public int getDSFID() {
        return -151;
    }

    @Override
    public int getProcessorType() {
        return 0;
    }

    @Override
    public void process(DistributionManager dm) {
        throw new IllegalStateException("this message is not intended to execute in a thread pool");
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.viewId);
        out.writeBoolean(this.preparing);
        DataSerializer.writeObject(this.alternateView, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.viewId = in.readInt();
        this.preparing = in.readBoolean();
        this.alternateView = (NetView)DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        String s = this.getSender() == null ? this.getRecipientsDescription() : "" + this.getSender();
        return "ViewAckMessage(" + s + "; " + this.viewId + "; preparing=" + this.preparing + "; altview=" + this.alternateView + ")";
    }
}

