/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.auth;

import java.security.Principal;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.membership.NetView;
import org.apache.geode.distributed.internal.membership.gms.Services;
import org.apache.geode.distributed.internal.membership.gms.interfaces.Authenticator;
import org.apache.geode.internal.cache.tier.sockets.HandShake;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.security.IntegratedSecurityService;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.AuthenticationFailedException;

public class GMSAuthenticator
implements Authenticator {
    private Services services;
    private Properties securityProps;
    private SecurityService securityService = IntegratedSecurityService.getSecurityService();

    @Override
    public void init(Services s) {
        this.services = s;
        this.securityProps = this.services.getConfig().getDistributionConfig().getSecurityProps();
    }

    @Override
    public void start() {
    }

    @Override
    public void started() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void stopped() {
    }

    @Override
    public void installView(NetView v) {
    }

    @Override
    public void beSick() {
    }

    @Override
    public void playDead() {
    }

    @Override
    public void beHealthy() {
    }

    @Override
    public void memberSuspected(InternalDistributedMember initiator, InternalDistributedMember suspect, String reason) {
    }

    @Override
    public String authenticate(InternalDistributedMember member, Properties credentials) throws AuthenticationFailedException {
        return this.authenticate(member, credentials, this.securityProps);
    }

    String authenticate(DistributedMember member, Properties credentials, Properties secProps) throws AuthenticationFailedException {
        String authMethod = secProps.getProperty("security-peer-authenticator");
        if (!this.securityService.isPeerSecurityRequired() && StringUtils.isBlank(authMethod)) {
            return null;
        }
        InternalLogWriter securityLogWriter = this.services.getSecurityLogWriter();
        if (credentials == null) {
            securityLogWriter.warning(LocalizedStrings.AUTH_PEER_AUTHENTICATION_MISSING_CREDENTIALS, member);
            return LocalizedStrings.AUTH_PEER_AUTHENTICATION_MISSING_CREDENTIALS.toLocalizedString(member);
        }
        String failMsg = null;
        try {
            if (this.securityService.isIntegratedSecurity()) {
                this.securityService.login(credentials);
                this.securityService.authorizeClusterManage();
            } else {
                this.invokeAuthenticator(secProps, member, credentials);
            }
        }
        catch (Exception ex) {
            securityLogWriter.warning(LocalizedStrings.AUTH_PEER_AUTHENTICATION_FAILED_WITH_EXCEPTION, new Object[]{member, ex.getLocalizedMessage()}, (Throwable)ex);
            failMsg = LocalizedStrings.AUTH_PEER_AUTHENTICATION_FAILED.toLocalizedString(ex.getLocalizedMessage());
        }
        return failMsg;
    }

    Principal invokeAuthenticator(Properties securityProps, DistributedMember member, Properties credentials) throws AuthenticationFailedException {
        String authMethod = securityProps.getProperty("security-peer-authenticator");
        try (org.apache.geode.security.Authenticator auth = null;){
            auth = SecurityService.getObjectOfType(authMethod, org.apache.geode.security.Authenticator.class);
            InternalLogWriter logWriter = this.services.getLogWriter();
            InternalLogWriter securityLogWriter = this.services.getSecurityLogWriter();
            auth.init(this.securityProps, logWriter, securityLogWriter);
            Principal principal = auth.authenticate(credentials, member);
            return principal;
        }
    }

    @Override
    public Properties getCredentials(InternalDistributedMember member) {
        try {
            return this.getCredentials(member, this.securityProps);
        }
        catch (Exception e) {
            String authMethod = this.securityProps.getProperty("security-peer-auth-init");
            this.services.getSecurityLogWriter().warning(LocalizedStrings.AUTH_FAILED_TO_OBTAIN_CREDENTIALS_IN_0_USING_AUTHINITIALIZE_1_2, new Object[]{authMethod, e.getLocalizedMessage()});
            return null;
        }
    }

    Properties getCredentials(DistributedMember member, Properties secProps) {
        String authMethod = secProps.getProperty("security-peer-auth-init");
        return HandShake.getCredentials(authMethod, secProps, member, true, this.services.getLogWriter(), this.services.getSecurityLogWriter());
    }

    Properties getSecurityProps() {
        return this.securityProps;
    }

    @Override
    public void emergencyClose() {
    }
}

