/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.geode.CancelCriterion;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.UnsupportedVersionException;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.ProcessorKeeper21;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.deadlock.MessageDependencyMonitor;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.i18n.StringId;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.DSFIDNotFoundException;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.versions.ConcurrentCacheModificationException;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.util.Breadcrumbs;
import org.apache.geode.internal.util.concurrent.StoppableCountDownLatch;
import org.apache.logging.log4j.Logger;

public class ReplyProcessor21
implements MembershipListener {
    private static final Logger logger;
    public static final boolean THROW_EXCEPTION_ON_TIMEOUT;
    public static final double PR_SEVERE_ALERT_RATIO;
    protected static final ProcessorKeeper21 keeper;
    protected final InternalDistributedMember[] members;
    protected volatile boolean waiting = false;
    protected volatile ReplyException exception;
    private volatile boolean done;
    protected boolean keeperCleanedUp;
    protected volatile boolean shutdown;
    private final StoppableCountDownLatch latch;
    protected int processorId;
    protected final InternalDistributedSystem system;
    protected final DM dmgr;
    protected long statStart;
    protected long initTime;
    protected boolean severeAlertEnabled;
    protected volatile boolean severeAlertTimerReset;
    public static final ThreadLocal SevereAlertShorten;
    private static ThreadLocal ForceSevereAlertProcessing;
    private static final ThreadLocal messageId;
    private static final Integer VOID_RPID;

    public static ReplyProcessor21 getProcessor(int processorId) {
        return (ReplyProcessor21)keeper.retrieve(processorId);
    }

    public ReplyProcessor21(InternalDistributedSystem system, InternalDistributedMember member) {
        this(system, Collections.singleton(member));
    }

    public ReplyProcessor21(InternalDistributedSystem system, InternalDistributedMember member, CancelCriterion cancelCriterion) {
        this(system, Collections.singleton(member), cancelCriterion);
    }

    public ReplyProcessor21(DM dm, InternalDistributedMember member) {
        this(dm, Collections.singleton(member));
    }

    public ReplyProcessor21(DM dm, Collection initMembers) {
        this(dm, dm.getSystem(), initMembers, null);
    }

    public ReplyProcessor21(InternalDistributedSystem system, Collection initMembers) {
        this(system.getDistributionManager(), system, initMembers, null);
    }

    public ReplyProcessor21(InternalDistributedSystem system, Collection initMembers, CancelCriterion cancelCriterion) {
        this(system.getDistributionManager(), system, initMembers, cancelCriterion);
    }

    private ReplyProcessor21(DM dm, InternalDistributedSystem system, Collection initMembers, CancelCriterion cancelCriterion) {
        this(dm, system, initMembers, cancelCriterion, true);
    }

    protected ReplyProcessor21(DM dm, InternalDistributedSystem system, Collection initMembers, CancelCriterion cancelCriterion, boolean register) {
        if (!this.allowReplyFromSender()) {
            Assert.assertTrue(initMembers != null, "null initMembers");
            Assert.assertTrue(system != null, "null system");
            if (dm != null) {
                Assert.assertTrue(!initMembers.contains(dm.getId()), "dm present in initMembers but reply from sender is not allowed");
            }
        }
        this.system = system;
        this.dmgr = dm;
        if (cancelCriterion == null) {
            cancelCriterion = dm.getCancelCriterion();
        }
        this.latch = new StoppableCountDownLatch(cancelCriterion, 1);
        int sz = initMembers.size();
        this.members = new InternalDistributedMember[sz];
        if (sz > 0) {
            int i = 0;
            Iterator it = initMembers.iterator();
            while (it.hasNext()) {
                this.members[i] = (InternalDistributedMember)it.next();
                ++i;
            }
        }
        this.done = false;
        this.shutdown = false;
        this.exception = null;
        if (register) {
            this.register();
        }
        this.keeperCleanedUp = false;
        this.initTime = System.currentTimeMillis();
    }

    protected int register() {
        this.processorId = keeper.put(this);
        return this.processorId;
    }

    protected DM getDistributionManager() {
        try {
            DM result = this.system.getDistributionManager();
            if (result == null) {
                result = this.dmgr;
                Assert.assertTrue(result != null, "null DistributionManager");
            }
            return result;
        }
        catch (IllegalStateException ex) {
            this.system.getCancelCriterion().checkCancelInProgress(null);
            throw new DistributedSystemDisconnectedException(ex.getMessage());
        }
    }

    protected boolean allowReplyFromSender() {
        return false;
    }

    protected boolean logMultipleExceptions() {
        return true;
    }

    public void process(DistributionMessage msg) {
        this.process(msg, true);
    }

    protected void process(DistributionMessage msg, boolean warn) {
        InternalDistributedMember sender;
        ReplyException ex;
        if (logger.isDebugEnabled()) {
            logger.debug("{} got process({}) from {}", (Object)this, (Object)msg, (Object)msg.getSender());
        }
        if (msg instanceof ReplyMessage && (ex = ((ReplyMessage)msg).getException()) != null) {
            if (ex.getCause() instanceof DSFIDNotFoundException) {
                this.processException(msg, (DSFIDNotFoundException)ex.getCause());
            } else {
                this.processException(msg, ex);
            }
        }
        if (!this.removeMember(sender = msg.getSender(), false) && warn) {
            DM dm = this.getDistributionManager();
            Set ids = this.getDistributionManagerIds();
            if (ids == null || ids.contains(sender)) {
                List<InternalDistributedMember> viewMembers = dm.getViewMembers();
                if (this.system.getConfig().getMcastPort() == 0 && (viewMembers == null || viewMembers.contains(sender))) {
                    logger.warn(LocalizedMessage.create(LocalizedStrings.ReplyProcessor21_RECEIVED_REPLY_FROM_MEMBER_0_BUT_WAS_NOT_EXPECTING_ONE_MORE_THAN_ONE_REPLY_MAY_HAVE_BEEN_RECEIVED_THE_REPLY_THAT_WAS_NOT_EXPECTED_IS_1, new Object[]{sender, msg}));
                }
            }
        }
        this.checkIfDone();
    }

    protected synchronized void processException(DistributionMessage msg, ReplyException ex) {
        this.processException(ex);
    }

    protected synchronized void processException(ReplyException ex) {
        if (this.exception == null) {
            this.exception = ex;
        } else if (this.logMultipleExceptions() && !(ex.getCause() instanceof ConcurrentCacheModificationException)) {
            logger.fatal(LocalizedMessage.create(LocalizedStrings.ReplyProcessor21_EXCEPTION_RECEIVED_IN_REPLYMESSAGE_ONLY_ONE_EXCEPTION_IS_PASSED_BACK_TO_CALLER_THIS_EXCEPTION_IS_LOGGED_ONLY), (Throwable)ex);
        }
    }

    protected synchronized void processException(DistributionMessage msg, DSFIDNotFoundException ex) {
        short versionOrdinal = ex.getProductVersionOrdinal();
        String versionStr = null;
        try {
            Version version = Version.fromOrdinal(versionOrdinal, false);
            versionStr = version.toString();
        }
        catch (UnsupportedVersionException unsupportedVersionException) {
            // empty catch block
        }
        if (versionStr == null) {
            versionStr = "Ordinal=" + versionOrdinal;
        }
        logger.fatal(LocalizedMessage.create(LocalizedStrings.ReplyProcessor21_UNKNOWN_DSFID_ERROR, new Object[]{ex.getUnknownDSFID(), msg.getSender(), versionStr}), (Throwable)ex);
    }

    @Override
    public void memberJoined(InternalDistributedMember id) {
    }

    @Override
    public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void memberSuspect(InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
        if (!this.isSevereAlertProcessingEnabled()) return;
        InternalDistributedMember[] internalDistributedMemberArray = this.members;
        synchronized (this.members) {
            for (InternalDistributedMember e : this.members) {
                if (e == null || !e.equals(whoSuspected)) continue;
                this.severeAlertTimerReset = true;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void memberDeparted(InternalDistributedMember id, boolean crashed) {
        this.removeMember(id, true);
        this.checkIfDone();
    }

    public final void waitForReplies() throws InterruptedException, ReplyException {
        boolean result = this.waitForReplies(0L);
        Assert.assertTrue(result, "failed but no exception thrown");
    }

    protected Set addListenerAndGetMembers() {
        return this.getDistributionManager().addMembershipListenerAndGetDistributionManagerIds(this);
    }

    protected void removeListener() {
        try {
            this.getDistributionManager().removeMembershipListener(this);
        }
        catch (DistributedSystemDisconnectedException distributedSystemDisconnectedException) {
            // empty catch block
        }
    }

    protected Set getDistributionManagerIds() {
        return this.getDistributionManager().getDistributionManagerIds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preWait() {
        this.waiting = true;
        DM mgr = this.getDistributionManager();
        this.statStart = mgr.getStats().startReplyWait();
        InternalDistributedMember[] internalDistributedMemberArray = this.members;
        synchronized (this.members) {
            Set activeMembers = this.addListenerAndGetMembers();
            this.processActiveMembers(activeMembers);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void processActiveMembers(Set activeMembers) {
        for (int i = 0; i < this.members.length; ++i) {
            if (this.members[i] == null || activeMembers.contains(this.members[i])) continue;
            this.memberDeparted(this.members[i], false);
        }
    }

    protected void postWait() {
        this.waiting = false;
        this.removeListener();
        DM mgr = this.getDistributionManager();
        mgr.getStats().endReplyWait(this.statStart, this.initTime);
        mgr.getCancelCriterion().checkCancelInProgress(null);
    }

    public final void startWait() {
        if (!this.waiting && this.stillWaiting()) {
            this.preWait();
        }
    }

    public final void endWait(boolean doCleanup) {
        try {
            this.postWait();
        }
        finally {
            if (doCleanup) {
                this.cleanup();
            }
        }
    }

    public final boolean waitForReplies(long msecs) throws InterruptedException, ReplyException {
        return this.waitForReplies(msecs, this.getLatch(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean waitForReplies(long msecs, StoppableCountDownLatch latch, boolean doCleanUp) throws InterruptedException, ReplyException {
        if (this.keeperCleanedUp) {
            throw new IllegalStateException(LocalizedStrings.ReplyProcessor21_THIS_REPLY_PROCESSOR_HAS_ALREADY_BEEN_REMOVED_FROM_THE_PROCESSOR_KEEPER.toLocalizedString());
        }
        boolean result = true;
        boolean interrupted = Thread.interrupted();
        MessageDependencyMonitor.waitingForReply(this);
        try {
            if (interrupted) {
                throw new InterruptedException();
            }
            if (this.stillWaiting()) {
                this.preWait();
                try {
                    result = this.basicWait(msecs, latch);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
                finally {
                    if (doCleanUp) {
                        this.postWait();
                    }
                }
            }
            if (this.exception != null) {
                throw this.exception;
            }
        }
        finally {
            if (doCleanUp) {
                try {
                    this.cleanup();
                }
                finally {
                    if (interrupted) {
                        throw new InterruptedException();
                    }
                }
            }
            MessageDependencyMonitor.doneWaiting(this);
        }
        return result;
    }

    protected boolean basicWait(long msecs, StoppableCountDownLatch latch) throws InterruptedException, ReplyException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.stillWaiting()) {
            long timeout = (long)this.getAckWaitThreshold() * 1000L;
            long timeSoFar = System.currentTimeMillis() - this.initTime;
            long severeAlertTimeout = this.getAckSevereAlertThresholdMS();
            if (timeout <= 0L) {
                timeout = Long.MAX_VALUE;
            }
            if (msecs == 0L) {
                boolean timedOut = false;
                if (timeout <= timeSoFar + 1L) {
                    boolean bl = timedOut = !latch.await(10L);
                }
                if (timedOut || !latch.await(timeout - timeSoFar - 1L)) {
                    this.dmgr.getCancelCriterion().checkCancelInProgress(null);
                    this.timeout(this.isSevereAlertProcessingEnabled() && severeAlertTimeout > 0L, false);
                    if (this.isSevereAlertProcessingEnabled() && severeAlertTimeout > 0L) {
                        boolean timedout;
                        do {
                            this.severeAlertTimerReset = false;
                            boolean bl = timedout = !latch.await(severeAlertTimeout);
                        } while (timedout && this.severeAlertTimerReset);
                        if (timedout) {
                            this.dmgr.getCancelCriterion().checkCancelInProgress(null);
                            this.timeout(false, true);
                            latch.await();
                        }
                    } else {
                        latch.await();
                    }
                    logger.info(LocalizedMessage.create(LocalizedStrings.ReplyProcessor21_WAIT_FOR_REPLIES_COMPLETED_1, this.shortName()));
                }
            } else if (msecs > timeout) {
                if (!latch.await(timeout)) {
                    this.timeout(this.isSevereAlertProcessingEnabled() && severeAlertTimeout > 0L, false);
                    if (!latch.await(msecs - timeout)) {
                        logger.info(LocalizedMessage.create(LocalizedStrings.ReplyProcessor21_WAIT_FOR_REPLIES_TIMING_OUT_AFTER_0_SEC, msecs / 1000L));
                        return false;
                    }
                    logger.info(LocalizedMessage.create(LocalizedStrings.ReplyProcessor21_WAIT_FOR_REPLIES_COMPLETED_1, this.shortName()));
                }
            } else if (!latch.await(msecs)) {
                return false;
            }
        }
        Assert.assertTrue(latch != this.latch || !this.stillWaiting(), this);
        if (this.stopBecauseOfExceptions()) {
            throw this.exception;
        }
        return true;
    }

    public final boolean waitForRepliesUninterruptibly(long p_msecs) throws ReplyException {
        return this.waitForRepliesUninterruptibly(p_msecs, this.getLatch(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean waitForRepliesUninterruptibly(long p_msecs, StoppableCountDownLatch latch, boolean doCleanUp) throws ReplyException {
        if (this.keeperCleanedUp) {
            throw new IllegalStateException(LocalizedStrings.ReplyProcessor21_THIS_REPLY_PROCESSOR_HAS_ALREADY_BEEN_REMOVED_FROM_THE_PROCESSOR_KEEPER.toLocalizedString());
        }
        long msecs = p_msecs;
        boolean result = true;
        MessageDependencyMonitor.waitingForReply(this);
        try {
            if (this.stillWaiting()) {
                this.preWait();
                try {
                    while (true) {
                        this.dmgr.getCancelCriterion().checkCancelInProgress(null);
                        long startWaitTime = System.currentTimeMillis();
                        boolean interrupted = Thread.interrupted();
                        try {
                            result = this.basicWait(msecs, latch);
                        }
                        catch (InterruptedException e) {
                            long interruptTime;
                            interrupted = true;
                            this.dmgr.getCancelCriterion().checkCancelInProgress(e);
                            if (msecs <= 0L || (msecs -= (interruptTime = System.currentTimeMillis()) - startWaitTime) > 0L) continue;
                            msecs = 1L;
                            result = false;
                        }
                        finally {
                            if (!interrupted) continue;
                            Thread.currentThread().interrupt();
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    if (doCleanUp) {
                        this.postWait();
                    }
                }
            }
            if (this.exception != null) {
                throw this.exception;
            }
        }
        finally {
            if (doCleanUp) {
                this.cleanup();
            }
            MessageDependencyMonitor.doneWaiting(this);
        }
        return result;
    }

    public void cleanup() {
        if (!this.keeperCleanedUp) {
            this.keeperCleanedUp = true;
            keeper.remove(this.getProcessorId());
        }
    }

    public final void waitForRepliesUninterruptibly() throws ReplyException {
        this.waitForRepliesUninterruptibly(0L);
    }

    public int getProcessorId() {
        return this.processorId;
    }

    protected boolean canStopWaiting() {
        return false;
    }

    protected boolean stillWaiting() {
        if (this.shutdown) {
            ReplyException re;
            this.exception = re = new ReplyException(new DistributedSystemDisconnectedException(LocalizedStrings.ReplyProcessor21_ABORTED_DUE_TO_SHUTDOWN.toLocalizedString()));
            return false;
        }
        if (this.canStopWaiting()) {
            return false;
        }
        if (this.stopBecauseOfExceptions()) {
            return false;
        }
        return this.numMembers() > 0;
    }

    protected boolean stopBecauseOfExceptions() {
        return this.exception != null;
    }

    protected void checkIfDone() {
        boolean finished;
        boolean bl = finished = !this.stillWaiting();
        if (finished) {
            this.finished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void finished() {
        boolean isDone = false;
        ReplyProcessor21 replyProcessor21 = this;
        synchronized (replyProcessor21) {
            if (!this.done) {
                this.done = true;
                isDone = true;
                this.getLatch().countDown();
            }
        }
        if (isDone) {
            this.postFinish();
        }
    }

    protected void postFinish() {
    }

    protected String shortName() {
        String base = this.getClass().getName();
        int dot = base.lastIndexOf(46);
        if (dot == -1) {
            return base;
        }
        return base.substring(dot + 1);
    }

    public String toString() {
        return "<" + this.shortName() + " " + this.getProcessorId() + " waiting for " + this.numMembers() + " replies" + (this.exception == null ? "" : " exception: " + this.exception) + " from " + this.membersToString() + ">";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeMember(InternalDistributedMember m, boolean departed) {
        boolean removed = false;
        InternalDistributedMember[] internalDistributedMemberArray = this.members;
        synchronized (this.members) {
            for (InternalDistributedMember e : this.members) {
                if (e == null || !e.equals(m)) continue;
                this.members[i] = null;
                if (!departed) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return true;
                }
                removed = true;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int numMembers() {
        int sz = 0;
        InternalDistributedMember[] internalDistributedMemberArray = this.members;
        synchronized (this.members) {
            int cells = this.members.length;
            for (int i = 0; i < cells; ++i) {
                if (this.members[i] == null) continue;
                ++sz;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return sz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean waitingOnMember(InternalDistributedMember id) {
        InternalDistributedMember[] internalDistributedMemberArray = this.members;
        synchronized (this.members) {
            int cells = this.members.length;
            for (int i = 0; i < cells; ++i) {
                if (!id.equals(this.members[i])) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    protected int getAckWaitThreshold() {
        return this.system.getConfig().getAckWaitThreshold();
    }

    protected int getSevereAlertThreshold() {
        return this.system.getConfig().getAckSevereAlertThreshold();
    }

    protected boolean processTimeout() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeout(boolean suspectThem, boolean severeAlert) {
        if (!this.processTimeout()) {
            return;
        }
        Set activeMembers = this.getDistributionManagerIds();
        long timeout = this.getAckWaitThreshold();
        Object[] msgArgs = new Object[]{timeout + (long)(severeAlert ? this.getSevereAlertThreshold() : 0), this, this.getDistributionManager().getId(), activeMembers};
        StringId msg = LocalizedStrings.ReplyProcessor21_0_SEC_HAVE_ELAPSED_WHILE_WAITING_FOR_REPLIES_1_ON_2_WHOSE_CURRENT_MEMBERSHIP_LIST_IS_3;
        if (severeAlert) {
            logger.fatal(LocalizedMessage.create(msg, msgArgs));
        } else {
            logger.warn(LocalizedMessage.create(msg, msgArgs));
        }
        msgArgs[3] = "(omitted)";
        Breadcrumbs.setProblem(msg, msgArgs);
        this.getDistributionManager().getStats().incReplyTimeouts();
        HashSet<InternalDistributedMember> suspectMembers = suspectThem || severeAlert ? new HashSet<InternalDistributedMember>() : null;
        InternalDistributedMember[] internalDistributedMemberArray = this.members;
        synchronized (this.members) {
            for (int i = 0; i < this.members.length; ++i) {
                if (this.members[i] == null) continue;
                if (!activeMembers.contains(this.members[i])) {
                    logger.warn(LocalizedMessage.create(LocalizedStrings.ReplyProcessor21_VIEW_NO_LONGER_HAS_0_AS_AN_ACTIVE_MEMBER_SO_WE_WILL_NO_LONGER_WAIT_FOR_IT, this.members[i]));
                    this.memberDeparted(this.members[i], false);
                    continue;
                }
                if (suspectMembers == null) continue;
                suspectMembers.add(this.members[i]);
            }
            // ** MonitorExit[var9_8] (shouldn't be in output)
            if (THROW_EXCEPTION_ON_TIMEOUT) {
                TimeoutException cause = new TimeoutException(LocalizedStrings.TIMED_OUT_WAITING_FOR_ACKS.toLocalizedString());
                throw new InternalGemFireException(LocalizedStrings.ReplyProcessor21_0_SEC_HAVE_ELAPSED_WHILE_WAITING_FOR_REPLIES_1_ON_2_WHOSE_CURRENT_MEMBERSHIP_LIST_IS_3.toLocalizedString(msgArgs), cause);
            }
            if (suspectThem && suspectMembers != null && suspectMembers.size() > 0) {
                this.getDistributionManager().getMembershipManager().suspectMembers(suspectMembers, "Failed to respond within ack-wait-threshold");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String membersToString() {
        StringBuffer sb = new StringBuffer("[");
        boolean first = true;
        InternalDistributedMember[] internalDistributedMemberArray = this.members;
        synchronized (this.members) {
            for (int i = 0; i < this.members.length; ++i) {
                InternalDistributedMember member = this.members[i];
                if (member == null) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(member);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            sb.append("]");
            return sb.toString();
        }
    }

    protected InternalDistributedMember[] getMembers() {
        return this.members;
    }

    private StoppableCountDownLatch getLatch() {
        return this.latch;
    }

    public void enableSevereAlertProcessing() {
        this.severeAlertEnabled = true;
    }

    public static void setShortSevereAlertProcessing(boolean flag) {
        SevereAlertShorten.set(flag);
    }

    public static boolean getShortSevereAlertProcessing() {
        return (Boolean)SevereAlertShorten.get();
    }

    public static void forceSevereAlertProcessing() {
        ForceSevereAlertProcessing.set(Boolean.TRUE);
    }

    public static void unforceSevereAlertProcessing() {
        ForceSevereAlertProcessing.set(Boolean.FALSE);
    }

    public static boolean isSevereAlertProcessingForced() {
        return (Boolean)ForceSevereAlertProcessing.get();
    }

    public long getAckSevereAlertThresholdMS() {
        long disconnectTimeout = (long)this.getSevereAlertThreshold() * 1000L;
        if (disconnectTimeout > 0L && ((Boolean)SevereAlertShorten.get()).booleanValue()) {
            disconnectTimeout = (long)((double)disconnectTimeout * PR_SEVERE_ALERT_RATIO);
        }
        return disconnectTimeout;
    }

    public boolean isSevereAlertProcessingEnabled() {
        return this.severeAlertEnabled || ReplyProcessor21.isSevereAlertProcessingForced();
    }

    public static void setMessageRPId(int id) {
        messageId.set(id);
    }

    public static void initMessageRPId() {
        messageId.set(VOID_RPID);
    }

    public static void clearMessageRPId() {
        messageId.set(VOID_RPID);
    }

    public static int getMessageRPId() {
        int result = 0;
        Object v = messageId.get();
        if (v != null) {
            result = (Integer)v;
        }
        return result;
    }

    public void cancel(InternalDistributedMember sender, RuntimeException ex) {
        this.processException(new ReplyException("Unexpected exception while processing reply message", ex));
        this.removeMember(sender, false);
        this.checkIfDone();
    }

    static {
        double ratio;
        logger = LogService.getLogger();
        THROW_EXCEPTION_ON_TIMEOUT = Boolean.getBoolean("ack-threshold-exception");
        keeper = new ProcessorKeeper21();
        SevereAlertShorten = new ThreadLocal(){

            protected Object initialValue() {
                return Boolean.FALSE;
            }
        };
        ForceSevereAlertProcessing = new ThreadLocal(){

            protected Object initialValue() {
                return Boolean.FALSE;
            }
        };
        String str = System.getProperty("gemfire.ack-severe-alert-reduction-ratio", ".80");
        try {
            ratio = Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            System.err.println("Unable to parse gemfire.ack-severe-alert-reduction-ratio setting of \"" + str + "\"");
            ratio = 0.8;
        }
        PR_SEVERE_ALERT_RATIO = ratio;
        messageId = new ThreadLocal();
        VOID_RPID = 0;
    }
}

